/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;

@SASScope
public class BaseSocketListener
extends Thread {
    public static final long DEFAULT_TIMEOUT_INTERVAL = 1000L;
    private long timeoutInterval = 1000L;
    private boolean isReading;
    private ServerSocket server = null;
    private Socket client = null;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int minPort = 0;
    private int maxPort = 0;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)BaseSocketListener.class.getPackage().getName(), null);

    public void setMinPort(int minPort) {
        this.minPort = minPort;
        this.validateMaxPortRange();
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
        this.validateMinPortRange();
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    private void validateMinPortRange() {
        this.minPort = Math.min(this.minPort, this.maxPort);
        this.maxPort = Math.max(this.minPort, this.maxPort);
    }

    private void validateMaxPortRange() {
        this.maxPort = Math.max(this.minPort, this.maxPort);
        this.minPort = Math.min(this.minPort, this.maxPort);
    }

    public int setup() throws IOException {
        int openPort = this.minPort;
        int localPort = -1;
        while (true) {
            try {
                this.server = new ServerSocket(openPort);
                localPort = this.server.getLocalPort();
                return localPort;
            }
            catch (IOException e) {
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
                this.server = null;
                if (openPort != this.getMaxPort()) continue;
                throw e;
                if (++openPort <= this.getMaxPort()) continue;
                return localPort;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.server == null) {
            return;
        }
        try {
            int c;
            this.client = this.server.accept();
            Object in = null;
            BaseSocketListener baseSocketListener = this;
            synchronized (baseSocketListener) {
                this.isReading = true;
                in = new BufferedInputStream(this.client.getInputStream());
            }
            while ((c = ((InputStream)in).read()) != -1) {
                this.baos.write(c);
            }
            this.baos.flush();
        }
        catch (IOException e) {
            if (this.server == null) {
            } else {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException iOException) {}
            }
            BaseSocketListener baseSocketListener = this;
            synchronized (baseSocketListener) {
                this.isReading = false;
                this.notifyAll();
            }
        }
    }

    public void close() throws IOException {
        if (this.server != null) {
            ServerSocket temp = this.server;
            this.server = null;
            temp.close();
        }
    }

    public Socket getSocket() {
        return this.client;
    }

    public void write(OutputStream outs) throws IOException {
        this.waitForReadToFinish();
        outs.write(this.baos.toByteArray());
        outs.flush();
    }

    public void write(Writer outs) throws IOException {
        this.waitForReadToFinish();
        outs.write(new String(this.baos.toByteArray()));
        outs.flush();
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.write(out);
        }
        catch (Exception ex) {
            out.write("ERROR: " + ex.getMessage() + "\n");
        }
        return out.toString();
    }

    protected synchronized void waitForReadToFinish() {
        if (this.isReading) {
            try {
                this.wait(this.timeoutInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public long getTimeoutInterval() {
        return this.timeoutInterval;
    }

    public void setTimeoutInterval(long timeoutInterval) {
        this.timeoutInterval = timeoutInterval;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }
}

