/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.tree.MetadataEntityTreeNode;
import com.sas.util.PreorderTreeModelIterator;
import com.sas.util.Strings;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public abstract class TreeUtil {
    public static boolean isNodeSibling(TreeModel treeModel, Object node, Object siblingNode) {
        ArrayList<Object> childList = new ArrayList<Object>();
        boolean returnValue = false;
        PreorderTreeModelIterator e = new PreorderTreeModelIterator(treeModel);
        while (e.hasNext()) {
            Object nextNode = e.next();
            if (returnValue) continue;
            childList.clear();
            int childCount = treeModel.getChildCount(nextNode);
            for (int i = 0; i < childCount; ++i) {
                childList.add(treeModel.getChild(nextNode, i));
            }
            if (childList.contains(node) && childList.contains(siblingNode)) {
                returnValue = true;
                continue;
            }
            returnValue = false;
        }
        return returnValue;
    }

    public static Object[] getPathToRoot(TreeModel treeModel, Object node) {
        return TreeUtil.getPathToRoot(treeModel, node, false);
    }

    public static Object[] getPathToRoot(TreeModel treeModel, Object node, boolean findFirstMatch) {
        Object[] returnArray = new Object[]{};
        PreorderTreeModelIterator e = new PreorderTreeModelIterator(treeModel);
        while (e.hasNext()) {
            Object[] parentArray = e.getParentStack();
            Object nextNode = e.next();
            if (!nextNode.equals(node)) continue;
            Object[] tempArray = new Object[parentArray.length + 1];
            System.arraycopy(parentArray, 0, tempArray, 0, parentArray.length);
            tempArray[tempArray.length - 1] = nextNode;
            returnArray = tempArray;
            if (!findFirstMatch) continue;
            break;
        }
        return returnArray;
    }

    public static void expandAllNodes(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            if (!tree.isCollapsed(row)) continue;
            tree.expandRow(row);
        }
    }

    public static void expandTreeToLevel(JTree tree, int level) {
        int currentLevel = 0;
        if (!tree.isRootVisible()) {
            currentLevel = 1;
        }
        while (currentLevel <= level) {
            int rowCount = tree.getRowCount();
            for (int i = rowCount - 1; i >= 0; --i) {
                if (!tree.isCollapsed(i)) continue;
                tree.expandRow(i);
            }
            ++currentLevel;
        }
    }

    public static void expandFirstPath(JTree tree) {
        int row = 0;
        PreorderTreeModelIterator e = new PreorderTreeModelIterator(tree.getModel());
        while (e.hasNext()) {
            Object nextNode = e.next();
            if (tree.getModel().getChildCount(nextNode) == 0) {
                return;
            }
            if (tree.isCollapsed(row)) {
                tree.expandRow(row);
            }
            ++row;
        }
    }

    @SASScope
    public static TreePath getTreePathByUniqueMemberName(TreeModel treeModel, String uniqueMemberName) {
        if (treeModel != null && uniqueMemberName != null && uniqueMemberName.length() > 0) {
            int[] positions = Strings.positions((String)uniqueMemberName, (int)0, (int)(uniqueMemberName.length() - 1), (char)']');
            ArrayList<String> namePath = new ArrayList<String>();
            for (int i = positions.length - 1; i > 0; --i) {
                String name = uniqueMemberName.substring(positions[i - 1] + 3, positions[i]);
                namePath.add(0, name);
            }
            Object root = treeModel.getRoot();
            if (treeModel.getChildCount(root) > 0) {
                MetadataEntityTreeNode metaTreeNode;
                int c;
                int depth = 0;
                if (root instanceof MetadataEntityTreeNode && (c = Strings.count((String)(metaTreeNode = (MetadataEntityTreeNode)root).getUniqueName(), (int)0, (int)-1, (char)']')) == 3) {
                    depth = 1;
                }
                Object allNode = treeModel.getChild(root, 0);
                TreePath path = new TreePath(treeModel.getRoot());
                path = path.pathByAddingChild(allNode);
                return TreeUtil.findPath(treeModel, path, namePath.toArray(), depth);
            }
        }
        return null;
    }

    private static TreePath findPath(TreeModel treeModel, TreePath parent, Object[] names, int depth) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        String o = node.toString().trim();
        if (o.equals(names[depth])) {
            if (depth == names.length - 1) {
                return parent;
            }
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    TreePath result = TreeUtil.findPath(treeModel, path, names, depth + 1);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }
}

