/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.swing.visuals.util.FixFocusButton;
import com.sas.swing.visuals.util.RB;
import com.sas.text.Message;
import com.sas.util.Util;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingConstants;

public final class CommonButtons
implements SwingConstants {
    public static final String RB_KEY = "CommonButtons.";
    public static final int OK_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    public static final int APPLY_BUTTON = 4;
    public static final int HELP_BUTTON = 8;
    public static final int YES_BUTTON = 16;
    public static final int NO_BUTTON = 32;
    public static final int CLOSE_BUTTON = 64;
    public static final int BROWSE_BUTTON = 128;
    public static final int NO_BUTTONS = 4096;
    public static final int OK_CANCEL_BUTTONS = 3;
    public static final int OK_CANCEL_APPLY_BUTTONS = 7;
    public static final int YES_NO_BUTTONS = 48;
    public static final int YES_NO_CANCEL_BUTTONS = 50;

    private CommonButtons() {
    }

    public static AbstractButton[] createButtons(int buttonIds) {
        ArrayList<AbstractButton> list = new ArrayList<AbstractButton>();
        if ((1 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(1));
        }
        if ((4 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(4));
        }
        if ((0x10 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(16));
        }
        if ((0x20 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(32));
        }
        if ((2 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(2));
        }
        if ((0x40 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(64));
        }
        if ((0x80 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(128));
        }
        if ((8 & buttonIds) != 0) {
            list.add(CommonButtons.createButton(8));
        }
        return list.toArray(new JButton[0]);
    }

    public static AbstractButton createButton(int id) {
        CommonButtons.validateButtonID(id);
        FixFocusButton button = new FixFocusButton(CommonButtons.getLabel(id));
        button.putClientProperty("ID", new Integer(id));
        return button;
    }

    private static void validateButtonID(int id) {
        switch (id) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "unsupportedButton.txt"), (Object)new Integer(id)));
            }
        }
    }

    private static String getLabel(int id) {
        switch (id) {
            case 1: {
                return Util.getCommonStringResource((String)"Ok.txt");
            }
            case 2: {
                return Util.getCommonStringResource((String)"Cancel.txt");
            }
            case 4: {
                return Util.getCommonStringResource((String)"Apply.txt");
            }
            case 8: {
                return Util.getCommonStringResource((String)"Help.txt");
            }
            case 16: {
                return Util.getCommonStringResource((String)"Yes.txt");
            }
            case 32: {
                return Util.getCommonStringResource((String)"No.txt");
            }
            case 64: {
                return Util.getCommonStringResource((String)"Close.txt");
            }
            case 128: {
                return Util.getCommonStringResource((String)"Browse.txt");
            }
        }
        throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "invalidButton.txt"), (Object)new Integer(id)));
    }
}

