/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.util.ApplyInterface;
import com.sas.util.Command;
import java.awt.Component;
import java.util.Stack;

public class ChangeEnabledStateCommand
implements Command,
ApplyInterface {
    private boolean _state;
    private Stack _stack;

    public ChangeEnabledStateCommand(boolean state) {
        this._state = state;
    }

    public Object clone() throws CloneNotSupportedException {
        ChangeEnabledStateCommand clone = new ChangeEnabledStateCommand(this.getEnabledState());
        if (this._stack != null) {
            clone._stack = (Stack)this._stack.clone();
        }
        return clone;
    }

    public boolean getEnabledState() {
        return this._state;
    }

    public boolean isExecutable() {
        return true;
    }

    public void execute(Object obj) {
        Component component = (Component)obj;
        if (this._stack == null) {
            this._stack = new Stack();
        }
        this._stack.push(component);
        this._stack.push(component.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        component.setEnabled(this.getEnabledState());
    }

    public int apply(Object obj) {
        this.execute(obj);
        return 0;
    }

    public boolean isUndoable() {
        return true;
    }

    public void undo() {
        if (this._stack != null && !this._stack.empty()) {
            Boolean state = (Boolean)this._stack.pop();
            Component component = (Component)this._stack.pop();
            component.setEnabled(state);
        }
    }

    public void undoAll() {
        if (this._stack != null) {
            while (!this._stack.empty()) {
                this.undo();
            }
        }
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }
}

