/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.util;

import com.sas.net.ResourceLocatorInterface;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.swing.visuals.ImageIconResource;
import com.sas.swing.visuals.ImageView;
import com.sas.swing.visuals.util.IconMap;
import com.sas.swing.visuals.util.LayoutConstants;
import java.awt.Cursor;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

public class ActionUIFactory
implements LayoutConstants,
SwingConstants {
    private HashMap _menuBars;
    private HashMap _popupMenus;
    private HashMap _toolBars;
    private ResourceLocatorInterface _resourceLocator;
    private IconMap _iconMap;
    private static ReferenceQueue REFERENCE_QUEUE;

    public void populateMenuBar(JMenuBar menuBar, ActionList actionList) {
        if (actionList != null && menuBar != null) {
            List actions = actionList.getActions();
            int iCount = actions.size();
            for (int i = 0; i < iCount; ++i) {
                Object action = actions.get(i);
                if (action instanceof ActionList) {
                    menuBar.add(this.getMenu((ActionList)action));
                    continue;
                }
                if (!(action instanceof Action)) continue;
                menuBar.add(this.getMenu((Action)action));
            }
        }
    }

    public JMenuBar getMenuBar(ActionList actionList) {
        if (this._menuBars != null && this._menuBars.containsKey(actionList)) {
            return (JMenuBar)this._menuBars.get(actionList);
        }
        JMenuBar menuBar = this.newMenuBar();
        this.populateMenuBar(menuBar, actionList);
        if (this._menuBars == null) {
            this._menuBars = new HashMap();
        }
        this._menuBars.put(actionList, menuBar);
        return menuBar;
    }

    public JMenu getMenu(ActionList actionList) {
        boolean addSeparator = false;
        boolean itemsAdded = false;
        JMenu menu = this.getMenu((Action)actionList);
        if (actionList != null) {
            List actions = actionList.getActions();
            ButtonGroup buttonGroup = null;
            String groupName = null;
            int iCount = actions.size();
            for (int i = 0; i < iCount; ++i) {
                Object action = actions.get(i);
                if (action instanceof ActionList) {
                    if (addSeparator && itemsAdded) {
                        menu.addSeparator();
                    }
                    menu.add(this.getMenu((ActionList)action));
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action instanceof Action) {
                    if (addSeparator && itemsAdded) {
                        menu.addSeparator();
                    }
                    Action a = (Action)action;
                    JMenuItem item = this.getMenuItem(a);
                    String group = (String)a.getValue("GroupName");
                    if (group != null) {
                        if (!group.equals(groupName)) {
                            groupName = group;
                            buttonGroup = new ButtonGroup();
                        }
                        buttonGroup.add(item);
                    }
                    menu.add(item);
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action == ActionList.SEPARATOR) {
                    addSeparator = true;
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        return menu;
    }

    public JMenu getMenu(Action action) {
        JMenu menu = this.newMenu();
        this.loadActionResources(action);
        menu.setAction((javax.swing.Action)action);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            menu.setDisplayedMnemonicIndex(n);
        }
        return menu;
    }

    public void populatePopupMenu(JPopupMenu menu, ActionList actionList) {
        if (actionList != null && menu != null) {
            boolean addSeparator = false;
            boolean itemsAdded = false;
            List actions = actionList.getActions();
            int iCount = actions.size();
            for (int i = 0; i < iCount; ++i) {
                Object action = actions.get(i);
                if (action instanceof ActionList) {
                    if (addSeparator && itemsAdded) {
                        menu.addSeparator();
                    }
                    menu.add(this.getMenu((ActionList)action));
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action instanceof Action) {
                    if (addSeparator && itemsAdded) {
                        menu.addSeparator();
                    }
                    menu.add(this.getMenuItem((Action)action));
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action == ActionList.SEPARATOR) {
                    addSeparator = true;
                    continue;
                }
                throw new IllegalStateException();
            }
        }
    }

    public JPopupMenu getPopupMenu(ActionList actionList) {
        if (this._popupMenus != null && this._popupMenus.containsKey(actionList)) {
            return (JPopupMenu)this._popupMenus.get(actionList);
        }
        JPopupMenu menu = this.newPopupMenu();
        this.populatePopupMenu(menu, actionList);
        if (this._popupMenus == null) {
            this._popupMenus = new HashMap();
        }
        this._popupMenus.put(actionList, menu);
        return menu;
    }

    public JMenuItem getMenuItem(Action action) {
        this.loadActionResources(action);
        return this.newMenuItem(action);
    }

    public void populateToolBar(JToolBar toolBar, ActionList actionList) {
        if (actionList != null && toolBar != null) {
            boolean addSeparator = false;
            boolean itemsAdded = false;
            List actions = actionList.getActions();
            ButtonGroup buttonGroup = null;
            String groupName = null;
            int iCount = actions.size();
            for (int i = 0; i < iCount; ++i) {
                Object action = actions.get(i);
                if (action instanceof ActionList) {
                    if (addSeparator && itemsAdded) {
                        toolBar.addSeparator();
                    }
                    toolBar.add(this.getToolBar((ActionList)action));
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action instanceof Action) {
                    if (addSeparator && itemsAdded) {
                        toolBar.addSeparator();
                    }
                    Action a = (Action)action;
                    AbstractButton item = this.getToolItem(a);
                    String group = (String)a.getValue("GroupName");
                    if (group != null) {
                        if (!group.equals(groupName)) {
                            groupName = group;
                            buttonGroup = new ButtonGroup();
                        }
                        buttonGroup.add(item);
                    }
                    toolBar.add(item);
                    addSeparator = false;
                    itemsAdded = true;
                    continue;
                }
                if (action == ActionList.SEPARATOR) {
                    addSeparator = true;
                    continue;
                }
                throw new IllegalStateException();
            }
        }
    }

    public JToolBar getToolBar(ActionList actionList) {
        if (this._toolBars != null && this._toolBars.containsKey(actionList)) {
            return (JToolBar)this._toolBars.get(actionList);
        }
        JToolBar toolBar = this.newToolBar();
        this.populateToolBar(toolBar, actionList);
        if (this._toolBars == null) {
            this._toolBars = new HashMap();
        }
        this._toolBars.put(actionList, toolBar);
        return toolBar;
    }

    public AbstractButton getButton(Action action) {
        this.loadActionResources(action);
        return this.newButton(action);
    }

    public AbstractButton getToolItem(Action action) {
        this.loadActionResources(action);
        return this.newToolItem(action);
    }

    public AbstractButton getTaskItem(Action action) {
        this.loadActionResources(action);
        return this.newTaskItem(action);
    }

    public AbstractButton getShortcutItem(Action action) {
        return this.getShortcutItem(action, false);
    }

    public AbstractButton getShortcutItem(Action action, boolean smallIcons) {
        this.loadActionResources(action);
        return this.newShortcutItem(action, smallIcons);
    }

    public ActionList getActionList(JMenuBar menuBar) {
        return (ActionList)this.getKeyFromValue(this._menuBars, menuBar);
    }

    public ActionList getActionList(JPopupMenu popupMenu) {
        return (ActionList)this.getKeyFromValue(this._popupMenus, popupMenu);
    }

    public ActionList getActionList(JMenu menu) {
        return (ActionList)menu.getAction();
    }

    public Action getAction(JMenuItem menuItem) {
        return (Action)menuItem.getAction();
    }

    public ActionList getActionList(JToolBar toolBar) {
        return (ActionList)this.getKeyFromValue(this._toolBars, toolBar);
    }

    public Action getAction(AbstractButton toolItem) {
        return (Action)toolItem.getAction();
    }

    public ResourceLocatorInterface getResourceLocator() {
        return this._resourceLocator;
    }

    public IconMap getIconMap() {
        return this._iconMap;
    }

    public void setIconMap(IconMap iconMap) {
        this._iconMap = iconMap;
    }

    public void setResourceLocator(ResourceLocatorInterface resourceLocator) {
        this._resourceLocator = resourceLocator;
    }

    protected JMenuBar newMenuBar() {
        return new JMenuBar();
    }

    protected JPopupMenu newPopupMenu() {
        return new JPopupMenu();
    }

    protected JMenu newMenu() {
        return new JMenu();
    }

    protected JMenuItem newMenuItem(Action action) {
        JMenuItem menuItem;
        String actionType = (String)action.getValue("Type");
        if ("boolean".equals(actionType)) {
            menuItem = action.getValue("GroupName") != null ? this.newRadioButtonMenuItem() : this.newCheckBoxMenuItem();
            Object obj = action.getValue("state");
            if (obj != null && obj instanceof Boolean) {
                menuItem.setSelected((Boolean)obj);
            } else {
                menuItem.setSelected(false);
            }
            action.addPropertyChangeListener((PropertyChangeListener)new ButtonStateListener(menuItem, action));
        } else {
            menuItem = this.newMenuItem();
        }
        this.loadActionResources(action);
        menuItem.setAction((javax.swing.Action)action);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            menuItem.setDisplayedMnemonicIndex(n);
        }
        menuItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        menuItem.setToolTipText(null);
        return menuItem;
    }

    protected JMenuItem newMenuItem() {
        return new JMenuItem();
    }

    protected JMenuItem newCheckBoxMenuItem() {
        return new JCheckBoxMenuItem();
    }

    protected JMenuItem newRadioButtonMenuItem() {
        return new JRadioButtonMenuItem();
    }

    protected JToolBar newToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        return bar;
    }

    protected AbstractButton newTaskItem(Action action) {
        AbstractButton taskItem = this.newToolItem(action);
        Object longName = action.getValue("LongName");
        if (longName != null) {
            taskItem.setText((String)longName);
        } else {
            taskItem.setText((String)action.getValue("Name"));
        }
        taskItem.setCursor(Cursor.getPredefinedCursor(12));
        taskItem.setHorizontalAlignment(2);
        taskItem.setBorder(null);
        taskItem.setMnemonic(0);
        taskItem.setMargin(new Insets(0, 5, 0, 5));
        return taskItem;
    }

    protected AbstractButton newToolItem(Action action) {
        AbstractButton button;
        String actionType = (String)action.getValue("Type");
        if ("boolean".equals(actionType)) {
            button = action.getValue("GroupName") != null ? this.newRadioButton() : this.newCheckBox();
            Object obj = action.getValue("state");
            if (obj != null && obj instanceof Boolean) {
                button.setSelected((Boolean)obj);
            }
            action.addPropertyChangeListener((PropertyChangeListener)new ButtonStateListener(button, action));
        } else {
            button = this.newButton();
        }
        button.setMargin(EMPTY_INSETS);
        button.setRolloverEnabled(true);
        button.setAction((javax.swing.Action)action);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            button.setDisplayedMnemonicIndex(n);
        }
        return button;
    }

    protected AbstractButton newButton(Action action) {
        AbstractButton button;
        String actionType = (String)action.getValue("Type");
        if ("boolean".equals(actionType)) {
            button = this.newToggleButton();
            Object obj = action.getValue("state");
            if (obj != null && obj instanceof Boolean) {
                button.setSelected((Boolean)obj);
            }
            action.addPropertyChangeListener((PropertyChangeListener)new ButtonStateListener(button, action));
        } else {
            button = this.newButton();
        }
        button.setAction((javax.swing.Action)action);
        Integer n = (Integer)action.getValue("MnemonicIndex");
        if (n != null) {
            button.setDisplayedMnemonicIndex(n);
        }
        return button;
    }

    protected AbstractButton newButton() {
        return new JButton();
    }

    protected AbstractButton newCheckBox() {
        return new JCheckBox();
    }

    protected AbstractButton newRadioButton() {
        return new JRadioButton();
    }

    protected AbstractButton newToggleButton() {
        return new JToggleButton();
    }

    protected AbstractButton newShortcutItem(Action action) {
        return this.newShortcutItem(action, false);
    }

    protected AbstractButton newShortcutItem(Action action, boolean smallIcons) {
        AbstractButton button = this.newButton();
        button.setMargin(EMPTY_INSETS);
        button.setAction((javax.swing.Action)action);
        button.setMnemonic(0);
        button.setRolloverEnabled(true);
        if (!smallIcons) {
            button.setHorizontalTextPosition(0);
            button.setVerticalTextPosition(3);
            button.setMargin(new Insets(0, 3, 0, 3));
            Object largeIcon = action.getValue("LargeIcon");
            if (largeIcon != null) {
                button.setIcon((Icon)largeIcon);
            }
        }
        return button;
    }

    private Object getKeyFromValue(HashMap map, Object value) {
        for (Object key : map.keySet()) {
            if (map.get(key) != value) continue;
            return key;
        }
        return null;
    }

    public void loadActionResources(Action action) {
        this.loadIcon(action, "SmallIcon", "SmallIconName");
        this.loadIcon(action, "LargeIcon", "LargeIconName");
    }

    private void loadIcon(Action action, String iconProperty, String iconNameProperty) {
        String iconName;
        if (action.getValue(iconProperty) == null && (iconName = (String)action.getValue(iconNameProperty)) != null) {
            if (this.getIconMap() != null) {
                action.putValue(iconProperty, (Object)this.getIconMap().getIcon(iconName));
            } else if (this.getResourceLocator() != null) {
                ResourceLocatorInterface resourceLocator = this.getResourceLocator();
                resourceLocator.setResourceName(iconName);
                action.putValue(iconProperty, (Object)new ImageIconResource(resourceLocator));
            } else {
                action.putValue(iconProperty, (Object)new ImageView(iconName));
            }
        }
    }

    class OwnedWeakReference
    extends WeakReference {
        private Object _owner;

        public OwnedWeakReference(Object target, ReferenceQueue queue, Object owner) {
            super(target, queue);
            this._owner = owner;
        }

        public Object getOwner() {
            return this._owner;
        }
    }

    class ButtonStateListener
    implements PropertyChangeListener {
        private WeakReference _target;
        private Action _action;

        public ButtonStateListener(AbstractButton c, Action a) {
            this.setTarget(c);
            this._action = a;
        }

        public void setTarget(AbstractButton c) {
            OwnedWeakReference r;
            if (REFERENCE_QUEUE == null) {
                REFERENCE_QUEUE = new ReferenceQueue();
            }
            while ((r = (OwnedWeakReference)REFERENCE_QUEUE.poll()) != null) {
                ButtonStateListener oldPCL = (ButtonStateListener)r.getOwner();
                Action oldAction = oldPCL.getAction();
                if (oldAction == null) continue;
                oldAction.removePropertyChangeListener((PropertyChangeListener)oldPCL);
            }
            this._target = new OwnedWeakReference(c, REFERENCE_QUEUE, this);
        }

        public AbstractButton getTarget() {
            return (AbstractButton)this._target.get();
        }

        public Action getAction() {
            return this._action;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Boolean selected;
            AbstractButton button = this.getTarget();
            if (button == null) {
                return;
            }
            if ("state".equals(event.getPropertyName()) && (selected = (Boolean)event.getNewValue()) != null) {
                button.setSelected(selected);
            }
        }
    }
}

