/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.treetable.ZoneByData;
import com.sas.swing.visuals.treetable.ZoneByTree;
import com.sas.swing.visuals.treetable.ZoneDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.table.TableModel;

public class Zones {
    ArrayList zonedefs;
    TreeTable tt;
    Color lineColor;
    BasicStroke[] styles;
    boolean enabled;

    public Zones(TreeTable t) {
        this.clear();
        this.lineColor = Color.black;
        this.tt = t;
        this.enabled = true;
    }

    public void clear() {
        this.zonedefs = new ArrayList();
    }

    public void add(ZoneDefinition d) {
        if (d == null) {
            throw new IllegalArgumentException();
        }
        this.zonedefs.add(d);
    }

    public void addDataZone(int i) {
        this.zonedefs.add(new ZoneByData(i));
    }

    public void addTreeZone(int i) {
        this.zonedefs.add(new ZoneByTree(i));
    }

    public void addDataZone(Object x) {
        this.addDataZone(this.tt.getColumnIndex(x));
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    protected int depth(int rx) {
        int maxdepth = this.zonedefs.size();
        TableModel tm = this.tt.getModel();
        if (tm instanceof TreeTableModel) {
            TreeTableRow row = ((TreeTableModel)tm).getRowAt(rx);
            for (int i = 0; i < maxdepth; ++i) {
                ZoneDefinition d = (ZoneDefinition)this.zonedefs.get(i);
                if (d.contains(row)) continue;
                return i - 1;
            }
        } else {
            Object[] row = this.getRowAt(tm, rx);
            for (int i = 0; i < maxdepth; ++i) {
                ZoneDefinition d = (ZoneDefinition)this.zonedefs.get(i);
                if (d.contains(row)) continue;
                return i - 1;
            }
        }
        return maxdepth;
    }

    protected int diff(int r) {
        int i;
        if (this.zonedefs.size() == 0) {
            return 0;
        }
        ZoneDefinition d0 = (ZoneDefinition)this.zonedefs.get(0);
        TableModel tm = this.tt.getModel();
        if (tm instanceof TreeTableModel) {
            ZoneDefinition di;
            TreeTableModel ttm = (TreeTableModel)tm;
            TreeTableRow row0 = ttm.getRowAt(r);
            TreeTableRow row1 = ttm.getRowAt(r + 1);
            if (!d0.contains(row0) && !d0.contains(row1)) {
                return 0;
            }
            for (i = 0; i < this.zonedefs.size() && (di = (ZoneDefinition)this.zonedefs.get(i)).equal(row0, row1); ++i) {
            }
        } else {
            ZoneDefinition di;
            Object[] row0 = this.getRowAt(tm, r);
            Object[] row1 = this.getRowAt(tm, r + 1);
            if (!d0.contains(row0) && !d0.contains(row1)) {
                return 0;
            }
            for (i = 0; i < this.zonedefs.size() && (di = (ZoneDefinition)this.zonedefs.get(i)).equal(row0, row1); ++i) {
            }
        }
        return this.zonedefs.size() - i;
    }

    public void paint(Graphics2D g, Component c) {
        if (!this.enabled) {
            return;
        }
        TableModel tm = this.tt.getModel();
        this.paintInit();
        int rowHeight = this.tt.getRowHeight();
        int r0 = 0;
        int r1 = tm.getRowCount() - 2;
        int y0 = rowHeight;
        int y1 = c.getHeight();
        int x0 = 0;
        int x1 = c.getWidth();
        int y = y0;
        for (int r = r0; r <= r1; ++r) {
            int d = this.diff(r);
            if (d > 0) {
                g.setColor(this.lineColor);
                g.setStroke(this.styles[d - 1]);
                g.drawLine(x0, y, x1, y);
            }
            y += rowHeight;
        }
    }

    protected void paintInit() {
        if (this.styles != null && this.styles.length == this.zonedefs.size()) {
            return;
        }
        this.styles = new BasicStroke[this.zonedefs.size()];
        float dashlen = (float)(8.0 * (double)this.zonedefs.size() - 6.0);
        float spacelen = 0.0f;
        for (int s = this.zonedefs.size() - 1; s >= 0; --s) {
            float[] dashinfo = new float[]{dashlen, spacelen};
            this.styles[s] = new BasicStroke(1.0f, 0, 2, 2.0f, dashinfo, 0.0f);
            dashlen = (float)((double)dashlen - 8.0);
            spacelen = 8.0f;
        }
    }

    private Object[] getRowAt(TableModel m, int rx) {
        Object[] row = new Object[m.getColumnCount()];
        for (int cx = 0; cx < row.length; ++cx) {
            row[cx] = m.getValueAt(rx, cx);
        }
        return row;
    }
}

