/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.MissingValues;
import com.sas.swing.visuals.treetable.ConcatenatedFieldComparator;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.treetable.TreeTableRowRE;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableModel
extends DefaultTreeModel
implements TreeModel,
TableModel,
TreeWillExpandListener {
    protected JTree jtree;
    protected TreeTable treetable;
    protected String[] columnNames;
    protected TreeTableRow root;
    protected DefaultTableModel tm;
    protected boolean displayedAsTree = true;
    protected boolean rootVisible;
    protected ArrayList visibleMap;
    protected ArrayList naturalMap;
    protected boolean visibleMap_ok;
    protected boolean naturalMap_ok;
    private IdentityHashMap expandedRows;
    private boolean sorting = false;
    boolean savedNodeExpansionStateIsWritable = true;
    Class[] columnClassCache;
    protected Hashtable columnEditableFlags = new Hashtable();
    protected Comparator lastComparator = null;

    public TreeTableModel(TreeNode r, String[] cNames) {
        this(r);
        this.columnNames = cNames;
    }

    public TreeTableModel(TreeNode r) {
        super(r);
        this.expandedRows = new IdentityHashMap();
        this.root = (TreeTableRow)r;
        this.setTreeModelOnSubtree(this, this.root);
        this.tm = new DefaultTableModel();
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        this.rootVisible = true;
    }

    public TreeTableModel() {
        super(null);
        this.expandedRows = new IdentityHashMap();
        this.tm = new DefaultTableModel();
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        this.rootVisible = true;
    }

    @Override
    public void setRoot(TreeNode newRoot) {
        if (newRoot == this.root) {
            return;
        }
        this._removeFromParent(newRoot);
        this.setTreeModelOnSubtree(null, this.root);
        super.setRoot(newRoot);
        this.root = (TreeTableRow)newRoot;
        this.setTreeModelOnSubtree(this, this.root);
        this.refreshJTreeExpandState();
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        this.fireTableDataChanged();
    }

    public void setTreeModelOnSubtree(TreeTableModel m, TreeTableRow t) {
        if (t == null) {
            return;
        }
        Enumeration<TreeNode> nodes = t.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            TreeTableRow n = (TreeTableRow)nodes.nextElement();
            n.setTreeModel(m);
        }
    }

    private void _removeFromParent(TreeNode newRoot) throws IllegalArgumentException {
        if (newRoot != null) {
            if (newRoot instanceof MutableTreeNode) {
                ((MutableTreeNode)newRoot).removeFromParent();
            } else if (newRoot.getParent() != null) {
                throw new IllegalArgumentException("newRoot.parent!=null && !newRoot instanceof MutableTreeNode");
            }
        }
    }

    public JTree getTree() {
        return this.jtree;
    }

    public void setTree(JTree t) {
        if (this.jtree != null) {
            this.jtree.removeTreeWillExpandListener(this);
        }
        this.jtree = t;
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        if (this.jtree != null) {
            this.jtree.setRootVisible(this.rootVisible);
            this.jtree.addTreeWillExpandListener(this);
            this.jtree.setModel(this);
            this.naturalMap_ok = false;
            this.visibleMap_ok = false;
            this.refreshJTreeExpandState();
        }
    }

    public TreeTable getTreeTable() {
        return this.treetable;
    }

    public void setTreeTable(TreeTable tt) {
        this.treetable = tt;
    }

    public boolean getDisplayedAsTree() {
        return this.displayedAsTree;
    }

    public void setDisplayedAsTree(boolean d) {
        boolean old_d = this.displayedAsTree;
        this.displayedAsTree = d;
        if (d != old_d) {
            this.visibleMap_ok = false;
            this.sort(this.lastComparator);
            this.rebuildVisibleMap();
        }
    }

    public boolean getRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean v) {
        this.rootVisible = v;
        if (this.jtree != null) {
            this.jtree.setRootVisible(v);
        }
        this.visibleMap_ok = false;
        this.fireTableDataChanged();
    }

    public TreeTableRow getRowAt(int rx) throws IndexOutOfBoundsException {
        return this.getRowAt(rx, true);
    }

    public int indexOf(TreeTableRow row) {
        return this.indexOf(row, true);
    }

    public TreeTableRow getRowAt(int rx, boolean visibleRowsOnly) throws IndexOutOfBoundsException {
        if (visibleRowsOnly) {
            this.rebuildVisibleMap();
            return (TreeTableRow)this.visibleMap.get(rx);
        }
        this.rebuildNaturalMap();
        return (TreeTableRow)this.naturalMap.get(rx);
    }

    public int indexOf(TreeTableRow row, boolean visibleRowsOnly) {
        if (visibleRowsOnly) {
            this.rebuildVisibleMap();
            return this.visibleMap.indexOf(row);
        }
        this.rebuildNaturalMap();
        return this.naturalMap.indexOf(row);
    }

    @Override
    public Object getValueAt(int rx, int cx) {
        Object[] row = this.getRowDataAt(rx);
        if (row == null || cx < 0 || cx >= row.length) {
            return null;
        }
        return row[cx];
    }

    @Override
    public void setValueAt(Object value, int rx, int cx) throws IndexOutOfBoundsException {
        TreeNode root;
        TreeTableRow node;
        if (this.treetable != null) {
            this.treetable.saveSelectionState();
        }
        if ((node = this.getRowAt(rx)) == (root = (TreeNode)this.getRoot())) {
            if (node.setValueAt(value, cx)) {
                this.fireTableCellUpdated(rx, cx);
                this.jtree.updateUI();
            }
        } else {
            TreeTableRow parent = (TreeTableRow)node.getParent();
            int nodePositionInParent = parent.getIndex(node);
            boolean isParentCollapsed = parent.isCollapsed();
            parent.remove(node);
            boolean setOk = node.setValueAt(value, cx);
            parent.insert(node, nodePositionInParent);
            if (!isParentCollapsed && parent.isCollapsed()) {
                TreeNode[] tr = parent.getPath();
                this.expandPath(tr);
            }
            if (setOk) {
                this.fireTableCellUpdated(rx, cx);
            }
        }
        this.refreshJTreeExpandState(new TreePath(this.getPathToRoot(node)));
        if (this.treetable != null) {
            this.treetable.restoreSelectionState();
        }
    }

    protected Object[] getRowDataAt(int rx) throws IndexOutOfBoundsException {
        return this.getRowAt(rx).getTableRow();
    }

    protected Object[] getRowDataAt(int rx, boolean visibleRowsOnly) throws IndexOutOfBoundsException {
        return this.getRowAt(rx, visibleRowsOnly).getTableRow();
    }

    public String getLinkCommand(int rx, int cx, boolean visibleRowsOnly) {
        TreeTableRow node = this.getRowAt(rx, visibleRowsOnly);
        return node != null ? node.getLinkCommand(cx) : null;
    }

    public boolean setLinkCommand(String cmd, int rx, int cx, boolean visibleRowsOnly) {
        TreeTableRow node = this.getRowAt(rx, visibleRowsOnly);
        return node != null ? node.setLinkCommand(cx, cmd) : false;
    }

    public void expandToDepth(int depth, boolean trim) {
        this.expandToDepth((TreeTableRow)this.getRoot(), depth, trim);
    }

    public void expandToDepth(TreeTableRow n, int maxdepth, boolean trim) {
        int ndepth = n.getLevel();
        if (ndepth > maxdepth || this.isLeaf(n)) {
            return;
        }
        if (ndepth < maxdepth) {
            if (n.isCollapsed()) {
                this.expandPath(n.getPath());
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                TreeTableRow n2 = (TreeTableRow)n.getChildAt(i);
                this.expandToDepth(n2, maxdepth, trim);
            }
        } else if (trim && !n.isCollapsed()) {
            this.collapsePath(n.getPath());
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        this.treeExpansion(true, e);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
        this.treeExpansion(false, e);
    }

    private void treeExpansion(boolean expanded, TreeExpansionEvent event) {
        if (!this.savedNodeExpansionStateIsWritable) {
            return;
        }
        TreeTableRow n = (TreeTableRow)event.getPath().getLastPathComponent();
        n.setExpanded(expanded);
        this.visibleMap_ok = false;
    }

    @Override
    public int getRowCount() {
        return this.getRowCount(true);
    }

    public int getTotalRowCount() {
        return this.getRowCount(false);
    }

    public int getRowCount(boolean visibleRowsOnly) {
        if (visibleRowsOnly) {
            this.rebuildVisibleMap();
            return this.visibleMap.size();
        }
        this.rebuildNaturalMap();
        return this.naturalMap.size();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] cNames) {
        this.columnNames = cNames;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int cx) {
        return this.columnNames[cx];
    }

    public Class getColumnClass(int cx) {
        Object[] row;
        int nr = this.getRowCount(false);
        if (nr == 0) {
            return Object.class;
        }
        if (this.columnClassCache == null) {
            row = this.getRowDataAt(0, false);
            this.columnClassCache = new Class[row.length];
        }
        if (cx < 0 || cx >= this.columnClassCache.length) {
            return null;
        }
        int rx = 0;
        while (this.columnClassCache[cx] == null) {
            try {
                row = this.getRowDataAt(rx, false);
            }
            catch (IndexOutOfBoundsException e) {
                return Object.class;
            }
            Object element = row[cx];
            if (element != null && !(element instanceof MissingValues)) {
                this.columnClassCache[cx] = row[cx].getClass();
            }
            ++rx;
        }
        return this.columnClassCache[cx];
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tm.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tm.removeTableModelListener(l);
    }

    public void fireTableDataChanged() {
        this.tm.fireTableDataChanged();
    }

    public void fireTableRowsInserted(int r0, int r1) {
        this.tm.fireTableRowsInserted(r0, r1);
    }

    public void fireTableRowsUpdated(int r0, int r1) {
        this.tm.fireTableRowsUpdated(r0, r1);
    }

    public void fireTableRowsDeleted(int r0, int r1) {
        this.tm.fireTableRowsDeleted(r0, r1);
    }

    public void fireTableCellUpdated(int r, int c) {
        this.tm.fireTableChanged(new MutableTableModelEvent(this.tm, r, r, c));
    }

    public void fireTableStructureChanged() {
        this.tm.fireTableStructureChanged();
    }

    public void fireTableChanged(TableModelEvent e) {
        this.tm.fireTableChanged(e);
    }

    public void fireTreeNodeChanged(TreeTableRow r) {
        int pathLength = r.getLevel() + 1;
        Object[] path = new Object[pathLength];
        TreeNode node = r;
        for (int i = pathLength - 1; i >= 0; --i) {
            path[i] = node;
            node = node.getParent();
        }
        super.fireTreeNodesChanged(r, path, null, null);
    }

    @Override
    public boolean isCellEditable(int rx, int cx) {
        return this.isRowEditable(rx) && this.isColumnEditable(cx);
    }

    public boolean isRowEditable(int rx) throws IndexOutOfBoundsException {
        TreeTableRow r = this.getRowAt(rx);
        return r != null && r.isEditable();
    }

    public void setRowEditable(int rx, boolean ed) throws IndexOutOfBoundsException {
        TreeTableRow r = this.getRowAt(rx);
        if (r != null) {
            r.setEditable(ed);
        }
    }

    public boolean isColumnEditable(int cx) throws IndexOutOfBoundsException {
        if (cx < 0 || cx >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
        Integer key = new Integer(cx);
        return this.columnEditableFlags.get(key) == null;
    }

    public void setColumnEditable(int cx, boolean ed) throws IndexOutOfBoundsException {
        if (cx < 0 || cx >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
        Integer key = new Integer(cx);
        if (ed) {
            this.columnEditableFlags.remove(key);
        } else {
            this.columnEditableFlags.put(key, key);
        }
    }

    @Override
    public void nodesWereInserted(TreeNode parent, int[] indices) {
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        super.nodesWereInserted(parent, indices);
        for (int i = 0; i < indices.length; ++i) {
            TreeTableRow row = (TreeTableRow)parent.getChildAt(indices[i]);
            this.setTreeModelOnSubtree(this, row);
        }
        if (this.sorting) {
            return;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void nodesWereRemoved(TreeNode parent, int[] indices, Object[] removed) {
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        for (int i = 0; i < removed.length; ++i) {
            this.setTreeModelOnSubtree(null, (TreeTableRow)removed[i]);
        }
        super.nodesWereRemoved(parent, indices, removed);
        if (this.sorting) {
            return;
        }
        this.fireTableDataChanged();
    }

    @Override
    public void nodeStructureChanged(TreeNode parent) {
        this.naturalMap_ok = false;
        this.visibleMap_ok = false;
        super.nodeStructureChanged(parent);
        this.setTreeModelOnSubtree(this, (TreeTableRow)parent);
        this.fireTableDataChanged();
    }

    public void rebuildMaps() {
        this.rebuildVisibleMap();
    }

    protected void rebuildNaturalMap() {
        if (!this.naturalMap_ok) {
            this.naturalMap = new ArrayList();
            this.mapSubtree((TreeTableRow)this.getRoot(), new MapCounter());
            this.naturalMap_ok = true;
            this.visibleMap_ok = false;
        }
    }

    protected void rebuildVisibleMap() {
        if (!this.visibleMap_ok) {
            this.visibleMap = new ArrayList();
            this.mapVisibleSubtree(new MapCounter());
            if (!this.displayedAsTree && this.comparatorOK(this.lastComparator)) {
                this.tableSort(this.lastComparator);
            }
            this.visibleMap_ok = true;
            this.fireTableDataChanged();
        }
    }

    protected void mapSubtree(TreeNode n, MapCounter k) {
        if (this.naturalMap.size() != k.index) {
            throw new NullPointerException("sanity check failed");
        }
        if (n == null) {
            return;
        }
        this.naturalMap.add(k.index, n);
        ++k.index;
        for (int i = 0; i < n.getChildCount(); ++i) {
            TreeNode childNode = n.getChildAt(i);
            this.mapSubtree(childNode, k);
        }
    }

    protected void mapVisibleSubtree(MapCounter k) throws IndexOutOfBoundsException {
        TreeTableRow rootNode;
        int first;
        int numRows = this.getRowCount(false);
        int n = first = this.rootVisible ? 0 : 1;
        if (!this.rootVisible && (rootNode = this.getRowAt(0, false)).isCollapsed()) {
            return;
        }
        for (int naturalIndex = first; naturalIndex < numRows; ++naturalIndex) {
            TreeTableRow n2 = this.getRowAt(naturalIndex, false);
            if (this.visibleMap.size() != k.index) {
                throw new NullPointerException("sanity check failed");
            }
            this.visibleMap.add(k.index, n2);
            if (!this.isLeaf(n2) && n2.isCollapsed()) {
                TreeTableRow m;
                int n_level = n2.getLevel();
                int j = naturalIndex + 1;
                while (j < numRows && (m = this.getRowAt(j, false)).getLevel() > n_level) {
                    naturalIndex = j++;
                }
            }
            ++k.index;
        }
    }

    void sort(Comparator comp) {
        this.lastComparator = comp;
        if (!this.comparatorOK(comp)) {
            return;
        }
        try {
            this.sorting = true;
            if (this.displayedAsTree) {
                this.treeSort((TreeTableRow)this.getRoot(), comp);
                this.naturalMap_ok = false;
                this.visibleMap_ok = false;
                this.refreshJTreeExpandState();
            } else {
                this.tableSort(comp);
            }
        }
        finally {
            this.sorting = false;
        }
        this.fireTableDataChanged();
    }

    protected void treeSort(TreeTableRow n, Comparator comp) {
        if (n == null) {
            return;
        }
        int len = n.getChildCount();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(len);
        for (int i = 0; i < len; ++i) {
            children.add(n.getChildAt(i));
        }
        Collections.sort(children, comp);
        boolean nExpanded = n.isExpanded();
        n.removeAllChildren();
        for (int i = 0; i < len; ++i) {
            TreeTableRow n2 = (TreeTableRow)children.get(i);
            n.add(n2);
            this.treeSort(n2, comp);
        }
        n.setExpanded(nExpanded);
    }

    protected void tableSort(Comparator comp) {
        Collections.sort(this.visibleMap, comp);
    }

    protected boolean comparatorOK(Comparator c) {
        return c != null && (!(c instanceof ConcatenatedFieldComparator) || ((ConcatenatedFieldComparator)c).getLength() > 0);
    }

    protected void collapsePath(TreeNode[] pp) {
        this.collapsePath(new TreePath(pp));
    }

    protected void collapsePath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.collapsePath(p);
        }
        TreeTableRow n = (TreeTableRow)p.getLastPathComponent();
        n.setExpanded(false);
        this.visibleMap_ok = false;
    }

    protected void expandPath(TreeNode[] pp) {
        this.expandPath(new TreePath(pp));
    }

    protected void expandPath(TreePath p) {
        if (this.jtree != null) {
            this.jtree.expandPath(p);
        }
        TreeTableRow n = (TreeTableRow)p.getLastPathComponent();
        n.setExpanded(true);
        this.visibleMap_ok = false;
    }

    public Collection getTreeExpansionState() {
        ArrayList<TreeTableRow> rows = new ArrayList<TreeTableRow>();
        for (TreeTableRow r : this.expandedRows.keySet()) {
            rows.add(r);
        }
        return rows;
    }

    void setRowExpansionState(TreeTableRow r, boolean exp) {
        if (exp) {
            this.expandedRows.put(r, null);
        } else {
            this.expandedRows.remove(r);
        }
    }

    protected void refreshJTreeExpandState() {
        this.setTreeExpansionState(new ExpandedTreeTableRowRecognizer());
    }

    protected void refreshJTreeExpandState(TreePath p) {
        boolean wasWritable = this.savedNodeExpansionStateIsWritable;
        this.savedNodeExpansionStateIsWritable = false;
        this.setTreeExpansionState(p, new ExpandedTreeTableRowRecognizer());
        this.savedNodeExpansionStateIsWritable = wasWritable;
    }

    public void setTreeExpansionState(Collection state) {
        if (this.jtree == null) {
            return;
        }
        this.rebuildNaturalMap();
        TreeTableRowRE ttrr = null;
        if (this.jtree instanceof TreeTableRowRE) {
            ttrr = (TreeTableRowRE)this.jtree;
        }
        if (ttrr != null) {
            ttrr.disconnectTreeExpansionListeners();
        }
        this.savedNodeExpansionStateIsWritable = false;
        Object rootNode = this.getRoot();
        this.expandedRows.clear();
        this.visibleMap_ok = false;
        if (rootNode != null) {
            this.setTreeExpansionState(new TreePath(rootNode), state);
        }
        this.savedNodeExpansionStateIsWritable = true;
        if (ttrr != null) {
            ttrr.reconnectTreeExpansionListeners();
        }
        this.rebuildVisibleMap();
    }

    private void setTreeExpansionState(TreePath p, Collection expand) {
        TreeTableRow n = (TreeTableRow)p.getLastPathComponent();
        for (int i = 0; i < n.getChildCount(); ++i) {
            TreeNode n2 = n.getChildAt(i);
            TreePath p2 = p.pathByAddingChild(n2);
            this.setTreeExpansionState(p2, expand);
        }
        if (expand.contains(n)) {
            this.jtree.expandPath(p);
            n.setExpanded(true);
        } else {
            this.jtree.collapsePath(p);
            n.setExpanded(false);
        }
    }

    private class ExpandedTreeTableRowRecognizer
    extends AbstractCollection {
        private ExpandedTreeTableRowRecognizer() {
        }

        @Override
        public boolean contains(Object x) {
            return x instanceof TreeTableRow && ((TreeTableRow)x).isExpanded();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return null;
        }
    }

    private class MapCounter {
        public int index = 0;
    }

    class MutableTableModelEvent
    extends TableModelEvent {
        public MutableTableModelEvent(TableModel m) {
            super(m);
        }

        public MutableTableModelEvent(TableModel m, int r) {
            super(m, r);
        }

        public MutableTableModelEvent(TableModel m, int r0, int r1) {
            super(m, r0, r1);
        }

        public MutableTableModelEvent(TableModel m, int r0, int r1, int c) {
            super(m, r0, r1, c);
        }

        public MutableTableModelEvent(TableModel m, int r0, int r1, int c, int t) {
            super(m, r0, r1, c, t);
        }

        public void setFirstRow(int r) {
            this.firstRow = r;
        }

        public void setLastRow(int r) {
            this.lastRow = r;
        }

        public void setColumn(int c) {
            this.column = c;
        }

        public void setType(int t) {
            this.type = t;
        }
    }
}

