/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.CellActionEvent;
import com.sas.swing.visuals.treetable.RB;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;

public abstract class CellAction {
    public static final CellAction EDIT = new CellAction(CellAction.getResource("editCellContents")){

        @Override
        public boolean isAvailable(JTable t, int rx, int cx, Object value) {
            return t.isCellEditable(rx, cx);
        }

        @Override
        public void perform(CellActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JTable) {
                JTable t = (JTable)src;
                int rx = e.getRow();
                int cx = e.getColumn();
                t.editCellAt(rx, cx);
            }
        }
    };
    public static final CellAction TOGGLE_ROW_SELECTION = new CellAction(CellAction.getResource("toggleRowSelection")){

        @Override
        public boolean isAvailable(JTable t, int rx, int cx, Object value) {
            return t.getRowSelectionAllowed();
        }

        @Override
        public void perform(CellActionEvent e) {
            Object src = e.getSource();
            if (src instanceof JTable) {
                JTable t = (JTable)src;
                int rx = e.getRow();
                if (t.isRowSelected(rx)) {
                    t.removeRowSelectionInterval(rx, rx);
                } else {
                    t.addRowSelectionInterval(rx, rx);
                }
            }
        }
    };
    private static Vector allPredefinedCellActions = new Vector();
    String name;

    public static Enumeration getAllPredefinedCellActions() {
        return allPredefinedCellActions.elements();
    }

    private static String getResource(String key) {
        return RB.getStringResource("TreeTable.", "cellPopup." + key + ".txt");
    }

    public CellAction(String newName) {
        this.name = newName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAvailable(JTable t, int row, int col, Object value) {
        return true;
    }

    public abstract void perform(CellActionEvent var1);

    static {
        allPredefinedCellActions.addElement(EDIT);
        allPredefinedCellActions.addElement(TOGGLE_ROW_SELECTION);
    }
}

