/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treecombobox;

import com.sas.swing.models.IconInterface;
import com.sas.visuals.Resources;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeItemsListCellRenderer
extends DefaultListCellRenderer {
    private static final ImageIcon folderIcon = new ImageIcon(Resources.getImage((String)"Folder", (int)16));
    private Icon defaultIcon = folderIcon;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Object nodeObject = null;
        Icon icon = null;
        String text = null;
        if (value instanceof DefaultMutableTreeNode) {
            nodeObject = ((DefaultMutableTreeNode)value).getUserObject();
        }
        if (value instanceof IconInterface) {
            icon = ((IconInterface)value).getIcon();
        } else if (nodeObject != null && nodeObject instanceof IconInterface) {
            icon = ((IconInterface)nodeObject).getIcon();
        }
        if (value instanceof JLabel) {
            icon = ((JLabel)value).getIcon();
            text = ((JLabel)value).getText();
        } else if (nodeObject != null & nodeObject instanceof JLabel) {
            icon = ((JLabel)nodeObject).getIcon();
            text = ((JLabel)nodeObject).getText();
        }
        if (icon == null) {
            icon = this.getIcon(value);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        if (text != null) {
            this.setText(text);
        } else {
            this.setText(value.toString());
        }
        this.setFont(list.getFont());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    public void setDefaultIcon(Icon nodeIcon) {
        this.defaultIcon = nodeIcon;
    }

    public Icon getIcon(Object value) {
        return this.defaultIcon;
    }
}

