/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview.editors;

import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.util.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class ComboBoxEditor
extends DefaultTableCellEditor {
    protected JComboBox comboBox;
    protected boolean addEditedEntryToComboBox;
    protected JTable table;

    public ComboBoxEditor() {
        super((JComboBox)new ComboBox());
        this.init();
    }

    public ComboBoxEditor(JComboBox comboBox) {
        super(comboBox);
        this.init();
    }

    protected void init() {
        this.comboBox = (JComboBox)this.editorComponent;
        this.comboBox.removeActionListener(this.delegate);
        this.setClickCountToStart(2);
        this.addEditedEntryToComboBox = false;
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o;
                if (e.getActionCommand().equals("comboBoxEdited") && ComboBoxEditor.this.addEditedEntryToComboBox && ComboBoxEditor.this.getIndex(o = ComboBoxEditor.this.comboBox.getEditor().getItem()) == -1) {
                    ComboBoxEditor.this.comboBox.addItem(o);
                }
                if (e.getActionCommand().equals("comboBoxChanged") && ComboBoxEditor.this.comboBox.isPopupVisible()) {
                    ComboBoxEditor.this.comboBox.setPopupVisible(false);
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox cb;
        this.table = table;
        this.comboBox.setSelectedItem(value);
        Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (comp instanceof JComboBox && (cb = (JComboBox)comp).isEditable()) {
            this.comboBox.getEditor().selectAll();
            final Object item = this.comboBox.getEditor().getItem();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Util.equal((Object)item, (Object)ComboBoxEditor.this.comboBox.getEditor().getItem())) {
                        ComboBoxEditor.this.comboBox.getEditor().selectAll();
                    }
                }
            });
        }
        return comp;
    }

    public void addItem(Object item) {
        this.comboBox.addItem(item);
    }

    public void insertItemAt(Object item, int index) {
        this.comboBox.insertItemAt(item, index);
    }

    public void removeItem(Object item) {
        this.comboBox.removeItem(item);
    }

    public void removeItemAt(int index) {
        this.comboBox.removeItemAt(index);
    }

    public void removeAllItems() {
        this.comboBox.removeAllItems();
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }

    public void setAddEditedEntryToComboBox(boolean mode) {
        this.addEditedEntryToComboBox = mode;
    }

    protected int getIndex(Object item) {
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            if (!this.comboBox.getItemAt(i).equals(item)) continue;
            return i;
        }
        return -1;
    }
}

