/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview.actions;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.SwingAction;
import com.sas.commands.BaseCommand;
import com.sas.swing.visuals.tableview.actions.RB;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;

public class TableViewAction
extends SwingAction {
    public static final String RB_KEY = "TableViewAction.";

    public TableViewAction() {
        this(null);
    }

    public TableViewAction(BaseCommand command) {
        super(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        ChangeCursorCommand cmd = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        ActionProviderViewInterface view = this.getViewer();
        Component viewer = null;
        if (view instanceof Component) {
            viewer = (Component)((Object)view);
        }
        try {
            if (viewer != null) {
                JScrollPane pane = (JScrollPane)Util.getParent(viewer, JScrollPane.class);
                if (pane != null) {
                    Util.apply(pane, cmd);
                } else {
                    Util.apply(viewer, cmd);
                }
            }
            super.actionPerformed(event);
        }
        catch (Exception ex) {
            if (viewer instanceof SupportsGenericErrorHandlerInterface && ((SupportsGenericErrorHandlerInterface)((Object)viewer)).getGenericErrorHandler() != null) {
                GenericErrorHandlerInterface errorHandler = ((SupportsGenericErrorHandlerInterface)((Object)viewer)).getGenericErrorHandler();
                if (this.getCommand() != null) {
                    if (errorHandler instanceof Frame) {
                        ((Frame)((Object)errorHandler)).setTitle(Message.format((String)RB.getStringResource(RB_KEY, "errorHandlerTitle.txt"), (Object)this.getCommand().getName()));
                    } else if (errorHandler instanceof JOptionPaneErrorHandler) {
                        ((JOptionPaneErrorHandler)errorHandler).setTitle(Message.format((String)RB.getStringResource(RB_KEY, "errorHandlerTitle.txt"), (Object)this.getCommand().getName()));
                    }
                }
                String pat = ex.toString();
                errorHandler.handleError(viewer, new Message(this.escapeForMessage(pat)), null);
            } else {
                ex.printStackTrace();
            }
        }
        finally {
            if (viewer != null) {
                cmd.undoAll();
            }
        }
    }

    private String escapeForMessage(String s) {
        char[] ch = new char[]{'{', '}'};
        String[] st = new String[]{"'{'", "'}'"};
        String message = "";
        if (s != null) {
            message = Strings.replace((String)s, (char[])ch, (String[])st);
        }
        return message;
    }
}

