/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.RB;
import com.sas.swing.visuals.tableview.TableFormatAreaInterface;

public class TableFormatArea
implements TableFormatAreaInterface {
    private int startRow;
    private int endRow;
    private int repeatRow;
    private int startColumn;
    private int endColumn;
    private int repeatColumn;
    public static final String RB_KEY = "TableFormatArea.";

    public TableFormatArea(int sr, int er, int rr, int sc, int ec, int rc) {
        this.setStartRow(sr);
        this.setEndRow(er);
        this.setRepeatRow(rr);
        this.setStartColumn(sc);
        this.setEndColumn(ec);
        this.setRepeatColumn(rc);
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int start) {
        if (start < 1 && start != -369) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidStartRow.txt"));
        }
        this.startRow = start;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int end) {
        if (end != -1 && end < this.startRow) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidEndRow.txt"));
        }
        this.endRow = end;
    }

    public int getRepeatRow() {
        return this.repeatRow;
    }

    public void setRepeatRow(int repeat) {
        if (repeat < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRepeatRow.txt"));
        }
        this.repeatRow = repeat;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int start) {
        if (start < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidStartColumn.txt"));
        }
        this.startColumn = start;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int end) {
        if (end != -1 && end < this.startColumn) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidEndColumn.txt"));
        }
        this.endColumn = end;
    }

    public int getRepeatColumn() {
        return this.repeatColumn;
    }

    public void setRepeatColumn(int repeat) {
        if (repeat < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRepeatColumn.txt"));
        }
        this.repeatColumn = repeat;
    }

    @Override
    public boolean areaMatches(int row, int column, Object uniqueID) {
        return !(row < this.getStartRow() || this.getEndRow() != -1 && row > this.getEndRow() || (row - this.getStartRow()) % this.getRepeatRow() != 0 || column < this.getStartColumn() || this.getEndColumn() != -1 && column > this.getEndColumn() || (column - this.getStartColumn()) % this.getRepeatColumn() != 0);
    }
}

