/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.DefaultTableHeaderRenderer;
import com.sas.swing.visuals.tableview.OriginComponentUI;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class OriginComponent
extends JComponent {
    protected TableView table;
    protected TableCellRenderer renderer;
    private Object headerValue;
    private Action action;
    private static final String uiClassID = "OriginComponentUI";

    public OriginComponent() {
        this(null);
    }

    public OriginComponent(TableView table) {
        this.table = table;
        this.initializeLocalVars();
    }

    public void initializeLocalVars() {
        this.setRenderer(this.createDefaultRenderer());
        this.setAction(this.createDefaultAction());
        this.headerValue = "";
        this.updateUI();
    }

    public void setTable(TableView table) {
        if (this.table != table) {
            TableView old = this.table;
            this.table = table;
            this.firePropertyChange("table", old, this.table);
        }
    }

    public TableView getTable() {
        return this.table;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TableCellRenderer newRenderer) {
        if (this.renderer != newRenderer) {
            TableCellRenderer old = this.renderer;
            this.renderer = newRenderer;
            this.firePropertyChange("renderer", old, this.renderer);
        }
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(Object newValue) {
        if (this.headerValue != newValue) {
            Object old = this.headerValue;
            this.headerValue = newValue;
            this.firePropertyChange("headerValue", old, this.headerValue);
        }
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultTableHeaderRenderer();
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) {
        if (this.action != newAction) {
            Action old = this.action;
            this.action = newAction;
            this.firePropertyChange("action", old, this.action);
        }
    }

    protected Action createDefaultAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OriginComponent.this.table.selectAll();
            }
        };
    }

    @Override
    public OriginComponentUI getUI() {
        return (OriginComponentUI)this.ui;
    }

    public void setUI(OriginComponentUI ui) {
        if (this.ui != ui) {
            super.setUI(ui);
            this.repaint();
        }
    }

    @Override
    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.tableview.BasicOriginComponentUI");
        }
        this.setUI((OriginComponentUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

