/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.CellSelectionModel;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.SortHeaderRenderer;
import com.sas.swing.visuals.tableview.SwingHoldColumnSupport;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnHeader
extends JTableHeader
implements HoldInterface,
SwingConstants {
    public static final String RB_KEY = "ColumnHeader.";
    private static final String uiClassID = "ColumnHeaderUI";
    protected boolean heightSet;
    protected int height;
    protected int cellsToSizeCount;
    protected int lastColumnSized;
    public boolean printing;
    protected boolean holdingEnabled;
    private SwingHoldColumnSupport holdColumnSupport;

    public ColumnHeader() {
    }

    public ColumnHeader(TableColumnModel model) {
        super(model);
    }

    public boolean isHeightSet() {
        return this.heightSet;
    }

    @Override
    public void setTable(JTable table) {
        super.setTable(table);
        this.sizeColumnsToFit();
        if (this.getColumnModel().getSelectionModel() instanceof CellSelectionModel && table instanceof TableView) {
            ((CellSelectionModel)this.getColumnModel().getSelectionModel()).setTable((TableView)table);
        }
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        super.setColumnModel(columnModel);
        this.sizeColumnsToFit();
    }

    @Override
    public int columnAtPoint(Point point) {
        return this.columnAtPoint(point, true);
    }

    public int columnAtPoint(Point point, boolean accountForHolds) {
        Point newPoint = new Point(point);
        if (!this.getComponentOrientation().isLeftToRight()) {
            newPoint.x = this.getWidthInRightToLeft() - newPoint.x;
            if (this.table != null) {
                newPoint.x = this.table.getWidth() - newPoint.x;
            }
        }
        return ((TableView)this.getTable()).columnAtPoint(newPoint, accountForHolds);
    }

    @Override
    public Rectangle getHeaderRect(int column) {
        Rectangle r = new Rectangle();
        TableColumnModel tcm = this.getColumnModel();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (tcm.getColumnCount() > column) {
            r.width = tcm.getColumn(column).getWidth();
        }
        if (column < 0) {
            if (!ltr) {
                r.x = this.getWidthInRightToLeft();
            }
        } else if (column >= tcm.getColumnCount()) {
            if (ltr) {
                r.x = this.getWidth();
            }
        } else {
            for (int i = 0; i < column; ++i) {
                r.x += tcm.getColumn(i).getWidth();
            }
            if (!ltr) {
                r.x = this.getWidthInRightToLeft() - r.x - tcm.getColumn(column).getWidth();
            }
            r.height = this.getHeight();
        }
        if (this.getTable() instanceof TableView) {
            if (this.isHeld(((TableView)this.getTable()).convertColumnIndexToModel(column), 10)) {
                r.x += this.getViewPosition().x;
            } else if (this.isHeld(((TableView)this.getTable()).convertColumnIndexToModel(column), 11)) {
                Rectangle vr = this.getVisibleRect();
                int insetFromRight = this.getTable().getSize().width - r.x;
                r.x = vr.x + (vr.width - insetFromRight);
            }
        }
        return r;
    }

    private int getWidthInRightToLeft() {
        if (this.table != null && this.table.getAutoResizeMode() != 0) {
            if (this.table instanceof TableView) {
                return ((TableView)this.table).getCellAreaWidth();
            }
            return this.table.getWidth();
        }
        return super.getWidth();
    }

    public Point getViewPosition() {
        Container p = this.getParent();
        Point point = new Point(0, 0);
        if (p instanceof JViewport) {
            point = ((JViewport)p).getViewPosition();
        }
        return point;
    }

    @Override
    protected TableCellRenderer createDefaultRenderer() {
        return new SortHeaderRenderer();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int column) {
        Object value = this.getColumnModel().getColumn(column).getHeaderValue();
        boolean isSelected = this.getTable().isColumnSelected(column);
        boolean colIsAnchor = ((TableView)this.getTable()).getCurrentColumn() == column;
        boolean hasFocus = colIsAnchor && ((TableView)this.getTable()).getCurrentRow() < 0 && this.getTable().isFocusOwner();
        return renderer.getTableCellRendererComponent(this.getTable(), value, isSelected, hasFocus, -1, column);
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setOpaque(false);
        this.heightSet = false;
        this.cellsToSizeCount = 25;
        this.lastColumnSized = -1;
        this.holdColumnSupport = new SwingHoldColumnSupport(this);
        this.setHoldingEnabled(true);
        this.setAutoscrolls(true);
    }

    @Override
    public void updateUI() {
        if (this.getDefaultRenderer() instanceof JComponent) {
            ((JComponent)((Object)this.getDefaultRenderer())).updateUI();
        }
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.tableview.BasicColumnHeaderUI");
        }
        this.setUI((TableHeaderUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setHeight(int newHeight) {
        if (this.getHeight() != newHeight) {
            this.height = newHeight;
            this.heightSet = true;
        }
    }

    @Override
    public int getHeight() {
        if (this.isHeightSet()) {
            return this.height;
        }
        return super.getHeight();
    }

    public void setCellsToSizeCount(int newCount) {
        if (this.getCellsToSizeCount() != newCount) {
            int old = this.getCellsToSizeCount();
            this.cellsToSizeCount = newCount;
            this.firePropertyChange("cellsToSizeCount", old, this.cellsToSizeCount);
        }
    }

    public int getCellsToSizeCount() {
        return this.cellsToSizeCount;
    }

    public void sizeColumnToFit(int column) {
        if (this.getTable() instanceof TableView) {
            TableView table = (TableView)this.getTable();
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            if (table.getAutoResizeMode() == 0 && this.getResizingAllowed() && tableColumn.getResizable() && table.getColumnAutoResizeMode() != 0) {
                if (column > this.lastColumnSized) {
                    for (int c = this.lastColumnSized + 1; c <= column; ++c) {
                        tableColumn.setPreferredWidth(this.calculatePreferredWidthForColumn(c));
                    }
                    this.lastColumnSized = column;
                } else {
                    tableColumn.setPreferredWidth(this.calculatePreferredWidthForColumn(column));
                }
            }
        }
    }

    public void sizeColumnsToFit() {
        TableView table;
        if (this.getTable() instanceof TableView && (table = (TableView)this.getTable()) != null && table.tableInitialized && table.getAutoResizeMode() == 0 && this.getResizingAllowed() && table.getColumnAutoResizeMode() != 0) {
            int colCount = table.getColumnCount();
            int[] columns = new int[colCount];
            for (int i = 0; i < colCount; ++i) {
                columns[i] = i;
            }
            int[] sizes = this.calculatePreferredWidthForColumns(columns);
            for (int c = 0; c < colCount && c < sizes.length; ++c) {
                TableColumn column = this.getColumnModel().getColumn(c);
                if (!column.getResizable()) continue;
                column.setPreferredWidth(sizes[c]);
            }
            this.lastColumnSized = colCount - 1;
        }
    }

    public int[] calculatePreferredWidthForColumns(int[] columns) {
        JTable table;
        if (columns != null && columns.length > 0 && (table = this.getTable()) != null) {
            int cellSpacing = this.getColumnModel().getColumnMargin();
            int rowCount = this.cellsToSizeCount < 0 ? table.getRowCount() : Math.min(table.getRowCount(), this.cellsToSizeCount);
            int[] maxCellWidths = new int[columns.length];
            int[] headerWidths = new int[columns.length];
            Component component = null;
            for (int r = 0; r <= rowCount; ++r) {
                for (int c = 0; c < columns.length; ++c) {
                    if (r == rowCount) {
                        headerWidths[c] = this.getPreferredHeaderWidthForColumn(columns[c]);
                        continue;
                    }
                    TableCellRenderer cellRenderer = table.getCellRenderer(r, columns[c]);
                    component = table.prepareRenderer(cellRenderer, r, columns[c]);
                    int cellWidth = component.getPreferredSize().width;
                    if (cellWidth <= maxCellWidths[c]) continue;
                    maxCellWidths[c] = cellWidth;
                }
            }
            for (int i = 0; i < columns.length; ++i) {
                maxCellWidths[i] = Math.max(headerWidths[i], maxCellWidths[i] + cellSpacing);
            }
            return maxCellWidths;
        }
        return new int[0];
    }

    protected int getPreferredHeaderWidthForColumn(int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer headerRenderer = tableColumn.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = this.getDefaultRenderer();
        }
        return headerRenderer.getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)column).getPreferredSize().width;
    }

    public int calculatePreferredWidthForColumn(int column) {
        return this.calculatePreferredWidthForColumns(new int[]{column})[0];
    }

    @Override
    public void paintComponent(Graphics g) {
        this.printing = false;
        int heldColumnLeftWidth = this.getLeadingHeldWidth();
        int heldColumnRightWidth = this.getTrailingHeldWidth();
        this.verifyClipRect(g, heldColumnLeftWidth, heldColumnRightWidth);
        super.paintComponent(g);
    }

    @Override
    public void printComponent(Graphics g) {
        this.printing = true;
        super.paintComponent(g);
    }

    private void verifyClipRect(Graphics g, int heldColumnLeftWidth, int heldColumnRightWidth) {
        Rectangle viewRect = this.getVisibleRect();
        Rectangle clipBounds = g.getClipBounds();
        clipBounds = viewRect;
        g.setClip(clipBounds);
    }

    public int getLeadingHeldWidth() {
        int heldColumnLeftWidth = 0;
        int heldColumnSize = this.getHeldIndices(10).size();
        for (int i = 0; i < heldColumnSize; ++i) {
            heldColumnLeftWidth += this.getColumnModel().getColumn(i).getWidth();
        }
        return heldColumnLeftWidth;
    }

    public int getTrailingHeldWidth() {
        int heldColumnRightWidth = 0;
        int heldColumnSize = this.getHeldIndices(11).size();
        if (heldColumnSize == 0) {
            return 0;
        }
        int colCount = this.getTable().getColumnCount();
        for (int i = colCount - heldColumnSize; i < colCount; ++i) {
            heldColumnRightWidth += this.getColumnModel().getColumn(i).getWidth();
        }
        return heldColumnRightWidth;
    }

    @Override
    public List getHeldIndices() {
        return this.holdColumnSupport.getHeldIndices();
    }

    @Override
    public List getHeldIndices(int orientation) {
        return this.holdColumnSupport.getHeldIndices(orientation);
    }

    public HoldInterface getHold() {
        return this.holdColumnSupport.getHold();
    }

    @Override
    public void hold(int columnModelIndex) {
        this.holdColumnSupport.hold(columnModelIndex);
    }

    @Override
    public void hold(int columnModelIndex, int orientation) {
        this.holdColumnSupport.hold(columnModelIndex, orientation);
    }

    @Override
    public boolean isHeld(int columnModelIndex) {
        return this.holdColumnSupport.isHeld(columnModelIndex);
    }

    @Override
    public boolean isHeld(int columnModelIndex, int orientation) {
        return this.holdColumnSupport.isHeld(columnModelIndex, orientation);
    }

    @Override
    public boolean isHoldingAllowed(int orientation) {
        return this.holdColumnSupport.isHoldingAllowed(orientation);
    }

    @Override
    public void release(int columnModelIndex) {
        this.holdColumnSupport.release(columnModelIndex);
    }

    @Override
    public void releaseAll() {
        this.holdColumnSupport.releaseAll();
    }

    @Override
    public boolean isHoldingEnabled() {
        return this.holdingEnabled;
    }

    @Override
    public void setHoldingEnabled(boolean enableHolding) {
        if (this.holdingEnabled != enableHolding) {
            this.holdingEnabled = enableHolding;
            this.firePropertyChange("holdingEnabled", this.holdingEnabled ? Boolean.FALSE : Boolean.TRUE, this.holdingEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

