/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.RowHeaderUI;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;

public class BasicRowHeaderUI
extends RowHeaderUI {
    protected RowHeader header;
    protected CellRendererPane rendererPane;
    protected boolean resizingHeader;
    protected boolean resizingRow;
    protected MouseInputListener mouseInputListener;

    protected int viewIndexForRow(int row) {
        TableView table = this.header.getTable();
        return table.convertRowIndexToView(row);
    }

    protected int modelIndexForRow(int row) {
        TableView table = this.header.getTable();
        return table.convertRowIndexToModel(row);
    }

    protected RowHeader getHeader() {
        return this.header;
    }

    public void setResizingHeader(boolean newValue) {
        this.resizingHeader = newValue;
    }

    public boolean isResizingHeader() {
        return this.resizingHeader;
    }

    public void setResizingRow(boolean newValue) {
        this.resizingRow = newValue;
    }

    public boolean isResizingRow() {
        return this.resizingRow;
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent h) {
        return new BasicRowHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.header = (RowHeader)c;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected int getHeaderWidth() {
        if (this.header.isWidthSet()) {
            return this.header.getWidth();
        }
        int width = 0;
        TableRowModel tableModel = this.header.getRowModel();
        int rowCount = tableModel.getRowCount();
        if (rowCount > 0) {
            Component comp = this.getHeaderRenderer(rowCount - 1);
            width = Math.max(width, comp.getPreferredSize().width);
            if (this.header.getTable().getTableHeader() instanceof ColumnHeader) {
                int cellCount = ((ColumnHeader)this.header.getTable().getTableHeader()).getCellsToSizeCount();
                if (cellCount < 0) {
                    cellCount = rowCount - 1;
                }
                int max = Math.min(rowCount - 1, cellCount);
                for (int row = 0; row < max; ++row) {
                    comp = this.getHeaderRenderer(row);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
            }
        }
        return width;
    }

    protected Dimension createHeaderSize() {
        long height = 0L;
        int rowCount = this.header.getRowModel().getRowCount();
        if (rowCount > 0) {
            Rectangle r = this.header.getTable().getCellRect(rowCount - 1, 0, true, false);
            height = r.y + r.height;
        }
        if (height > Integer.MAX_VALUE) {
            height = Integer.MAX_VALUE;
        }
        return new Dimension(this.getHeaderWidth(), (int)height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.createHeaderSize();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.createHeaderSize();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.createHeaderSize();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int draggedRow;
        Rectangle vr;
        if (this.header.getRowModel() == null) {
            return;
        }
        if (this.header.getRowModel().getRowCount() <= 0) {
            return;
        }
        Rectangle oldClipBounds = g.getClipBounds();
        int heldRowTopHeight = this.header.getTopHeldHeight();
        int heldRowBottomHeight = this.header.getBottomHeldHeight();
        int heldRowTopCount = this.header.getHeldIndices(1).size();
        int heldRowBottomCount = this.header.getHeldIndices(3).size();
        int rowCount = this.header.getTable().getRowCount();
        boolean accountForHolds = !this.getHeader().printing;
        int rMin = Math.max(this.getHeader().rowAtPoint(new Point(0, oldClipBounds.y), accountForHolds), heldRowTopCount);
        int rMax = Math.min(this.getHeader().rowAtPoint(new Point(0, oldClipBounds.y + oldClipBounds.height - 1), accountForHolds), rowCount - 1 - heldRowBottomCount);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMin <= heldRowTopCount - 1) {
            rMin = heldRowTopCount - 1;
        }
        if (rMax == -1) {
            rMax = rowCount - heldRowBottomCount - 1;
        }
        if (rMax >= rowCount - heldRowBottomCount - 1) {
            rMax = rowCount - heldRowBottomCount - 1;
        }
        this.paintCells(g, rMin, rMax);
        if (heldRowBottomCount > 0) {
            vr = this.header.getVisibleRect();
            int visTableHeight = Math.min(vr.height, this.header.getTable().getCellAreaHeight());
            if (this.header.printing) {
                g.translate(0, oldClipBounds.y + oldClipBounds.height - vr.y - visTableHeight);
            }
            this.paintCells(g, rowCount - heldRowBottomCount, rowCount - 1);
            if (this.header.printing) {
                g.translate(0, -(oldClipBounds.y + oldClipBounds.height - vr.y - visTableHeight));
            }
        }
        if (heldRowTopCount > 0) {
            vr = this.header.getVisibleRect();
            if (this.header.printing) {
                g.translate(0, oldClipBounds.y - vr.y);
            }
            this.paintCells(g, 0, heldRowTopCount - 1);
            if (this.header.printing) {
                g.translate(0, -(oldClipBounds.y - vr.y));
            }
        }
        if ((draggedRow = this.header.getDraggedRow()) != -1) {
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedRow);
            draggedCellRect.y += this.header.getDraggedDistance();
            if (this.header.isOpaque()) {
                g.setColor(this.header.getBackground());
            } else {
                g.setColor(this.header.getParent().getBackground());
            }
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedRow);
        }
        this.rendererPane.removeAll();
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int rowIndex) {
        Component component = this.getHeaderRenderer(rowIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected Component getHeaderRenderer(int rowIndex) {
        TableCellRenderer renderer = this.header.getDefaultRenderer();
        return this.header.prepareRenderer(renderer, rowIndex);
    }

    protected void paintCells(Graphics g, int rMin, int rMax) {
        int draggedRow = this.header.getDraggedRow();
        Rectangle cellRect = this.header.getHeaderRect(rMin);
        for (int row = rMin; row <= rMax; ++row) {
            int rowHeight;
            cellRect.height = rowHeight = this.header.getTable().getRowHeight(row);
            if (row != draggedRow) {
                this.paintCell(g, cellRect, row);
            }
            cellRect.y += rowHeight;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected int lastEffectiveMouseY;
        protected int lastEffectiveMouseX;

        protected boolean shouldIgnore(MouseEvent e) {
            return !BasicRowHeaderUI.this.header.getTable().isEnabled() || !BasicRowHeaderUI.this.header.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicRowHeaderUI.this.getHeader().getDraggedRow() == -1 && BasicRowHeaderUI.this.isResizingRow() && !BasicRowHeaderUI.this.isResizingHeader() && !e.isConsumed()) {
                BasicRowHeaderUI.this.getHeader().sizeRowToFit(this.getResizingRow(e.getPoint()));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                TableView table;
                BasicRowHeaderUI.this.getHeader().setDraggedRow(-1);
                BasicRowHeaderUI.this.getHeader().setResizingRow(-1);
                BasicRowHeaderUI.this.getHeader().setDraggedDistance(0);
                if (!BasicRowHeaderUI.this.getHeader().getTable().hasFocus() && BasicRowHeaderUI.this.getHeader().getTable().isRequestFocusEnabled()) {
                    BasicRowHeaderUI.this.getHeader().getTable().requestFocus();
                }
                Point p = e.getPoint();
                this.lastEffectiveMouseY = p.y;
                this.lastEffectiveMouseX = p.x;
                if (BasicRowHeaderUI.this.isResizingHeader()) {
                    return;
                }
                int resizeIndex = this.getResizingRow(p);
                if (this.canResize(resizeIndex) && BasicRowHeaderUI.this.getHeader().getResizingAllowed() && resizeIndex != -1) {
                    BasicRowHeaderUI.this.getHeader().setResizingRow(resizeIndex);
                    return;
                }
                int row = BasicRowHeaderUI.this.getHeader().rowAtPoint(p);
                if (row != -1 && ((JTable)(table = BasicRowHeaderUI.this.getHeader().getTable())).getRowSelectionAllowed() && (SwingUtilities.isLeftMouseButton(e) || !((JTable)table).isRowSelected(row))) {
                    this.setValueIsAdjusting(true);
                    ((JTable)table).changeSelection(row, -1, e.isControlDown(), e.isShiftDown());
                }
                if (!(SwingUtilities.isLeftMouseButton(e) || BasicRowHeaderUI.this.getHeader().getDraggedRow() != -1 || BasicRowHeaderUI.this.isResizingHeader() || BasicRowHeaderUI.this.isResizingRow() || e.isConsumed() || !BasicRowHeaderUI.this.getHeader().getTable().isPopupMenuEnabled())) {
                    Point point = BasicRowHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? new Point(p.x - BasicRowHeaderUI.this.getHeader().getWidth(), p.y) : new Point(p.x + BasicRowHeaderUI.this.header.getTable().getWidth(), p.y);
                    BasicRowHeaderUI.this.getHeader().getTable().showPopup(point);
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int reorderIndex = this.getReorderRow(p);
                    if (BasicRowHeaderUI.this.getHeader().getReorderingAllowed() && reorderIndex != -1) {
                        BasicRowHeaderUI.this.getHeader().setDraggedRow(reorderIndex);
                    }
                }
            }
        }

        protected boolean canResize(int row) {
            return row != -1 && BasicRowHeaderUI.this.header.getResizingAllowed();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                if (this.canResize(this.getResizingRow(e.getPoint()))) {
                    BasicRowHeaderUI.this.setResizingHeader(false);
                    BasicRowHeaderUI.this.setResizingRow(true);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                    if (BasicRowHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicRowHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else if (this.resizingHeader(e.getPoint())) {
                    BasicRowHeaderUI.this.setResizingHeader(true);
                    BasicRowHeaderUI.this.setResizingRow(false);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(10);
                    if (BasicRowHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicRowHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else {
                    BasicRowHeaderUI.this.setResizingHeader(false);
                    BasicRowHeaderUI.this.setResizingRow(false);
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    if (BasicRowHeaderUI.this.getHeader().getCursor() != defaultCursor) {
                        BasicRowHeaderUI.this.getHeader().setCursor(defaultCursor);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                boolean headerLeftToRight = BasicRowHeaderUI.this.header.getComponentOrientation().isLeftToRight();
                int mouseY = e.getY();
                int mouseX = e.getX();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int deltaY = mouseY - this.lastEffectiveMouseY;
                    int deltaX = mouseX - this.lastEffectiveMouseX;
                    int resizingRow = BasicRowHeaderUI.this.getHeader().getResizingRow();
                    int draggedRow = BasicRowHeaderUI.this.getHeader().getDraggedRow();
                    if (BasicRowHeaderUI.this.isResizingHeader()) {
                        if (deltaX == 0) {
                            return;
                        }
                        int oldWidth = BasicRowHeaderUI.this.header.getWidth();
                        int newWidth = 0;
                        newWidth = headerLeftToRight ? oldWidth + deltaX : oldWidth - deltaX;
                        JScrollPane pane = BasicRowHeaderUI.this.getHeader().getTable().getScrollPane();
                        int maxWidth = pane.getSize().width - pane.getInsets().left - pane.getInsets().right;
                        if (newWidth < 1) {
                            newWidth = 1;
                        }
                        if (newWidth > maxWidth) {
                            newWidth = maxWidth;
                        }
                        BasicRowHeaderUI.this.header.setWidth(newWidth);
                        int acheivedDeltaX = BasicRowHeaderUI.this.header.getWidth() - oldWidth;
                        if (headerLeftToRight) {
                            this.lastEffectiveMouseX += acheivedDeltaX;
                        }
                        this.lastEffectiveMouseY = mouseY;
                        BasicRowHeaderUI.this.getHeader().resizeAndRepaint();
                    } else {
                        if (deltaY == 0) {
                            return;
                        }
                        if (resizingRow != -1) {
                            TableView table = BasicRowHeaderUI.this.getHeader().getTable();
                            int oldHeight = ((JTable)table).getRowHeight(resizingRow);
                            int newHeight = oldHeight + deltaY;
                            if (newHeight < 4) {
                                newHeight = 4;
                            }
                            ((JTable)table).setRowHeight(resizingRow, newHeight);
                            int acheivedDeltaY = ((JTable)table).getRowHeight(resizingRow) - oldHeight;
                            this.lastEffectiveMouseY += acheivedDeltaY;
                            this.lastEffectiveMouseX = mouseX;
                        } else if (draggedRow != -1) {
                            this.move(e, deltaY);
                            this.lastEffectiveMouseY = mouseY;
                            this.lastEffectiveMouseX = mouseX;
                        } else {
                            this.lastEffectiveMouseY = mouseY;
                            this.lastEffectiveMouseX = mouseX;
                        }
                    }
                } else {
                    this.lastEffectiveMouseY = mouseY;
                    this.lastEffectiveMouseX = mouseX;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                BasicRowHeaderUI.this.getHeader().setResizingRow(-1);
                BasicRowHeaderUI.this.getHeader().setDraggedRow(-1);
                BasicRowHeaderUI.this.getHeader().setDraggedDistance(0);
                BasicRowHeaderUI.this.getHeader().repaint();
                TableView table = BasicRowHeaderUI.this.getHeader().getTable();
                this.setValueIsAdjusting(false);
                if (table != null) {
                    table.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        protected void move(MouseEvent e, int delta) {
            int hitRowIndex;
            TableRowModel tableModel = BasicRowHeaderUI.this.getHeader().getRowModel();
            TableView table = BasicRowHeaderUI.this.getHeader().getTable();
            int lastRow = tableModel.getRowCount() - 1;
            int draggedRow = BasicRowHeaderUI.this.getHeader().getTable().convertRowIndexToModel(BasicRowHeaderUI.this.getHeader().getDraggedRow());
            int draggedDistance = BasicRowHeaderUI.this.getHeader().getDraggedDistance() + delta;
            int prevIndex = hitRowIndex = BasicRowHeaderUI.this.getHeader().getDraggedRow();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            if (row != -1) {
                Rectangle rect = BasicRowHeaderUI.this.header.getHeaderRect(row);
                rect.width = table.getWidth();
                table.scrollRectToVisible(rect);
            }
            boolean swapping = true;
            while (swapping) {
                int height;
                if (draggedDistance < 0 && hitRowIndex != 0) {
                    if (!BasicRowHeaderUI.this.header.isHeld(BasicRowHeaderUI.this.modelIndexForRow(hitRowIndex - 1))) {
                        height = table.getRowHeight(hitRowIndex - 1);
                        if (-draggedDistance > height / 2) {
                            table.moveRow(hitRowIndex, hitRowIndex - 1);
                            draggedDistance = height + draggedDistance;
                            --hitRowIndex;
                            continue;
                        }
                        swapping = false;
                        continue;
                    }
                    swapping = false;
                    continue;
                }
                if (draggedDistance > 0 && hitRowIndex != lastRow) {
                    if (!BasicRowHeaderUI.this.header.isHeld(BasicRowHeaderUI.this.modelIndexForRow(hitRowIndex + 1))) {
                        height = table.getRowHeight(hitRowIndex + 1);
                        if (draggedDistance > height / 2) {
                            table.moveRow(hitRowIndex, hitRowIndex + 1);
                            draggedDistance = -(height - draggedDistance);
                            ++hitRowIndex;
                            continue;
                        }
                        swapping = false;
                        continue;
                    }
                    swapping = false;
                    continue;
                }
                swapping = false;
            }
            table.repaint();
            BasicRowHeaderUI.this.getHeader().repaint();
            BasicRowHeaderUI.this.getHeader().setDraggedRow(hitRowIndex);
            BasicRowHeaderUI.this.getHeader().setDraggedDistance(draggedDistance);
        }

        protected int getResizingRow(Point p) {
            return this.getResizingRow(p, BasicRowHeaderUI.this.header.getTable().rowAtPoint(p));
        }

        protected int getResizingRow(Point p, int row) {
            if (row == -1) {
                return -1;
            }
            Rectangle r = BasicRowHeaderUI.this.header.getHeaderRect(row);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2;
            int rowIndex = p.y < midPoint ? row - 1 : row;
            return rowIndex;
        }

        protected int getReorderRow(Point p) {
            if (BasicRowHeaderUI.this.header.getTable().isRowsReorderable()) {
                int row = BasicRowHeaderUI.this.header.getTable().rowAtPoint(p);
                if (row == -1) {
                    return -1;
                }
                TableView table = BasicRowHeaderUI.this.header.getTable();
                if (BasicRowHeaderUI.this.header.isHeld(table.convertRowIndexToModel(row))) {
                    return -1;
                }
                return row;
            }
            return -1;
        }

        protected boolean resizingHeader(Point p) {
            Rectangle r = new Rectangle(0, 0, BasicRowHeaderUI.this.header.getWidth(), BasicRowHeaderUI.this.header.getHeight());
            r.grow(-3, 0);
            r.x = BasicRowHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? 0 : 3;
            r.width += 3;
            return !r.contains(p);
        }

        protected void setValueIsAdjusting(boolean flag) {
            TableView table = BasicRowHeaderUI.this.getHeader().getTable();
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            table.getSelectionModel().setValueIsAdjusting(flag);
            table.getRowModel().getSelectionModel().setValueIsAdjusting(flag);
        }
    }
}

