/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.RB;
import com.sas.swing.visuals.dualselector.TableDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.ValueListEditorDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.ValueProviderDualSelectorAdapter;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.TreeUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

@SASScope
public class ValueProviderTableSelector
extends BaseDualSelector
implements ChangeListener,
EditorInterface,
EditorListener,
TableModelListener {
    public static final String RB_KEY = "ValueProviderTableSelector.";
    private static final long serialVersionUID = 3104253127139729637L;
    private int browseMode;
    private boolean search;
    private boolean editable;
    private boolean reorderingAllowed;
    private boolean isEditing;
    private boolean valueModified;
    public JButton addEditButton;
    private JPanel editButtonPanel;
    private JPopupMenu popupMenu;
    private boolean ignoreEvents;
    private boolean ignoreEventFromTransfer;
    private ChangeCursorCommand changeCursorCommand;
    private EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, Locale locale) {
        this(valueProvider, browseMode, search, false, null, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(valueProvider, browseMode, search, false, errorHandler, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(valueProvider, browseMode, search, false, false, errorHandler, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, null, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, Locale locale) {
        this(valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, dataType, -1, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, Locale locale) {
        this(valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, dataType, -1, null, locale);
    }

    public ValueProviderTableSelector(ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, ViewQueryCacheInterface viewQueryCache, Locale locale) {
        this(null, valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, dataType, pageSize, viewQueryCache, locale);
    }

    public ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, Locale locale) {
        this(adapter, browseMode, search, editable, reorderingAllowed, null, null, locale);
    }

    public ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, Locale locale) {
        this(adapter, adapter.getModel(), browseMode, search, editable, reorderingAllowed, locale);
    }

    private ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, Locale locale) {
        this(adapter, valueProvider, browseMode, search, editable, reorderingAllowed, null, locale);
    }

    private ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(adapter, valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, null, locale);
    }

    private ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, Locale locale) {
        this(adapter, valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, dataType, -1, locale);
    }

    private ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, Locale locale) {
        this(adapter, valueProvider, browseMode, search, editable, reorderingAllowed, errorHandler, dataType, -1, null, locale);
    }

    private ValueProviderTableSelector(ValueProviderDualSelectorAdapter adapter, ValueProviderInterface valueProvider, int browseMode, boolean search, boolean editable, boolean reorderingAllowed, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, ViewQueryCacheInterface viewQueryCache, Locale locale) {
        this.browseMode = browseMode;
        this.search = search;
        this.editable = editable;
        this.reorderingAllowed = reorderingAllowed;
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.ignoreEvents = false;
        this.setLocale(locale);
        this.setDesignTime(com.sas.beans.Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        if (dataType == null) {
            try {
                if (valueProvider != null) {
                    dataType = valueProvider.getDataType();
                }
            }
            catch (ValueProviderException ex) {
                LoggerRepository2.getLogger((String)ValueProviderTableSelector.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (dataType == null) {
            dataType = StringType.DEFAULT_INSTANCE;
        }
        if (adapter == null) {
            adapter = new ValueProviderDualSelectorAdapter(valueProvider, browseMode, search, this, errorHandler, dataType, pageSize, viewQueryCache, locale);
        } else if (valueProvider != null) {
            adapter.setModel(valueProvider);
        }
        this.sourceAdapter = adapter;
        adapter.setParentSelector(this);
        EditorInterface editor = EditorFactory.defaultInstance.getEditor(dataType, locale);
        if (editor instanceof DatePicker) {
            ((DatePicker)editor).setShowRelativeDates(true);
        }
        this.targetAdapter = new ValueListEditorDualSelectorAdapter(this, editor);
        ValueListEditor vle = ((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor();
        vle.removeButton(ValueListEditor.BUTTON_EDIT);
        vle.removeButton(ItemListManagerViewerInterface.BUTTON_ADD);
        ValueItemsToTableModelAdapter tm = new ValueItemsToTableModelAdapter(new ArrayList());
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("LABEL");
        tm.setColumnName(RB.getStringResource(RB_KEY, "label.txt", this.getLocale()), 0);
        if (valueProvider != null) {
            JComponent sourceComp = null;
            if (this.isBrowsing()) {
                sourceComp = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getBrowseAdapter().getComponent();
            }
            if (sourceComp instanceof JTree) {
                tm.setColumnName(RB.getStringResource(RB_KEY, "parentPath.txt", this.getLocale()), 1);
                columns.add(ValueItem.PARENT);
            } else {
                boolean multi = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getModel().isValueDisplayed();
                if (multi) {
                    tm.setColumnName(RB.getStringResource(RB_KEY, "value.txt", this.getLocale()), 0);
                    tm.setColumnName(RB.getStringResource(RB_KEY, "label.txt", this.getLocale()), 1);
                    columns.add(0, "VALUE");
                }
                if (sourceComp instanceof JTable) {
                    ((JTable)sourceComp).getModel().addTableModelListener(this);
                }
            }
        }
        tm.setColumns(columns);
        vle.setModel(tm);
        ValueProviderDualSelectorAdapter.setPropertiesOnTable(vle.getTable());
        int visibleRowCount = 5;
        TableView targetTable = ((ValueListEditor)this.targetAdapter.getComponent()).getTable();
        targetTable.setVisibleRowCount(visibleRowCount);
        this.initializeBaseDualSelector();
        EqualSpacePartitioner partition = new EqualSpacePartitioner(false);
        partition.setPartitionsToDivide(new boolean[]{true, false, true});
        partition.setMinimumSize(100);
        ((AutoSizingGridLayout)this.mainPanel.getLayout()).setColumnSpacePartitioner(partition);
        this.setAlternatingSingleButtonIcons(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16), Resources.getImageIcon((String)"ArrowLeftRemove.gif", (int)16));
        this.setAlternatingMultipleButtonIcons(Resources.getImageIcon((String)"ArrowRightAddAll.gif", (int)16), Resources.getImageIcon((String)"ArrowLeftRemoveAll.gif", (int)16));
        this.addEditButton = (JButton)vle.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_ADD, 0);
        this.addEditButton.setIcon(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16));
        this.setOpaque(false);
        this.setCopyModeEnabled(true);
        this.setCopyModeDuplicatesAllowed(false);
        if (this.isBrowsing() && search || !this.isBrowsing()) {
            this.sourceLabel.setVisible(false);
        }
        this.addSourceListeners();
        targetTable.addMouseListener(this.targetMouseListener);
        this.setModel(valueProvider);
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
        this.targetAdapter.getComponent().setOpaque(false);
        this.targetAdapter.getContainerComponent().setOpaque(false);
        targetTable.setRowSelectionAllowed(true);
        targetTable.setColumnSelectionAllowed(false);
        targetTable.setCellSelectionEnabled(false);
        if (vle.getEditorPanel() != null) {
            vle.getEditorPanel().setVisible(false);
        }
        this.updateEditField();
        this.updateReorderingButtons();
        vle.addEditorListener(this);
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component comp = FocusManager.getCurrentManager().getFocusOwner();
                if (comp != null) {
                    boolean owner = SwingUtilities.isDescendingFrom(comp, ValueProviderTableSelector.this);
                    if (ValueProviderTableSelector.this.isEditing && !owner) {
                        ValueProviderTableSelector.this.isEditing = false;
                        ValueProviderTableSelector.this.valueModified = false;
                        ValueProviderTableSelector.this.fireEditingStopped();
                    } else if (owner) {
                        ValueProviderTableSelector.this.isEditing = true;
                        ValueProviderTableSelector.this.fireEditingStarted();
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTree tree;
        TreePath[] paths;
        Object source = e.getSource();
        if (source == this.alternatingSingleButton && !this.direction && ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSelectedAdapter().getComponent() instanceof JTree && (paths = (tree = (JTree)((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSelectedAdapter().getComponent()).getSelectionPaths()) != null && paths.length == 1 && tree.getModel().getChildCount(paths[0].getLastPathComponent()) > 0) {
            JPopupMenu popup = this.createPopupMenu();
            popup.pack();
            Dimension menuSize = Util.computePopupMenuSize(popup, this);
            Point popupLoc = Util.computePopupMenuLocation(this.alternatingSingleButton.getX(), this.alternatingSingleButton.getY() + this.alternatingSingleButton.getHeight() + 1, menuSize.width, menuSize.height, this.alternatingSingleButton.getParent());
            popup.show(this.alternatingSingleButton.getParent(), popupLoc.x, popupLoc.y);
            return;
        }
        super.actionPerformed(e);
    }

    private JPopupMenu createPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new TransferParentAction());
            this.popupMenu.add(new TransferParentAndChildrenAction());
            this.popupMenu.add(new TransferParentAndAllChildrenAction());
        }
        return this.popupMenu;
    }

    private boolean isBrowsing() {
        return this.browseMode == 20 || this.browseMode == 30;
    }

    public ValueProviderDualSelectorAdapter getSourceAdapter() {
        return (ValueProviderDualSelectorAdapter)this.sourceAdapter;
    }

    private void updateReorderingButtons() {
        ValueListEditor vle = ((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor();
        ((Component)vle.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 0)).setVisible(this.reorderingAllowed);
        ((Component)vle.getPredefinedButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 0)).setVisible(this.reorderingAllowed);
    }

    private void updateEditField() {
        if (this.editable) {
            this.editButtonPanel = new JPanel();
            this.editButtonPanel.setOpaque(false);
            AutoSizingGridLayout editButtonPanelLayout = new AutoSizingGridLayout(1, 1, 0, 0, false, false, false);
            editButtonPanelLayout.setDefaultCellGravity(8);
            editButtonPanelLayout.setGridGravity(8);
            this.editButtonPanel.setLayout(editButtonPanelLayout);
            this.editButtonPanel.add(this.addEditButton);
            this.middleContainer.add(this.editButtonPanel);
            AutoSizingGridLayout sourceBottomActionButtonContainerLayout = (AutoSizingGridLayout)this.getSourceBottomActionButtonContainer().getLayout();
            sourceBottomActionButtonContainerLayout.setColumns(1);
            sourceBottomActionButtonContainerLayout.setRows(-1);
            sourceBottomActionButtonContainerLayout.setFillCell(true);
            sourceBottomActionButtonContainerLayout.setRemainderColumn(1);
            sourceBottomActionButtonContainerLayout.setUseColumnRemainder(true);
            this.getSourceBottomActionButtonContainer().add(new JLabel(RB.getStringResource(RB_KEY, "customLabel.txt", this.getLocale())));
            ValueListEditor vle = ((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor();
            this.getSourceBottomActionButtonContainer().add(vle.getEditor().getEditorComponent());
        } else if (this.editButtonPanel != null) {
            this.middleContainer.remove(this.editButtonPanel);
            this.getSourceBottomActionButtonContainer().removeAll();
        }
    }

    private void addSourceListeners() {
        if (this.isBrowsing()) {
            ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getBrowseComponent().addMouseListener(this.sourceMouseListener);
        }
        if (this.search) {
            ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSearchAdapter().getComponent().addMouseListener(this.sourceMouseListener);
        }
    }

    public void setBrowseAndSearchVisible(int browseMode, boolean search) {
        this.browseMode = browseMode;
        this.search = search;
        if (((ValueProviderDualSelectorAdapter)this.sourceAdapter).setBrowseAndSearchVisible(browseMode, search)) {
            this.sourceContainer.removeAll();
            this.sourceContainer.add(this.sourceLabel);
            this.sourceContainer.add(this.sourceTopButtonContainer);
            this.sourceContainer.add(this.sourceAdapter.getContainerComponent());
            this.sourceContainer.add(this.sourceBottomButtonContainer);
            this.addSourceListeners();
        }
        this.sourceLabel.setVisible((!this.isBrowsing() || !search) && this.isBrowsing());
    }

    public void reloadValues() {
        ((ValueProviderDualSelectorAdapter)this.sourceAdapter).reloadValues();
        if (this.targetAdapter != null && ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getModel() != null) {
            JComponent sourceComp = null;
            if (this.isBrowsing()) {
                sourceComp = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getBrowseAdapter().getComponent();
            }
            ArrayList<String> columns = new ArrayList<String>();
            ValueItemsToTableModelAdapter tm = (ValueItemsToTableModelAdapter)((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor().getModel();
            if (sourceComp instanceof JTree) {
                tm.setColumnName(RB.getStringResource(RB_KEY, "label.txt", this.getLocale()), 0);
                tm.setColumnName(RB.getStringResource(RB_KEY, "parentPath.txt", this.getLocale()), 1);
                columns.add("LABEL");
                columns.add(ValueItem.PARENT);
            } else {
                boolean multi = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getModel().isValueDisplayed();
                tm.setColumnName(RB.getStringResource(RB_KEY, "value.txt", this.getLocale()), 0);
                tm.setColumnName(RB.getStringResource(RB_KEY, "label.txt", this.getLocale()), multi ? 1 : 0);
                if (multi) {
                    columns.add("VALUE");
                }
                columns.add("LABEL");
            }
            tm.setColumns(columns);
            ValueProviderDualSelectorAdapter.setPropertiesOnTable(((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor().getTable());
        }
    }

    @Override
    public void initializeSize() {
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        ((ValueProviderDualSelectorAdapter)this.sourceAdapter).removeChangeListener(this);
        ((ValueProviderDualSelectorAdapter)this.sourceAdapter).addChangeListener(this);
        this.targetAdapter.getComponent().removeFocusListener(this.targetFocusListener);
        ((ValueListEditor)this.targetAdapter.getComponent()).getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!(ValueProviderTableSelector.this.ignoreEventFromTransfer || e != null && e.getType() != -1 && e.getType() != 1 && e.getType() != -1)) {
                    ValueProviderTableSelector.this.ensureButtonsEnabled();
                }
            }
        });
    }

    public void setModel(ValueProviderInterface valueProvider) {
        ValueProviderInterface oldModel = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getModel();
        ((ValueProviderDualSelectorAdapter)this.sourceAdapter).setModel(valueProvider);
        TableModel targetModel = this.getTargetModel();
        if (targetModel != null && targetModel.getColumnCount() != 2) {
            JComponent sourceComp = null;
            if (this.isBrowsing()) {
                sourceComp = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getBrowseAdapter().getComponent();
            }
            if (targetModel instanceof ValueItemsToTableModelAdapter && sourceComp instanceof JTree) {
                ((ValueItemsToTableModelAdapter)targetModel).setColumnName(RB.getStringResource(RB_KEY, "label.txt", this.getLocale()), 0);
                ((ValueItemsToTableModelAdapter)targetModel).setColumnName(RB.getStringResource(RB_KEY, "parentPath.txt", this.getLocale()), 1);
                ArrayList<String> columns = new ArrayList<String>();
                columns.add("LABEL");
                if (valueProvider.isValueDisplayed()) {
                    columns.add(ValueItem.PARENT);
                }
                ((ValueItemsToTableModelAdapter)targetModel).setColumns(columns);
                ValueListEditor vle = ((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor();
                ValueProviderDualSelectorAdapter.setPropertiesOnTable(vle.getTable());
            }
        }
        this.firePropertyChange("model", oldModel, valueProvider);
        this.ensureButtonsEnabled();
    }

    public TableModel getTargetModel() {
        return ((ValueListEditorDualSelectorAdapter)this.targetAdapter).getValueListEditor().getModel();
    }

    @Override
    public boolean canTransferSelectedSourceItems() {
        SupportedSpecialValues ssv;
        boolean transfer = true;
        List selItems = null;
        if (this.getTargetMaximumCount() >= 0) {
            int targetCount;
            selItems = this.sourceAdapter.getSelectedItems();
            int selCount = selItems.size();
            if (selCount < 0) {
                selCount = 0;
            }
            boolean bl = transfer = (targetCount = this.targetAdapter.getCount()) + selCount <= this.getTargetMaximumCount();
        }
        if (transfer && (ssv = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSupportedSpecialValues()) != null && (ssv.isAllSupported() || ssv.isOtherSupported())) {
            if (selItems == null) {
                selItems = this.sourceAdapter.getSelectedItems();
            }
            if (selItems != null && !selItems.isEmpty()) {
                boolean specialSelected = false;
                boolean regularSelected = false;
                for (Object element : selItems) {
                    if (element == SpecialValues.ALL || element == SpecialValues.OTHER || element instanceof ValueItem && (((ValueItem)element).getValue() == SpecialValues.ALL || ((ValueItem)element).getValue() == SpecialValues.OTHER)) {
                        if (specialSelected || regularSelected) {
                            transfer = false;
                            break;
                        }
                        specialSelected = true;
                        continue;
                    }
                    regularSelected = true;
                    if (!specialSelected) continue;
                    transfer = false;
                    break;
                }
            }
        }
        return transfer;
    }

    @Override
    protected boolean areValuesEqual(Object value1, Object value2) {
        if (com.sas.util.Util.equal((Object)value1, (Object)value2)) {
            return true;
        }
        return value2 instanceof ValueItem && value1 instanceof ValueItem && com.sas.util.Util.equal((Object)((ValueItem)value1).getValue(), (Object)((ValueItem)value2).getValue()) && com.sas.util.Util.equal((Object)((ValueItem)value1).getLabel(), (Object)((ValueItem)value2).getLabel());
    }

    @Override
    public synchronized void transferAllSourceItems() {
        try {
            this.changeCursorCommand.apply(this);
            super.transferAllSourceItems();
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    @Override
    protected void ensureButtonsEnabled() {
        super.ensureButtonsEnabled();
        if (this.isEnabled()) {
            TableDualSelectorAdapter tableds;
            TableModel tm;
            ValueProviderDualSelectorAdapter vpdsa;
            if (this.sourceAdapter.getCount() > 0 && this.canTransferAllSourceItems()) {
                this.alternatingMultipleButton.setEnabled(true);
            } else {
                this.alternatingMultipleButton.setEnabled(false);
            }
            if (this.alternatingMultipleButton.isEnabled() && this.sourceAdapter instanceof ValueProviderDualSelectorAdapter && (vpdsa = (ValueProviderDualSelectorAdapter)this.sourceAdapter).getSelectedAdapter() instanceof TableDualSelectorAdapter && (tm = ((JTable)(tableds = (TableDualSelectorAdapter)vpdsa.getSelectedAdapter()).getComponent()).getModel()) instanceof TrueRowCountCalculatedInterface && !((TrueRowCountCalculatedInterface)tm).isTrueRowCountCalculated()) {
                this.alternatingMultipleButton.setEnabled(false);
            }
        }
    }

    @Override
    protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
        try {
            this.ignoreEventFromTransfer = true;
            super.transferAllItems(fromAdapter, toAdapter);
        }
        finally {
            this.ignoreEventFromTransfer = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List passedItems) {
        try {
            this.ignoreEventFromTransfer = true;
            super.transferItems(fromAdapter, toAdapter, passedItems);
        }
        finally {
            this.ignoreEventFromTransfer = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.direction = false;
        this.ensureButtonsEnabled();
    }

    public List getSelectedItems() {
        return this.targetAdapter.getAllItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedItems(List items) {
        block13: {
            try {
                this.ignoreEvents = true;
                this.targetAdapter.removeItems(this.targetAdapter.getAllItems());
                if (items.isEmpty()) break block13;
                ArrayList itemsToSelect = new ArrayList();
                if (((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSelectedAdapter().getComponent() instanceof JTree) {
                    JTree tree = (JTree)((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSelectedAdapter().getComponent();
                    for (Object element : items) {
                        TreePath treePath;
                        String uniqueMemberName = null;
                        if (element instanceof ValueItem && ((ValueItem)element).getValue() != null) {
                            uniqueMemberName = ((ValueItem)element).getValue().toString();
                        } else if (element instanceof String) {
                            uniqueMemberName = (String)element;
                        }
                        if (uniqueMemberName == null || (treePath = TreeUtil.getTreePathByUniqueMemberName(tree.getModel(), uniqueMemberName)) == null) continue;
                        if (element instanceof String) {
                            ValueItem vi = new ValueItem((Object)ValueProviderUtil.getLabelFor((String)((String)element)), element);
                            vi.setAttribute(ValueItem.PARENT, (Object)ValueProviderUtil.splitOLAPName((String)((String)element)));
                            element = vi;
                        }
                        itemsToSelect.add(element);
                    }
                } else {
                    List allItems = this.sourceAdapter.getAllItems();
                    DataTypeInterface dataType = ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getDataType();
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        boolean found = false;
                        Object element = iter.next();
                        if (!found) {
                            for (Object element2 : allItems) {
                                if (!ValuePicker.areValuesEqual(element, element2, dataType, this.getLocale())) continue;
                                itemsToSelect.add(element2);
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        itemsToSelect.add(element);
                    }
                }
                this.targetAdapter.addItems(itemsToSelect);
            }
            finally {
                this.ignoreEvents = false;
            }
        }
    }

    public JComponent getBrowseComponent() {
        return ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getBrowseAdapter().getComponent();
    }

    public JComponent getSearchComponent() {
        return ((ValueProviderDualSelectorAdapter)this.sourceAdapter).getSearchAdapter().getComponent();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            boolean oldValue = this.editable;
            this.editable = editable;
            this.updateEditField();
            this.firePropertyChange("editable", oldValue, this.editable);
        }
    }

    public boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean reorderingAllowed) {
        if (this.reorderingAllowed != reorderingAllowed) {
            boolean oldValue = this.reorderingAllowed;
            this.reorderingAllowed = reorderingAllowed;
            this.updateReorderingButtons();
            this.firePropertyChange("reorderingAllowed", oldValue, this.reorderingAllowed);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public void setValue(Object anObject) {
        if (!(anObject instanceof List)) {
            ArrayList newList = new ArrayList(1);
            if (anObject != null) {
                newList.add(anObject);
            }
            anObject = newList;
        }
        this.setSelectedItems(anObject);
    }

    @Override
    public Object getValue() {
        return this.getSelectedItems();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
    }

    @Override
    public void editingStarted(ChangeEvent e) {
    }

    @Override
    public void valueModified(ChangeEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void valueChanged(ChangeEvent e) {
        if (!this.ignoreEvents) {
            this.fireValueChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e == null || e.getType() == -1 || e.getType() == 1) {
            this.ensureButtonsEnabled();
        }
    }

    @SASScope
    private class TransferParentAndAllChildrenAction
    extends AbstractAction {
        public TransferParentAndAllChildrenAction() {
            super(RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItemAndAllChildren.txt", ValueProviderTableSelector.this.getLocale()));
            this.putValue("ShortDescription", RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItemAndAllChildrenToolTip.txt", ValueProviderTableSelector.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTreeDualSelectorAdapter treeAdapter = (JTreeDualSelectorAdapter)((ValueProviderDualSelectorAdapter)ValueProviderTableSelector.this.sourceAdapter).getSelectedAdapter();
            try {
                ((ValueProviderDualSelectorAdapter.ValueProviderTreeDualSelectorAdapter)treeAdapter).setMoveMode(3);
                ValueProviderTableSelector.this.transferSourceItems();
            }
            finally {
                ((ValueProviderDualSelectorAdapter.ValueProviderTreeDualSelectorAdapter)treeAdapter).setMoveMode(1);
            }
        }
    }

    @SASScope
    private class TransferParentAndChildrenAction
    extends AbstractAction {
        public TransferParentAndChildrenAction() {
            super(RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItemAndChildren.txt", ValueProviderTableSelector.this.getLocale()));
            this.putValue("ShortDescription", RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItemAndChildrenToolTip.txt", ValueProviderTableSelector.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTreeDualSelectorAdapter treeAdapter = (JTreeDualSelectorAdapter)((ValueProviderDualSelectorAdapter)ValueProviderTableSelector.this.sourceAdapter).getSelectedAdapter();
            try {
                ((ValueProviderDualSelectorAdapter.ValueProviderTreeDualSelectorAdapter)treeAdapter).setMoveMode(2);
                ValueProviderTableSelector.this.transferSourceItems();
            }
            finally {
                ((ValueProviderDualSelectorAdapter.ValueProviderTreeDualSelectorAdapter)treeAdapter).setMoveMode(1);
            }
        }
    }

    @SASScope
    private class TransferParentAction
    extends AbstractAction {
        public TransferParentAction() {
            super(RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItem.txt", ValueProviderTableSelector.this.getLocale()));
            this.putValue("ShortDescription", RB.getStringResource(ValueProviderTableSelector.RB_KEY, "addItemToolTip.txt", ValueProviderTableSelector.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTreeDualSelectorAdapter treeAdapter = (JTreeDualSelectorAdapter)((ValueProviderDualSelectorAdapter)ValueProviderTableSelector.this.sourceAdapter).getSelectedAdapter();
            ((ValueProviderDualSelectorAdapter.ValueProviderTreeDualSelectorAdapter)treeAdapter).setMoveMode(1);
            ValueProviderTableSelector.this.transferSourceItems();
        }
    }
}

