/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.FullWidthTable;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.NoBorderTableHeaderRenderer;
import com.sas.swing.visuals.dualselector.RB;
import com.sas.swing.visuals.dualselector.TableDualSelectorAdapter;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.DNDObject;
import com.sas.text.Message;
import com.sas.util.JavaCollectionPermuter;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope
public class ValueProviderDualSelectorAdapter
implements DualSelectorInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener,
ListSelectionListener,
ActionListener,
TreeSelectionListener,
SupportsGenericErrorHandlerInterface,
PropertyChangeListener,
ChangeListener,
MutableSupportedSpecialValuesInterface {
    public static final String RB_KEY = "ValueProviderDualSelectorAdapter.";
    public static final int BROWSE_NONE = 10;
    public static final int BROWSE_TABLE_PAGING_MODE = 20;
    public static final int BROWSE_TABLE_STATIC_MODE = 30;
    public static final int BROWSE_COMBO_MODE = 40;
    public static final int BROWSE_COMBO_EDITABLE_MODE = 50;
    protected JComponent parentSelector;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;
    private JTabbedPane tabbedPane;
    private JPanel browsePanel;
    private DualSelectorInterface browseAdapter;
    private JComponent browseComponent;
    private DualSelectorInterface searchAdapter;
    private JPanel searchPanel;
    private JButton searchButton;
    private ComboBox searchCombo;
    private JTextField searchField;
    private JComponent container;
    private ValueProviderInterface valueProvider;
    private ValueProviderModelAdapter model;
    private ValueProviderModelAdapter searchTableModel;
    private DataTypeInterface dataType;
    private boolean caseSensitiveSearch;
    private int browseMode;
    private int pageSize;
    private boolean inErrorMode;
    private boolean addNullValueForSingleComboSelection;
    private SupportedSpecialValues specialValues;
    private GenericErrorHandlerInterface errorHandler;
    private ChangeCursorCommand changeCursorCommand;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean search;
    private Locale locale;
    private ViewQueryCacheInterface viewQueryCache;

    public ValueProviderDualSelectorAdapter(ValueProviderInterface valueProvider, int browseMode, boolean search, JComponent parent, Locale locale) {
        this(valueProvider, browseMode, search, parent, null, locale);
    }

    public ValueProviderDualSelectorAdapter(ValueProviderInterface valueProvider, int browseMode, boolean search, JComponent parent, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(valueProvider, browseMode, search, parent, errorHandler, null, locale);
    }

    public ValueProviderDualSelectorAdapter(ValueProviderInterface valueProvider, int browseMode, boolean search, JComponent parent, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, Locale locale) {
        this(valueProvider, browseMode, search, parent, errorHandler, dataType, -1, locale);
    }

    public ValueProviderDualSelectorAdapter(ValueProviderInterface valueProvider, int browseMode, boolean search, JComponent parent, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, Locale locale) {
        this(valueProvider, browseMode, search, parent, errorHandler, dataType, pageSize, null, locale);
    }

    public ValueProviderDualSelectorAdapter(ValueProviderInterface valueProvider, int browseMode, boolean search, JComponent parent, GenericErrorHandlerInterface errorHandler, DataTypeInterface dataType, int pageSize, ViewQueryCacheInterface viewQueryCache, Locale locale) {
        this.browseMode = browseMode;
        this.search = search;
        this.locale = locale;
        this.errorHandler = errorHandler;
        this.parentSelector = parent;
        this.dataType = dataType;
        this.pageSize = pageSize;
        this.viewQueryCache = viewQueryCache;
        this.addNullValueForSingleComboSelection = true;
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.valueProvider = valueProvider;
        this.createBrowsePanel();
        this.createSearchPanel();
        this.createContainer();
    }

    private boolean isBrowsing() {
        return this.browseMode != 10;
    }

    public int getPageSize() {
        if (this.model != null) {
            return this.model.getPageSize();
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (this.model.getPageSize() != pageSize) {
            this.model.setPageSize(pageSize);
            this.createBrowsePanel();
        }
    }

    public void setAddNullValueForSingleComboSelection(boolean addNullValueForSingleComboSelection) {
        if (this.addNullValueForSingleComboSelection != addNullValueForSingleComboSelection) {
            this.addNullValueForSingleComboSelection = addNullValueForSingleComboSelection;
            if (this.model != null) {
                this.model.setAddNullValueForSingleComboSelection(addNullValueForSingleComboSelection);
            }
            this.updateAvailableValuesForCombo();
        }
    }

    private void createContainer() {
        if (this.isBrowsing() && this.search) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setOpaque(false);
            this.browsePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.searchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "browseTab.txt", this.locale), this.browsePanel);
            this.tabbedPane.addTab(RB.getStringResource(RB_KEY, "searchTab.txt", this.locale), this.searchPanel);
            this.container = this.tabbedPane;
            this.tabbedPane.addChangeListener(this);
        } else if (this.isBrowsing()) {
            if (this.browsePanel != null) {
                this.browsePanel.setBorder(null);
                this.container = this.browsePanel;
                if (this.tabbedPane != null) {
                    this.tabbedPane.removeChangeListener(this);
                }
                this.tabbedPane = null;
            }
        } else if (this.search && this.searchPanel != null) {
            this.searchPanel.setBorder(null);
            this.container = this.searchPanel;
            if (this.tabbedPane != null) {
                this.tabbedPane.removeChangeListener(this);
            }
            this.tabbedPane = null;
        }
    }

    public void selectBrowseTab() {
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(0);
            if (this.browseComponent != null) {
                this.browseComponent.requestFocusInWindow();
            }
        }
    }

    public void selectSearchTab() {
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(1);
            if (this.searchField != null) {
                this.searchField.requestFocusInWindow();
            }
        }
    }

    public void clearSearchResults() {
        if (this.searchTableModel != null) {
            if (this.searchField != null) {
                this.searchField.setText(null);
            }
            this.searchTableModel.clearSearchResults();
        }
    }

    private int getLabelColumn() {
        if (this.valueProvider != null && this.valueProvider.isValueDisplayed()) {
            return 1;
        }
        return 0;
    }

    private void createSearchPanel() {
        if (this.search) {
            if (this.searchPanel == null) {
                FullWidthTable table;
                block13: {
                    JComponent sourceComp;
                    table = new FullWidthTable();
                    this.searchTableModel = new ValueProviderModelAdapter(this.valueProvider, this.getDataType(), 603, this.pageSize, this.locale);
                    this.searchTableModel.setViewQueryCache(this.viewQueryCache);
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "value.txt"), 0);
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "label.txt"), this.valueProvider != null && this.valueProvider.isValueDisplayed() ? 1 : 0);
                    this.searchTableModel.addPropertyChangeListener(this);
                    if (this.valueProvider != null) {
                        ArrayList<String> columns = new ArrayList<String>();
                        if (this.valueProvider.isValueDisplayed()) {
                            columns.add("VALUE");
                        }
                        columns.add("LABEL");
                        this.searchTableModel.setColumns(columns);
                    }
                    if (this.browseAdapter != null && (sourceComp = this.browseAdapter.getComponent()) instanceof JTree) {
                        this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "label.txt", Locale.getDefault()), 0);
                        this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "parentPath.txt", Locale.getDefault()), 1);
                        ArrayList<String> columns = new ArrayList<String>();
                        columns.add("LABEL");
                        columns.add(ValueItem.PARENT);
                        this.searchTableModel.setColumns(columns);
                    }
                    try {
                        table.setModel((TableModel)this.searchTableModel.getModel());
                    }
                    catch (ValueProviderException e) {
                        LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).debug(e.getMessage(), (Throwable)e);
                        if (this.getGenericErrorHandler() == null) break block13;
                        this.getGenericErrorHandler().handleError(this, this.newMessageWithCharacterFilters(e.getMessage()), null);
                    }
                }
                ValueProviderDualSelectorAdapter.setPropertiesOnTable(table);
                table.getEditController().setEditEnabled(false);
                this.searchAdapter = new ValueProviderTableDualSelectorAdapter(table, this.parentSelector);
                this.searchPanel = new JPanel();
                this.searchPanel.setOpaque(false);
                AutoSizingGridLayout panelLayout = new AutoSizingGridLayout(-1, 1, 5, 5, true, true, true);
                panelLayout.setIgnoreSizeOfNonVisibleComponents(true);
                panelLayout.setRemainderRow(2);
                this.searchPanel.setLayout(panelLayout);
                JPanel topPanel = new JPanel();
                topPanel.setOpaque(false);
                AutoSizingGridLayout topLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
                topLayout.setIgnoreSizeOfNonVisibleComponents(true);
                topPanel.setLayout(topLayout);
                this.searchAdapter.getComponent().setOpaque(false);
                this.searchAdapter.getContainerComponent().setOpaque(false);
                ((JScrollPane)this.searchAdapter.getContainerComponent()).getViewport().setOpaque(false);
                this.searchPanel.add(topPanel);
                this.searchPanel.add(this.searchAdapter.getContainerComponent());
                ((TableView)this.searchAdapter.getComponent()).getRowModel().getSelectionModel().addListSelectionListener(this);
                JPanel searchPanel = topPanel;
                searchPanel.setLayout(new AutoSizingGridLayout(4, 1, 5, 5, true, false, true));
                JLabel searchLabel = new JLabel(RB.getStringResource(RB_KEY, "searchForItems.txt", this.locale));
                searchPanel.add(searchLabel);
                JPanel innerSearchPanel = new JPanel();
                innerSearchPanel.setOpaque(false);
                AutoSizingGridLayout innerSearchLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
                innerSearchLayout.setRemainderColumn(2);
                innerSearchPanel.setLayout(innerSearchLayout);
                this.searchCombo = new ComboBox();
                DefaultComboBoxModel<ValueItem> comboModel = new DefaultComboBoxModel<ValueItem>();
                comboModel.addElement(new ValueItem((Object)RB.getStringResource(RB_KEY, "contain.txt", this.locale), SearchCriteria.OPERATOR_CONTAINS));
                comboModel.addElement(new ValueItem((Object)RB.getStringResource(RB_KEY, "isEqualTo.txt", this.locale), SearchCriteria.OPERATOR_EQUAL));
                comboModel.addElement(new ValueItem((Object)RB.getStringResource(RB_KEY, "startWith.txt", this.locale), SearchCriteria.OPERATOR_STARTS_WITH));
                comboModel.addElement(new ValueItem((Object)RB.getStringResource(RB_KEY, "endWith.txt", this.locale), SearchCriteria.OPERATOR_ENDS_WITH));
                comboModel.addElement(new ValueItem((Object)RB.getStringResource(RB_KEY, "matchPattern.txt", this.locale), SearchCriteria.OPERATOR_MATCH_PATTERN));
                this.searchCombo.setModel(comboModel);
                innerSearchPanel.add(this.searchCombo);
                this.searchField = new JTextField(12);
                innerSearchPanel.add(this.searchField);
                searchPanel.add(innerSearchPanel);
                JPanel innerSearchPanel2 = new JPanel();
                innerSearchPanel2.setOpaque(false);
                AutoSizingGridLayout innerSearchLayout2 = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
                innerSearchPanel2.setLayout(innerSearchLayout2);
                this.searchButton = new JButton(RB.getStringResource(RB_KEY, "searchButtonLabel.txt", this.locale));
                innerSearchPanel2.add(this.searchButton);
                searchPanel.add(innerSearchPanel2);
                JLabel searchResultsLabel = new JLabel(RB.getStringResource(RB_KEY, "searchResults.txt", this.locale));
                searchPanel.add(searchResultsLabel);
                this.searchField.addActionListener(this);
                this.searchButton.addActionListener(this);
                int visibleRowCount = 5;
                int visibleColumnCount = 1;
                ((TableView)this.searchAdapter.getComponent()).setColumnAutoResizeMode(4);
                ((TableView)this.searchAdapter.getComponent()).setVisibleRowCount(visibleRowCount);
                ((TableView)this.searchAdapter.getComponent()).setVisibleColumnCount(visibleColumnCount);
            } else {
                JComponent sourceComp = null;
                if (this.browseAdapter != null) {
                    sourceComp = this.browseAdapter.getComponent();
                }
                if (this.valueProvider != null && !(sourceComp instanceof JTree)) {
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "value.txt"), 0);
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "label.txt"), this.valueProvider.isValueDisplayed() ? 1 : 0);
                    ArrayList<String> columns = new ArrayList<String>();
                    if (this.valueProvider.isValueDisplayed()) {
                        columns.add("VALUE");
                    }
                    columns.add("LABEL");
                    this.searchTableModel.setColumns(columns);
                } else if (sourceComp instanceof JTree) {
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "label.txt", Locale.getDefault()), 0);
                    this.searchTableModel.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "parentPath.txt", Locale.getDefault()), 1);
                    ArrayList<String> columns = new ArrayList<String>();
                    columns.add("LABEL");
                    columns.add(ValueItem.PARENT);
                    this.searchTableModel.setColumns(columns);
                }
                ValueProviderDualSelectorAdapter.setPropertiesOnTable((TableView)this.searchAdapter.getComponent());
            }
        }
    }

    public void reloadValues() {
        if (this.model != null) {
            this.model.refresh();
        }
        this.createBrowsePanel();
        this.createSearchPanel();
    }

    public List getColumns() {
        if (this.model != null) {
            return this.model.getColumns();
        }
        return Collections.EMPTY_LIST;
    }

    private void getModelForValues() {
        int mode = -1;
        if (this.browseMode == 20) {
            mode = 600;
        } else if (this.browseMode == 30) {
            mode = 601;
        } else if (this.browseMode == 40 || this.browseMode == 50) {
            mode = 602;
        }
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        if (this.model == null) {
            this.model = new ValueProviderModelAdapter(this.valueProvider, this.getDataType(), mode, this.getSupportedSpecialValues(), this.pageSize, this.locale);
            this.model.setViewQueryCache(this.viewQueryCache);
        } else {
            this.model.setModel(this.valueProvider);
            this.model.setDataType(this.getDataType());
            this.model.setLocale(this.locale);
            this.model.setMode(mode);
            this.model.setSupportedSpecialValues(this.getSupportedSpecialValues());
        }
        this.model.setAddNullValueForSingleComboSelection(this.addNullValueForSingleComboSelection);
        this.model.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "value.txt"), 0);
        this.model.setColumnName(RB.getStringResource("ValueProviderTableSelector.", "label.txt"), this.valueProvider != null && this.valueProvider.isValueDisplayed() ? 1 : 0);
        this.model.addPropertyChangeListener(this);
        if (this.valueProvider != null) {
            ArrayList<String> columns = new ArrayList<String>();
            if (this.valueProvider.isValueDisplayed()) {
                columns.add("VALUE");
            }
            columns.add("LABEL");
            this.model.setColumns(columns);
        }
    }

    private void createBrowsePanel() {
        Object m;
        boolean change;
        block46: {
            this.getModelForValues();
            change = false;
            m = null;
            try {
                m = this.model.getModel();
                this.inErrorMode = false;
            }
            catch (ValueProviderException e) {
                this.inErrorMode = true;
                LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).debug(e.getMessage(), (Throwable)e);
                if (this.getGenericErrorHandler() == null) break block46;
                this.getGenericErrorHandler().handleError(this, this.newMessageWithCharacterFilters(e.getMessage()), null);
            }
        }
        if (m instanceof TableModel) {
            if (this.isBrowsing()) {
                if (!(this.browseAdapter instanceof ValueProviderTableDualSelectorAdapter)) {
                    change = true;
                    FullWidthTable table = new FullWidthTable();
                    table.getEditController().setEditEnabled(false);
                    this.browseAdapter = new ValueProviderTableDualSelectorAdapter(table, this.parentSelector);
                    this.browseComponent = this.browseAdapter.getComponent();
                    table.setModel((TableModel)m);
                    ValueProviderDualSelectorAdapter.setPropertiesOnTable(table);
                } else {
                    ((TableView)this.browseComponent).setModel((TableModel)m);
                    ValueProviderDualSelectorAdapter.setPropertiesOnTable((TableView)this.browseComponent);
                }
            }
        } else if (m instanceof TreeModel) {
            if (!(this.browseAdapter instanceof JTreeDualSelectorAdapter)) {
                change = true;
                this.browseAdapter = new ValueProviderTreeDualSelectorAdapter(this.parentSelector);
                ((JTreeDualSelectorAdapter)this.browseAdapter).setMoveChildNodesWithParent(false);
                this.browseComponent = this.browseAdapter.getComponent();
                ((JTree)this.browseComponent).setRootVisible(false);
                ((JTree)this.browseComponent).setShowsRootHandles(true);
                ((JTree)this.browseComponent).setVisibleRowCount(8);
            }
            ((JTree)this.browseComponent).setModel((TreeModel)m);
        } else if (m instanceof ComboBoxModel || this.browseMode == 50) {
            if (this.isBrowsing()) {
                if (this.browseMode == 40) {
                    if (!(this.browseAdapter instanceof JComboBoxDualSelectorAdapter)) {
                        change = true;
                        WideComboBox combo = new WideComboBox();
                        combo.setPrototypeDisplayValue("WWWWWWWWWW");
                        combo.setEditable(false);
                        combo.setPopupStyle(5);
                        this.browseAdapter = new JComboBoxDualSelectorAdapter(combo, this.parentSelector);
                        this.browseComponent = this.browseAdapter.getComponent();
                    }
                    ((JComboBox)this.browseComponent).setModel((ComboBoxModel)m);
                } else if (this.browseMode == 50) {
                    if (!(this.browseAdapter instanceof EditorDualSelectorAdapter)) {
                        change = true;
                        try {
                            EditorInterface editor = EditorFactory.defaultInstance.getEditor(this.dataType == null ? this.valueProvider.getDataType() : this.dataType, this.locale);
                            if (editor instanceof DatePicker) {
                                ((DatePicker)editor).setShowRelativeDates(true);
                            }
                            this.browseAdapter = new EditorDualSelectorAdapter(editor, this.parentSelector);
                            this.browseComponent = this.browseAdapter.getComponent();
                        }
                        catch (ValueProviderException ex) {
                            LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    this.updateAvailableValuesForCombo();
                }
            }
        } else if (!(this.browseAdapter instanceof EmptyDualSelectorAdapter)) {
            change = true;
            this.browseAdapter = new EmptyDualSelectorAdapter();
            this.browseComponent = this.browseAdapter.getComponent();
        }
        if (change && this.browseAdapter != null && this.browseAdapter.getContainerComponent() != null) {
            this.browseAdapter.getContainerComponent().setOpaque(false);
            JComponent containerComp = this.browseAdapter.getContainerComponent();
            if (containerComp instanceof JScrollPane) {
                ((JScrollPane)containerComp).getViewport().setOpaque(false);
            }
        }
        if (this.browseAdapter != null) {
            if (this.browsePanel == null) {
                this.browsePanel = new JPanel();
                this.browsePanel.setOpaque(false);
                AutoSizingGridLayout panelLayout = new AutoSizingGridLayout(-1, 1, 5, 5, true, true, true);
                panelLayout.setIgnoreSizeOfNonVisibleComponents(true);
                panelLayout.setRemainderRow(1);
                this.browsePanel.setLayout(panelLayout);
                this.browsePanel.add(this.browseAdapter.getContainerComponent());
                if (this.browseComponent instanceof TableView) {
                    int visibleRowCount = 5;
                    int visibleColumnCount = 1;
                    TableView tv = (TableView)this.browseComponent;
                    tv.setColumnAutoResizeMode(4);
                    tv.setVisibleRowCount(visibleRowCount);
                    tv.setVisibleColumnCount(visibleColumnCount);
                } else if (this.browseComponent instanceof JTree) {
                    ((JTree)this.browseComponent).setVisibleRowCount(5);
                }
                if (this.browseComponent instanceof TableView) {
                    ((TableView)this.browseComponent).getRowModel().getSelectionModel().addListSelectionListener(this);
                } else if (this.browseComponent instanceof JTree) {
                    ((JTree)this.browseComponent).getSelectionModel().addTreeSelectionListener(this);
                } else if (this.browseComponent instanceof JComboBox) {
                    ((JComboBox)this.browseComponent).addActionListener(this);
                }
            } else if (change) {
                Component oldBrowseComp = this.browsePanel.getComponent(0);
                this.browsePanel.removeAll();
                this.browsePanel.add(this.browseAdapter.getContainerComponent());
                if (oldBrowseComp instanceof TableView) {
                    ((TableView)oldBrowseComp).getRowModel().getSelectionModel().removeListSelectionListener(this);
                } else if (oldBrowseComp instanceof JTree) {
                    ((JTree)oldBrowseComp).getSelectionModel().removeTreeSelectionListener(this);
                } else if (oldBrowseComp instanceof JComboBox) {
                    ((JComboBox)oldBrowseComp).removeActionListener(this);
                }
                if (this.browseComponent instanceof TableView) {
                    ((TableView)this.browseComponent).getRowModel().getSelectionModel().addListSelectionListener(this);
                } else if (this.browseComponent instanceof JTree) {
                    ((JTree)this.browseComponent).getSelectionModel().addTreeSelectionListener(this);
                } else if (this.browseComponent instanceof JComboBox) {
                    ((JComboBox)this.browseComponent).addActionListener(this);
                }
            }
        }
    }

    private void updateAvailableValuesForCombo() {
        if (this.model != null) {
            Object m;
            block8: {
                m = null;
                try {
                    m = this.model.getModel();
                }
                catch (ValueProviderException e) {
                    LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).debug(e.getMessage(), (Throwable)e);
                    if (this.getGenericErrorHandler() == null) break block8;
                    this.getGenericErrorHandler().handleError(this, this.newMessageWithCharacterFilters(e.getMessage()), null);
                }
            }
            if (m instanceof ComboBoxModel && this.browseAdapter instanceof EditorDualSelectorAdapter) {
                ArrayList listOfValues = new ArrayList();
                int size = ((ComboBoxModel)m).getSize();
                for (int i = 0; i < size; ++i) {
                    listOfValues.add(((ComboBoxModel)m).getElementAt(i));
                }
                EditorInterface editor = ((EditorDualSelectorAdapter)this.browseAdapter).getEditor();
                if (editor instanceof DatePicker) {
                    ((DatePicker)editor).setAvailableValues(listOfValues);
                } else if (editor instanceof TextEditor) {
                    ((TextEditor)editor).setAvailableValues(listOfValues);
                }
            }
        }
    }

    protected DataTypeInterface getDataType() {
        return this.dataType;
    }

    public JPanel getBrowsePanel() {
        return this.browsePanel;
    }

    public JPanel getSearchPanel() {
        return this.searchPanel;
    }

    public boolean isInErrorMode() {
        return this.inErrorMode;
    }

    public void setParentSelector(JComponent parent) {
        this.parentSelector = parent;
        if (this.browseAdapter != null) {
            if (this.browseAdapter instanceof TableDualSelectorAdapter) {
                ((TableDualSelectorAdapter)this.browseAdapter).setParentSelector(this.parentSelector);
            } else if (this.browseAdapter instanceof JTreeDualSelectorAdapter) {
                ((JTreeDualSelectorAdapter)this.browseAdapter).setParentSelector(this.parentSelector);
            } else if (this.browseAdapter instanceof JComboBoxDualSelectorAdapter) {
                ((JComboBoxDualSelectorAdapter)this.browseAdapter).setParentSelector(this.parentSelector);
            }
        }
        if (this.searchAdapter != null && this.searchAdapter instanceof TableDualSelectorAdapter) {
            ((TableDualSelectorAdapter)this.searchAdapter).setParentSelector(this.parentSelector);
        }
    }

    public DualSelectorInterface getSelectedAdapter() {
        if (this.isBrowsing() && this.search) {
            int index = this.tabbedPane.getSelectedIndex();
            if (index == 0) {
                return this.browseAdapter;
            }
            if (index == 1) {
                return this.searchAdapter;
            }
        }
        if (this.isBrowsing()) {
            return this.browseAdapter;
        }
        if (this.search) {
            return this.searchAdapter;
        }
        return null;
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        if (this.specialValues != specialValuesSupported) {
            this.specialValues = specialValuesSupported;
            if (this.model != null) {
                this.model.setSupportedSpecialValues(this.specialValues);
                this.updateAvailableValuesForCombo();
            }
        }
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    @Override
    public void clearSelections() {
        if (this.browseAdapter != null) {
            this.browseAdapter.clearSelections();
        }
        if (this.searchAdapter != null) {
            this.searchAdapter.clearSelections();
        }
    }

    @Override
    public int getCount() {
        return this.getSelectedAdapter().getCount();
    }

    @Override
    public int getSelectedCount() {
        return this.getSelectedAdapter().getSelectedCount();
    }

    @Override
    public int getLastSelectedIndex() {
        return this.getSelectedAdapter().getLastSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.getSelectedAdapter().setSelectedIndex(index);
    }

    public boolean setBrowseAndSearchVisible(int browseState, boolean searchVisible) {
        if (this.browseMode == browseState && this.search == searchVisible) {
            return false;
        }
        if (this.browseMode != browseState) {
            this.browseMode = browseState;
            if (this.isBrowsing()) {
                this.createBrowsePanel();
            } else {
                if (this.tabbedPane != null) {
                    this.tabbedPane.remove(this.browsePanel);
                }
                this.browseAdapter = null;
                this.browseComponent = null;
                this.browsePanel = null;
            }
        }
        if (this.search != searchVisible) {
            this.search = searchVisible;
            if (this.search) {
                this.createSearchPanel();
            } else {
                if (this.tabbedPane != null) {
                    this.tabbedPane.remove(this.searchPanel);
                }
                this.searchAdapter = null;
                this.searchPanel = null;
            }
        }
        this.createContainer();
        return true;
    }

    protected static void setPropertiesOnTable(TableView table) {
        table.setShowGrid(false);
        table.getColumnModel().setColumnMargin(0);
        table.setGridColor(SystemColor.activeCaptionBorder);
        table.getColumnHeader().setResizingAllowed(false);
        table.getTableHeader().setDefaultRenderer(new NoBorderTableHeaderRenderer());
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowAutoResizeMode(0);
        if (table.getColumnCount() > 1) {
            table.setColumnHeaderVisible(true);
        } else {
            table.setColumnHeaderVisible(false);
        }
        table.setOpaque(false);
        JScrollPane tableScrollPane = table.getScrollPane();
        if (tableScrollPane != null) {
            tableScrollPane.getViewport().setOpaque(true);
            tableScrollPane.getViewport().setBackground(table.getBackground());
        }
    }

    @Override
    public JComponent getComponent() {
        return this.container;
    }

    @Override
    public JComponent getContainerComponent() {
        return this.container;
    }

    private List createListOfItemsForTable(DualSelectorInterface adapter, List items) {
        if (adapter instanceof JTreeDualSelectorAdapter) {
            ArrayList<Object> newItems = new ArrayList<Object>();
            for (TreePath treePath : items) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)object;
                    if (treeNode.getUserObject() instanceof MetadataEntityInterface) {
                        MetadataEntityInterface entity = (MetadataEntityInterface)treeNode.getUserObject();
                        ValueItem item = new ValueItem();
                        try {
                            item.setLabel(entity.getLabel());
                            String uniqueName = entity.getUniqueName();
                            item.setValue((Object)uniqueName);
                            item.setAttribute(ValueItem.PARENT, (Object)ValueProviderUtil.splitOLAPName((String)uniqueName));
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                        newItems.add(item);
                        continue;
                    }
                    if (treeNode.getUserObject() instanceof ValueItem) {
                        newItems.add(treeNode.getUserObject());
                        continue;
                    }
                    newItems.add(new ValueItem(treePath.getLastPathComponent(), treeNode.getUserObject()));
                    continue;
                }
                newItems.add(new ValueItem(treePath.getLastPathComponent(), treePath.getLastPathComponent()));
            }
            items = newItems;
        } else {
            int index = 0;
            if (this.valueProvider != null && this.valueProvider.isValueDisplayed()) {
                index = 1;
            }
            ArrayList newItems = new ArrayList();
            for (Object e : items) {
                if (e instanceof Vector && ((Vector)e).size() > 0) {
                    newItems.add(((Vector)e).get(index));
                    continue;
                }
                newItems.add(e);
            }
            items = newItems;
        }
        return items;
    }

    public List getSelectedItemsFor(DualSelectorInterface adapter) {
        List selectedItems = adapter.getSelectedItems();
        return this.prepareSelectedItems(adapter, selectedItems);
    }

    public List prepareSelectedItems(DualSelectorInterface adapter, List selectedItems) {
        selectedItems = this.createListOfItemsForTable(adapter, selectedItems);
        return selectedItems;
    }

    @Override
    public List getSelectedItems() {
        return this.getSelectedItemsFor(this.getSelectedAdapter());
    }

    @Override
    public List getAllItems() {
        DualSelectorInterface adapter = this.getSelectedAdapter();
        List allItems = adapter.getAllItems();
        return this.prepareSelectedItems(adapter, allItems);
    }

    @Override
    public List getAllMoveableItems() {
        DualSelectorInterface adapter = this.getSelectedAdapter();
        List allMoveableItems = adapter.getAllMoveableItems();
        allMoveableItems = this.createListOfItemsForTable(adapter, allMoveableItems);
        return allMoveableItems;
    }

    @Override
    public void addItems(List newItems) {
        this.getSelectedAdapter().addItems(newItems);
    }

    @Override
    public void removeItems(List removeItems) {
        this.getSelectedAdapter().removeItems(removeItems);
    }

    @Override
    public boolean isInAdapter(Object item) {
        return this.getSelectedAdapter().isInAdapter(item);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                event.rejectDrop();
            } else {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    event.acceptDrop(2);
                    if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                        ((BaseDualSelector)this.parentSelector).transferTargetItems();
                    } else {
                        ((BaseDualSelector)this.parentSelector).transferSourceItems();
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        List selected;
        ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
            DNDObject items = new DNDObject();
            for (int i = 0; i < selected.size(); ++i) {
                items.add(selected.get(i));
            }
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public void setModel(ValueProviderInterface valueProvider) {
        this.valueProvider = valueProvider;
    }

    public ValueProviderInterface getModel() {
        return this.valueProvider;
    }

    public boolean isMoreValuesSelected() {
        if (this.browseComponent instanceof TableView) {
            TableView table = (TableView)this.browseComponent;
            int[] rows = table.getRowModel().getSelectedRows();
            if (rows != null && rows.length > 0) {
                for (int i = 0; i < rows.length; ++i) {
                    try {
                        Object v;
                        TableModel tm = (TableModel)this.model.getModel();
                        if (!(tm instanceof ValueProviderModelAdapter.ValueProviderToTableModelAdapter ? this.isMoreValue(v = ((ValueProviderModelAdapter.ValueProviderToTableModelAdapter)tm).getValueAt(rows[i], 0, false)) : this.isMoreValue(tm.getValueAt(rows[i], 0)))) continue;
                        return true;
                    }
                    catch (ValueProviderException e) {
                        return false;
                    }
                }
            }
        } else {
            if (this.browseComponent instanceof JComboBox) {
                JComboBox combo = (JComboBox)this.browseComponent;
                return this.isMoreValue(combo.getSelectedItem());
            }
            if (this.browseComponent instanceof EditorInterface) {
                Object eValue = ((EditorInterface)((Object)this.browseComponent)).getValue();
                return this.isMoreValue(eValue);
            }
        }
        return false;
    }

    public boolean isMoreValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getMoreOptionsValue(), (Object)value) || Util.equal((Object)this.model.getMoreOptionsValue().getValue(), (Object)value));
    }

    public boolean isSeperatorValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getSeperatorValue(), (Object)value) || Util.equal((Object)this.model.getSeperatorValue().getValue(), (Object)value));
    }

    public boolean isNoResultsFoundValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getNoResultsFoundValue(), (Object)value) || Util.equal((Object)this.model.getNoResultsFoundValue().getValue(), (Object)value));
    }

    public boolean isAllValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getAllValue(), (Object)value) || Util.equal((Object)this.model.getAllValue().getValue(), (Object)value));
    }

    public boolean isOtherValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getOtherValue(), (Object)value) || Util.equal((Object)this.model.getOtherValue().getValue(), (Object)value));
    }

    public boolean isMissingValue(Object value) {
        return this.model != null && (Util.equal((Object)this.model.getMissingValue(), (Object)value) || Util.equal((Object)this.model.getMissingValue().getValue(), (Object)value));
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.fireStateChanged();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.searchButton || source == this.searchField) {
            try {
                this.changeCursorCommand.apply((Component)source);
                this.changeCursorCommand.apply(SwingUtilities.getWindowAncestor(this.searchButton));
                this.search();
                TableView table = (TableView)this.searchAdapter.getComponent();
                if (table == null) return;
                table.setCurrentRow(0);
                table.setCurrentColumn(0);
                Rectangle rect = table.getCellRect(0, 0, true);
                table.scrollRectToVisible(rect);
                return;
            }
            finally {
                this.changeCursorCommand.undoAll();
            }
        } else {
            if (source != this.browseComponent) return;
            this.fireStateChanged();
        }
    }

    private void search() {
        if (this.valueProvider instanceof ListSearchInterface) {
            TableView table;
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.setTextToMatch(this.searchField.getText());
            searchCriteria.setOperator(((ValueItem)this.searchCombo.getSelectedItem()).getValue());
            searchCriteria.setCaseSensitiveSearch(this.isCaseSensitiveSearch());
            try {
                this.searchTableModel.search(searchCriteria);
            }
            catch (ValueProviderException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "";
                }
                if (this.getGenericErrorHandler() != null) {
                    LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).debug(msg, (Throwable)e);
                    this.getGenericErrorHandler().handleError(this, this.newMessageWithCharacterFilters(msg), null);
                }
                LoggerRepository2.getLogger((String)ValueProviderDualSelectorAdapter.class.getName(), null).error(msg, (Throwable)e);
            }
            if (this.searchAdapter != null && this.searchAdapter.getComponent() instanceof TableView && (table = (TableView)this.searchAdapter.getComponent()).getColumnHeader() != null) {
                table.getColumnHeader().sizeColumnsToFit();
            }
        }
    }

    public DualSelectorInterface getBrowseAdapter() {
        return this.browseAdapter;
    }

    public DualSelectorInterface getSearchAdapter() {
        return this.searchAdapter;
    }

    public JComponent getBrowseComponent() {
        return this.browseComponent;
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public void setCaseSensitiveSearch(boolean caseSensitiveSearch) {
        if (this.caseSensitiveSearch != caseSensitiveSearch) {
            this.caseSensitiveSearch = caseSensitiveSearch;
        }
    }

    public int getBrowseMode() {
        return this.browseMode;
    }

    public void setBrowseMode(int browseMode) {
        if (this.browseMode != browseMode) {
            this.browseMode = browseMode;
            this.createBrowsePanel();
        }
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public JComboBox getSearchCombo() {
        return this.searchCombo;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    public void setAdditionalAvailableValues(List additionalValues) {
        if (this.model != null) {
            this.model.setAdditionalAvailableValues(additionalValues);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object nv;
        if (evt != null && Strings.equal((String)evt.getPropertyName(), (String)"loadingValues", (boolean)true, (boolean)true) && (nv = evt.getNewValue()) instanceof Boolean) {
            boolean loading = (Boolean)nv;
            if (loading) {
                Container comp = this.parentSelector;
                if (comp == null) {
                    if (this.browsePanel != null) {
                        comp = this.browsePanel;
                    } else if (this.searchPanel != null) {
                        comp = this.searchPanel;
                    }
                }
                if (comp != null) {
                    comp = SwingUtilities.getWindowAncestor(comp);
                }
                if (comp != null) {
                    this.changeCursorCommand.apply(comp);
                }
            } else {
                this.changeCursorCommand.undoAll();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    private Message newMessageWithCharacterFilters(String messageString) {
        if (messageString == null) {
            messageString = "";
        } else {
            messageString = Strings.padSingleQuotesForMessage((String)messageString);
            messageString = messageString.replaceAll("\\{", "(");
            messageString = messageString.replaceAll("\\}", ")");
        }
        Message message = new Message(messageString);
        return message;
    }

    @SASScope
    private class EmptyDualSelectorAdapter
    implements DualSelectorInterface {
        private JComponent comp;
        private JComponent container;

        public EmptyDualSelectorAdapter() {
            if (ValueProviderDualSelectorAdapter.this.browseMode == 20 || ValueProviderDualSelectorAdapter.this.browseMode == 30) {
                FullWidthTable table = new FullWidthTable(){

                    @Override
                    public boolean isEnabled() {
                        return false;
                    }
                };
                DefaultTableModel dtm = new DefaultTableModel();
                if (ValueProviderDualSelectorAdapter.this.model != null && ValueProviderDualSelectorAdapter.this.model.getColumns() != null) {
                    List cols = ValueProviderDualSelectorAdapter.this.model.getColumns();
                    int i = 0;
                    Iterator iter = cols.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        dtm.addColumn(ValueProviderDualSelectorAdapter.this.model.getColumnName(i++));
                    }
                }
                dtm.addRow(new Object[]{RB.getStringResource(ValueProviderDualSelectorAdapter.RB_KEY, "errorLoadingValues.txt")});
                table.setModel(dtm);
                table.getEditController().setEditEnabled(false);
                ValueProviderDualSelectorAdapter.setPropertiesOnTable(table);
                table.setEnabled(false);
                table.setRowMargin(0);
                table.setVisibleRowCount(5);
                JScrollPane pane = new JScrollPane(table);
                this.comp = table;
                this.container = pane;
            } else {
                WideComboBox combo = new WideComboBox(){

                    @Override
                    public boolean isEnabled() {
                        return false;
                    }
                };
                combo.addItem(RB.getStringResource(ValueProviderDualSelectorAdapter.RB_KEY, "errorLoadingValues.txt"));
                combo.setEditable(false);
                combo.setEnabled(false);
                combo.setPopupStyle(5);
                this.comp = combo;
                this.container = combo;
            }
        }

        @Override
        public void addItems(List newItems) {
        }

        @Override
        public void clearSelections() {
        }

        @Override
        public List getAllItems() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getAllMoveableItems() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public JComponent getComponent() {
            return this.comp;
        }

        @Override
        public JComponent getContainerComponent() {
            return this.container;
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public int getLastSelectedIndex() {
            return 0;
        }

        @Override
        public int getSelectedCount() {
            return 0;
        }

        @Override
        public List getSelectedItems() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean isInAdapter(Object item) {
            return false;
        }

        @Override
        public void removeItems(List removeItems) {
        }

        @Override
        public void setSelectedIndex(int index) {
        }
    }

    @SASScope
    class ValueProviderTreeDualSelectorAdapter
    extends JTreeDualSelectorAdapter {
        public static final int ONLY_SELECTED = 1;
        public static final int SELECTED_AND_CHILDREN = 2;
        public static final int SELECTED_AND_ALL_CHILDREN = 3;
        private int moveMode;

        public ValueProviderTreeDualSelectorAdapter(JComponent parent) {
            super(parent);
            this.moveMode = 1;
        }

        public ValueProviderTreeDualSelectorAdapter(JTree tree, JComponent parent) {
            super(tree, parent);
            this.moveMode = 1;
        }

        @Override
        public List getAllMoveableItems() {
            List allItems = super.getAllMoveableItems();
            if (allItems != null && !allItems.isEmpty()) {
                allItems.remove(0);
            }
            return allItems;
        }

        @Override
        public List getSelectedItems() {
            TreeModel tm = this.component.getModel();
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            TreePath[] selectedItems = this.component.getSelectionPaths();
            if (selectedItems != null) {
                for (int i = 0; i < selectedItems.length; ++i) {
                    TreePath tempPath = selectedItems[i];
                    if (list.contains(tempPath)) continue;
                    if (this.moveMode == 1) {
                        list.add(selectedItems[i]);
                        continue;
                    }
                    list.add(selectedItems[i]);
                    List childPaths = this.getChildPaths(tm, tempPath);
                    for (int j = 0; j < childPaths.size(); ++j) {
                        if (list.contains(childPaths.get(j))) continue;
                        list.add((TreePath)childPaths.get(j));
                    }
                }
            }
            return list;
        }

        private List getChildPaths(TreeModel treeModel, TreePath childPath) {
            ArrayList<TreePath> returnList = new ArrayList<TreePath>();
            Object lastComponent = childPath.getLastPathComponent();
            int childCount = treeModel.getChildCount(lastComponent);
            for (int i = 0; i < childCount; ++i) {
                Object childNode = treeModel.getChild(lastComponent, i);
                TreePath tempPath = childPath.pathByAddingChild(childNode);
                returnList.add(tempPath);
                if (this.moveMode != 3 || treeModel.getChildCount(childNode) <= 0) continue;
                returnList.addAll(this.getChildPaths(treeModel, tempPath));
            }
            return returnList;
        }

        public int getMoveMode() {
            return this.moveMode;
        }

        public void setMoveMode(int moveMode) {
            if (this.moveMode != moveMode) {
                this.moveMode = moveMode;
            }
        }
    }

    @SASScope
    private class JComboBoxDualSelectorAdapter
    implements DualSelectorInterface,
    DualSelectorUpDownInterface,
    DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private ComboBoxModel comboModel;
        protected JComboBox component;
        protected JPanel containerComp;
        protected JComponent parentSelector;
        public DropTarget dropTarget = null;
        public DragSource dragSource = null;

        public JComboBoxDualSelectorAdapter(JComponent parent) {
            this(new JComboBox(), parent);
        }

        public JComboBoxDualSelectorAdapter(JComboBox combo, JComponent parent) {
            this.component = combo;
            this.parentSelector = parent;
            this.containerComp = new JPanel();
            this.containerComp.setOpaque(false);
            AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
            this.containerComp.setLayout(layout);
            this.containerComp.add(combo);
            this.comboModel = this.component.getModel();
            if (this.parentSelector != null) {
                if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
                    this.dropTarget = new DropTarget(this.component, this);
                    this.dragSource = DragSource.getDefaultDragSource();
                    this.dragSource.createDefaultDragGestureRecognizer(this.component, 3, this);
                } else {
                    ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
                }
            }
        }

        @Override
        public void clearSelections() {
            this.component.setSelectedIndex(-1);
            this.component.repaint();
        }

        @Override
        public int getCount() {
            return this.component.getModel().getSize();
        }

        @Override
        public int getSelectedCount() {
            List list = this.getSelectedItems();
            return list.size();
        }

        @Override
        public int getLastSelectedIndex() {
            return this.component.getSelectedIndex();
        }

        @Override
        public void setSelectedIndex(int index) {
            this.component.setSelectedIndex(index);
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public JComponent getContainerComponent() {
            return this.containerComp;
        }

        @Override
        public List getSelectedItems() {
            this.comboModel = this.component.getModel();
            ArrayList<Object> selectedItems = new ArrayList<Object>();
            if (this.comboModel != null && this.comboModel.getSize() > 0 && this.component.getSelectedIndex() >= 0) {
                selectedItems.add(this.component.getSelectedItem());
            }
            return selectedItems;
        }

        @Override
        public List getAllItems() {
            this.comboModel = this.component.getModel();
            ArrayList allItems = new ArrayList();
            for (int i = 0; i < this.getCount(); ++i) {
                Object o = this.comboModel.getElementAt(i);
                if (ValueProviderDualSelectorAdapter.this.isMoreValue(o) || ValueProviderDualSelectorAdapter.this.isSeperatorValue(o) || ValueProviderDualSelectorAdapter.this.isMoreValue(o) || ValueProviderDualSelectorAdapter.this.isAllValue(o) || ValueProviderDualSelectorAdapter.this.isOtherValue(o)) continue;
                allItems.add(o);
            }
            return allItems;
        }

        @Override
        public List getAllMoveableItems() {
            return this.getAllItems();
        }

        @Override
        public void addItems(List newItems) {
            this.comboModel = this.component.getModel();
            if (this.comboModel instanceof DefaultComboBoxModel) {
                for (int i = 0; i < newItems.size(); ++i) {
                    ((DefaultComboBoxModel)this.comboModel).addElement(newItems.get(i));
                }
            } else {
                ((CollectionToComboBoxModelAdapter)this.comboModel).getModel().addAll(newItems);
                ((CollectionToComboBoxModelAdapter)this.comboModel).refresh();
            }
        }

        @Override
        public void removeItems(List removeItems) {
            this.comboModel = this.component.getModel();
            int size = removeItems.size();
            if (this.comboModel instanceof DefaultComboBoxModel) {
                if (size == this.comboModel.getSize()) {
                    ((DefaultComboBoxModel)this.comboModel).removeAllElements();
                } else {
                    for (int i = 0; i < removeItems.size(); ++i) {
                        ((DefaultComboBoxModel)this.comboModel).removeElementAt(((DefaultComboBoxModel)this.comboModel).getIndexOf(removeItems.get(i)));
                    }
                }
            } else {
                if (size == this.comboModel.getSize()) {
                    ((CollectionToComboBoxModelAdapter)this.comboModel).getModel().clear();
                } else {
                    ((CollectionToComboBoxModelAdapter)this.comboModel).getModel().removeAll(removeItems);
                }
                ((CollectionToComboBoxModelAdapter)this.comboModel).refresh();
            }
        }

        @Override
        public boolean isInAdapter(Object item) {
            this.comboModel = this.component.getModel();
            boolean value = false;
            if (this.comboModel instanceof DefaultComboBoxModel) {
                value = ((DefaultComboBoxModel)this.comboModel).getIndexOf(item) != -1;
            } else if (this.comboModel instanceof CollectionToComboBoxModelAdapter && ((CollectionToComboBoxModelAdapter)this.comboModel).getModel() instanceof Collection) {
                value = ((CollectionToComboBoxModelAdapter)this.comboModel).getModel().contains(item);
            }
            return value;
        }

        public void setParentSelector(JComponent parentSelector) {
            this.parentSelector = parentSelector;
        }

        @Override
        public int[] getSelectedIndices() {
            int index = this.component.getSelectedIndex();
            if (index != -1) {
                return new int[]{index};
            }
            return new int[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveItems(int[] selectedIndices, int offset) {
            int i;
            List dataToMove = new ArrayList();
            this.comboModel = this.component.getModel();
            try {
                if (this.comboModel instanceof CollectionToComboBoxModelAdapter) {
                    if (((CollectionToComboBoxModelAdapter)this.comboModel).getModel() instanceof Collection) {
                        dataToMove = (List)((CollectionToComboBoxModelAdapter)this.comboModel).getModel();
                    }
                } else {
                    int size = this.comboModel.getSize();
                    for (i = 0; i < size; ++i) {
                        dataToMove.add(this.comboModel.getElementAt(i));
                    }
                }
                if (dataToMove != null) {
                    if (selectedIndices.length == 1) {
                        JavaCollectionPermuter.move(dataToMove, (int)selectedIndices[0], (int)offset);
                    } else {
                        JavaCollectionPermuter.move(dataToMove, (int[])selectedIndices, (int)offset);
                    }
                    i = 0;
                    while (i < selectedIndices.length) {
                        int n = i++;
                        selectedIndices[n] = selectedIndices[n] + offset;
                    }
                    if (selectedIndices.length > 0) {
                        this.component.setSelectedIndex(selectedIndices[0]);
                    }
                }
            }
            catch (IllegalArgumentException i2) {
            }
            finally {
                if (this.comboModel instanceof MutableComboBoxModel) {
                    for (i = 0; i < dataToMove.size(); ++i) {
                        ((MutableComboBoxModel)this.comboModel).insertElementAt(dataToMove.get(i), i);
                        ((MutableComboBoxModel)this.comboModel).removeElementAt(i + 1);
                    }
                } else if (this.comboModel instanceof CollectionToComboBoxModelAdapter && ((CollectionToComboBoxModelAdapter)this.comboModel).getModel() instanceof Collection) {
                    ((CollectionToComboBoxModelAdapter)this.comboModel).setModel(dataToMove);
                }
            }
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return this.component.getSelectedIndex() == index;
        }

        @Override
        public boolean canMove(int[] indices, int offset) {
            boolean returnValue = false;
            if (offset == -1 && !this.isSelectedIndex(0)) {
                returnValue = true;
            }
            if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
                returnValue = true;
            }
            return returnValue;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
                event.acceptDrag(2);
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (this.parentSelector != null && ((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
                if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                    event.rejectDrop();
                } else {
                    Transferable transferable = event.getTransferable();
                    if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                        event.acceptDrop(2);
                        if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                            ((BaseDualSelector)this.parentSelector).transferTargetItems();
                        } else {
                            ((BaseDualSelector)this.parentSelector).transferSourceItems();
                        }
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (this.parentSelector != null) {
                List selected;
                ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
                if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
                    DNDObject items = new DNDObject();
                    for (int i = 0; i < selected.size(); ++i) {
                        items.add(selected.get(i));
                    }
                    this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
                }
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                // empty if block
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }
    }

    @SASScope
    private class EditorDualSelectorAdapter
    implements DualSelectorInterface,
    DualSelectorUpDownInterface,
    DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        protected EditorInterface editor;
        protected JPanel containerComp;
        protected JComponent parentSelector;
        public DropTarget dropTarget = null;
        public DragSource dragSource = null;

        public EditorDualSelectorAdapter(EditorInterface editor, JComponent parent) {
            this.editor = editor;
            this.parentSelector = parent;
            this.containerComp = new JPanel();
            this.containerComp.setOpaque(false);
            AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 0, 0, true, false, true);
            this.containerComp.setLayout(layout);
            this.containerComp.add(editor.getEditorComponent());
            if (this.parentSelector != null) {
                if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
                    this.dropTarget = new DropTarget(editor.getEditorComponent(), this);
                    this.dragSource = DragSource.getDefaultDragSource();
                    this.dragSource.createDefaultDragGestureRecognizer(editor.getEditorComponent(), 3, this);
                } else {
                    ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
                }
            }
        }

        public EditorInterface getEditor() {
            return this.editor;
        }

        @Override
        public void clearSelections() {
            this.editor.setValue(null);
        }

        @Override
        public int getCount() {
            return 1;
        }

        @Override
        public int getSelectedCount() {
            if (this.editor.getValue() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public int getLastSelectedIndex() {
            return -1;
        }

        @Override
        public void setSelectedIndex(int index) {
        }

        @Override
        public JComponent getComponent() {
            return (JComponent)this.editor.getEditorComponent();
        }

        @Override
        public JComponent getContainerComponent() {
            return this.containerComp;
        }

        @Override
        public List getSelectedItems() {
            Object val = this.editor.getValue();
            if (val != null) {
                ArrayList<Object> selectedItems = new ArrayList<Object>();
                selectedItems.add(val);
                return selectedItems;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getAllItems() {
            ArrayList<Object> allItems = new ArrayList<Object>();
            allItems.add(this.editor.getValue());
            return allItems;
        }

        @Override
        public List getAllMoveableItems() {
            return this.getAllItems();
        }

        @Override
        public void addItems(List newItems) {
        }

        @Override
        public void removeItems(List removeItems) {
        }

        @Override
        public boolean isInAdapter(Object item) {
            return Util.equal((Object)item, (Object)this.editor.getValue());
        }

        public void setParentSelector(JComponent parentSelector) {
            this.parentSelector = parentSelector;
        }

        @Override
        public int[] getSelectedIndices() {
            return new int[0];
        }

        @Override
        public void moveItems(int[] selectedIndices, int offset) {
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return false;
        }

        @Override
        public boolean canMove(int[] indices, int offset) {
            boolean returnValue = false;
            if (offset == -1 && !this.isSelectedIndex(0)) {
                returnValue = true;
            }
            if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
                returnValue = true;
            }
            return returnValue;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
                event.acceptDrag(2);
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
                if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                    event.rejectDrop();
                } else {
                    Transferable transferable = event.getTransferable();
                    if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                        event.acceptDrop(2);
                        if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                            ((BaseDualSelector)this.parentSelector).transferTargetItems();
                        } else {
                            ((BaseDualSelector)this.parentSelector).transferSourceItems();
                        }
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            List selected;
            ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
            if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
                DNDObject items = new DNDObject();
                for (int i = 0; i < selected.size(); ++i) {
                    items.add(selected.get(i));
                }
                this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                // empty if block
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }
    }

    @SASScope
    private class ValueProviderTableDualSelectorAdapter
    extends TableDualSelectorAdapter {
        public ValueProviderTableDualSelectorAdapter(TableView table, JComponent parent) {
            super(table, parent);
        }

        public ValueProviderTableDualSelectorAdapter(JComponent parent) {
            super(parent);
        }

        @Override
        protected Object getValueAt(int row, int column) {
            TableModel tm = this.component.getModel();
            if (tm instanceof ValueProviderModelAdapter.ValueProviderToTableModelAdapter) {
                return ((ValueProviderModelAdapter.ValueProviderToTableModelAdapter)tm).getValueAt(row, column, false);
            }
            return super.getValueAt(row, column);
        }

        @Override
        public int getSelectedCount() {
            return this.getSelectedIndices().length;
        }

        @Override
        public int[] getSelectedIndices() {
            int[] selected = this.component.getSelectedRows();
            try {
                List seperatorIndicies = null;
                seperatorIndicies = ValueProviderDualSelectorAdapter.this.model.getModel() instanceof ValueProviderModelAdapter.ValueProviderToTableModelAdapter ? ((ValueProviderModelAdapter.ValueProviderToTableModelAdapter)ValueProviderDualSelectorAdapter.this.model.getModel()).getSeparatorRowIndices() : Collections.EMPTY_LIST;
                if (!seperatorIndicies.isEmpty()) {
                    int cnt = 0;
                    for (int i = 0; i < selected.length; ++i) {
                        if (!seperatorIndicies.contains(new Integer(selected[i]))) continue;
                        selected[i] = -1;
                        ++cnt;
                    }
                    if (cnt > 0) {
                        int[] selectedIndices = new int[selected.length - cnt];
                        int t = 0;
                        for (int j = 0; j < selected.length; ++j) {
                            if (selected[j] == -1) continue;
                            selectedIndices[t++] = selected[j];
                        }
                        selected = selectedIndices;
                    }
                }
            }
            catch (ValueProviderException valueProviderException) {
                // empty catch block
            }
            return selected;
        }

        @Override
        public List getSelectedItems() {
            ArrayList selectedItems = new ArrayList();
            int[] selectedRows = this.component.getSelectedRows();
            int count = selectedRows.length;
            TableModel tableModel = this.component.getModel();
            if (count > 0 && tableModel != null && tableModel.getRowCount() > 0) {
                int columnCount = tableModel.getColumnCount();
                int minSelectionIndex = this.lsm.getMinSelectionIndex();
                int maxSelectionIndex = this.lsm.getMaxSelectionIndex();
                for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
                    if (!this.component.isRowSelected(i)) continue;
                    Vector<Object> rowVector = new Vector<Object>();
                    for (int j = 0; j < columnCount; ++j) {
                        Object value = this.getValueAt(i, j);
                        if (value == ValueProviderDualSelectorAdapter.this.model.getSeperatorValue()) {
                            rowVector.clear();
                            break;
                        }
                        rowVector.add(value);
                    }
                    if (rowVector.size() <= 0) continue;
                    selectedItems.add(rowVector);
                }
            }
            return selectedItems;
        }

        @Override
        public int getCount() {
            int count = super.getCount();
            if (count == 1 && this.component.getValueAt(0, ValueProviderDualSelectorAdapter.this.getLabelColumn()) == ValueProviderDualSelectorAdapter.this.model.getNoResultsFoundValue()) {
                return 0;
            }
            return count;
        }

        @Override
        public List getAllItems() {
            return this.getAllItems(true);
        }

        private List getAllItems(boolean includeSpecials) {
            ArrayList items = new ArrayList();
            TableModel tableModel = this.component.getModel();
            if (tableModel != null) {
                int rowCount = tableModel.getRowCount();
                int labelCol = ValueProviderDualSelectorAdapter.this.getLabelColumn();
                if (rowCount > 0) {
                    int columnCount = tableModel.getColumnCount();
                    for (int i = 0; i < rowCount; ++i) {
                        Vector<Object> rowVector = new Vector<Object>();
                        boolean add = true;
                        for (int j = 0; j < columnCount; ++j) {
                            Object o = null;
                            o = tableModel instanceof ValueProviderModelAdapter.ValueProviderToTableModelAdapter ? ((ValueProviderModelAdapter.ValueProviderToTableModelAdapter)tableModel).getValueAt(i, j, false) : tableModel.getValueAt(i, j);
                            if (j == labelCol) {
                                if (ValueProviderDualSelectorAdapter.this.isSeperatorValue(o) || ValueProviderDualSelectorAdapter.this.isMoreValue(o) || ValueProviderDualSelectorAdapter.this.isNoResultsFoundValue(o)) {
                                    add = false;
                                    break;
                                }
                                if (!includeSpecials && (ValueProviderDualSelectorAdapter.this.isAllValue(o) || ValueProviderDualSelectorAdapter.this.isOtherValue(o))) {
                                    add = false;
                                    break;
                                }
                            }
                            rowVector.add(j, o);
                        }
                        if (!add) continue;
                        items.add(rowVector);
                    }
                }
            }
            return items;
        }

        @Override
        public List getAllMoveableItems() {
            return this.getAllItems(false);
        }
    }
}

