/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.JListDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.RB;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeListSelector
extends BaseDualSelector
implements TreeSelectionListener,
ListSelectionListener,
ViewDefaultModel {
    private boolean clearSelection;
    private boolean moveParentsOrChildren;
    private boolean parentNodesMoveable;
    private static final String RB_KEY = "TreeListSelector.";
    private String rootTreeNodeName = RB.getStringResource("TreeListSelector.", "rootNodeName.txt");
    private transient TreeModel sourceTreeModel;
    private transient ListModel targetListModel;
    protected JTree sourceJTree;
    protected JList targetJList;
    protected DefaultMutableTreeNode rootNode;

    public TreeListSelector() {
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new JTreeDualSelectorAdapter(this);
        this.targetAdapter = new JListDualSelectorAdapter(this);
        this.sourceJTree = (JTree)this.sourceAdapter.getComponent();
        this.targetJList = (JList)this.targetAdapter.getComponent();
        this.setParentNodesMoveable(false);
        this.initializeBaseDualSelector();
        this.sourceJTree.addMouseListener(this.sourceMouseListener);
        this.targetJList.addMouseListener(this.targetMouseListener);
        if (this.getModel() == null) {
            this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
            this.setModel(new DefaultTreeModel(this.rootNode));
        }
        if (this.getTargetModel() == null) {
            this.setTargetModel(new DefaultListModel());
        }
        this.sourceAdapter.setSelectedIndex(1);
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.sourceJTree.removeTreeSelectionListener(this);
        this.sourceJTree.addTreeSelectionListener(this);
        this.targetJList.removeListSelectionListener(this);
        this.targetJList.addListSelectionListener(this);
    }

    public TreeCellRenderer getSourceCellRenderer() {
        return this.sourceJTree.getCellRenderer();
    }

    public void setSourceCellRenderer(TreeCellRenderer newValue) {
        TreeCellRenderer oldValue = this.sourceJTree.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.sourceJTree.setCellRenderer(newValue);
        this.firePropertyChange("SourceTreeCellRenderer", oldValue, newValue);
    }

    public ListCellRenderer getTargetCellRenderer() {
        return this.targetJList.getCellRenderer();
    }

    public void setTargetCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.targetJList.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.targetJList.setCellRenderer(newValue);
        this.firePropertyChange("targetListCellRenderer", oldValue, newValue);
    }

    public void setSourceRootVisible(boolean visible) {
        this.sourceJTree.setRootVisible(visible);
        if (!visible) {
            this.sourceJTree.setShowsRootHandles(true);
        }
    }

    public boolean isSourceRootVisible() {
        return this.sourceJTree.isRootVisible();
    }

    public void setParentNodesMoveable(boolean moveable) {
        this.parentNodesMoveable = moveable;
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesMoveable(moveable);
    }

    public boolean isParentNodesMoveable() {
        return this.parentNodesMoveable;
    }

    public void setParentOrChildrenMoveable(boolean nodes) {
        this.moveParentsOrChildren = nodes;
        if (this.moveParentsOrChildren) {
            ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesOnlyMoveable(true);
        } else {
            ((JTreeDualSelectorAdapter)this.sourceAdapter).setChildNodesOnlyMoveable(true);
        }
    }

    public boolean isParentsOrChildrenMoveable() {
        return this.moveParentsOrChildren;
    }

    public TreeModel getModel() {
        return this.sourceTreeModel;
    }

    public ListModel getTargetModel() {
        return this.targetListModel;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel oldModel = this.sourceTreeModel;
        if (treeModel != null) {
            this.sourceTreeModel = treeModel;
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        } else {
            this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
            this.sourceTreeModel = new DefaultTreeModel(this.rootNode);
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        }
        if (this.sourceJTree.getRowCount() > 0) {
            this.sourceJTree.removeTreeSelectionListener(this);
            this.sourceJTree.setSelectionRow(0);
            this.sourceJTree.addTreeSelectionListener(this);
        }
        if (!(this.sourceTreeModel instanceof DefaultTreeModel)) {
            this.setCopyModeEnabled(true);
        }
        this.firePropertyChange("model", oldModel, this.sourceTreeModel);
    }

    public void setTargetModel(ListModel listModel) throws IllegalArgumentException {
        ListModel oldModel;
        if (listModel instanceof DefaultListModel || listModel instanceof CollectionToListModelAdapter) {
            oldModel = this.targetListModel;
            if (listModel != null) {
                this.targetListModel = listModel;
            }
            if (this.targetJList != null) {
                this.targetJList.setModel(this.targetListModel);
            } else {
                this.targetListModel = new DefaultListModel();
                if (this.targetJList != null) {
                    this.targetJList.setModel(this.targetListModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetListModel", oldModel, this.targetListModel);
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultTreeModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent ie) {
        Object source = ie.getSource();
        this.direction = ie.getNewLeadSelectionPath() == null || source != this.sourceJTree;
        if (ie.getNewLeadSelectionPath() != null && source == this.sourceJTree) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.targetJList.getSelectionModel().clearSelection();
                this.direction = false;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ie) {
        this.direction = ie.getFirstIndex() >= 0;
        Object source = ie.getSource();
        if (!this.clearSelection && ie.getFirstIndex() >= 0 && source == this.targetJList) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.sourceJTree.getSelectionModel().clearSelection();
                this.direction = true;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }
}

