/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.dualselector.DualSelectorV2Interface;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.DNDObject;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope
public class TableDualSelectorAdapter
implements DualSelectorV2Interface,
DualSelectorUpDownInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private TableModel tableModel;
    protected TableView component;
    protected JScrollPane containerComponent;
    protected JComponent parentSelector;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;
    protected ListSelectionModel lsm;

    public TableDualSelectorAdapter(JComponent parent) {
        this(new TableView(), parent);
        this.component.getEditController().setEditEnabled(false);
        this.component.setRowHeaderVisible(false);
        this.component.setPopupMenuEnabled(false);
    }

    public TableDualSelectorAdapter(TableView table, JComponent parent) {
        this.component = table;
        this.parentSelector = parent;
        this.containerComponent = new JScrollPane(table);
        this.containerComponent.setHorizontalScrollBarPolicy(30);
        this.lsm = this.component.getRowModel().getSelectionModel();
        if (this.parentSelector != null) {
            if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
                DropTarget dropTarget = new DropTarget(this.component, this);
                this.dragSource = new DragSource();
                this.dragSource.createDefaultDragGestureRecognizer(this.component, 3, this);
            } else {
                ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
            }
        }
    }

    public void setParentSelector(JComponent parent) {
        this.parentSelector = parent;
    }

    @Override
    public void clearSelections() {
        this.lsm.clearSelection();
    }

    @Override
    public int getCount() {
        return this.component.getModel().getRowCount();
    }

    @Override
    public int getSelectedCount() {
        return this.component.getSelectedRowCount();
    }

    @Override
    public int getLastSelectedIndex() {
        return this.lsm.getMaxSelectionIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.getCount() > 0) {
            this.component.setRowSelectionInterval(index, index);
        } else if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
            ((BaseDualSelector)this.parentSelector).targetAdapter.clearSelections();
        } else {
            ((BaseDualSelector)this.parentSelector).sourceAdapter.clearSelections();
        }
    }

    @Override
    public void setSelectedValues(List values) {
        this.tableModel = this.component.getModel();
        if (this.tableModel == null || values == null) {
            return;
        }
        int rowCount = this.tableModel.getRowCount();
        int valuesSize = values.size();
        Vector<Integer> selectedList = new Vector<Integer>();
        int columnCount = this.tableModel.getColumnCount();
        boolean found = false;
        block0: for (int i = 0; i < valuesSize; ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            for (int j = rowCount - 1; j >= 0; --j) {
                found = true;
                for (int k = 0; k < columnCount; ++k) {
                    if (((Vector)value).get(k).equals(this.getValueAt(j, k))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                selectedList.add(new Integer(j));
                continue block0;
            }
        }
        int selectedListSize = selectedList.size();
        if (selectedListSize > 0) {
            int[] selectedIndices = new int[selectedListSize];
            for (int ii = 0; ii < selectedListSize; ++ii) {
                selectedIndices[ii] = (Integer)selectedList.get(ii);
            }
            this.setSelectedIndices(selectedIndices);
        }
    }

    protected Object getValueAt(int row, int column) {
        TableModel tm = this.component.getModel();
        if (tm == null) {
            return null;
        }
        return tm.getValueAt(row, column);
    }

    public void setSelectedIndices(int[] indices) {
        if (indices == null) {
            return;
        }
        if (this.getCount() > 0) {
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] != -1) {
                    this.component.addRowSelectionInterval(indices[i], indices[i]);
                    continue;
                }
                if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                    ((BaseDualSelector)this.parentSelector).targetAdapter.clearSelections();
                    continue;
                }
                ((BaseDualSelector)this.parentSelector).sourceAdapter.clearSelections();
            }
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public JComponent getContainerComponent() {
        return this.containerComponent;
    }

    @Override
    public List getSelectedItems() {
        ArrayList selectedItems = new ArrayList();
        int count = this.component.getSelectedRows().length;
        TableModel tableModel = this.component.getModel();
        if (count > 0 && tableModel != null && tableModel.getRowCount() > 0) {
            int columnCount = tableModel.getColumnCount();
            int minSelectionIndex = this.lsm.getMinSelectionIndex();
            int maxSelectionIndex = this.lsm.getMaxSelectionIndex();
            for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
                if (!this.component.isRowSelected(i)) continue;
                Vector<Object> rowVector = new Vector<Object>();
                for (int j = 0; j < columnCount; ++j) {
                    rowVector.add(j, this.getValueAt(i, j));
                }
                selectedItems.add(rowVector);
            }
        }
        return selectedItems;
    }

    @Override
    public List getAllItems() {
        int rowCount;
        ArrayList items = new ArrayList();
        TableModel tableModel = this.component.getModel();
        if (tableModel != null && (rowCount = tableModel.getRowCount()) > 0) {
            int columnCount = tableModel.getColumnCount();
            for (int i = 0; i < rowCount; ++i) {
                Vector<Object> rowVector = new Vector<Object>();
                for (int j = 0; j < columnCount; ++j) {
                    rowVector.add(j, this.getValueAt(i, j));
                }
                items.add(rowVector);
            }
        }
        return items;
    }

    @Override
    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    @Override
    public void addItems(List newItems) {
        TableModel tableModel = this.component.getModel();
        if (tableModel != null && tableModel instanceof DefaultTableModel) {
            for (int i = 0; i < newItems.size(); ++i) {
                Object o = newItems.get(i);
                if (o instanceof Object[]) {
                    ((DefaultTableModel)tableModel).addRow((Object[])o);
                    continue;
                }
                if (!(o instanceof Vector)) continue;
                ((DefaultTableModel)tableModel).addRow((Vector)o);
            }
        }
    }

    @Override
    public void removeItems(List removeItems) {
        TableModel tableModel = this.component.getModel();
        if (tableModel != null && tableModel instanceof DefaultTableModel) {
            int listSize = removeItems.size();
            if (listSize == tableModel.getRowCount()) {
                ((DefaultTableModel)tableModel).setRowCount(0);
            } else {
                for (int i = 0; i < listSize; ++i) {
                    List totalItems = this.getAllItems();
                    int index = totalItems.indexOf(removeItems.get(i));
                    if (index < 0) continue;
                    ((DefaultTableModel)tableModel).removeRow(index);
                }
            }
        }
    }

    @Override
    public boolean isInAdapter(Object item) {
        List allItems = this.getAllItems();
        return allItems.contains(item);
    }

    @Override
    public int[] getSelectedIndices() {
        return this.component.getSelectedRows();
    }

    @Override
    public void moveItems(int[] selectedIndices, int offset) {
        block4: {
            TableModel tableModel = this.component.getModel();
            if (tableModel == null || !(tableModel instanceof DefaultTableModel) || !this.canMove(selectedIndices, offset)) break block4;
            int selectedIndicesLength = selectedIndices.length;
            this.lsm.clearSelection();
            if (offset == -1) {
                for (int i = 0; i < selectedIndicesLength; ++i) {
                    int index = selectedIndices[i];
                    ((DefaultTableModel)tableModel).moveRow(index, index, index + offset);
                    this.lsm.addSelectionInterval(index + offset, index + offset);
                }
            } else {
                for (int j = selectedIndicesLength - 1; j >= 0; --j) {
                    int index = selectedIndices[j];
                    ((DefaultTableModel)tableModel).moveRow(index, index, index + offset);
                    this.lsm.addSelectionInterval(index + offset, index + offset);
                }
            }
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.lsm.isSelectedIndex(index);
    }

    @Override
    public boolean canMove(int[] indices, int offset) {
        boolean returnValue = false;
        if (offset == -1 && !this.isSelectedIndex(0)) {
            returnValue = true;
        }
        if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                event.rejectDrop();
            } else {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    event.acceptDrop(2);
                    if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                        ((BaseDualSelector)this.parentSelector).transferTargetItems();
                    } else {
                        ((BaseDualSelector)this.parentSelector).transferSourceItems();
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        List selected;
        ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
            DNDObject items = new DNDObject();
            for (int i = 0; i < selected.size(); ++i) {
                items.add(selected.get(i));
            }
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

