/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.swing.models.MapToTableModelAdapter;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.TableDualSelectorAdapter;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Dimension;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope
public class DualTableSelector
extends BaseDualSelector
implements ListSelectionListener,
ViewDefaultModel {
    private transient TableModel sourceTableModel;
    private transient TableModel targetTableModel;
    private boolean clearSelection;
    protected ListSelectionModel sourceSM;
    protected ListSelectionModel targetSM;
    protected TableView sourceTable;
    protected TableView targetTable;
    private static final String RB_KEY = "DualTableSelector.";

    public DualTableSelector() {
        this(null, null);
    }

    public DualTableSelector(TableView sourceTableNew, TableView targetTableNew) {
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = sourceTableNew == null ? new TableDualSelectorAdapter(this) : new TableDualSelectorAdapter(sourceTableNew, this);
        this.targetAdapter = targetTableNew == null ? new TableDualSelectorAdapter(this) : new TableDualSelectorAdapter(targetTableNew, this);
        this.sourceTable = (TableView)this.sourceAdapter.getComponent();
        this.targetTable = (TableView)this.targetAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.sourceTable.addMouseListener(this.sourceMouseListener);
        this.targetTable.addMouseListener(this.targetMouseListener);
        if (sourceTableNew != null && sourceTableNew.getModel() != null) {
            this.setModel(sourceTableNew.getModel());
        } else if (this.getModel() == null) {
            this.sourceTableModel = new DefaultTableModel();
            this.setModel(this.sourceTableModel);
        }
        if (targetTableNew != null && targetTableNew.getModel() != null) {
            this.setTargetModel(targetTableNew.getModel());
        } else if (this.getTargetModel() == null && targetTableNew == null) {
            this.setDefaultTargetModel(new DefaultTableModel());
        }
        this.sourceSM = this.sourceTable.getRowModel().getSelectionModel();
        this.targetSM = this.targetTable.getRowModel().getSelectionModel();
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
        this.sourceTable.setRowSelectionAllowed(true);
        this.sourceTable.setColumnSelectionAllowed(false);
        this.sourceTable.setCellSelectionEnabled(false);
        this.targetTable.setRowSelectionAllowed(true);
        this.targetTable.setColumnSelectionAllowed(false);
        this.targetTable.setCellSelectionEnabled(false);
        if (sourceTableNew != null && sourceTableNew.getModel() != null) {
            this.setModel(sourceTableNew.getModel());
        }
        if (targetTableNew != null && targetTableNew.getModel() != null) {
            this.setTargetModel(targetTableNew.getModel());
        }
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.sourceSM.removeListSelectionListener(this);
        this.sourceSM.addListSelectionListener(this);
        this.targetSM.removeListSelectionListener(this);
        this.targetSM.addListSelectionListener(this);
    }

    public TableModel getModel() {
        return this.sourceTableModel;
    }

    public void setModel(TableModel tableModel) {
        TableModel oldModel = this.sourceTableModel;
        if (tableModel != null) {
            this.sourceTableModel = tableModel;
            if (this.sourceTable != null) {
                this.sourceTable.setModel(this.sourceTableModel);
            }
        } else {
            this.sourceTableModel = new DefaultTableModel();
            if (this.sourceTable != null) {
                this.sourceTable.setModel(this.sourceTableModel);
            }
        }
        if (!(this.sourceTableModel instanceof DefaultTableModel) && !(this.sourceTableModel instanceof MapToTableModelAdapter)) {
            this.setCopyModeEnabled(true);
        }
        if (this.targetTableModel != null && this.targetTableModel.getColumnCount() == 0 && this.targetTableModel instanceof DefaultTableModel) {
            int columnCount = this.sourceTableModel.getColumnCount();
            ((DefaultTableModel)this.targetTableModel).setColumnCount(columnCount);
            Object[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = this.sourceTable.getColumnName(i);
            }
            ((DefaultTableModel)this.targetTableModel).setColumnIdentifiers(columnNames);
            ((ColumnHeader)this.targetTable.getTableHeader()).sizeColumnsToFit();
        }
        this.firePropertyChange("sourceTableModel", oldModel, this.sourceTableModel);
        this.ensureButtonsEnabled();
    }

    @Override
    protected void initializeSize() {
        this.setPreferredSize(new Dimension(475, 250));
    }

    public TableModel getTargetModel() {
        return this.targetTableModel;
    }

    public void setDefaultTargetModel(DefaultTableModel tableModel) {
        if (tableModel != null) {
            this.targetTableModel = tableModel;
            this.targetTable.setModel(this.targetTableModel);
            this.firePropertyChange("targetTableModel", null, this.targetTableModel);
        }
    }

    public void setTargetModel(TableModel tableModel) throws IllegalArgumentException {
        if (tableModel instanceof DefaultTableModel || tableModel instanceof MapToTableModelAdapter) {
            TableModel oldModel = this.targetTableModel;
            if (tableModel != null) {
                this.targetTableModel = tableModel;
            }
            if (this.targetTable != null) {
                this.targetTable.setModel(this.targetTableModel);
            } else {
                this.targetTableModel = new DefaultTableModel();
                if (this.targetTable != null) {
                    this.targetTable.setModel(this.targetTableModel);
                }
            }
            ((ColumnHeader)this.targetTable.getTableHeader()).sizeColumnsToFit();
            this.firePropertyChange("targetTableModel", oldModel, this.targetTableModel);
        } else if (tableModel != null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultTableModel && this.getModel().getRowCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent ie) {
        Object source = ie.getSource();
        this.direction = source != this.sourceSM || this.sourceTableModel.getRowCount() <= 0;
        if (!this.clearSelection) {
            if (source == this.sourceSM && this.sourceTableModel.getRowCount() > 0) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.targetTable.getRowModel().getSelectionModel().clearSelection();
                    this.direction = false;
                }
                finally {
                    this.clearSelection = false;
                }
            }
            if (source == this.targetSM) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.sourceTable.getRowModel().getSelectionModel().clearSelection();
                    this.direction = true;
                }
                finally {
                    this.clearSelection = false;
                }
            }
        }
    }
}

