/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

@SASScope(value="ALL")
public class RadioButtonEditorPanel
extends JPanel
implements EditorPanelInterface {
    public static final String RB_KEY = "RadioButtonEditorPanel.";
    public static final String TRUE_VALUE = RB.getStringResource("RadioButtonEditorPanel.", "true.txt");
    public static final String FALSE_VALUE = RB.getStringResource("RadioButtonEditorPanel.", "false.txt");
    protected JRadioButton falseButton;
    protected JRadioButton trueButton;

    public RadioButtonEditorPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, true);
        this.setLayout(layout);
        this.add(this.makePanel());
    }

    protected JPanel makePanel() {
        JPanel radioButtonPanel = new JPanel();
        AutoSizingGridLayout radioButtonLayput = new AutoSizingGridLayout(2, 1, 5, 10, true, false, true);
        radioButtonPanel.setLayout(radioButtonLayput);
        JPanel radioButtonInnerPanel = new JPanel();
        AutoSizingGridLayout radioButtonInnerLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        radioButtonInnerPanel.setLayout(radioButtonInnerLayout);
        this.trueButton = new JRadioButton(TRUE_VALUE);
        this.trueButton.getAccessibleContext().setAccessibleName("trueButton");
        radioButtonInnerPanel.add(this.trueButton);
        this.falseButton = new JRadioButton(FALSE_VALUE);
        this.falseButton.getAccessibleContext().setAccessibleName("falseButton");
        radioButtonInnerPanel.add(this.falseButton);
        JLabel singleLabel = Util.createLabelForComponent(this.trueButton, RB.getStringResource("value.txt"));
        radioButtonPanel.add(singleLabel);
        radioButtonPanel.add(radioButtonInnerPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.trueButton);
        group.add(this.falseButton);
        return radioButtonPanel;
    }

    @Override
    public void setModel(EntityAttributeValueModelInterface selectorAdapter, String propertyName) {
        List list = selectorAdapter.getAvailableValues(propertyName);
        int listSize = list.size();
        if (listSize > 0) {
            for (int i = 0; i < listSize; ++i) {
                Object listValue = list.get(i);
                if (!(listValue instanceof PropertyValueInterface)) continue;
                PropertyValueInterface dvi = (PropertyValueInterface)listValue;
                String formattedValue = dvi.getFormattedValue();
                Object unFormattedValue = dvi.getUnformattedValue();
                if (unFormattedValue == null) continue;
                if (unFormattedValue.toString().equals(TRUE_VALUE)) {
                    this.trueButton.setText(formattedValue);
                    continue;
                }
                this.falseButton.setText(formattedValue);
            }
        } else {
            this.trueButton.setText(TRUE_VALUE);
            this.falseButton.setText(FALSE_VALUE);
        }
        Object currentValue = selectorAdapter.getSelectedValues(propertyName).get(0);
        Object currentUnformattedValue = ((PropertyValueInterface)currentValue).getUnformattedValue();
        if (currentUnformattedValue == null) {
            this.falseButton.setSelected(true);
        } else if (currentUnformattedValue.toString().equals(TRUE_VALUE)) {
            this.trueButton.setSelected(true);
        } else {
            this.falseButton.setSelected(true);
        }
    }

    @Override
    public Object getValue() {
        return this.trueButton.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }
}

