/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.DateEditorPanel;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EmptyComponent;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueTableModelAdapter;
import com.sas.swing.visuals.dataselectors.propertyeditor.MultiSelectionListEditorPanel;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.swing.visuals.dataselectors.propertyeditor.RadioButtonEditorPanel;
import com.sas.swing.visuals.dataselectors.propertyeditor.SingleSelectionListEditorPanel;
import com.sas.swing.visuals.dataselectors.propertyeditor.TextFieldEditorPanel;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;

@SASScope(value="ALL")
public class EntityAttributeValuePanel
extends JComponent
implements PanelInterface {
    public static final String RB_KEY = "EntityAttributeValuePanel.";
    private static final String EMPTY_CARD = "Empty";
    private static final String TEXTFIELD_CARD = "TextField";
    private static final String SINGLE_LIST_CARD = "SingleSelectionList";
    private static final String MULTI_LIST_CARD = "MultipleSelectionList";
    private static final String RADIO_BUTTON_CARD = "RadioButton";
    private static final String DATE_PANEL_CARD = "DatePanel";
    private static final String REQUIRED_DATE_PANEL_CARD = "RequiredDatePanel";
    private static final String TIME_PANEL_CARD = "TimePanel";
    private static final String REQUIRED_TIME_PANEL_CARD = "RequiredTimePanel";
    private static final String TIMESTAMP_PANEL_CARD = "TimestampPanel";
    private static final String REQUIRED_TIMESTAMP_PANEL_CARD = "RequiredTimestampPanel";
    private String dialogTitle;
    private String tabTitle;
    private JLabel selectionLabel;
    protected TableView tableView;
    protected EntityAttributeValueTableModelAdapter tableModel;
    protected EntityAttributeValueModelInterface selectorAdapter;
    protected CardLayout cardLayout;
    protected JPanel emptyContainer;
    protected JPanel cardContainer;
    protected TextFieldEditorPanel textFieldContainer;
    protected SingleSelectionListEditorPanel singleListContainer;
    protected MultiSelectionListEditorPanel multiListContainer;
    protected RadioButtonEditorPanel radioButtonContainer;
    protected DateEditorPanel datePanelContainer;
    protected DateEditorPanel requiredDatePanelContainer;
    protected DateEditorPanel requiredTimePanelContainer;
    protected DateEditorPanel timePanelContainer;
    protected DateEditorPanel requiredTimestampPanelContainer;
    protected DateEditorPanel timestampPanelContainer;
    protected int previousRow;
    protected JTextField valueField;
    protected EditorPanelInterface previousPanel;
    protected ListSelectionModel rowSM;
    protected Map editorMap;
    protected Map initialValues;
    protected Container promptIdentifierContainer;
    private boolean firstSelection;
    protected JScrollPane tablePane;

    public EntityAttributeValuePanel(EntityAttributeValueModelInterface selectorAdapter) {
        this.selectorAdapter = selectorAdapter;
        this.initialValues = new HashMap();
        this.initialize();
    }

    protected void initialize() {
        if (this.tableView == null) {
            this.tableView = new TableView();
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 10, true, true, true);
        this.setLayout(layout);
        this.add(this.makeLabelContainer());
        this.add(this.makePromptsContainer());
        this.initializeTableView();
    }

    protected Container makeLabelContainer() {
        Container labelContainer = new Container();
        AutoSizingGridLayout labelLayout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, true);
        labelContainer.setLayout(labelLayout);
        this.selectionLabel = new JLabel(RB.getStringResource(RB_KEY, "selectPrompt.txt"));
        labelContainer.add(this.selectionLabel);
        return labelContainer;
    }

    protected Container makePromptsContainer() {
        Container promptsContainer = new Container();
        AutoSizingGridLayout promptsLayout = new AutoSizingGridLayout(1, 2, 10, 0, true, true, true);
        promptsContainer.setLayout(promptsLayout);
        promptsContainer.add(this.makeTableContainer());
        promptsContainer.add(this.makeValuesContainer());
        return promptsContainer;
    }

    protected Container makeTableContainer() {
        Container tableContainer = new Container();
        AutoSizingGridLayout tableLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        tableContainer.setLayout(tableLayout);
        JLabel promptsLabel = Util.createLabelForComponent(this.tableView, RB.getStringResource(RB_KEY, "prompts.txt"));
        tableContainer.add(promptsLabel);
        JScrollPane tablePane = new JScrollPane(this.tableView);
        tablePane.setPreferredSize(new Dimension(300, 100));
        tableContainer.add(tablePane);
        return tableContainer;
    }

    protected Container makeValuesContainer() {
        Container valuesContainer = new Container();
        AutoSizingGridLayout valuesContainerLayout = new AutoSizingGridLayout(2, 1, 10, 10, true, false, true);
        valuesContainer.setLayout(valuesContainerLayout);
        valuesContainer.add(this.makePromptIdentifierLabelsContainer());
        valuesContainer.add(this.makeDefaultValueContainer());
        return valuesContainer;
    }

    protected Container makePromptIdentifierLabelsContainer() {
        this.promptIdentifierContainer = new Container();
        AutoSizingGridLayout promptIdentifierLayout = new AutoSizingGridLayout(-1, 2, 5, 0, true, false, true);
        this.promptIdentifierContainer.setLayout(promptIdentifierLayout);
        this.populatePromptIdentifierLabelsContainer(null);
        return this.promptIdentifierContainer;
    }

    protected Container makeDefaultValueContainer() {
        Container valueContainer = new Container();
        AutoSizingGridLayout valueLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, false, true);
        valueContainer.setLayout(valueLayout);
        this.textFieldContainer = new TextFieldEditorPanel();
        this.singleListContainer = new SingleSelectionListEditorPanel();
        this.multiListContainer = new MultiSelectionListEditorPanel();
        this.radioButtonContainer = new RadioButtonEditorPanel();
        this.datePanelContainer = new DateEditorPanel(true);
        this.requiredDatePanelContainer = new DateEditorPanel(false, 5);
        this.timePanelContainer = new DateEditorPanel(true, 7);
        this.requiredTimePanelContainer = new DateEditorPanel(false, 7);
        this.timestampPanelContainer = new DateEditorPanel(true, 8);
        this.requiredTimestampPanelContainer = new DateEditorPanel(false, 8);
        this.emptyContainer = new JPanel();
        AutoSizingGridLayout emptyLayout = new AutoSizingGridLayout(1, 0, 5, 0, true, false, true);
        this.emptyContainer.setLayout(emptyLayout);
        EmptyComponent ec = new EmptyComponent();
        this.emptyContainer.add(ec);
        this.cardContainer = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardContainer.setLayout(this.cardLayout);
        this.cardContainer.add((Component)this.emptyContainer, EMPTY_CARD);
        this.cardContainer.add((Component)this.textFieldContainer, TEXTFIELD_CARD);
        this.cardContainer.add((Component)this.singleListContainer, SINGLE_LIST_CARD);
        this.cardContainer.add((Component)this.multiListContainer, MULTI_LIST_CARD);
        this.cardContainer.add((Component)this.radioButtonContainer, RADIO_BUTTON_CARD);
        this.cardContainer.add((Component)this.datePanelContainer, DATE_PANEL_CARD);
        this.cardContainer.add((Component)this.requiredDatePanelContainer, REQUIRED_DATE_PANEL_CARD);
        this.cardContainer.add((Component)this.timePanelContainer, TIME_PANEL_CARD);
        this.cardContainer.add((Component)this.requiredTimePanelContainer, REQUIRED_TIME_PANEL_CARD);
        this.cardContainer.add((Component)this.timestampPanelContainer, TIMESTAMP_PANEL_CARD);
        this.cardContainer.add((Component)this.requiredTimestampPanelContainer, REQUIRED_TIMESTAMP_PANEL_CARD);
        valueContainer.add(this.cardContainer);
        return valueContainer;
    }

    protected void initializeTableView() {
        this.tableView.setRowHeaderVisible(false);
        this.tableView.setColumnHeaderVisible(false);
        this.tableView.setPopupMenuEnabled(false);
        this.tableView.setRowSelectionAllowed(true);
        this.tableView.setColumnSelectionAllowed(false);
        this.tableView.setCellSelectionEnabled(false);
        this.tableView.setAutoResizeMode(4);
        JTableHeader header = this.tableView.getTableHeader();
        if (header != null) {
            header.setReorderingAllowed(false);
        }
        this.tableModel = new EntityAttributeValueTableModelAdapter(this.selectorAdapter);
        this.tableView.setModel(this.tableModel);
        this.tableView.setSelectionMode(0);
        Set propertyNames = this.selectorAdapter.getProperties(this.getLocale()).keySet();
        for (String attributeName : propertyNames) {
            this.initialValues.put(attributeName, this.selectorAdapter.getSelectedValues(attributeName));
        }
        this.rowSM = this.tableView.getRowModel().getSelectionModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EntityAttributeValuePanel.this.tableView.requestFocus();
                EntityAttributeValuePanel.this.tableView.setRowSelectionInterval(0, 0);
            }
        });
        this.displayContainer(0);
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    if (EntityAttributeValuePanel.this.previousPanel != null) {
                        try {
                            EntityAttributeValuePanel.this.selectorAdapter.setValue((String)EntityAttributeValuePanel.this.tableModel.getPropertyAt(EntityAttributeValuePanel.this.previousRow), EntityAttributeValuePanel.this.previousPanel.getValue());
                        }
                        catch (IllegalArgumentException ex) {
                            if (EntityAttributeValuePanel.this.previousRow != selectedRow) {
                                JFrame frame = Util.getParentFrame(EntityAttributeValuePanel.this.tableView);
                                JOptionPane.showMessageDialog(frame, ex.getMessage(), RB.getStringResource("errorDialogTitle.txt"), 0);
                                EntityAttributeValuePanel.this.tableView.setRowSelectionInterval(EntityAttributeValuePanel.this.previousRow, EntityAttributeValuePanel.this.previousRow);
                            }
                            return;
                        }
                    }
                    EntityAttributeValuePanel.this.displayContainer(selectedRow);
                }
            }
        });
    }

    protected void displayContainer(int selectedRow) {
        String propertyName = (String)this.tableModel.getPropertyAt(selectedRow);
        Map supplementalProperties = this.selectorAdapter.getSupplementalProperties(propertyName);
        this.populatePromptIdentifierLabelsContainer(supplementalProperties);
        this.previousRow = selectedRow;
        String editorType = this.selectorAdapter.getEditor(propertyName, "JavaPanel");
        if (editorType == null) {
            this.previousPanel = this.textFieldContainer;
            this.textFieldContainer.setModel(this.selectorAdapter, propertyName);
            this.cardLayout.show(this.cardContainer, TEXTFIELD_CARD);
        } else if (editorType.equals("com.sas.swing.visuals.dataselectors.propertyeditor.TextFieldEditorPanel")) {
            this.previousPanel = this.textFieldContainer;
            this.textFieldContainer.setModel(this.selectorAdapter, propertyName);
            this.cardLayout.show(this.cardContainer, TEXTFIELD_CARD);
        } else if (editorType.equals("com.sas.swing.visuals.dataselectors.propertyeditor.SingleSelectionListEditorPanel")) {
            this.previousPanel = this.singleListContainer;
            this.singleListContainer.setModel(this.selectorAdapter, propertyName);
            this.cardLayout.show(this.cardContainer, SINGLE_LIST_CARD);
        } else if (editorType.equals("com.sas.swing.visuals.dataselectors.propertyeditor.MultiSelectionListEditorPanel")) {
            this.previousPanel = this.multiListContainer;
            this.multiListContainer.setModel(this.selectorAdapter, propertyName);
            this.cardLayout.show(this.cardContainer, MULTI_LIST_CARD);
        } else if (editorType.equals("com.sas.swing.visuals.dataselectors.propertyeditor.RadioButtonEditorPanel")) {
            this.previousPanel = this.radioButtonContainer;
            this.radioButtonContainer.setModel(this.selectorAdapter, propertyName);
            this.cardLayout.show(this.cardContainer, RADIO_BUTTON_CARD);
        } else if (editorType.equals("com.sas.swing.visuals.dataselectors.propertyeditor.DateEditorPanel")) {
            List propValue = (List)this.initialValues.get(propertyName);
            String formattedValue = ((PropertyValueInterface)propValue.get(0)).getFormattedValue();
            int type = this.selectorAdapter.getType(propertyName);
            if (type == 7) {
                if (this.selectorAdapter.isRequired(propertyName)) {
                    this.previousPanel = this.requiredTimePanelContainer;
                    this.requiredTimePanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, REQUIRED_TIME_PANEL_CARD);
                } else if (formattedValue != null && formattedValue.trim().equals("")) {
                    this.previousPanel = this.timePanelContainer;
                    this.datePanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, TIME_PANEL_CARD);
                } else {
                    this.previousPanel = this.requiredTimePanelContainer;
                    this.requiredTimePanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, REQUIRED_TIME_PANEL_CARD);
                }
            } else if (type == 8) {
                if (this.selectorAdapter.isRequired(propertyName)) {
                    this.previousPanel = this.requiredTimestampPanelContainer;
                    this.requiredTimestampPanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, REQUIRED_TIMESTAMP_PANEL_CARD);
                } else if (formattedValue != null && formattedValue.trim().equals("")) {
                    this.previousPanel = this.datePanelContainer;
                    this.datePanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, DATE_PANEL_CARD);
                } else {
                    this.previousPanel = this.requiredTimestampPanelContainer;
                    this.requiredTimestampPanelContainer.setModel(this.selectorAdapter, propertyName);
                    this.cardLayout.show(this.cardContainer, REQUIRED_TIMESTAMP_PANEL_CARD);
                }
            } else if (this.selectorAdapter.isRequired(propertyName)) {
                this.previousPanel = this.requiredDatePanelContainer;
                this.requiredDatePanelContainer.setModel(this.selectorAdapter, propertyName);
                this.cardLayout.show(this.cardContainer, REQUIRED_DATE_PANEL_CARD);
            } else if (formattedValue != null && formattedValue.trim().equals("")) {
                this.previousPanel = this.datePanelContainer;
                this.datePanelContainer.setModel(this.selectorAdapter, propertyName);
                this.cardLayout.show(this.cardContainer, DATE_PANEL_CARD);
            } else {
                this.previousPanel = this.requiredDatePanelContainer;
                this.requiredDatePanelContainer.setModel(this.selectorAdapter, propertyName);
                this.cardLayout.show(this.cardContainer, REQUIRED_DATE_PANEL_CARD);
            }
        } else {
            this.showEditorPanel(propertyName, editorType);
        }
    }

    protected void populatePromptIdentifierLabelsContainer(Map supplementalProperties) {
        if (supplementalProperties != null) {
            int mapSize = supplementalProperties.size();
            for (String propertyName : supplementalProperties.keySet()) {
                this.promptIdentifierContainer.add(new JLabel(propertyName));
                this.promptIdentifierContainer.add(new JLabel((String)supplementalProperties.get(propertyName)));
            }
        }
    }

    protected void showEditorPanel(String propertyName, String editorType) {
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if (this.editorMap.containsKey(propertyName)) {
            this.previousPanel = (EditorPanelInterface)this.editorMap.get(propertyName);
            this.cardLayout.show(this.cardContainer, editorType);
        } else {
            try {
                JComponent editor = (JComponent)Class.forName(editorType).newInstance();
                this.cardContainer.add((Component)editor, editorType);
                this.editorMap.put(propertyName, editor);
                this.cardLayout.show(this.cardContainer, editorType);
            }
            catch (Exception e) {
                throw new IllegalStateException(MessageFormat.format(RB.getStringResource("editorError.ex.txt"), propertyName));
            }
        }
    }

    public void commitLastEditedValue() {
        if (this.selectorAdapter != null && this.previousPanel != null) {
            String propertyName = (String)this.tableModel.getPropertyAt(this.previousRow);
            this.selectorAdapter.setValue(propertyName, this.previousPanel.getValue());
            this.selectorAdapter.commitChanges();
        }
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
    }

    @Override
    public void onApply() {
        this.commitLastEditedValue();
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onClose() {
    }

    @Override
    public String getDialogTitle() {
        return this.dialogTitle == null ? "" : this.dialogTitle;
    }

    @Override
    public String getTabTitle() {
        return this.tabTitle == null ? "" : this.tabTitle;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public String getHelpID() {
        return null;
    }

    @Override
    public boolean isYesNo() {
        return false;
    }

    @Override
    public boolean isContentsValid() {
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
    }
}

