/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeTypeUtility;
import com.sas.swing.visuals.dataselectors.filters.DateTimeValuePanel;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

@SASScope(value="ALL")
public class DateEditorPanel
extends JPanel
implements EditorPanelInterface {
    protected JCheckBox specifyDateCheckBox;
    protected DateTimeValuePanel dateTimePanel;
    protected boolean includeCheckBox;
    private int type;

    public DateEditorPanel() {
        this(false);
    }

    public DateEditorPanel(boolean includeCheckBox) {
        this(includeCheckBox, 5);
    }

    public DateEditorPanel(boolean includeCheckBox, int type) {
        this.includeCheckBox = includeCheckBox;
        this.type = type;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, true);
        this.setLayout(layout);
        this.add(this.makePanel());
    }

    protected JPanel makePanel() {
        JPanel datePanel = new JPanel();
        int numberOfComponents = 1;
        if (this.includeCheckBox) {
            numberOfComponents = 2;
        }
        AutoSizingGridLayout dateLayout = new AutoSizingGridLayout(numberOfComponents, 1, 5, 10, true, false, true);
        datePanel.setLayout(dateLayout);
        this.dateTimePanel = new DateTimeValuePanel(null);
        if (this.type == 7) {
            this.dateTimePanel.setUpDateTimeFields(false, 5L);
        } else if (this.type == 8) {
            this.dateTimePanel.setUpDateTimeFields(false, 6L);
        } else {
            this.dateTimePanel.setUpDateTimeFields(false, 4L);
        }
        if (numberOfComponents == 2) {
            this.specifyDateCheckBox = new JCheckBox(RB.getStringResource("specifyDate.txt"));
            this.specifyDateCheckBox.getAccessibleContext().setAccessibleName("specifyDateCheckBox");
            this.specifyDateCheckBox.setSelected(true);
            this.specifyDateCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DateEditorPanel.this.specifyDateCheckBox.isSelected()) {
                        DateEditorPanel.this.dateTimePanel.setEnabled(true);
                    } else {
                        DateEditorPanel.this.dateTimePanel.setEnabled(false);
                    }
                }
            });
            datePanel.add(this.specifyDateCheckBox);
        }
        datePanel.add(this.dateTimePanel);
        return datePanel;
    }

    @Override
    public void setModel(EntityAttributeValueModelInterface selectorAdapter, String propertyName) {
        Object o;
        List list = selectorAdapter.getSelectedValues(propertyName);
        if (list.size() == 1 && (o = ((PropertyValueInterface)list.get(0)).getUnformattedValue()) != null) {
            if (this.type == 7) {
                list.set(0, o);
            } else if (this.type == 8) {
                list.set(0, o);
            } else {
                list.set(0, (Date)AttributeTypeUtility.convertValueToDate((Object)o));
            }
            this.dateTimePanel.setSelectedValues(list);
        }
    }

    @Override
    public Object getValue() {
        if (this.specifyDateCheckBox == null || this.specifyDateCheckBox.isSelected()) {
            List list = this.dateTimePanel.getSelectedValues();
            if (this.type == 7) {
                return new Time(((Date)list.get(0)).getTime());
            }
            if (this.type == 8) {
                return new Timestamp(((Date)list.get(0)).getTime());
            }
            return list.get(0);
        }
        return null;
    }
}

