/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import com.sas.swing.visuals.dualselector.DualListSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;

public class ValueEditorDualListSelector
extends DualListSelector
implements ValueEditorInterface {
    transient List valueEditorActionListeners = new ArrayList();

    public ValueEditorDualListSelector(JComponent parent, String labelFrom, String labelTo, String name, List listOfAvailableValues) {
        ValueEditorDualListSelector tmpDataSelector = this;
        ((JComponent)tmpDataSelector).setOpaque(false);
        tmpDataSelector.setAlternatingMultipleButtonStyle(false);
        tmpDataSelector.setAlternatingSingleButtonStyle(false);
        tmpDataSelector.setCopyModeDuplicatesAllowed(false);
        tmpDataSelector.setDragAndDropEnabled(false);
        tmpDataSelector.setBounds(new Rectangle(0, 0, 373, 100));
        tmpDataSelector.setMinimumSize(new Dimension(60, 105));
        tmpDataSelector.setPreferredSize(new Dimension(160, 120));
        tmpDataSelector.setName(name);
        if (labelTo != null) {
            tmpDataSelector.setTargetLabel(labelTo);
        }
        if (labelFrom != null) {
            tmpDataSelector.setSourceLabel(labelFrom);
        }
        CollectionToListModelAdapter tmpModel = new CollectionToListModelAdapter();
        tmpModel.setModel(new ArrayList(listOfAvailableValues));
        tmpDataSelector.setModel(tmpModel);
        tmpDataSelector.setTargetModel(new DefaultListModel());
        parent.add((Component)tmpDataSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 6, 2, 6), 0, 0));
        InnerListChangeListener myListSelectionListener = new InnerListChangeListener();
        this.addPropertyChangeListener("targetItems", myListSelectionListener);
        this.addPropertyChangeListener("sourceItems", myListSelectionListener);
        this.setOpaque(false);
    }

    @Override
    public List setEditorValues(List newValues) {
        ArrayList vals = new ArrayList(newValues);
        if (vals.size() == 0) {
            return vals;
        }
        ValueEditorDualListSelector selector = this;
        ListModel targetModel = selector.getTargetModel();
        ListModel sourceModel = selector.getModel();
        DefaultListModel targetDLM = null;
        CollectionToListModelAdapter sourceLMA = null;
        if (targetModel instanceof DefaultListModel) {
            targetDLM = (DefaultListModel)targetModel;
        }
        if (sourceModel instanceof CollectionToListModelAdapter) {
            sourceLMA = (CollectionToListModelAdapter)sourceModel;
        }
        Iterator iter = vals.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            if (targetDLM == null) continue;
            if (targetDLM.contains(val)) {
                iter.remove();
            } else {
                targetDLM.addElement(val);
                selector.setTargetModel(targetDLM);
            }
            if (sourceLMA != null) {
                Collection col = sourceLMA.getModel();
                col.remove(val);
                sourceLMA.refresh();
                iter.remove();
            } else if (sourceModel instanceof DefaultListModel) {
                DefaultListModel sourceDLM = (DefaultListModel)sourceModel;
                sourceDLM.removeElement(val);
            }
            selector.updateUI();
            selector.validate();
        }
        return vals;
    }

    @Override
    public List getEditorValues() {
        ArrayList vals = new ArrayList();
        ValueEditorDualListSelector selector = this;
        ListModel lm = selector.getTargetModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            Object val = lm.getElementAt(i);
            vals.add(val);
        }
        return vals;
    }

    @Override
    public List copyEditorValues(ValueEditorInterface fromEditor) {
        List vals = fromEditor.getEditorValues();
        List remainingVals = this.setEditorValues(vals);
        return remainingVals;
    }

    @Override
    public void addValueEditorActionListener(ActionListener l) {
        if (this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.add(l);
    }

    @Override
    public void removeValueEditorActionListener(ActionListener l) {
        if (!this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.remove(l);
    }

    public void notifyValueEditorActionListeners(String command) {
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (ActionListener listener : this.valueEditorActionListeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.getSourceComponent() != null) {
            this.getSourceComponent().setBackground(enable ? Color.WHITE : Color.LIGHT_GRAY);
        }
        if (this.getTargetComponent() != null) {
            this.getTargetComponent().setBackground(enable ? Color.WHITE : Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setOpaque(boolean opaque) {
        Container foo;
        super.setOpaque(false);
        if (this.mainPanel != null) {
            this.mainPanel.setOpaque(false);
        }
        if (this.sourceLabel != null) {
            this.sourceLabel.setOpaque(false);
        }
        if (this.sourceContainer != null) {
            this.sourceContainer.setOpaque(false);
        }
        if (this.sourceTopButtonContainer != null) {
            this.sourceTopButtonContainer.setOpaque(false);
        }
        if (this.sourceBottomButtonContainer != null) {
            this.sourceBottomButtonContainer.setOpaque(false);
        }
        if (this.targetLabel != null) {
            this.targetLabel.setOpaque(false);
        }
        if (this.targetContainer != null) {
            this.targetContainer.setOpaque(false);
        }
        if (this.leftButton != null && (foo = this.leftButton.getParent()) instanceof JComponent) {
            ((JComponent)foo).setOpaque(false);
        }
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private class InnerListChangeListener
    implements PropertyChangeListener {
        private InnerListChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object obj = event.getSource();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            Object id = event.getPropagationId();
            String name = event.getPropertyName();
            ValueEditorDualListSelector.this.notifyValueEditorActionListeners(obj.toString());
        }
    }
}

