/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SimpleDualListSelectorAdapter {
    private transient ListModel allItems = null;
    private transient ArrayList indicesSelected = new ArrayList();
    private transient ListModel availableItemsModel = null;
    private transient ListModel selectedItemsModel = null;
    private transient List listAvailableDataListeners = new ArrayList();
    private transient List listSelectedDataListeners = new ArrayList();
    private transient boolean keepSelectionsInOrder = false;
    private transient int _selectToIndex = -1;

    public SimpleDualListSelectorAdapter() {
        this(null);
    }

    public SimpleDualListSelectorAdapter(ListModel listModel) {
        this.setModel(listModel);
    }

    public void setModel(ListModel listModel) {
        this.allItems = listModel == null ? new DefaultListModel() : listModel;
        this.availableItemsModel = new AvailableItemsModel();
        this.selectedItemsModel = new SelectedItemsModel();
    }

    public ListModel getModel() {
        return this.allItems;
    }

    public ListModel getAvailableItemsModel() {
        return this.availableItemsModel;
    }

    public ListModel getSelectedItemsModel() {
        return this.selectedItemsModel;
    }

    public boolean isAvailableEmpty() {
        return this.availableItemsModel.getSize() == 0;
    }

    public boolean isSelectionEmpty() {
        return this.indicesSelected.size() == 0;
    }

    public int[] getSelectedIndices() {
        int limit = this.indicesSelected.size();
        int[] allIndicesSelected = new int[limit];
        for (int i = 0; i < limit; ++i) {
            allIndicesSelected[i] = (Integer)this.indicesSelected.get(i);
        }
        return allIndicesSelected;
    }

    public void setSelectedValue(Object anObject) {
        int allItemsIndex = -1;
        int limit = this.allItems.getSize();
        for (int i = 0; i < limit; ++i) {
            Object listObject = this.allItems.getElementAt(i);
            if (anObject == null && listObject == null) {
                allItemsIndex = i;
                break;
            }
            if (anObject == null || anObject != listObject) continue;
            allItemsIndex = i;
            break;
        }
        if (allItemsIndex != -1) {
            this.selectFromAllItems(allItemsIndex);
        }
    }

    public boolean isOrdered() {
        return this.keepSelectionsInOrder;
    }

    public void setOrdered(boolean keepInOrder) {
        if (this.keepSelectionsInOrder == keepInOrder) {
            return;
        }
        this.keepSelectionsInOrder = keepInOrder;
        if (keepInOrder) {
            int[] allIndicesSelected = this.getSelectedIndices();
            Arrays.sort(allIndicesSelected);
            for (int offset = 0; offset < allIndicesSelected.length; ++offset) {
                this.indicesSelected.set(offset, new Integer(allIndicesSelected[offset]));
            }
            this.tellListDataListenersAboutChange();
        }
    }

    public int cnvItemIndex_FromAvailableIndex(int availableItemsIndex) {
        int ignoreIndex;
        int offset;
        int[] allIndicesSelected = this.getSelectedIndices();
        Arrays.sort(allIndicesSelected);
        for (offset = 0; offset < allIndicesSelected.length && availableItemsIndex + offset >= (ignoreIndex = allIndicesSelected[offset]); ++offset) {
        }
        return availableItemsIndex + offset;
    }

    public int cnvItemIndex_ToAvailableIndex(int allItemsIndex) {
        int[] allIndicesSelected = this.getSelectedIndices();
        int countSkip = 0;
        for (int i = 0; i < allIndicesSelected.length; ++i) {
            if (allItemsIndex > allIndicesSelected[i]) {
                ++countSkip;
                continue;
            }
            if (allItemsIndex != allIndicesSelected[i]) continue;
            return -1;
        }
        return allItemsIndex - countSkip;
    }

    public int cnvItemIndex_ToSelectedIndex(int allItemsIndex) {
        for (int i = 0; i < this.indicesSelected.size(); ++i) {
            int val = (Integer)this.indicesSelected.get(i);
            if (val != allItemsIndex) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int allItemsIndex) {
        return !this.indicesSelected.contains(new Integer(allItemsIndex));
    }

    public void deselectAllItems() {
        this.indicesSelected.clear();
        this.tellListDataListenersAboutChange();
    }

    public void selectAllItems() {
        this.indicesSelected.clear();
        for (int i = 0; i < this.allItems.getSize(); ++i) {
            this.indicesSelected.add(new Integer(i));
        }
        this.tellListDataListenersAboutChange();
    }

    public void setSelectToIndex(int selectToIndex) {
        if (this.keepSelectionsInOrder) {
            return;
        }
        this._selectToIndex = selectToIndex;
    }

    public void selectFromAllItems(int allItemsIndex) {
        this._selectFromAllItems(allItemsIndex);
        this.tellListDataListenersAboutChange();
    }

    public void selectFromAllItems(int[] allItemsIndices) {
        for (int i = 0; i < allItemsIndices.length; ++i) {
            this._selectFromAllItems(allItemsIndices[i]);
            if (this.keepSelectionsInOrder || this._selectToIndex == -1) continue;
            ++this._selectToIndex;
        }
        this.tellListDataListenersAboutChange();
    }

    public void selectFromAvailableItems(int availableItemIndex) {
        int allIndex = this.cnvItemIndex_FromAvailableIndex(availableItemIndex);
        this.selectFromAllItems(allIndex);
    }

    public void selectFromAvailableItems(int[] availableItemIndices) {
        int[] allIndices = new int[availableItemIndices.length];
        for (int i = 0; i < availableItemIndices.length; ++i) {
            allIndices[i] = this.cnvItemIndex_FromAvailableIndex(availableItemIndices[i]);
        }
        this.selectFromAllItems(allIndices);
    }

    public void deselectFromAllItems(int allItemsIndex) {
        int selectedIndex = this.cnvItemIndex_ToSelectedIndex(allItemsIndex);
        if (selectedIndex != -1) {
            this.indicesSelected.remove(selectedIndex);
            this.tellListDataListenersAboutChange();
        }
    }

    public void deselectFromSelectedItems(int selectedItemIndex) {
        this.indicesSelected.remove(selectedItemIndex);
        this.tellListDataListenersAboutChange();
    }

    public void deselectFromSelectedItems(int[] selectedItemIndices) {
        Iterator iter = this.indicesSelected.iterator();
        int j = 0;
        while (iter.hasNext()) {
            iter.next();
            for (int i = 0; i < selectedItemIndices.length; ++i) {
                if (j != selectedItemIndices[i]) continue;
                iter.remove();
                break;
            }
            ++j;
        }
        this.tellListDataListenersAboutChange();
    }

    private void _selectFromAllItems(int allItemsIndex) {
        boolean done = false;
        for (int i = 0; i < this.indicesSelected.size(); ++i) {
            int val = (Integer)this.indicesSelected.get(i);
            if (val == allItemsIndex) {
                return;
            }
            if (!this.keepSelectionsInOrder || val <= allItemsIndex) continue;
            this.indicesSelected.add(i, new Integer(allItemsIndex));
            done = true;
            break;
        }
        if (!done) {
            if (this._selectToIndex != -1) {
                this.indicesSelected.add(this._selectToIndex, new Integer(allItemsIndex));
            } else {
                this.indicesSelected.add(new Integer(allItemsIndex));
            }
        }
    }

    private void tellListDataListenersAboutChange() {
        ListDataListener l;
        int i;
        ListDataEvent e = null;
        List listeners = this.listAvailableDataListeners;
        ListModel m = this.getAvailableItemsModel();
        for (i = 0; i < listeners.size(); ++i) {
            l = (ListDataListener)listeners.get(i);
            e = new ListDataEvent(m, 0, 0, m.getSize() - 1);
            l.contentsChanged(e);
        }
        listeners = this.listSelectedDataListeners;
        m = this.getSelectedItemsModel();
        for (i = 0; i < listeners.size(); ++i) {
            l = (ListDataListener)listeners.get(i);
            e = new ListDataEvent(m, 0, 0, m.getSize() - 1);
            l.contentsChanged(e);
        }
    }

    private class SelectedItemsModel
    implements ListModel {
        @Override
        public int getSize() {
            return SimpleDualListSelectorAdapter.this.indicesSelected.size();
        }

        public Object getElementAt(int index) {
            int val = (Integer)SimpleDualListSelectorAdapter.this.indicesSelected.get(index);
            return SimpleDualListSelectorAdapter.this.allItems.getElementAt(val);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            SimpleDualListSelectorAdapter.this.listSelectedDataListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            if (SimpleDualListSelectorAdapter.this.listSelectedDataListeners.contains(l)) {
                SimpleDualListSelectorAdapter.this.listSelectedDataListeners.remove(l);
            }
        }
    }

    private class AvailableItemsModel
    implements ListModel {
        @Override
        public int getSize() {
            return SimpleDualListSelectorAdapter.this.allItems.getSize() - SimpleDualListSelectorAdapter.this.indicesSelected.size();
        }

        public Object getElementAt(int index) {
            int realIndex = SimpleDualListSelectorAdapter.this.cnvItemIndex_FromAvailableIndex(index);
            return SimpleDualListSelectorAdapter.this.allItems.getElementAt(realIndex);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            SimpleDualListSelectorAdapter.this.listAvailableDataListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            if (SimpleDualListSelectorAdapter.this.listAvailableDataListeners.contains(l)) {
                SimpleDualListSelectorAdapter.this.listAvailableDataListeners.remove(l);
            }
        }
    }
}

