/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.visuals.dataselectors.filters.editors.RB;
import com.sas.swing.visuals.dataselectors.filters.editors.SimpleDualListSelectorAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleDualListSelector
extends JComponent {
    public static final String RB_KEY = "SimpleDualListSelector.";
    private String _labelAvailableValues = RB.getStringResource("SimpleDualListSelector.", "LabelAvailableValues.txt");
    private String _labelSelectedValues = RB.getStringResource("SimpleDualListSelector.", "LabelSelectedValues.txt");
    private transient JLabel availableLabel = null;
    private transient JLabel selectedLabel = null;
    private transient JList availableList = null;
    private transient JList selectedList = null;
    private transient JButton selectAllButton = null;
    private transient JButton selectButton = null;
    private transient JButton deselectAllButton = null;
    private transient JButton deselectButton = null;
    private transient JScrollPane scrollAvailable = null;
    private transient JScrollPane scrollSelected = null;
    private transient JPanel layoutPanelLeft = null;
    private transient JPanel layoutPanelSelectButtons = null;
    private transient JPanel layoutPanelRight = null;
    private transient JPanel layoutPanelDeselectButtons = null;
    private transient SimpleDualListSelectorAdapter adapter = null;
    private transient InnerListDataListener myDualListListDataListener = null;
    private transient List listSelectionListeners = new ArrayList();
    private DataFlavor listDragItemsDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref", "List of values");

    public SimpleDualListSelector() {
        this.setModel(new DefaultListModel());
        this.init();
    }

    public void setModel(ListModel listModel) {
        this.adapter = new SimpleDualListSelectorAdapter(listModel);
        if (this.myDualListListDataListener == null) {
            this.myDualListListDataListener = new InnerListDataListener();
        }
        if (this.availableList != null) {
            ListModel alm = this.adapter.getAvailableItemsModel();
            if (alm != null) {
                alm.removeListDataListener(this.myDualListListDataListener);
            }
            this.availableList.setModel(this.adapter.getAvailableItemsModel());
            alm = this.adapter.getAvailableItemsModel();
            if (alm != null) {
                alm.addListDataListener(this.myDualListListDataListener);
            }
            this.availableList.validate();
        }
        if (this.selectedList != null) {
            ListModel slm = this.adapter.getSelectedItemsModel();
            if (slm != null) {
                slm.removeListDataListener(this.myDualListListDataListener);
            }
            this.selectedList.setModel(this.adapter.getSelectedItemsModel());
            slm = this.adapter.getSelectedItemsModel();
            if (slm != null) {
                slm.addListDataListener(this.myDualListListDataListener);
            }
            this.selectedList.validate();
        }
    }

    public ListModel getModel() {
        return this.adapter.getModel();
    }

    public void setOrdered(boolean keepInOrder) {
        this.adapter.setOrdered(keepInOrder);
    }

    public boolean isOrdered() {
        return this.adapter.isOrdered();
    }

    public void setSelectedListLabel(String label) {
        this.selectedLabel.setText(label);
    }

    public String getSelectedListLabel() {
        return this.selectedLabel.getText();
    }

    public void setAvailableListLabel(String label) {
        this.availableLabel.setText(label);
    }

    public String getAvailableListLabel() {
        return this.availableLabel.getText();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.layoutPanelLeft = new JPanel(new GridBagLayout());
        this.layoutPanelSelectButtons = new JPanel(new GridBagLayout());
        this.layoutPanelRight = new JPanel(new GridBagLayout());
        this.layoutPanelDeselectButtons = new JPanel(new GridBagLayout());
        this.setOpaque(false);
        this.availableLabel = new JLabel(this._labelAvailableValues);
        this.layoutPanelLeft.add((Component)this.availableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 2, 0, 0), 0, 0));
        this.availableList = new JList(this.adapter.getAvailableItemsModel());
        this.availableList.setName("Available Items JList");
        JScrollPane scrollAvailable = new JScrollPane(this.availableList);
        JComboBox tmpBug = new JComboBox();
        scrollAvailable.setBorder(tmpBug.getBorder());
        this.layoutPanelLeft.add((Component)scrollAvailable, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 16, 1, new Insets(0, 2, 2, 0), 0, 0));
        this.availableLabel.setLabelFor(this.availableList);
        this.selectButton = new JButton(">");
        this.selectButton.setMargin(new Insets(1, 1, 1, 1));
        this.selectAllButton = new JButton(">>");
        this.selectAllButton.setMargin(new Insets(1, 1, 1, 1));
        this.deselectButton = new JButton("<");
        this.deselectButton.setMargin(new Insets(1, 1, 1, 1));
        this.deselectAllButton = new JButton("<<");
        this.deselectAllButton.setMargin(new Insets(1, 1, 1, 1));
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        this.layoutPanelSelectButtons.add((Component)new JSeparator(), gbc.clone());
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.layoutPanelSelectButtons.add((Component)this.selectButton, gbc.clone());
        this.layoutPanelSelectButtons.add((Component)this.selectAllButton, gbc.clone());
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        this.layoutPanelSelectButtons.add((Component)new JSeparator(), gbc.clone());
        this.selectedLabel = new JLabel(this._labelSelectedValues);
        this.layoutPanelRight.add((Component)this.selectedLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(2, 0, 0, 2), 0, 0));
        this.selectedList = new JList(this.adapter.getSelectedItemsModel());
        this.selectedList.setName("Selected Items JList");
        JScrollPane scrollSelected = new JScrollPane(this.selectedList);
        scrollSelected.setBorder(tmpBug.getBorder());
        this.layoutPanelRight.add((Component)scrollSelected, new GridBagConstraints(2, 1, 1, 0, 1.0, 1.0, 14, 1, new Insets(0, 0, 2, 2), 0, 0));
        this.selectedLabel.setLabelFor(this.selectedList);
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        this.layoutPanelDeselectButtons.add((Component)new JSeparator(), gbc.clone());
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.layoutPanelDeselectButtons.add((Component)this.deselectButton, gbc.clone());
        this.layoutPanelDeselectButtons.add((Component)this.deselectAllButton, gbc.clone());
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.1;
        this.layoutPanelDeselectButtons.add((Component)new JSeparator(), gbc.clone());
        this.add((Component)this.layoutPanelLeft, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.layoutPanelSelectButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.layoutPanelRight, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.layoutPanelDeselectButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.setButtonStates();
        InnerButtonsActionListener actionListener = new InnerButtonsActionListener();
        this.selectButton.addActionListener(actionListener);
        this.deselectButton.addActionListener(actionListener);
        this.selectAllButton.addActionListener(actionListener);
        this.deselectAllButton.addActionListener(actionListener);
        InnerFocusListener focusListener = new InnerFocusListener();
        this.selectedList.addFocusListener(focusListener);
        this.availableList.addFocusListener(focusListener);
        InnerListSelectionListener selectionListener = new InnerListSelectionListener();
        this.selectedList.addListSelectionListener(selectionListener);
        this.availableList.addListSelectionListener(selectionListener);
        DragSource defaultDragSource = DragSource.getDefaultDragSource();
        defaultDragSource.createDefaultDragGestureRecognizer(this.availableList, 3, new ListDragGestureListener(this.availableList));
        DropTarget availableDropTarget = new DropTarget(this.availableList, 3, new ListDropTargetListener(), true);
        this.availableList.setDropTarget(availableDropTarget);
        defaultDragSource.createDefaultDragGestureRecognizer(this.selectedList, 3, new ListDragGestureListener(this.selectedList));
        DropTarget selectedDropTarget = new DropTarget(this.selectedList, 3, new ListDropTargetListener(), true);
        this.selectedList.setDropTarget(selectedDropTarget);
    }

    private void doActionMoveSelectItemsToSelectedList() {
        int[] indices = this.availableList.getSelectedIndices();
        int selectToIndex = this.selectedList.getSelectedIndex();
        this.adapter.setSelectToIndex(selectToIndex);
        this.adapter.selectFromAvailableItems(indices);
        this.notifyListSelectionListeners();
        if (indices.length > 0) {
            int size = this.availableList.getModel().getSize();
            if (size > 0) {
                if (indices[0] < size) {
                    this.availableList.setSelectedIndex(indices[0]);
                } else {
                    this.availableList.setSelectedIndex(size - 1);
                }
            } else {
                this.availableList.clearSelection();
            }
        }
        this.setButtonStates();
    }

    private void doActionReturnSelectItemsToAvailableList() {
        int[] indices = this.selectedList.getSelectedIndices();
        this.adapter.deselectFromSelectedItems(indices);
        this.notifyListSelectionListeners();
        if (indices.length > 0) {
            int size = this.selectedList.getModel().getSize();
            if (size > 0) {
                if (indices[0] < size) {
                    this.selectedList.setSelectedIndex(indices[0]);
                } else {
                    this.selectedList.setSelectedIndex(size - 1);
                }
            } else {
                this.selectedList.clearSelection();
            }
        }
        this.setButtonStates();
    }

    private void doActionMoveAllItemsToSelectedList() {
        int selectToIndex = this.selectedList.getSelectedIndex();
        this.adapter.setSelectToIndex(selectToIndex);
        this.adapter.selectAllItems();
        this.availableList.clearSelection();
        this.notifyListSelectionListeners();
        this.setButtonStates();
    }

    private void doActionReturnAllItemsToAvailableList() {
        this.adapter.deselectAllItems();
        this.selectedList.clearSelection();
        this.notifyListSelectionListeners();
        this.setButtonStates();
    }

    private void setButtonStates() {
        this.selectButton.setEnabled(this.isEnabled() && !this.availableList.isSelectionEmpty());
        this.selectAllButton.setEnabled(this.isEnabled() && !this.adapter.isAvailableEmpty());
        this.deselectButton.setEnabled(this.isEnabled() && !this.selectedList.isSelectionEmpty());
        this.deselectAllButton.setEnabled(this.isEnabled() && !this.adapter.isSelectionEmpty());
    }

    public void clearSelection() {
        this.adapter.deselectAllItems();
        this.notifyListSelectionListeners();
    }

    public void ensureIndexIsVisible(int allItemsIndex) {
        ListModel allItemsListModel = this.adapter.getModel();
        if (allItemsIndex >= allItemsListModel.getSize()) {
            return;
        }
        int[] allIndicesSelected = this.adapter.getSelectedIndices();
        int countSkip = 0;
        for (int i = 0; i < allIndicesSelected.length; ++i) {
            if (allItemsIndex > allIndicesSelected[i]) {
                ++countSkip;
                continue;
            }
            if (allItemsIndex != allIndicesSelected[i]) continue;
            this.selectedList.ensureIndexIsVisible(i);
            return;
        }
        if (allItemsIndex <= countSkip) {
            return;
        }
        this.availableList.ensureIndexIsVisible(allItemsIndex - countSkip);
    }

    public void ensureObjectIsVisible(Object anObject) {
        ListModel allItemsListModel = this.adapter.getModel();
        for (int i = 0; i < allItemsListModel.getSize(); ++i) {
            Object objInList = allItemsListModel.getElementAt(i);
            if (objInList == null && anObject == null) {
                this.ensureIndexIsVisible(i);
                return;
            }
            if (objInList == null || !objInList.equals(anObject)) continue;
            this.ensureIndexIsVisible(i);
            return;
        }
    }

    public boolean isSelectionEmpty() {
        return this.adapter.isSelectionEmpty();
    }

    public int getSelectedIndex() {
        int[] indices = this.adapter.getSelectedIndices();
        if (indices.length == 0) {
            return -1;
        }
        return indices[0];
    }

    public int[] getSelectedIndices() {
        return this.adapter.getSelectedIndices();
    }

    public Object getSelectedValue() {
        int i = this.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        return this.adapter.getModel().getElementAt(i);
    }

    public Object[] getSelectedValues() {
        int[] indices = this.adapter.getSelectedIndices();
        Object[] objs = new Object[indices.length];
        ListModel lm = this.adapter.getModel();
        for (int i = 0; i < indices.length; ++i) {
            Object obj = lm.getElementAt(indices[i]);
            objs[i] = obj;
        }
        return objs;
    }

    public boolean isSelectedIndex(int index) {
        return this.adapter.isSelected(index);
    }

    public void setListData(Object[] listData) {
        DefaultListModel<Object> dlm = new DefaultListModel<Object>();
        for (int i = 0; i < listData.length; ++i) {
            dlm.addElement(listData[i]);
        }
        this.adapter.setModel(dlm);
        this.notifyListSelectionListeners();
    }

    public void setListData(Vector listData) {
        this.setListData(listData.toArray());
    }

    public void setSelectedIndex(int index) {
        int selectToIndex = this.selectedList.getSelectedIndex();
        this.adapter.setSelectToIndex(selectToIndex);
        this.adapter.selectFromAllItems(index);
        this.notifyListSelectionListeners();
    }

    public void setSelectedIndices(int[] indices) {
        int selectToIndex = this.selectedList.getSelectedIndex();
        this.adapter.setSelectToIndex(selectToIndex);
        this.adapter.selectFromAllItems(indices);
        this.notifyListSelectionListeners();
    }

    public void setSelectedValues(Object[] objects) {
        this.adapter.deselectAllItems();
        for (int i = 0; i < objects.length; ++i) {
            this.adapter.setSelectedValue(objects[i]);
        }
        this.notifyListSelectionListeners();
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.adapter.setSelectedValue(anObject);
        if (shouldScroll) {
            this.ensureObjectIsVisible(anObject);
        }
        this.notifyListSelectionListeners();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (!this.listSelectionListeners.contains(listener)) {
            this.listSelectionListeners.add(listener);
        }
    }

    protected void notifyListSelectionListeners() {
        int[] indices = this.adapter.getSelectedIndices();
        ListSelectionEvent event = new ListSelectionEvent(this, 0, indices.length - 1, false);
        for (int i = 0; i < this.listSelectionListeners.size(); ++i) {
            ListSelectionListener l = (ListSelectionListener)this.listSelectionListeners.get(i);
            l.valueChanged(event);
        }
    }

    void removeListSelectionListener(ListSelectionListener listener) {
        if (this.listSelectionListeners.contains(listener)) {
            this.listSelectionListeners.remove(listener);
        }
    }

    public ListCellRenderer getAvailableListCellRenderer() {
        return this.availableList.getCellRenderer();
    }

    public void setAvailableListCellRenderer(ListCellRenderer cellRenderer) {
        this.availableList.setCellRenderer(cellRenderer);
    }

    public ListCellRenderer getSelectedListCellRenderer() {
        return this.selectedList.getCellRenderer();
    }

    public void setSelectedListCellRenderer(ListCellRenderer cellRenderer) {
        this.selectedList.setCellRenderer(cellRenderer);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.selectButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
        this.deselectButton.setEnabled(enable);
        this.availableLabel.setEnabled(enable);
        this.selectedLabel.setEnabled(enable);
        this.availableList.setEnabled(enable);
        this.selectedList.setEnabled(enable);
        this.availableList.setBackground(enable ? Color.WHITE : Color.LIGHT_GRAY);
        this.selectedList.setBackground(enable ? Color.WHITE : Color.LIGHT_GRAY);
        this.setButtonStates();
    }

    @Override
    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        this.layoutPanelLeft.setOpaque(false);
        this.layoutPanelRight.setOpaque(false);
        this.layoutPanelSelectButtons.setOpaque(false);
        this.layoutPanelDeselectButtons.setOpaque(false);
    }

    class ListDropTargetListener
    implements DropTargetListener {
        ListDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtDragEvent) {
            this.doDragAllowedCheck(dtDragEvent);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtDragEvent) {
            this.doDragAllowedCheck(dtDragEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtDragEvent) {
            this.doDragAllowedCheck(dtDragEvent);
        }

        @Override
        public void dragExit(DropTargetEvent dtEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dtDropEvent) {
            DropTarget source = (DropTarget)dtDropEvent.getSource();
            Component sourceComponent = source.getComponent();
            if (!dtDropEvent.isLocalTransfer()) {
                dtDropEvent.rejectDrop();
                return;
            }
            int dropAction = dtDropEvent.getDropAction();
            int allowed = dropAction & 3;
            if (allowed == 0) {
                dtDropEvent.rejectDrop();
                return;
            }
            DataFlavor chosenFlavor = this.chooseFlavor(dtDropEvent);
            if (chosenFlavor == null) {
                dtDropEvent.rejectDrop();
                return;
            }
            dtDropEvent.acceptDrop(dropAction);
            Object data = null;
            try {
                data = dtDropEvent.getTransferable().getTransferData(chosenFlavor);
                if (data == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                dtDropEvent.dropComplete(false);
                return;
            }
            if (!(data instanceof JList)) {
                dtDropEvent.dropComplete(false);
                return;
            }
            JList sourceList = (JList)data;
            if (sourceComponent == sourceList) {
                dtDropEvent.dropComplete(false);
                return;
            }
            if (sourceList == SimpleDualListSelector.this.availableList) {
                SimpleDualListSelector.this.doActionMoveSelectItemsToSelectedList();
            } else {
                SimpleDualListSelector.this.doActionReturnSelectItemsToAvailableList();
            }
            dtDropEvent.dropComplete(true);
        }

        private void doDragAllowedCheck(DropTargetDragEvent dtDragEvent) {
            if (!dtDragEvent.isDataFlavorSupported(SimpleDualListSelector.this.listDragItemsDataFlavor)) {
                dtDragEvent.rejectDrag();
                return;
            }
            int dropAction = dtDragEvent.getDropAction();
            int allowed = dropAction & 3;
            dtDragEvent.acceptDrag(allowed);
        }

        private DataFlavor chooseFlavor(DropTargetDropEvent dtDropEvent) {
            if (dtDropEvent.isDataFlavorSupported(SimpleDualListSelector.this.listDragItemsDataFlavor)) {
                return SimpleDualListSelector.this.listDragItemsDataFlavor;
            }
            return null;
        }
    }

    protected class ListDragSourceListener
    implements DragSourceListener {
        protected ListDragSourceListener() {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int dropAction = e.getDropAction();
            int allowed = dropAction & 3;
            Cursor cursor = null;
            cursor = allowed != 0 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyNoDrop;
            context.setCursor(cursor);
        }

        @Override
        public void dragExit(DragSourceEvent e) {
            e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsDropEvent) {
        }
    }

    class ListDragItemsTransferable
    implements Transferable {
        protected JList _srcList;
        public DataFlavor[] flavors;
        private List flavorList;

        public ListDragItemsTransferable(JList srcList) {
            this.flavors = new DataFlavor[]{SimpleDualListSelector.this.listDragItemsDataFlavor};
            this.flavorList = Arrays.asList(this.flavors);
            this._srcList = srcList;
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(SimpleDualListSelector.this.listDragItemsDataFlavor)) {
                return this._srcList;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavorList.contains(flavor);
        }
    }

    protected class ListDragGestureListener
    implements DragGestureListener {
        ListDragSourceListener _dsListener;
        JList _srcList;

        public ListDragGestureListener(JList srcList) {
            this._dsListener = new ListDragSourceListener();
            this._srcList = null;
            this._srcList = srcList;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (this._srcList.isSelectionEmpty()) {
                return;
            }
            ListDragItemsTransferable transferable = new ListDragItemsTransferable(this._srcList);
            try {
                dge.startDrag(null, transferable, this._dsListener);
            }
            catch (InvalidDnDOperationException idoe) {
                idoe.printStackTrace();
            }
        }
    }

    private class InnerListSelectionListener
    implements ListSelectionListener {
        private InnerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object obj;
            if (!e.getValueIsAdjusting() && (obj = e.getSource()) instanceof JList && (obj == SimpleDualListSelector.this.availableList || obj == SimpleDualListSelector.this.selectedList)) {
                SimpleDualListSelector.this.setButtonStates();
            }
        }
    }

    private class InnerButtonsActionListener
    implements ActionListener {
        private InnerButtonsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == SimpleDualListSelector.this.selectButton) {
                SimpleDualListSelector.this.doActionMoveSelectItemsToSelectedList();
            } else if (event.getSource() == SimpleDualListSelector.this.deselectButton) {
                SimpleDualListSelector.this.doActionReturnSelectItemsToAvailableList();
            } else if (event.getSource() == SimpleDualListSelector.this.selectAllButton) {
                SimpleDualListSelector.this.doActionMoveAllItemsToSelectedList();
            } else if (event.getSource() == SimpleDualListSelector.this.deselectAllButton) {
                SimpleDualListSelector.this.doActionReturnAllItemsToAvailableList();
            }
        }
    }

    private class InnerFocusListener
    implements FocusListener {
        private InnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (event.getSource() == SimpleDualListSelector.this.availableList || event.getSource() == SimpleDualListSelector.this.selectedList) {
                // empty if block
            }
        }

        @Override
        public void focusLost(FocusEvent event) {
        }
    }

    private class InnerListDataListener
    implements ListDataListener {
        private InnerListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            SimpleDualListSelector.this.setButtonStates();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            SimpleDualListSelector.this.setButtonStates();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            SimpleDualListSelector.this.setButtonStates();
        }
    }
}

