/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.filters.AdvancedFilterSelectorPanel;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;

public class AdvancedFilterSelector
extends BaseSwingSelectorPanel
implements LayoutConstants {
    public static final String RB_KEY = "AdvancedFilterSelector.";
    private AdvancedFilterSelectorPanel filterPanel;
    private String dialogTitle;

    public AdvancedFilterSelector() {
        this(null);
    }

    public AdvancedFilterSelector(AdvancedFilterSelectorPanel filterSelectorPanel) {
        this.filterPanel = filterSelectorPanel;
        this.createComponents();
        this.dialogTitle = RB.getStringResource(RB_KEY, "filterDialogTitle.txt");
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        this.setLayout(mainLayout);
        if (this.filterPanel == null) {
            this.filterPanel = new AdvancedFilterSelectorPanel();
            this.filterPanel.setNameDescriptionVisible(false);
            this.filterPanel.setPromptEditingAllowed(false);
        }
        this.add(this.filterPanel);
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && (model instanceof AdvancedFilterModelInterface || model == null)) {
            Object old = this.selectorModel;
            this.selectorModel = model;
            this.filterPanel.setModel(model);
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    @Override
    public void onApply() {
        this.setContentsValid(true);
        if (!this.validatePanel()) {
            this.contentsValid = false;
            return;
        }
        if (this.filterPanel.getSelectedItem() != null) {
            this.filterPanel.updateSelectionModel();
        }
        super.onApply();
    }

    private boolean validatePanel() {
        if (((AdvancedFilterModelInterface)this.selectorModel).getSelectionCount() == 0) {
            if (!this.filterPanel.isItemSelectable() && this.filterPanel.isQualifierSelectionEnabled() || this.filterPanel.isItemSelectable() && this.filterPanel.getSelectedItem() != null) {
                boolean isValid = this.filterPanel.validateFilterDefinition();
                return isValid;
            }
            return true;
        }
        boolean valid = this.filterPanel.validateFilter();
        return valid;
    }

    public void setItemSelectable(boolean isSelectable) {
        this.filterPanel.setItemSelectable(isSelectable);
    }

    public void setSelectedItem(FilterItemInterface filterItem) {
        this.filterPanel.setSelectedItem(filterItem);
    }

    public void setNameDescriptionVisible(boolean isVisible) {
        this.filterPanel.setNameDescriptionVisible(isVisible);
    }

    @Override
    public String getDialogTitle() {
        return this.dialogTitle;
    }

    @Override
    public void onCancel() {
        this.contentsValid = true;
        super.onCancel();
    }

    public AdvancedFilterSelectorPanel getFilterPanel() {
        return this.filterPanel;
    }
}

