/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.FilterLogicEditableTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.PromptValueProviderModelInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.filters.AdvancedFilterSelectorPanel;
import com.sas.swing.visuals.dataselectors.filters.MultiLineToolTip;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class AdvancedFilterCombinationPanel
extends JComponent
implements LayoutConstants,
PropertyChangeListener {
    public static final String RB_KEY = "AdvancedFilterCombinationPanel.";
    public static final String AND_COMMAND = "AND";
    public static final String OR_COMMAND = "OR";
    public static final String NOT_COMMAND = "Not";
    public static final String GROUP_COMMAND = "Group";
    public static final String SPLIT_COMMAND = "Split";
    public static final String UP_COMMAND = "Up";
    public static final String DOWN_COMMAND = "Down";
    public static final String EDIT_COMMAND = "Edit";
    public static final String DELETE_COMMAND = "Delete";
    public static final String ADD_COMMAND = "Add";
    public static final String UPDATE_COMMAND = "Update";
    public static final String COMBINATIONS_COMMAND = "Combinations";
    private static boolean debug = false;
    protected AdvancedFilterModelInterface model;
    protected TableView filterTable;
    protected FilterTableModel filterTableModel;
    protected JPanel combinationsPanel;
    protected JPanel labelPanel;
    protected JPanel upperButtonPanel;
    protected JPanel lowerButtonPanel;
    protected JButton andButton;
    protected JButton orButton;
    protected JButton notButton;
    protected JButton groupButton;
    protected JButton splitButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JButton editButton;
    protected JButton deleteButton;
    protected JButton addButton;
    protected JButton updateButton;
    protected JButton combinationsButton;
    protected Icon foldIcon;
    protected Icon unfoldIcon;
    protected String andLabel;
    protected String orLabel;
    protected JComboBox groupComboBoxEditor;
    protected JCheckBox cascadePromptsCheckBox;
    protected AdvancedFilterSelectorPanel filterDefinitionPanel;
    protected JLabel filterTableTitleLabel;
    protected JScrollPane scrollPane;
    protected ListSelectionModel filterTableRowSelectionModel;
    private boolean isEditing;
    private int editFilterIndex;
    private FilterLogicTestNodeInterface editTestNode;
    private boolean ignoringTableChanges;
    private static final String closeCombinationsToolTipText = RB.getStringResource("AdvancedFilterCombinationPanel.", "closeCombinationsToolTip.txt");
    private static final String openCombinationsToolTipText = RB.getStringResource("AdvancedFilterCombinationPanel.", "openCombinationsToolTip.txt");
    private static final String andStr = com.sas.dataselectors.filters.RB.getStringResource("Util.", "Boolean.AND.Label.txt");
    private static final String orStr = com.sas.dataselectors.filters.RB.getStringResource("Util.", "Boolean.OR.Label.txt");
    private boolean isCombinationsAreaAlwaysShown;
    private List buttonList;

    public AdvancedFilterCombinationPanel(AdvancedFilterSelectorPanel filterDefinitionPanel) {
        this.filterDefinitionPanel = filterDefinitionPanel;
        this.andLabel = RB.getStringResource(RB_KEY, "andLabel.txt");
        this.orLabel = RB.getStringResource(RB_KEY, "orLabel.txt");
        this.createComponents();
        this.addListeners();
        this.foldIcon = Resources.getImageIcon((String)"Fold");
        this.unfoldIcon = Resources.getImageIcon((String)"Unfold");
    }

    protected void createComponents() {
        this.filterTableTitleLabel = new JLabel();
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "filterComboTableTitle.txt"), this.filterTableTitleLabel);
        this.filterTableTitleLabel.setName("filterTableTitleLabel");
        this.filterTable = new TableView(){

            @Override
            protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
                Component cellEditorComp = this.getEditorComponent();
                if (cellEditorComp != null && cellEditorComp instanceof JComboBox && evt.getKeyCode() == 40) {
                    JComboBox combo = (JComboBox)this.editorComp;
                    if (!combo.isPopupVisible()) {
                        combo.showPopup();
                    }
                    return false;
                }
                return super.processKeyBinding(stroke, evt, condition, pressed);
            }

            @Override
            public void processComponentKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 9 && e.getID() == 401) {
                    AdvancedFilterCombinationPanel.this.handleKeyEvent(e);
                } else {
                    super.processComponentKeyEvent(e);
                }
            }

            @Override
            public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
                if (row == 1 && column == 2) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return super.getCellRect(row, column, includeSpacing);
            }
        };
        this.filterTableTitleLabel.setLabelFor(this.filterTable);
        this.filterTable.setName("filterCombinationsTable");
        this.filterTable.setColumnHeaderVisible(false);
        this.filterTable.setRowHeaderVisible(false);
        this.filterTable.setPopupMenuEnabled(false);
        this.filterTableModel = new FilterTableModel();
        this.filterTable.setModel(this.filterTableModel);
        this.filterTable.setSelectionMode(2);
        this.filterTable.setAutoResizeMode(3);
        this.filterTable.getTableHeader().setReorderingAllowed(false);
        this.filterTable.getColumnModel().getColumn(0).setPreferredWidth(225);
        this.filterTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.filterTable.setRowSelectionAllowed(true);
        this.filterTable.getColumnModel().getColumn(1).setMaxWidth(60);
        DefaultTableCellRenderer tableRender = new DefaultTableCellRenderer();
        tableRender.setTransform(new LogicalConditionCellTransform());
        this.filterTable.setCellRenderer(-1, 2, tableRender);
        this.groupComboBoxEditor = new JComboBox(){

            @Override
            public void processComponentKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 9 && e.getID() == 401) {
                    AdvancedFilterCombinationPanel.this.handleKeyEvent(e);
                } else {
                    super.processComponentKeyEvent(e);
                }
            }
        };
        this.groupComboBoxEditor.addItem(AND_COMMAND);
        this.groupComboBoxEditor.addItem(OR_COMMAND);
        this.groupComboBoxEditor.setRenderer(new LogicalConditionComboBoxValueRenderer());
        DefaultTableCellEditor conditionComboEditor = new DefaultTableCellEditor(this.groupComboBoxEditor);
        this.filterTable.getColumnModel().getColumn(1).setCellEditor(conditionComboEditor);
        this.scrollPane = new JScrollPane(this.filterTable);
        this.scrollPane.setPreferredSize(new Dimension(350, 64));
        this.andButton = new JButton();
        this.andButton.setName("combinationAndButton");
        this.andButton.setActionCommand(AND_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(this.andLabel, this.andButton);
        this.andButton.setToolTipText(RB.getStringResource(RB_KEY, "andToolTip.txt"));
        this.andButton.setEnabled(false);
        this.orButton = new JButton();
        this.orButton.setName("combinationOrButton");
        this.orButton.setActionCommand(OR_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(this.orLabel, this.orButton);
        this.orButton.setToolTipText(RB.getStringResource(RB_KEY, "orToolTip.txt"));
        this.orButton.setEnabled(false);
        this.notButton = new JButton();
        this.notButton.setName("combinationNotButton");
        this.notButton.setActionCommand(NOT_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "notLabel.txt"), this.notButton);
        this.notButton.setToolTipText(RB.getStringResource(RB_KEY, "notToolTip.txt"));
        this.notButton.setEnabled(false);
        this.groupButton = new JButton();
        this.groupButton.setName("combinationGroupButton");
        this.groupButton.setActionCommand(GROUP_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "groupLabel.txt"), this.groupButton);
        this.groupButton.setToolTipText(RB.getStringResource(RB_KEY, "groupToolTip.txt"));
        this.groupButton.setEnabled(false);
        this.splitButton = new JButton();
        this.splitButton.setName("combinationSplitButton");
        this.splitButton.setActionCommand(SPLIT_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "splitLabel.txt"), this.splitButton);
        this.splitButton.setToolTipText(RB.getStringResource(RB_KEY, "splitToolTip.txt"));
        this.splitButton.setEnabled(false);
        this.upButton = new JButton(Resources.getImageIcon((String)"UpArrow"));
        this.upButton.setName("combinationUpButton");
        this.upButton.setActionCommand(UP_COMMAND);
        this.upButton.setToolTipText(RB.getStringResource(RB_KEY, "upToolTip.txt"));
        this.upButton.setEnabled(false);
        this.downButton = new JButton(Resources.getImageIcon((String)"DownArrow"));
        this.downButton.setName("combinationDownButton");
        this.downButton.setActionCommand(DOWN_COMMAND);
        this.downButton.setToolTipText(RB.getStringResource(RB_KEY, "downToolTip.txt"));
        this.downButton.setEnabled(false);
        this.editButton = new JButton();
        this.editButton.setName("combinationEditButton");
        this.editButton.setActionCommand(EDIT_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "editLabel.txt"), this.editButton);
        this.editButton.setToolTipText(RB.getStringResource(RB_KEY, "editToolTip.txt"));
        this.editButton.setHorizontalTextPosition(10);
        ImageIcon upIcon = Resources.getImageIcon((String)"PointerUp");
        this.editButton.setIcon(upIcon);
        this.deleteButton = new JButton();
        this.deleteButton.setName("combinationDeleteButton");
        this.deleteButton.setActionCommand(DELETE_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "deleteLabel.txt"), this.deleteButton);
        this.deleteButton.setToolTipText(RB.getStringResource(RB_KEY, "deleteToolTip.txt"));
        this.addButton = new JButton();
        this.addButton.setName("combinationAddButton");
        this.addButton.setActionCommand(ADD_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "addLabel.txt"), this.addButton);
        this.addButton.setToolTipText(RB.getStringResource(RB_KEY, "addToolTip.txt"));
        this.addButton.setHorizontalTextPosition(10);
        ImageIcon downIcon = Resources.getImageIcon((String)"PointerDown");
        this.addButton.setIcon(downIcon);
        this.addButton.setEnabled(false);
        this.updateButton = new JButton();
        this.updateButton.setName("combinationUpdateButton");
        this.updateButton.setActionCommand(UPDATE_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "updateLabel.txt"), this.updateButton);
        this.updateButton.setToolTipText(RB.getStringResource(RB_KEY, "updateToolTip.txt"));
        this.updateButton.setHorizontalTextPosition(10);
        this.updateButton.setIcon(downIcon);
        this.updateButton.setEnabled(false);
        this.combinationsButton = new JButton();
        this.combinationsButton.setName("combinationsButton");
        this.combinationsButton.setActionCommand(COMBINATIONS_COMMAND);
        this.filterDefinitionPanel.setComponentMnemonics(RB.getStringResource(RB_KEY, "combinationsLabel.txt"), this.combinationsButton);
        this.combinationsButton.setToolTipText(openCombinationsToolTipText);
        this.combinationsButton.setHorizontalTextPosition(10);
        this.combinationsButton.setIcon(this.unfoldIcon);
        LabelView groupingWarningMessage = new LabelView(){

            @Override
            public JToolTip createToolTip() {
                return new MultiLineToolTip();
            }
        };
        groupingWarningMessage.setPreferredSpanSize(new Dimension(450, -1));
        groupingWarningMessage.setText(RB.getStringResource(RB_KEY, "groupingWarningMessage.txt"));
        groupingWarningMessage.setToolTipText(RB.getStringResource(RB_KEY, "groupingWarningToolTipMessage.txt"));
        groupingWarningMessage.setFont(groupingWarningMessage.getFont().deriveFont(2));
        groupingWarningMessage.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        mainLayout.setRemainderRow(2);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        this.upperButtonPanel = new JPanel();
        this.upperButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
        this.upperButtonPanel.setOpaque(false);
        FlowLayout upperButtonPanelLayout = new FlowLayout(2, 0, 0);
        JPanel bPanel = new JPanel();
        bPanel.setOpaque(false);
        AutoSizingGridLayout bPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        bPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        bPanel.setLayout(bPanelLayout);
        bPanel.add(this.addButton);
        bPanel.add(this.updateButton);
        bPanel.add(this.combinationsButton);
        this.upperButtonPanel.setLayout(upperButtonPanelLayout);
        this.upperButtonPanel.add(bPanel);
        this.labelPanel = new JPanel();
        this.labelPanel.setOpaque(false);
        AutoSizingGridLayout labelPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        this.labelPanel.setLayout(labelPanelLayout);
        this.labelPanel.add(this.filterTableTitleLabel);
        JPanel filterTableAndButtonsPanel = new JPanel();
        filterTableAndButtonsPanel.setOpaque(false);
        AutoSizingGridLayout filterTableAndButtonsPanelLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        filterTableAndButtonsPanelLayout.setRemainderRow(1);
        filterTableAndButtonsPanel.setLayout(filterTableAndButtonsPanelLayout);
        filterTableAndButtonsPanel.add(this.scrollPane);
        this.lowerButtonPanel = new JPanel();
        this.lowerButtonPanel.setOpaque(false);
        AutoSizingGridLayout lowerButtonPanelLayout = new AutoSizingGridLayout(1, 7, 5, 5, true, false, false);
        this.lowerButtonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        lowerButtonPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.lowerButtonPanel.setLayout(lowerButtonPanelLayout);
        this.lowerButtonPanel.add(this.andButton);
        this.lowerButtonPanel.add(this.orButton);
        this.lowerButtonPanel.add(this.notButton);
        this.lowerButtonPanel.add(this.groupButton);
        this.lowerButtonPanel.add(this.splitButton);
        this.lowerButtonPanel.add(this.upButton);
        this.lowerButtonPanel.add(this.downButton);
        filterTableAndButtonsPanel.add(this.lowerButtonPanel);
        this.cascadePromptsCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "cascadePromptsLabel.txt"));
        this.cascadePromptsCheckBox.setName("cascadePromptsCheckBox");
        this.cascadePromptsCheckBox.setSelected(false);
        this.cascadePromptsCheckBox.setVisible(false);
        JPanel cascadePromptsPanel = new JPanel();
        cascadePromptsPanel.setBorder(BorderFactory.createEmptyBorder(-1, 0, 3, 0));
        cascadePromptsPanel.setOpaque(false);
        AutoSizingGridLayout cascadePromptsPanelLayout = new AutoSizingGridLayout(1, 1, 0, 0, false, false, false);
        cascadePromptsPanelLayout.setIgnoreSizeOfNonVisibleComponents(true);
        cascadePromptsPanel.setLayout(cascadePromptsPanelLayout);
        cascadePromptsPanel.add(this.cascadePromptsCheckBox);
        filterTableAndButtonsPanel.add(cascadePromptsPanel);
        JPanel edit_deleteButtonPanel = new JPanel();
        edit_deleteButtonPanel.setOpaque(false);
        AutoSizingGridLayout edit_deleteButtonPanelLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, false);
        edit_deleteButtonPanel.setLayout(edit_deleteButtonPanelLayout);
        edit_deleteButtonPanel.add(this.editButton);
        edit_deleteButtonPanel.add(this.deleteButton);
        this.combinationsPanel = new JPanel();
        this.combinationsPanel.setOpaque(false);
        AutoSizingGridLayout combinationsPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        combinationsPanelLayout.setRemainderColumn(1);
        this.combinationsPanel.setLayout(combinationsPanelLayout);
        this.combinationsPanel.add(filterTableAndButtonsPanel);
        this.combinationsPanel.add(edit_deleteButtonPanel);
        this.add(this.labelPanel);
        this.add(this.combinationsPanel);
        this.buttonList = new ArrayList();
        this.buttonList.add(this.andButton);
        this.buttonList.add(this.orButton);
        this.buttonList.add(this.notButton);
        this.buttonList.add(this.groupButton);
        this.buttonList.add(this.splitButton);
        this.buttonList.add(this.upButton);
        this.buttonList.add(this.downButton);
        this.buttonList.add(this.editButton);
        this.buttonList.add(this.deleteButton);
        this.buttonList.add(this.addButton);
        this.buttonList.add(this.updateButton);
        this.buttonList.add(this.combinationsButton);
    }

    public JButton getButton(String actionCommand) {
        for (JButton button : this.buttonList) {
            if (!button.getActionCommand().equals(actionCommand)) continue;
            return button;
        }
        return null;
    }

    public void setCombinationsAreaAlwaysShown(boolean isShown) {
        this.isCombinationsAreaAlwaysShown = isShown;
        if (this.isCombinationsAreaAlwaysShown) {
            this.setCombinationsVisible(true);
            this.combinationsButton.setVisible(false);
        }
    }

    protected JPanel getCombinationsButtonPanel() {
        return this.upperButtonPanel;
    }

    private void handleKeyEvent(KeyEvent e) {
        if (e.isShiftDown()) {
            this.tabToNextEditableTableCell(1);
        } else {
            this.tabToNextEditableTableCell(0);
        }
        e.consume();
    }

    private void tabToNextEditableTableCell(int direction) {
        int nextRow = this.filterTable.getSelectedRow();
        int numRows = this.filterTable.getRowCount();
        if (nextRow == -1 && numRows > 0) {
            nextRow = 0;
            this.filterTable.setCurrentRow(0);
            this.filterTable.setCurrentColumn(1);
        }
        if (nextRow >= 0) {
            if (direction == 0) {
                if (nextRow == numRows - 1) {
                    if (numRows > 1) {
                        nextRow = 0;
                    }
                } else {
                    ++nextRow;
                }
            } else if (numRows == 1 || nextRow == 0) {
                if (numRows > 1) {
                    nextRow = numRows - 1;
                }
            } else {
                --nextRow;
            }
            this.filterTable.changeSelection(nextRow, 1, false, false);
            if (this.filterTable.isCellEditable(nextRow, 1)) {
                this.filterTable.editCellAt(nextRow, 1);
                Component editorComp = this.filterTable.getEditorComponent();
                if (editorComp != null) {
                    editorComp.requestFocus();
                }
            } else if (this.filterTable.isEditing()) {
                this.filterTable.editingCanceled(new ChangeEvent(this));
            }
        }
    }

    protected void addListeners() {
        InnerActionListener myActionListener = new InnerActionListener(this);
        InnerListSelectionListener myListSelectionListener = new InnerListSelectionListener();
        InnerItemListener myItemListener = new InnerItemListener();
        this.groupComboBoxEditor.addItemListener(myItemListener);
        this.andButton.addActionListener(myActionListener);
        this.orButton.addActionListener(myActionListener);
        this.notButton.addActionListener(myActionListener);
        this.groupButton.addActionListener(myActionListener);
        this.splitButton.addActionListener(myActionListener);
        this.upButton.addActionListener(myActionListener);
        this.downButton.addActionListener(myActionListener);
        this.editButton.addActionListener(myActionListener);
        this.deleteButton.addActionListener(myActionListener);
        this.addButton.addActionListener(myActionListener);
        this.updateButton.addActionListener(myActionListener);
        this.combinationsButton.addActionListener(myActionListener);
        this.filterDefinitionPanel.addPropertyChangeListener(this);
        this.cascadePromptsCheckBox.addActionListener(myActionListener);
        this.filterTableRowSelectionModel = this.filterTable.getRowModel().getSelectionModel();
        this.filterTableRowSelectionModel.addListSelectionListener(myListSelectionListener);
    }

    public void setModel(Object model) {
        if (this.model != model && (model instanceof AdvancedFilterModelInterface || model == null)) {
            AdvancedFilterModelInterface old = this.model;
            this.model = (AdvancedFilterModelInterface)model;
            if (model instanceof AdvancedFilterModelInterface) {
                boolean isOLAP = ((AdvancedFilterModelInterface)model).isOLAP();
                this.groupButton.setVisible(!isOLAP);
                this.notButton.setVisible(!isOLAP);
                this.splitButton.setVisible(!isOLAP);
                this.filterTableModel.setModel(this.model);
                if (model instanceof PromptValueProviderModelInterface && !isOLAP) {
                    this.cascadePromptsCheckBox.setVisible(true);
                    boolean modelContainsCascade = ((PromptValueProviderModelInterface)model).isCascadingPrompts();
                    if (modelContainsCascade) {
                        this.cascadePromptsCheckBox.setEnabled(true);
                        this.cascadePromptsCheckBox.setSelected(true);
                    } else {
                        int isCascadable = ((PromptValueProviderModelInterface)model).isCascadable();
                        this.cascadePromptsCheckBox.setSelected(false);
                        boolean isEnabled = isCascadable != 1;
                        this.cascadePromptsCheckBox.setEnabled(isEnabled);
                    }
                } else {
                    this.cascadePromptsCheckBox.setSelected(false);
                    this.cascadePromptsCheckBox.setVisible(false);
                }
                this.enableButtons();
                this.updateExpressionText();
            }
            this.firePropertyChange("model", old, this.model);
        }
    }

    private void enableCascadePromptsCheckBox() {
        if (this.model instanceof PromptValueProviderModelInterface) {
            int isCascadable = ((PromptValueProviderModelInterface)((Object)this.model)).isCascadable();
            if (isCascadable == 0) {
                this.cascadePromptsCheckBox.setEnabled(true);
            } else {
                ((PromptValueProviderModelInterface)((Object)this.model)).setEnforcePromptCascades(false);
                if (isCascadable == 2 || isCascadable == 4) {
                    this.cascadePromptsCheckBox.setEnabled(true);
                    if (this.cascadePromptsCheckBox.isSelected()) {
                        this.displayInvalidCascadeMessage(isCascadable);
                        this.cascadePromptsCheckBox.setSelected(false);
                    }
                } else {
                    this.cascadePromptsCheckBox.setSelected(false);
                    this.cascadePromptsCheckBox.setEnabled(false);
                }
            }
        }
    }

    protected void displayInvalidCascadeMessage(int reason) {
        String errorTitle = this.filterDefinitionPanel.getErrorDialogTitle();
        String title = errorTitle != null ? errorTitle : RB.getStringResource(RB_KEY, "invalidCascadeTitle.txt");
        String errorMessage = reason == 2 ? RB.getStringResource(RB_KEY, "invalidCascade.txt") : RB.getStringResource(RB_KEY, "invalidCascade_shared.txt");
        LabelView errorMessageLabel = new LabelView(errorMessage);
        errorMessageLabel.setPreferredSpanSize(new Dimension(400, -1));
        JOptionPane.showMessageDialog(this, errorMessageLabel, title, 2);
    }

    public void refreshCombinations() {
        if (this.filterTableModel != null) {
            this.filterTableModel.updateRows();
        }
    }

    public void cancelEditing() {
        this.isEditing = false;
        this.editTestNode = null;
        this.updateButton.setEnabled(false);
        this.addButton.setEnabled(false);
        if (this.filterTable.isEditing()) {
            this.filterTable.editingCanceled(new ChangeEvent(this));
        }
    }

    public Object getModel() {
        return this.model;
    }

    public int getFilterCount() {
        return this.filterTableModel.getRowCount();
    }

    protected void processUpdateAction() {
        FilterLogicEditableTestNodeInterface node = this.filterDefinitionPanel.getChangableSelectionModel();
        int editNodeIndex = this.getSelectionIndex(this.editTestNode);
        this.model.setSelectionCursor(editNodeIndex);
        this.model.setSelection(new DefaultFilterLogicTestNode(node));
    }

    private int getSelectionIndex(FilterLogicTestNodeInterface testNode) {
        if (this.model != null) {
            int count = this.model.getSelectionCount();
            for (int i = 0; i < count; ++i) {
                this.model.setSelectionCursor(i);
                FilterLogicTestNodeInterface currentNode = this.model.getSelection();
                if (testNode != currentNode) continue;
                return i;
            }
        }
        return -2;
    }

    private void selectAndScrollToNode(FilterLogicTestNodeInterface testNode) {
        int movedNodeIndex = this.getSelectionIndex(testNode);
        if (movedNodeIndex != -2) {
            this.filterTable.setRowSelectionInterval(movedNodeIndex, movedNodeIndex);
            this.filterTable.scrollRectToVisible(this.filterTable.getCellRect(movedNodeIndex, 0, true));
            this.filterTable.requestFocus();
        }
    }

    protected void enableButtons() {
        int selectedRowCount = this.filterTable.getSelectedRowCount();
        int selectedRow = this.filterTableRowSelectionModel.getMinSelectionIndex();
        SimpleFilterLogicTreeInterface tree = this.model.getSelectionTree();
        if (selectedRowCount != 1) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.andButton.setEnabled(false);
            this.orButton.setEnabled(false);
            this.notButton.setEnabled(false);
            this.splitButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            boolean groupEnabled = selectedRowCount == 0 ? false : tree.canGroupLeaves(selectedRow, this.filterTableRowSelectionModel.getMaxSelectionIndex());
            this.groupButton.setEnabled(groupEnabled);
        } else if (selectedRowCount == 1) {
            int filterCount = this.model.getSelectionCount();
            if (filterCount == 1) {
                this.editButton.setEnabled(this.isFilterEditable(selectedRow));
                this.deleteButton.setEnabled(true);
                this.andButton.setEnabled(false);
                this.orButton.setEnabled(false);
                this.notButton.setEnabled(true);
                this.splitButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.editButton.setEnabled(this.isFilterEditable(selectedRow));
                this.deleteButton.setEnabled(true);
                this.andButton.setEnabled(true);
                this.orButton.setEnabled(true);
                this.notButton.setEnabled(true);
                boolean splitEnabled = tree.isLeafGrouped(selectedRow);
                this.splitButton.setEnabled(splitEnabled);
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
                if (this.filterTableModel.getRowCount() == selectedRow + 1) {
                    this.downButton.setEnabled(false);
                    this.andButton.setEnabled(false);
                    this.orButton.setEnabled(false);
                } else {
                    SimpleFilterLogicTreeInterface logicTree;
                    if (selectedRow == 0) {
                        this.upButton.setEnabled(false);
                    }
                    if ((logicTree = this.model.getSelectionTree()) != null) {
                        String conditionType = logicTree.getLeafConditionalRelationType(selectedRow);
                        boolean andEnabledState = !AND_COMMAND.equals(conditionType);
                        this.andButton.setEnabled(andEnabledState);
                        this.orButton.setEnabled(!andEnabledState);
                    }
                }
            }
            this.groupButton.setEnabled(false);
        }
    }

    private boolean isFilterEditable(int selectionIndex) {
        int size;
        List values;
        this.model.setSelectionCursor(selectionIndex);
        FilterLogicTestNodeInterface filter = this.model.getSelection();
        if (filter == null || this.filterDefinitionPanel == null) {
            return false;
        }
        if (!(this.filterDefinitionPanel.isPromptEditingAllowed() || (values = filter.getTestValuesList()) == null || (size = values.size()) != 1 && size != 2)) {
            return !this.containsPromptedValue(values);
        }
        return true;
    }

    private boolean containsPromptedValue(List values) {
        if (values != null) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                if (!this.model.isPromptedValue(iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCombinationsAreaVisible() {
        return this.getComponentCount() == 2;
    }

    private void setCombinationsVisible(boolean isVisible) {
        if (!isVisible && this.isCombinationsAreaAlwaysShown) {
            return;
        }
        int count = this.getComponentCount();
        if (isVisible) {
            this.add((Component)this.labelPanel, 0);
            this.add((Component)this.combinationsPanel, 1);
        } else if (count == 2) {
            this.remove(1);
            this.remove(0);
        }
        boolean isFoldEnabled = this.filterTableModel.getRowCount() <= 0;
        Icon currentFoldIcon = isVisible ? this.foldIcon : this.unfoldIcon;
        String currentCombinationsToolTipText = isVisible ? closeCombinationsToolTipText : openCombinationsToolTipText;
        this.combinationsButton.setIcon(currentFoldIcon);
        this.combinationsButton.setToolTipText(currentCombinationsToolTipText);
        this.combinationsButton.setEnabled(isFoldEnabled);
        this.updateButton.setVisible(isVisible);
        this.addButton.setVisible(isVisible);
        this.filterDefinitionPanel.setCombinationsVisible(isVisible);
    }

    protected boolean isEditing() {
        return this.isEditing;
    }

    protected FilterLogicTestNodeInterface getEditTestNode() {
        return this.editTestNode;
    }

    private void updateExpressionText() {
        SimpleFilterLogicTreeInterface tree;
        if (this.model != null && (tree = this.model.getSelectionTree()) != null) {
            String expText = Util.getFormattedExpressionString(tree, this.getLocale(), 1, -1, -1);
            this.filterDefinitionPanel.updateExpressionText(expText);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String property = evt.getPropertyName();
        if (source == this.filterDefinitionPanel && property != null && property.equals("selectionComplete")) {
            boolean isSelectionComplete = (Boolean)evt.getNewValue();
            if (!this.model.isOLAP() || this.filterTable.getRowCount() < 2) {
                this.addButton.setEnabled(isSelectionComplete);
            }
            if (!isSelectionComplete) {
                this.updateButton.setEnabled(false);
            } else if (this.isEditing) {
                this.updateButton.setEnabled(true);
            } else {
                this.updateButton.setEnabled(false);
            }
        }
    }

    class FilterTableModel
    extends DefaultTableModel {
        AdvancedFilterModelInterface model;

        public FilterTableModel() {
            this.createColumns();
        }

        protected void createColumns() {
            this.addColumn("");
            this.addColumn("");
        }

        public void setModel(AdvancedFilterModelInterface advancedFilterModel) {
            boolean combinationsVisible;
            this.model = advancedFilterModel;
            this.updateRows();
            int count = this.getRowCount();
            boolean bl = combinationsVisible = count > 0;
            if (!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.isQualifiersVisible() && this.model.isOLAP()) {
                combinationsVisible = false;
            }
            AdvancedFilterCombinationPanel.this.setCombinationsVisible(combinationsVisible);
            AdvancedFilterCombinationPanel.this.filterTable.setFocusable(combinationsVisible);
            if (count == 1 && AdvancedFilterCombinationPanel.this.isFilterEditable(0)) {
                this.model.setSelectionCursor(0);
                AdvancedFilterCombinationPanel.this.isEditing = true;
                AdvancedFilterCombinationPanel.this.updateButton.setEnabled(true);
                AdvancedFilterCombinationPanel.this.addButton.setEnabled(true);
                AdvancedFilterCombinationPanel.this.editFilterIndex = 0;
                AdvancedFilterCombinationPanel.this.editTestNode = this.model.getSelection();
                DefaultFilterLogicTestNode editableTestNode = new DefaultFilterLogicTestNode(AdvancedFilterCombinationPanel.this.editTestNode);
                AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(editableTestNode);
                AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(AdvancedFilterCombinationPanel.this.editFilterIndex, AdvancedFilterCombinationPanel.this.editFilterIndex);
            } else if (count == 0) {
                this.model.setSelectionCursor(-1);
                AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(this.model.getSelection());
            } else {
                DefaultFilterLogicTestNode newNode = new DefaultFilterLogicTestNode();
                if (this.model.isOLAP()) {
                    this.model.setSelectionCursor(0);
                    FilterLogicTestNodeInterface firstNode = this.model.getSelection();
                    newNode.setFilterItem(firstNode.getFilterItem());
                }
                AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(newNode);
            }
            if (this.model.isOLAP()) {
                boolean itemSelectorEnabled = count <= 0;
                AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setFilterItemSelectorEnabledState(itemSelectorEnabled);
                if (count > 1) {
                    AdvancedFilterCombinationPanel.this.addButton.setEnabled(false);
                    AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setOLAPFieldsEnabled(false);
                }
            }
        }

        public void updateRows() {
            SimpleFilterLogicTreeInterface tree;
            AdvancedFilterCombinationPanel.this.ignoringTableChanges = true;
            int numRows = this.getRowCount();
            if (numRows > 0) {
                for (int k = numRows - 1; k >= 0; --k) {
                    this.removeRow(k);
                }
            }
            if (this.model != null && (tree = this.model.getSelectionTree()) != null) {
                Object[] vals = new Object[2];
                List expressionInfo = Util.getExpressionInfo(tree, 1, AdvancedFilterCombinationPanel.this.getLocale(), true);
                if (expressionInfo != null) {
                    for (Map infoMap : expressionInfo) {
                        String filterInfo = (String)infoMap.get("VirText");
                        String relationship = (String)infoMap.get("Cond");
                        Object node = infoMap.get("Node");
                        if (relationship != null) {
                            if (relationship.equals(andStr)) {
                                relationship = AdvancedFilterCombinationPanel.AND_COMMAND;
                            } else if (relationship.equals(orStr)) {
                                relationship = AdvancedFilterCombinationPanel.OR_COMMAND;
                            }
                        }
                        vals[0] = filterInfo == null ? "" : filterInfo;
                        vals[1] = relationship == null ? "" : relationship;
                        this.addRow(vals);
                    }
                }
            }
            if ((numRows = this.getRowCount()) > 0) {
                if (AdvancedFilterCombinationPanel.this.filterTable.isVisible()) {
                    AdvancedFilterCombinationPanel.this.combinationsButton.setEnabled(false);
                    AdvancedFilterCombinationPanel.this.combinationsButton.setIcon(AdvancedFilterCombinationPanel.this.foldIcon);
                    AdvancedFilterCombinationPanel.this.combinationsButton.setToolTipText(closeCombinationsToolTipText);
                } else {
                    AdvancedFilterCombinationPanel.this.setCombinationsVisible(true);
                }
                AdvancedFilterCombinationPanel.this.filterTable.setFocusable(true);
            } else {
                AdvancedFilterCombinationPanel.this.combinationsButton.setEnabled(true);
                AdvancedFilterCombinationPanel.this.filterTable.setFocusable(false);
                if (AdvancedFilterCombinationPanel.this.filterTable.isVisible()) {
                    AdvancedFilterCombinationPanel.this.combinationsButton.setIcon(AdvancedFilterCombinationPanel.this.foldIcon);
                } else {
                    AdvancedFilterCombinationPanel.this.combinationsButton.setIcon(AdvancedFilterCombinationPanel.this.unfoldIcon);
                }
            }
            AdvancedFilterCombinationPanel.this.firePropertyChange("combinationsChanged", false, true);
            AdvancedFilterCombinationPanel.this.filterTable.repaint();
            AdvancedFilterCombinationPanel.this.ignoringTableChanges = false;
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && row < this.getRowCount() - 1;
        }
    }

    private class InnerItemListener
    implements ItemListener {
        private InnerItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object obj;
            SimpleFilterLogicTreeInterface tree;
            if (AdvancedFilterCombinationPanel.this.filterTable.isEditing() && e.getSource() == AdvancedFilterCombinationPanel.this.groupComboBoxEditor && e.getStateChange() == 1 && (tree = AdvancedFilterCombinationPanel.this.model.getSelectionTree()) != null && ((obj = AdvancedFilterCombinationPanel.this.groupComboBoxEditor.getSelectedItem()) instanceof String && obj.equals(AdvancedFilterCombinationPanel.OR_COMMAND) || obj.equals(AdvancedFilterCombinationPanel.AND_COMMAND))) {
                int selectedRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                tree.setLeafConditionalRelationType(selectedRow, (String)obj);
                tree.refreshNodeList();
                AdvancedFilterCombinationPanel.this.enableButtons();
                AdvancedFilterCombinationPanel.this.updateExpressionText();
            }
        }
    }

    private class InnerListSelectionListener
    implements ListSelectionListener {
        private InnerListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || AdvancedFilterCombinationPanel.this.ignoringTableChanges) {
                return;
            }
            AdvancedFilterCombinationPanel.this.enableButtons();
            AdvancedFilterCombinationPanel.this.updateExpressionText();
        }
    }

    class LogicalConditionComboBoxValueRenderer
    extends DefaultListCellRenderer {
        LogicalConditionComboBoxValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == AdvancedFilterCombinationPanel.OR_COMMAND) {
                this.setText(orStr);
            } else if (value == AdvancedFilterCombinationPanel.AND_COMMAND) {
                this.setText(andStr);
            } else if (value != null) {
                this.setText(value.toString());
            }
            return component;
        }
    }

    class LogicalConditionCellTransform
    implements TransformInterface {
        LogicalConditionCellTransform() {
        }

        public Object transform(Object obj) {
            if (obj == AdvancedFilterCombinationPanel.OR_COMMAND) {
                return orStr;
            }
            if (obj == AdvancedFilterCombinationPanel.AND_COMMAND) {
                return andStr;
            }
            return obj;
        }
    }

    private class InnerActionListener
    implements ActionListener {
        private AdvancedFilterCombinationPanel panel;
        private LabelView deleteMessageLabel;
        private String groupDeleteDialogTitle;

        public InnerActionListener(AdvancedFilterCombinationPanel panel) {
            this.panel = panel;
            this.groupDeleteDialogTitle = RB.getStringResource(AdvancedFilterCombinationPanel.RB_KEY, "groupDeleteDialogTitle.txt");
            this.deleteMessageLabel = new LabelView();
            this.deleteMessageLabel.setPreferredSpanSize(new Dimension(400, -1));
            this.deleteMessageLabel.setText(RB.getStringResource(AdvancedFilterCombinationPanel.RB_KEY, "groupDeleteMessage.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SimpleFilterLogicTreeInterface tree;
            Object source = event.getSource();
            if (source == AdvancedFilterCombinationPanel.this.cascadePromptsCheckBox && AdvancedFilterCombinationPanel.this.model instanceof PromptValueProviderModelInterface) {
                boolean cascadePrompts = AdvancedFilterCombinationPanel.this.cascadePromptsCheckBox.isSelected();
                if (cascadePrompts) {
                    int cascadable = ((PromptValueProviderModelInterface)((Object)AdvancedFilterCombinationPanel.this.model)).isCascadable();
                    if (cascadable == 2 || cascadable == 4) {
                        AdvancedFilterCombinationPanel.this.displayInvalidCascadeMessage(cascadable);
                        AdvancedFilterCombinationPanel.this.cascadePromptsCheckBox.setSelected(false);
                        ((PromptValueProviderModelInterface)((Object)AdvancedFilterCombinationPanel.this.model)).setEnforcePromptCascades(false);
                        return;
                    }
                    ((PromptValueProviderModelInterface)((Object)AdvancedFilterCombinationPanel.this.model)).setEnforcePromptCascades(cascadePrompts);
                }
                ((PromptValueProviderModelInterface)((Object)AdvancedFilterCombinationPanel.this.model)).setEnforcePromptCascades(cascadePrompts);
            } else if (source == AdvancedFilterCombinationPanel.this.addButton) {
                if (!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.validateFilterDefinition()) {
                    return;
                }
                AdvancedFilterCombinationPanel.this.isEditing = false;
                AdvancedFilterCombinationPanel.this.editTestNode = null;
                AdvancedFilterCombinationPanel.this.updateButton.setEnabled(false);
                FilterLogicEditableTestNodeInterface node = AdvancedFilterCombinationPanel.this.filterDefinitionPanel.getChangableSelectionModel();
                DefaultFilterLogicTestNode testNode = new DefaultFilterLogicTestNode(node);
                if (AdvancedFilterCombinationPanel.this.model != null && testNode != null) {
                    if (debug) {
                        System.out.println("\nAdding test node with this info:");
                        System.out.println(testNode);
                    }
                    AdvancedFilterCombinationPanel.this.model.addSelection(testNode);
                    if (!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.isItemSelectable() || AdvancedFilterCombinationPanel.this.model.isOLAP()) {
                        DefaultFilterLogicTestNode newNode = new DefaultFilterLogicTestNode();
                        newNode.setFilterItem(testNode.getFilterItem());
                        AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(newNode);
                    }
                    if (AdvancedFilterCombinationPanel.this.model.isOLAP()) {
                        boolean itemSelectorEnabled = AdvancedFilterCombinationPanel.this.model.getSelectionCount() <= 0;
                        AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setFilterItemSelectorEnabledState(itemSelectorEnabled);
                        if (AdvancedFilterCombinationPanel.this.model.getSelectionCount() > 1) {
                            AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setOLAPFieldsEnabled(false);
                        }
                    } else {
                        AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(new DefaultFilterLogicTestNode());
                    }
                    if (debug) {
                        System.out.println("selection count after add= " + AdvancedFilterCombinationPanel.this.model.getSelectionCount());
                    }
                }
                if (AdvancedFilterCombinationPanel.this.filterTable.isEditing()) {
                    AdvancedFilterCombinationPanel.this.filterTable.editingCanceled(new ChangeEvent(this));
                }
                AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                AdvancedFilterCombinationPanel.this.selectAndScrollToNode(testNode);
                AdvancedFilterCombinationPanel.this.enableButtons();
                AdvancedFilterCombinationPanel.this.enableCascadePromptsCheckBox();
                AdvancedFilterCombinationPanel.this.updateExpressionText();
            } else if (source == AdvancedFilterCombinationPanel.this.updateButton) {
                if (!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.validateFilterDefinition()) {
                    return;
                }
                AdvancedFilterCombinationPanel.this.isEditing = false;
                AdvancedFilterCombinationPanel.this.updateButton.setEnabled(false);
                FilterLogicEditableTestNodeInterface node = AdvancedFilterCombinationPanel.this.filterDefinitionPanel.getChangableSelectionModel();
                int editNodeIndex = AdvancedFilterCombinationPanel.this.getSelectionIndex(AdvancedFilterCombinationPanel.this.editTestNode);
                AdvancedFilterCombinationPanel.this.model.setSelectionCursor(editNodeIndex);
                AdvancedFilterCombinationPanel.this.model.setSelection(new DefaultFilterLogicTestNode(node));
                AdvancedFilterCombinationPanel.this.editTestNode = null;
                if (AdvancedFilterCombinationPanel.this.filterTable.isEditing()) {
                    AdvancedFilterCombinationPanel.this.filterTable.editingCanceled(new ChangeEvent(this));
                }
                AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.clearSelection();
                AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(editNodeIndex, editNodeIndex);
                if (!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.isItemSelectable() || AdvancedFilterCombinationPanel.this.model.isOLAP()) {
                    DefaultFilterLogicTestNode newNode = new DefaultFilterLogicTestNode();
                    newNode.setFilterItem(node.getFilterItem());
                    AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(newNode);
                    if (AdvancedFilterCombinationPanel.this.model.isOLAP() && AdvancedFilterCombinationPanel.this.model.getSelectionCount() > 1) {
                        AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setOLAPFieldsEnabled(false);
                    }
                } else {
                    AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(new DefaultFilterLogicTestNode());
                }
                AdvancedFilterCombinationPanel.this.updateButton.setEnabled(false);
                AdvancedFilterCombinationPanel.this.enableCascadePromptsCheckBox();
            } else if (source == AdvancedFilterCombinationPanel.this.combinationsButton) {
                final boolean isVisible = AdvancedFilterCombinationPanel.this.getComponentCount() == 0;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdvancedFilterCombinationPanel.this.setCombinationsVisible(isVisible);
                    }
                });
            } else if (source == AdvancedFilterCombinationPanel.this.editButton) {
                AdvancedFilterCombinationPanel.this.isEditing = true;
                AdvancedFilterCombinationPanel.this.updateButton.setEnabled(true);
                AdvancedFilterCombinationPanel.this.editFilterIndex = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                if (debug) {
                    System.out.println("\n\nEdit button clicked:");
                    System.out.println("editing index=" + AdvancedFilterCombinationPanel.this.editFilterIndex);
                    System.out.println("\n moving selection cursor to index " + AdvancedFilterCombinationPanel.this.editFilterIndex);
                }
                AdvancedFilterCombinationPanel.this.model.setSelectionCursor(AdvancedFilterCombinationPanel.this.editFilterIndex);
                AdvancedFilterCombinationPanel.this.editTestNode = AdvancedFilterCombinationPanel.this.model.getSelection();
                if (debug) {
                    System.out.println("creating a new DefaultFilterLogicTestNode for editing for node info = " + AdvancedFilterCombinationPanel.this.editTestNode);
                }
                DefaultFilterLogicTestNode editableTestNode = new DefaultFilterLogicTestNode(AdvancedFilterCombinationPanel.this.editTestNode);
                AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(editableTestNode);
                if (AdvancedFilterCombinationPanel.this.model.isOLAP()) {
                    boolean itemSelectorEnabled = AdvancedFilterCombinationPanel.this.model.getSelectionCount() <= 0;
                    AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setFilterItemSelectorEnabledState(itemSelectorEnabled);
                }
                if (AdvancedFilterCombinationPanel.this.filterTable.isEditing()) {
                    AdvancedFilterCombinationPanel.this.filterTable.editingCanceled(new ChangeEvent(this));
                }
                AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(AdvancedFilterCombinationPanel.this.editFilterIndex, AdvancedFilterCombinationPanel.this.editFilterIndex);
                AdvancedFilterCombinationPanel.this.enableButtons();
                AdvancedFilterCombinationPanel.this.updateExpressionText();
            } else if (source == AdvancedFilterCombinationPanel.this.deleteButton) {
                DefaultFilterLogicTestNode currentFilterDefinitionNode = null;
                if (AdvancedFilterCombinationPanel.this.isEditing) {
                    currentFilterDefinitionNode = new DefaultFilterLogicTestNode();
                    if ((!AdvancedFilterCombinationPanel.this.filterDefinitionPanel.isItemSelectable() || AdvancedFilterCombinationPanel.this.model.isOLAP()) && AdvancedFilterCombinationPanel.this.editTestNode != null) {
                        currentFilterDefinitionNode.setFilterItem(AdvancedFilterCombinationPanel.this.editTestNode.getFilterItem());
                    }
                    AdvancedFilterCombinationPanel.this.isEditing = false;
                    AdvancedFilterCombinationPanel.this.editTestNode = null;
                    AdvancedFilterCombinationPanel.this.updateButton.setEnabled(false);
                    AdvancedFilterCombinationPanel.this.addButton.setEnabled(false);
                } else {
                    currentFilterDefinitionNode = new DefaultFilterLogicTestNode(AdvancedFilterCombinationPanel.this.filterDefinitionPanel.getChangableSelectionModel());
                }
                int index = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                SimpleFilterLogicTreeInterface tree2 = AdvancedFilterCombinationPanel.this.model.getSelectionTree();
                if (tree2 != null) {
                    int returnCode;
                    boolean doDeleteFilter = true;
                    if (tree2.isLeafGrouped(index) && (returnCode = JOptionPane.showConfirmDialog(this.panel, this.deleteMessageLabel, this.groupDeleteDialogTitle, 2, 2)) != 0) {
                        doDeleteFilter = false;
                    }
                    if (doDeleteFilter) {
                        tree2.removeLeafAt(index);
                        AdvancedFilterCombinationPanel.this.model.setSelectionCursor(-1);
                        DefaultFilterLogicTestNode selNode = (DefaultFilterLogicTestNode)AdvancedFilterCombinationPanel.this.model.getSelection();
                        selNode.setFilterItem(currentFilterDefinitionNode.getFilterItem());
                        List qualifiers = currentFilterDefinitionNode.getFilterItemQualifiers();
                        if (qualifiers != null && qualifiers.size() > 0) {
                            selNode.setFilterItemQualifiers(new ArrayList(qualifiers));
                        } else {
                            selNode.setFilterItemQualifiers(null);
                        }
                        selNode.setCondition(currentFilterDefinitionNode.getCondition());
                        if (currentFilterDefinitionNode.getTestValuesList() == null) {
                            selNode.setTestValuesList(null);
                        } else {
                            selNode.setTestValuesList(new ArrayList(currentFilterDefinitionNode.getTestValuesList()));
                        }
                        AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setSelectionModel(selNode);
                        if (AdvancedFilterCombinationPanel.this.filterTable.isEditing()) {
                            AdvancedFilterCombinationPanel.this.filterTable.editingCanceled(new ChangeEvent(this));
                        }
                        AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                        AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.clearSelection();
                        AdvancedFilterCombinationPanel.this.enableButtons();
                        AdvancedFilterCombinationPanel.this.enableCascadePromptsCheckBox();
                        if (AdvancedFilterCombinationPanel.this.model.isOLAP() && AdvancedFilterCombinationPanel.this.filterTable.getRowCount() < 2 && AdvancedFilterCombinationPanel.this.filterDefinitionPanel.isSelectionComplete()) {
                            AdvancedFilterCombinationPanel.this.addButton.setEnabled(true);
                        }
                        AdvancedFilterCombinationPanel.this.updateExpressionText();
                        if (AdvancedFilterCombinationPanel.this.model.isOLAP()) {
                            boolean itemSelectorEnabled = AdvancedFilterCombinationPanel.this.model.getSelectionCount() <= 0;
                            AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setFilterItemSelectorEnabledState(itemSelectorEnabled);
                            AdvancedFilterCombinationPanel.this.filterDefinitionPanel.setOLAPFieldsEnabled(true);
                        }
                    }
                }
            } else if (source == AdvancedFilterCombinationPanel.this.andButton || source == AdvancedFilterCombinationPanel.this.orButton) {
                SimpleFilterLogicTreeInterface tree3 = AdvancedFilterCombinationPanel.this.model.getSelectionTree();
                if (tree3 != null) {
                    int selectedRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                    String leafRelationType = source == AdvancedFilterCombinationPanel.this.andButton ? AdvancedFilterCombinationPanel.AND_COMMAND : AdvancedFilterCombinationPanel.OR_COMMAND;
                    tree3.setLeafConditionalRelationType(selectedRow, leafRelationType);
                    tree3.refreshNodeList();
                    if (AdvancedFilterCombinationPanel.this.filterTable.isEditing()) {
                        AdvancedFilterCombinationPanel.this.filterTable.editingCanceled(new ChangeEvent(this));
                    }
                    AdvancedFilterCombinationPanel.this.filterTable.setValueAt(leafRelationType, selectedRow, 1);
                    AdvancedFilterCombinationPanel.this.filterTable.changeSelection(selectedRow, 1, false, false);
                    AdvancedFilterCombinationPanel.this.enableButtons();
                    AdvancedFilterCombinationPanel.this.updateExpressionText();
                }
            } else if (source == AdvancedFilterCombinationPanel.this.notButton) {
                SimpleFilterLogicTreeInterface tree4 = AdvancedFilterCombinationPanel.this.model.getSelectionTree();
                if (tree4 != null) {
                    int selectedRow;
                    boolean currentState = tree4.isLeafNegated(selectedRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex());
                    tree4.setLeafNegated(selectedRow, !currentState);
                    AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                    AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
            } else if (source == AdvancedFilterCombinationPanel.this.groupButton) {
                SimpleFilterLogicTreeInterface tree5 = AdvancedFilterCombinationPanel.this.model.getSelectionTree();
                if (tree5 != null) {
                    int minRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                    int maxRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMaxSelectionIndex();
                    tree5.groupLeaves(minRow, maxRow);
                    AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                    AdvancedFilterCombinationPanel.this.enableButtons();
                    AdvancedFilterCombinationPanel.this.updateExpressionText();
                }
            } else if (source == AdvancedFilterCombinationPanel.this.splitButton) {
                SimpleFilterLogicTreeInterface tree6 = AdvancedFilterCombinationPanel.this.model.getSelectionTree();
                if (tree6 != null) {
                    int selectedRow = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                    tree6.splitGroup(selectedRow);
                    AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                    AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(selectedRow, selectedRow);
                    AdvancedFilterCombinationPanel.this.filterTable.scrollRectToVisible(AdvancedFilterCombinationPanel.this.filterTable.getCellRect(selectedRow, 0, true));
                    AdvancedFilterCombinationPanel.this.filterTable.requestFocus();
                    AdvancedFilterCombinationPanel.this.enableButtons();
                    AdvancedFilterCombinationPanel.this.updateExpressionText();
                }
            } else if ((source == AdvancedFilterCombinationPanel.this.upButton || source == AdvancedFilterCombinationPanel.this.downButton) && (tree = AdvancedFilterCombinationPanel.this.model.getSelectionTree()) != null) {
                int moveFilterIndex = AdvancedFilterCombinationPanel.this.filterTableRowSelectionModel.getMinSelectionIndex();
                AdvancedFilterCombinationPanel.this.model.setSelectionCursor(moveFilterIndex);
                FilterLogicTestNodeInterface movedTestNode = AdvancedFilterCombinationPanel.this.model.getSelection();
                if (source == AdvancedFilterCombinationPanel.this.upButton) {
                    tree.moveLeafUp(moveFilterIndex);
                } else {
                    tree.moveLeafDown(moveFilterIndex);
                }
                tree.refreshNodeList();
                AdvancedFilterCombinationPanel.this.filterTableModel.updateRows();
                int movedNodeIndex = AdvancedFilterCombinationPanel.this.getSelectionIndex(movedTestNode);
                AdvancedFilterCombinationPanel.this.filterTable.setRowSelectionInterval(movedNodeIndex, movedNodeIndex);
                AdvancedFilterCombinationPanel.this.filterTable.scrollRectToVisible(AdvancedFilterCombinationPanel.this.filterTable.getCellRect(movedNodeIndex, 0, true));
                AdvancedFilterCombinationPanel.this.selectAndScrollToNode(movedTestNode);
                AdvancedFilterCombinationPanel.this.enableButtons();
                if (((JButton)source).isEnabled()) {
                    ((JButton)source).requestFocus();
                }
            }
        }
    }
}

