/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemListInterface;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import com.sas.swing.visuals.dataselectors.calculateditems.SimpleCalculatedItemEditPanel;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class SimpleCalculatedItemSelector
extends BaseSwingSelectorPanel
implements LayoutConstants {
    private static final String RB_KEY = "SimpleCalculatedItemSelector.";
    private JTextField descTF;
    private DefaultListModel calculatedItemsModel;
    private JList calculatedItemsList;
    private JButton newB;
    private JButton editB;
    private JButton deleteB;
    private JButton deleteAllB;
    private String[][] dataItems;
    private boolean isRelational;

    public SimpleCalculatedItemSelector(boolean isRelational) {
        this.isRelational = isRelational;
        this.createComponents();
        this.addListeners();
    }

    private void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(4, 1, 5, 5, true, true, true);
        mainLayout.setRemainderRow(2);
        this.setLayout(mainLayout);
        this.add(new JLabel(RB.getStringResource(RB_KEY, this.isRelational ? "relationalListTitle.txt" : "olapListTitle.txt")));
        JPanel itemsPanel = new JPanel();
        AutoSizingGridLayout itemsPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, true, true);
        itemsPanelLayout.setRemainderColumn(1);
        itemsPanel.setLayout(itemsPanelLayout);
        this.calculatedItemsModel = new DefaultListModel();
        this.calculatedItemsList = new JList(this.calculatedItemsModel);
        this.calculatedItemsList.setSelectionMode(0);
        this.calculatedItemsList.setVisibleRowCount(8);
        JScrollPane itemsScrollPane = new JScrollPane(this.calculatedItemsList);
        itemsScrollPane.setPreferredSize(itemsScrollPane.getPreferredSize());
        itemsPanel.add(itemsScrollPane);
        JPanel listManipulatingButtonsPanel = new JPanel();
        listManipulatingButtonsPanel.setLayout(new AutoSizingGridLayout(4, 1, 5, 5, true, false, false));
        this.newB = new JButton(RB.getStringResource(RB_KEY, "newButton.txt"));
        this.editB = new JButton(RB.getStringResource(RB_KEY, "editButton.txt"));
        this.deleteB = new JButton(RB.getStringResource(RB_KEY, "deleteButton.txt"));
        this.deleteAllB = new JButton(RB.getStringResource(RB_KEY, "deleteAllButton.txt"));
        listManipulatingButtonsPanel.add(this.newB);
        listManipulatingButtonsPanel.add(this.editB);
        listManipulatingButtonsPanel.add(this.deleteB);
        listManipulatingButtonsPanel.add(this.deleteAllB);
        itemsPanel.add(listManipulatingButtonsPanel);
        this.add(itemsPanel);
        this.add(new JLabel(RB.getStringResource(RB_KEY, "desc.txt")));
        this.descTF = new JTextField();
        this.descTF.setEditable(false);
        this.add(this.descTF);
    }

    private void addListeners() {
        this.calculatedItemsList.addListSelectionListener(new ListListener());
        NewEditActionListener neAL = new NewEditActionListener(this);
        this.newB.addActionListener(neAL);
        this.editB.addActionListener(neAL);
        this.deleteB.addActionListener(new DeleteActionListener(this));
        this.deleteAllB.addActionListener(new DeleteAllActionListener(this));
    }

    private void setEnabledStateOfListManipulatingButtons() {
        boolean itemSelected = this.calculatedItemsList.getSelectedIndex() >= 0;
        this.editB.setEnabled(itemSelected);
        this.deleteB.setEnabled(itemSelected);
        this.deleteAllB.setEnabled(this.calculatedItemsModel.getSize() > 0);
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && model instanceof CalculatedItemListInterface) {
            Object old = this.selectorModel;
            CalculatedItemListInterface cilModel = (CalculatedItemListInterface)model;
            this.selectorModel = cilModel;
            Map measureNameMap = cilModel.getMeasureNameMap();
            TreeMap sortedMeasureNameMap = new TreeMap(Collator.getInstance());
            sortedMeasureNameMap.putAll(measureNameMap);
            this.dataItems = new String[sortedMeasureNameMap.size()][2];
            int i = 0;
            for (Map.Entry entry : sortedMeasureNameMap.entrySet()) {
                this.dataItems[i][0] = (String)entry.getKey();
                this.dataItems[i][1] = (String)entry.getValue();
                ++i;
            }
            this.resetListFromModel(null);
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    private void resetListFromModel(CalculatedItemInterface itemToSelect) {
        CalculatedItemListInterface ciListModel = (CalculatedItemListInterface)this.selectorModel;
        this.calculatedItemsModel.clear();
        this.descTF.setText("");
        int selectionIndex = -1;
        List itemList = ciListModel.getCalculatedItemList();
        for (int i = 0; i < itemList.size(); ++i) {
            CalculatedItemInterface ci = (CalculatedItemInterface)itemList.get(i);
            this.calculatedItemsModel.addElement(new ListElement(ci, i));
            if (itemToSelect == null || !itemToSelect.getLabel().equals(ci.getLabel())) continue;
            selectionIndex = i;
        }
        if (itemToSelect != null && selectionIndex != -1) {
            this.calculatedItemsList.setSelectedIndex(selectionIndex);
        }
        this.setEnabledStateOfListManipulatingButtons();
    }

    @Override
    public String getDialogTitle() {
        return RB.getStringResource(RB_KEY, this.isRelational ? "relationalTitle.txt" : "olapTitle.txt");
    }

    @SASScope
    private static class ListElement {
        CalculatedItemInterface calculatedItemInterface;
        int index;
        String displayText;

        ListElement(CalculatedItemInterface calculatedItemInterface, int index) {
            this.calculatedItemInterface = calculatedItemInterface;
            this.index = index;
            this.displayText = calculatedItemInterface.getLabel();
        }

        public String toString() {
            return this.displayText;
        }
    }

    @SASScope
    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            CalculatedItemListInterface ciListModel = (CalculatedItemListInterface)SimpleCalculatedItemSelector.this.selectorModel;
            ListElement le = (ListElement)SimpleCalculatedItemSelector.this.calculatedItemsList.getSelectedValue();
            if (le == null) {
                SimpleCalculatedItemSelector.this.descTF.setText("");
            } else {
                CalculatedItemInterface ci = le.calculatedItemInterface;
                SimpleCalculatedItemSelector.this.descTF.setText(ci.getDescription());
            }
            SimpleCalculatedItemSelector.this.setEnabledStateOfListManipulatingButtons();
        }
    }

    @SASScope
    private class DeleteAllActionListener
    implements ActionListener {
        private Component component;

        DeleteAllActionListener(Component component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this.component, RB.getStringResource(SimpleCalculatedItemSelector.RB_KEY, "deleteAllQuestion.txt"), RB.getStringResource(SimpleCalculatedItemSelector.RB_KEY, "confirmDeleteDialogTitle.txt"), 0, 2) == 0) {
                CalculatedItemListInterface ciListModel = (CalculatedItemListInterface)SimpleCalculatedItemSelector.this.selectorModel;
                ciListModel.removeAllCalculatedItems();
                SimpleCalculatedItemSelector.this.resetListFromModel(null);
            }
        }
    }

    @SASScope
    private class DeleteActionListener
    implements ActionListener {
        private Component component;

        DeleteActionListener(Component component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this.component, RB.getStringResource(SimpleCalculatedItemSelector.RB_KEY, "deleteSelectedQuestion.txt"), RB.getStringResource(SimpleCalculatedItemSelector.RB_KEY, "confirmDeleteDialogTitle.txt"), 0, 2) == 0) {
                ListElement le = (ListElement)SimpleCalculatedItemSelector.this.calculatedItemsList.getSelectedValue();
                CalculatedItemListInterface ciListModel = (CalculatedItemListInterface)SimpleCalculatedItemSelector.this.selectorModel;
                ciListModel.setSelectionCursor(le.index);
                ciListModel.removeSelectedCalculatedItem();
                SimpleCalculatedItemSelector.this.resetListFromModel(null);
            }
        }
    }

    @SASScope
    private class NewEditActionListener
    implements ActionListener {
        private Component component;

        NewEditActionListener(Component component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalculatedItemInterface ci;
            JButton buttonPressed = (JButton)e.getSource();
            boolean edit = buttonPressed == SimpleCalculatedItemSelector.this.editB;
            CalculatedItemListInterface ciListModel = (CalculatedItemListInterface)SimpleCalculatedItemSelector.this.selectorModel;
            if (edit) {
                ListElement le = (ListElement)SimpleCalculatedItemSelector.this.calculatedItemsList.getSelectedValue();
                ciListModel.setSelectionCursor(le.index);
                ci = le.calculatedItemInterface;
            } else {
                ci = ciListModel.newCalculatedItem();
            }
            Frame parent = Util.getParentAWTFrame(this.component);
            if (parent == null) {
                parent = new Frame();
            }
            SimpleCalculatedItemEditPanel panel = new SimpleCalculatedItemEditPanel(ciListModel, ci, SimpleCalculatedItemSelector.this.isRelational, SimpleCalculatedItemSelector.this.dataItems, edit);
            OptionsDialog dialog = new OptionsDialog(parent, (PanelInterface)panel, true);
            String titleResource = SimpleCalculatedItemSelector.this.isRelational ? (edit ? "SimpleCalculatedItemEditPanel.editRelationalTitle.txt" : "SimpleCalculatedItemEditPanel.newRelationalTitle.txt") : (edit ? "SimpleCalculatedItemEditPanel.editOlapTitle.txt" : "SimpleCalculatedItemEditPanel.newOlapTitle.txt");
            dialog.setTitle(RB.getStringResource(titleResource));
            dialog.pack();
            Util.centerOverWindow(dialog, this.component);
            dialog.setVisible(true);
            if (!dialog.wasCancelled()) {
                if (edit) {
                    ciListModel.updateSelectedCalculatedItem(ci);
                } else {
                    ciListModel.addCalculatedItem(ci);
                }
                SimpleCalculatedItemSelector.this.resetListFromModel(ci);
            }
        }
    }
}

