/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemListInterface;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.dataselectors.calculateditems.AdvancedCalculatedItemSelector;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class AdvancedCalculatedItemListSelector
extends JComponent {
    public static final String RB_KEY = "AdvancedCalculatedItemListSelector.";
    String _addItemButtonLabel = RB.getStringResource("AdvancedCalculatedItemListSelector.", "AddItemButtonLabel.txt");
    String _updateItemButtonLabel = RB.getStringResource("AdvancedCalculatedItemListSelector.", "UpdateItemButtonLabel.txt");
    String _calculatedItemListLabel = RB.getStringResource("AdvancedCalculatedItemListSelector.", "CalculatedItemListLabel.txt");
    String _deleteItemButtonLabel = RB.getStringResource("AdvancedCalculatedItemListSelector.", "DeleteItemButtonLabel.txt");
    String _deleteAllItemsButtonLabel = RB.getStringResource("AdvancedCalculatedItemListSelector.", "DeleteAllItemsButtonLabel.txt");
    AdvancedCalculatedItemSelector _advancedCalculatedItemSelector;
    JList _listControl;
    JButton _buttonAddItem;
    JButton _buttonUpdateItem;
    JButton _buttonDeleteItem;
    JButton _buttonDeleteAllItems;
    InnerListSelectionListener _InnerListSelectionListener = null;
    InnerActionListener _InnerActionListener = null;
    boolean _isUpdateAllowed = false;
    CalculatedItemListInterface _listModel = null;
    CollectionToListModelAdapter _controlsListModel = new CollectionToListModelAdapter();

    public AdvancedCalculatedItemListSelector() {
        this.init();
    }

    public CalculatedItemListInterface getModel() {
        return this._listModel;
    }

    public void setModel(CalculatedItemListInterface listModel) {
        this._listModel = listModel;
        CalculatedItemInterface itemModel = null;
        if (this._listModel != null) {
            CalculatedItemInterface selectedItem = this._listModel.getSelectedCalculatedItem();
            itemModel = selectedItem == null ? this._listModel.newCalculatedItem() : this._listModel.newCalculatedItem(selectedItem);
        }
        this._controlsListModel.setModel(this._listModel.getCalculatedItemList());
        this._listControl.setModel(this._controlsListModel);
        this._advancedCalculatedItemSelector.setModel(itemModel);
        this.checkForEnabledButtons();
    }

    public void init() {
        this.setEnabled(false);
        this.createComponents();
        this.repaint(0L);
        this.addListeners();
        this.validate();
        this.setEnabled(true);
        this.repaint();
    }

    public void createComponents() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setName("AdvancedCalculatedItemListSelector");
        JPanel containItemEditor = new JPanel();
        containItemEditor.setLayout(new GridBagLayout());
        containItemEditor.setName("containItemEditor");
        containItemEditor.setOpaque(false);
        this._advancedCalculatedItemSelector = new AdvancedCalculatedItemSelector();
        this._advancedCalculatedItemSelector.setMinimumSize(new Dimension(300, 390));
        this._advancedCalculatedItemSelector.setName("advancedCalculatedItemSelector");
        containItemEditor.add((Component)this._advancedCalculatedItemSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel containAddUpdateButtons = new JPanel();
        containAddUpdateButtons.setLayout(new GridBagLayout());
        containAddUpdateButtons.setName("containAddUpdateButtons");
        containAddUpdateButtons.setOpaque(false);
        this._buttonAddItem = new JButton();
        this._buttonAddItem.setName("buttonAddItem");
        this._buttonAddItem.setText(this._addItemButtonLabel);
        containAddUpdateButtons.add((Component)this._buttonAddItem, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 0, new Insets(4, 4, 4, 4), 0, 0));
        this._buttonUpdateItem = new JButton();
        this._buttonUpdateItem.setName("buttonUpdateItem");
        this._buttonUpdateItem.setText(this._updateItemButtonLabel);
        containAddUpdateButtons.add((Component)this._buttonUpdateItem, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(4, 4, 4, 4), 0, 0));
        containItemEditor.add((Component)containAddUpdateButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridBagLayout());
        listPanel.setName("listPanel");
        listPanel.setOpaque(false);
        this._listControl = new JList();
        this._listControl.setModel(new DefaultListModel());
        this._listControl.setName("listControl");
        JScrollPane listScroll = new JScrollPane(this._listControl);
        listScroll.setMinimumSize(new Dimension(100, 50));
        listScroll.setName("listScroll");
        listPanel.add((Component)listScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 6, 0, 6), 0, 0));
        JLabel listLabel = new JLabel();
        listLabel.setName("listLabel");
        listLabel.setText(this._calculatedItemListLabel);
        listPanel.add((Component)listLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        JPanel containDeleteButtons = new JPanel();
        containDeleteButtons.setLayout(new GridBagLayout());
        containDeleteButtons.setName("containDeleteButtons");
        containDeleteButtons.setOpaque(false);
        this._buttonDeleteItem = new JButton();
        this._buttonDeleteItem.setName("buttonDeleteItem");
        this._buttonDeleteItem.setText(this._deleteItemButtonLabel);
        containDeleteButtons.add((Component)this._buttonDeleteItem, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 4, 4, 4), 0, 0));
        this._buttonDeleteAllItems = new JButton();
        this._buttonDeleteAllItems.setName("buttonDeleteAllItems");
        this._buttonDeleteAllItems.setText(this._deleteAllItemsButtonLabel);
        containDeleteButtons.add((Component)this._buttonDeleteAllItems, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(4, 4, 4, 4), 0, 0));
        listPanel.add((Component)containDeleteButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane splitEditorAndList = new JSplitPane(0, true, containItemEditor, listPanel);
        splitEditorAndList.setDividerLocation(400);
        splitEditorAndList.setName("splitEditorAndList");
        splitEditorAndList.setOpaque(false);
        splitEditorAndList.setResizeWeight(1.0);
        this.add((Component)splitEditorAndList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addListeners() {
        this._InnerListSelectionListener = new InnerListSelectionListener(this);
        this._listControl.addListSelectionListener(this._InnerListSelectionListener);
        this._InnerActionListener = new InnerActionListener(this);
        this._buttonAddItem.addActionListener(this._InnerActionListener);
        this._buttonUpdateItem.addActionListener(this._InnerActionListener);
        this._buttonDeleteItem.addActionListener(this._InnerActionListener);
        this._buttonDeleteAllItems.addActionListener(this._InnerActionListener);
        this._advancedCalculatedItemSelector.addPropertyChangeListener(new InnerChangeListener());
    }

    void processAddItemButton() {
        if (this._listModel == null) {
            return;
        }
        CalculatedItemInterface itemModel = this._advancedCalculatedItemSelector.getModel();
        if (itemModel == null) {
            return;
        }
        if (this._listModel.addCalculatedItem(itemModel)) {
            itemModel = this._listModel.newCalculatedItem();
            this._advancedCalculatedItemSelector.setModel(itemModel);
            this.clearSelectionState();
        }
    }

    void processDeleteAllItemsButton() {
        if (this._listModel == null) {
            return;
        }
        this._listModel.removeAllCalculatedItems();
        this.clearSelectionState();
    }

    void processDeleteItemButton() {
        if (this._listModel == null) {
            return;
        }
        CalculatedItemInterface itemModel = this._advancedCalculatedItemSelector.getModel();
        if (itemModel == null) {
            return;
        }
        CalculatedItemInterface selectedItem = this._listModel.getSelectedCalculatedItem();
        if (selectedItem == null) {
            return;
        }
        this._listModel.removeSelectedCalculatedItem();
        this.clearSelectionState();
    }

    void processListItemSelectedChanged() {
        int index = this._listControl.getSelectedIndex();
        this._listModel.setSelectionCursor(index);
        CalculatedItemInterface selectedItem = this._listModel.getSelectedCalculatedItem();
        if (selectedItem == null) {
            return;
        }
        CalculatedItemInterface itemModel = this._listModel.newCalculatedItem(selectedItem);
        this._advancedCalculatedItemSelector.setModel(itemModel);
        this._isUpdateAllowed = true;
        this.checkForEnabledButtons();
    }

    void processUpdateItemButton() {
        if (this._listModel == null) {
            return;
        }
        CalculatedItemInterface itemModel = this._advancedCalculatedItemSelector.getModel();
        if (itemModel == null) {
            return;
        }
        CalculatedItemInterface selectedItem = this._listModel.getSelectedCalculatedItem();
        if (selectedItem == null) {
            return;
        }
        if (selectedItem == itemModel) {
            return;
        }
        this._listModel.updateSelectedCalculatedItem(itemModel);
        this._controlsListModel.refresh();
        itemModel = this._listModel.newCalculatedItem(selectedItem);
        this._advancedCalculatedItemSelector.setModel(itemModel);
        this._isUpdateAllowed = true;
        this.checkForEnabledButtons();
    }

    void checkForEnabledButtons() {
        CalculatedItemInterface itemModel = this._advancedCalculatedItemSelector.getModel();
        boolean turnItOn = itemModel.validate(false);
        this._buttonAddItem.setEnabled(turnItOn);
        this._buttonUpdateItem.setEnabled(turnItOn && this._isUpdateAllowed);
        boolean turnDeleteAllOn = this._listModel.getSelectionCount() > 0;
        boolean turnDeleteItemOn = this._listControl.getSelectedIndex() != -1;
        this._buttonDeleteAllItems.setEnabled(turnDeleteAllOn);
        this._buttonDeleteItem.setEnabled(turnDeleteItemOn);
    }

    void clearSelectionState() {
        this._listControl.clearSelection();
        this._listModel.clearSelectionCursor();
        this._controlsListModel.refresh();
        CalculatedItemInterface itemModel = this._listModel.newCalculatedItem();
        this._advancedCalculatedItemSelector.setModel(itemModel);
        this._isUpdateAllowed = false;
        this.checkForEnabledButtons();
    }

    public ExpressionBuilderPanel getExpressionBuilderPanel() {
        return this._advancedCalculatedItemSelector.getExpressionBuilderPanel();
    }

    public String getDefaultHelpProduct() {
        return this._advancedCalculatedItemSelector.getDefaultHelpProduct();
    }

    public String getDefaultHelpMapID() {
        return this._advancedCalculatedItemSelector.getDefaultHelpMapID();
    }

    public SASJavaHelp getDefaultSASJavaHelp() {
        return this._advancedCalculatedItemSelector.getDefaultSASJavaHelp();
    }

    @SASScope
    class InnerChangeListener
    implements PropertyChangeListener {
        InnerChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            Object id = event.getPropagationId();
            String name = event.getPropertyName();
            if (name != null && (name == AdvancedCalculatedItemSelector.EXPRESSION_TEXT || name == AdvancedCalculatedItemSelector.EXPRESSION_NAME || name == AdvancedCalculatedItemSelector.EXPRESSION_DESCRIPTION || name == AdvancedCalculatedItemSelector.EXPRESSION_TYPE)) {
                AdvancedCalculatedItemListSelector.this.checkForEnabledButtons();
            }
        }
    }

    @SASScope
    private class InnerListSelectionListener
    implements ListSelectionListener {
        AdvancedCalculatedItemListSelector m_container;

        public InnerListSelectionListener(AdvancedCalculatedItemListSelector container) {
            this.m_container = container;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            try {
                if (event.getSource() == this.m_container._listControl) {
                    if (!event.getValueIsAdjusting()) {
                        this.m_container.processListItemSelectedChanged();
                    }
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SASScope
    private class InnerActionListener
    implements ActionListener {
        AdvancedCalculatedItemListSelector m_container;

        public InnerActionListener(AdvancedCalculatedItemListSelector container) {
            this.m_container = container;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (event.getSource() == this.m_container._buttonAddItem) {
                    this.m_container.processAddItemButton();
                    return;
                }
                if (event.getSource() == this.m_container._buttonDeleteAllItems) {
                    this.m_container.processDeleteAllItemsButton();
                    return;
                }
                if (event.getSource() == this.m_container._buttonDeleteItem) {
                    this.m_container.processDeleteItemButton();
                    return;
                }
                if (event.getSource() == this.m_container._buttonUpdateItem) {
                    this.m_container.processUpdateItemButton();
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

