/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;

@SASScope
public class UnderlineIcon
implements Icon {
    private boolean draw;

    public UnderlineIcon(boolean draw) {
        this.draw = draw;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.draw) {
            String label = ((AbstractButton)c).getText();
            FontMetrics fm = g.getFontMetrics();
            int lineWidth = fm.stringWidth(label);
            int heightOffSet = fm.getHeight() / 2 - 1;
            g.setColor(c.getForeground());
            int leftInsets = ((AbstractButton)c).getInsets().left;
            int xStart = x + leftInsets + 1;
            g.drawLine(xStart, y + heightOffSet, xStart + lineWidth, y + heightOffSet);
        }
    }

    @Override
    public int getIconWidth() {
        return 0;
    }

    @Override
    public int getIconHeight() {
        return 0;
    }
}

