/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.CheckBoxListSelectionModel;
import java.util.BitSet;

public class TriStateCheckBoxListSelectionModel
extends CheckBoxListSelectionModel {
    private static final int MIN = -1;
    private static final int MAX = Integer.MAX_VALUE;
    private int minIndex = Integer.MAX_VALUE;
    private int maxIndex = -1;
    private BitSet mixedValue = new BitSet(32);
    private BitSet selectedValue = new BitSet(32);
    protected boolean cycleEnabled = true;
    protected boolean updateEnabled = true;

    public void setSelectedIndexValue(int index, int value) {
        if (value == 1) {
            this.setStates(index, true, true);
        } else if (value == 2) {
            this.setStates(index, false, true);
        } else if (value == 0) {
            this.setStates(index, false, false);
        }
    }

    public int getSelectedIndexValue(int index) {
        if (this.selectedValue.get(index)) {
            if (this.mixedValue.get(index)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        int minIntervalIndex = Math.min(index0, index1);
        int maxIntervalIndex = Math.max(index0, index1);
        if (this.isUpdateEnabled()) {
            for (int i = minIntervalIndex; i <= maxIntervalIndex; ++i) {
                if (this.getSelectedIndexValue(i) == 1) {
                    this.addSelectionInterval(i, i);
                    continue;
                }
                if (this.getSelectedIndexValue(i) == 2) {
                    this.removeSelectionInterval(i, i);
                    continue;
                }
                if (this.isCycleEnabled()) {
                    this.addMixedSelectionInterval(i, i);
                    continue;
                }
                this.addSelectionInterval(i, i);
            }
        } else {
            for (int i = minIntervalIndex; i <= maxIntervalIndex; ++i) {
                if (this.getSelectedIndexValue(i) == 0) {
                    this.removeSelectionInterval(i, i);
                    continue;
                }
                if (this.getSelectedIndexValue(i) == 2) {
                    this.addSelectionInterval(i, i);
                    continue;
                }
                this.addMixedSelectionInterval(i, i);
            }
        }
    }

    public void addMixedSelectionInterval(int index0, int index1) {
        super.addSelectionInterval(index0, index1);
        if (index0 == -1 || index1 == -1) {
            return;
        }
        int minIntervalIndex = Math.min(index0, index1);
        int maxIntervalIndex = Math.max(index0, index1);
        for (int i = minIntervalIndex; i <= maxIntervalIndex; ++i) {
            this.setSelectedIndexValue(i, 1);
        }
        this.fireValueChanged(index0, index1);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        super.addSelectionInterval(index0, index1);
        if (index0 == -1 || index1 == -1) {
            return;
        }
        int minIntervalIndex = Math.min(index0, index1);
        int maxIntervalIndex = Math.max(index0, index1);
        for (int i = minIntervalIndex; i <= maxIntervalIndex; ++i) {
            this.setSelectedIndexValue(i, 2);
        }
        this.fireValueChanged(index0, index1);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        super.removeSelectionInterval(index0, index1);
        if (index0 == -1 || index1 == -1) {
            return;
        }
        int minIntervalIndex = Math.min(index0, index1);
        int maxIntervalIndex = Math.max(index0, index1);
        for (int i = minIntervalIndex; i <= maxIntervalIndex; ++i) {
            this.setSelectedIndexValue(i, 0);
        }
        this.fireValueChanged(index0, index1);
    }

    @Override
    public void clearSelection() {
        this.removeSelectionInterval(this.minIndex, this.maxIndex);
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        super.insertIndexInterval(index, length, before);
        int insMinIndex = before ? index : index + 1;
        int insMaxIndex = insMinIndex + length - 1;
        for (int i = this.maxIndex; i >= insMinIndex; --i) {
            this.setStates(i + length, this.mixedValue.get(i), this.selectedValue.get(i));
        }
        boolean setMixedInsertedValues = this.mixedValue.get(index);
        boolean setSelectedInsertedValues = this.selectedValue.get(index);
        for (int i = insMinIndex; i <= insMaxIndex; ++i) {
            this.setStates(i, setMixedInsertedValues, setSelectedInsertedValues);
        }
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        super.removeIndexInterval(index0, index1);
        int rmMinMixedIndex = Math.min(index0, index1);
        int rmMaxMixedIndex = Math.max(index0, index1);
        int gapLength = rmMaxMixedIndex - rmMinMixedIndex + 1;
        for (int i = rmMinMixedIndex; i <= this.maxIndex; ++i) {
            this.setStates(i, this.mixedValue.get(i + gapLength), this.selectedValue.get(i + gapLength));
        }
    }

    protected void setStates(int index, boolean mixedState, boolean selectedState) {
        this.setMixedState(index, mixedState);
        this.setSelectedState(index, selectedState);
        if (mixedState || selectedState) {
            this.minIndex = Math.min(this.minIndex, index);
            this.maxIndex = Math.max(this.maxIndex, index);
        } else {
            if (index == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.selectedValue.get(this.minIndex) && !this.mixedValue.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (index == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.selectedValue.get(this.maxIndex) && !this.mixedValue.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }
    }

    protected void setMixedState(int index, boolean state) {
        if (state) {
            if (this.mixedValue.get(index)) {
                return;
            }
            this.mixedValue.set(index);
        } else {
            if (!this.mixedValue.get(index)) {
                return;
            }
            this.mixedValue.clear(index);
        }
    }

    protected void setSelectedState(int index, boolean state) {
        if (state) {
            if (this.selectedValue.get(index)) {
                return;
            }
            this.selectedValue.set(index);
        } else {
            if (!this.selectedValue.get(index)) {
                return;
            }
            this.selectedValue.clear(index);
        }
    }

    public void setCycleEnabled(boolean b) {
        if (this.isCycleEnabled() != b) {
            this.cycleEnabled = b;
        }
    }

    public boolean isCycleEnabled() {
        return this.cycleEnabled;
    }

    public void setUpdateEnabled(boolean b) {
        if (this.isUpdateEnabled() != b) {
            this.updateEnabled = b;
        }
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }
}

