/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.LimitedPlainDocument;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

@SASScope
public class LimitedTextArea
extends JTextArea {
    public LimitedTextArea() {
    }

    public LimitedTextArea(int rows, int columns) {
        super(rows, columns);
    }

    public LimitedTextArea(String text) {
        super(text);
    }

    public LimitedTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitedPlainDocument();
    }

    public int getMaxCharacters() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            return ((LimitedPlainDocument)doc).getMaxCharacters();
        }
        return Integer.MAX_VALUE;
    }

    public void setMaxCharacters(int maxCharacters) {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            int length = doc.getLength();
            if (length > maxCharacters) {
                try {
                    ((LimitedPlainDocument)doc).remove(maxCharacters, length - maxCharacters);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ((LimitedPlainDocument)doc).setMaxCharacters(maxCharacters);
        }
    }

    public int getMaxLines() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            return ((LimitedPlainDocument)doc).getMaxLines();
        }
        return Integer.MAX_VALUE;
    }

    public void setMaxLines(int maxLines) {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            int lines = ((LimitedPlainDocument)doc).getNumberOfLines();
            if (lines > maxLines) {
                try {
                    String text = this.getText();
                    int index = text.indexOf("\n");
                    for (int count = 1; count < maxLines; ++count) {
                        index = text.indexOf("\n", index);
                    }
                    ((LimitedPlainDocument)doc).remove(index, doc.getLength() - index);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ((LimitedPlainDocument)doc).setMaxLines(maxLines);
        }
    }

    public boolean isBeepEnabled() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            return ((LimitedPlainDocument)doc).isBeepEnabled();
        }
        return false;
    }

    public void setBeepEnabled(boolean beepEnabled) {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            ((LimitedPlainDocument)doc).setBeepEnabled(beepEnabled);
        }
    }
}

