/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.PromptUtil;
import com.sas.swing.visuals.DataTypeFormatter;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.text.Message;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.JTextComponent;

@SASScope
public class IntegerEditor
extends TextEditor {
    private DataTypeInterface intType;
    private boolean listenersRemoved;

    @Override
    public Object getValue() {
        Object val;
        if (this.comboBox != null && (val = this.comboBox.getSelectedItem()) instanceof ValueItem) {
            return ((ValueItem)val).getValue();
        }
        try {
            if (this.edited && !this.isHandlingError()) {
                ((JFormattedTextField)this.textComponent).commitEdit();
            }
        }
        catch (ParseException parseException) {
        }
        finally {
            this.edited = false;
        }
        return ((JFormattedTextField)this.textComponent).getValue();
    }

    @Override
    public void setValue(Object anObject) {
        if (this.comboBox != null) {
            super.setValue(anObject);
        } else {
            ((JFormattedTextField)this.textComponent).setValue(anObject);
            this.valueModified = false;
            this.fireValueChanged();
        }
    }

    @Override
    protected DataTypeInterface getDataType() {
        if (this.intType == null) {
            this.intType = IntegerType.DEFAULT_INSTANCE;
        }
        return this.intType;
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        this.listenersRemoved = true;
    }

    @Override
    protected JTextComponent createTextComponent() {
        DataTypeFormatter formatter = new DataTypeFormatter(this.getDataType());
        JFormattedTextField textField = new JFormattedTextField(formatter){

            @Override
            protected void invalidEdit() {
            }

            @Override
            public void commitEdit() throws ParseException {
                if (IntegerEditor.this.listenersRemoved) {
                    return;
                }
                Object oldValue = this.getValue();
                try {
                    super.commitEdit();
                    Object val = this.getValue();
                    if (!IntegerEditor.this.isValueAllowed(val)) {
                        throw new ParseException(Message.format((String)RB.getStringResource("notPermittedValue.fmt.txt", IntegerEditor.this.getLocale()), (Object)val), 0);
                    }
                }
                catch (ParseException ex) {
                    IntegerEditor.this.handleError(ex);
                    this.setValue(oldValue);
                    throw ex;
                }
            }
        };
        textField.setFocusLostBehavior(1);
        textField.setColumns(10);
        return textField;
    }

    @Override
    protected void configureUI() {
        this.configureUI(true);
    }

    @Override
    protected boolean isValueAllowed(Object value) {
        boolean ret = super.isValueAllowed(value);
        if (ret) {
            ret = PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)this.getSupportedSpecialValues(), (Object)value);
        }
        return ret;
    }
}

