/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.net.AppletResourceLocator;
import com.sas.net.BaseResourceLocator;
import com.sas.net.ClassResourceLocator;
import com.sas.net.ContextResourceLocator;
import com.sas.net.FileResourceLocator;
import com.sas.net.ResourceConsumerInterface;
import com.sas.net.ResourceLocatorInterface;
import com.sas.security.SecuritySupport;
import com.sas.swing.visuals.BaseBorder;
import com.sas.swing.visuals.ImageConsumerList;
import com.sas.swing.visuals.RB;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ResizeToFitInterface;
import com.sas.visuals.Resources;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.TileImageFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ImageView
extends JComponent
implements Icon,
IconInterface,
ResizeToFitInterface,
PublicClonable,
PropertyChangeListener,
ResourceConsumerInterface {
    static final long serialVersionUID = -4747809423684047093L;
    public static final String RB_KEY = "ImageView.";
    public static final int NO_SCALE = 0;
    public static final int SCALE = 1;
    public static final int SCALE_HEIGHT = 2;
    public static final int SCALE_WIDTH = 3;
    public static final int TILE = 4;
    public static final int AUTO_SCALE = 5;
    public static final int LAST_DISPLAY_MODE = 5;
    protected transient Image image;
    protected transient Image dispImage;
    protected transient Image filteredImage;
    protected transient Image disabledImage;
    protected transient Image missingImage;
    protected transient int oldWidth;
    protected transient int oldHeight;
    protected Insets currentInsets;
    protected String source;
    protected boolean imageWait;
    protected int displayMode;
    protected boolean defaultImageLoaded;
    protected String absoluteSource;
    protected String relativeSourceClassName;
    protected transient Class relativeSourceClass;
    protected String relativeSource;
    protected URL sourceURL;
    protected boolean sourceAppletRelative;
    protected ResourceLocatorInterface resourceLocator;
    private transient ImageConsumerList consumerListFilter;
    private transient MediaTracker imageTracker;
    private transient boolean prevResizeToFit;
    private transient boolean imageDone;
    private boolean resizeToFit;
    private ImageFilter imageFilter;
    private transient ClassResourceLocator missingFileLocator;
    private boolean fileNotFound;
    private static String[] requiredInterfacesString = new String[]{"com.sas.langc.StringDataInterface"};
    private static int defaultHeight = 32;
    private static int defaultWidth = 32;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "displayMode"}, {"Description", RB.getStringResource(RB_KEY, "displayMode.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ImageViewDisplayModeEditor"}}, {{"Name", "image"}, {"Description", RB.getStringResource(RB_KEY, "image.pd.txt")}, {"Hidden", "true"}}, {{"Name", "imageFilter"}, {"Description", RB.getStringResource(RB_KEY, "imageFilter.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ImageFilterEditor"}}, {{"Name", "imageLoadWait"}, {"Description", RB.getStringResource(RB_KEY, "imageLoadWait.pd.txt")}, {"Expert", "true"}}, {{"Name", "sourceAbsolute"}, {"Description", RB.getStringResource(RB_KEY, "sourceAbsolute.pd.txt")}, {"Property editor class", "com.sas.beans.editors._FileNameEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "source";
        ebi.defaultOutputPropertyName = "source";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public ImageView() {
        this.setDefaultValues();
        if (com.sas.beans.Util.isDesignTime()) {
            this.setImage(Resources.getImage((String)RB.getStringResource(RB_KEY, "defaultDesignImage.image")));
            this.defaultImageLoaded = true;
        }
    }

    public ImageView(URL srcURL) {
        this.setDefaultValues();
        this.setSourceURL(srcURL);
    }

    public ImageView(Class relativeClass, String relativeSrc) {
        this.setDefaultValues();
        this.setRelativeSourceClass(relativeClass);
        this.setSourceRelative(relativeSrc);
    }

    public ImageView(String src) {
        this.setDefaultValues();
        this.setSource(src);
    }

    public ImageView(Image img) {
        this.setDefaultValues();
        this.setImage(img);
    }

    public ImageView(ResourceLocatorInterface resourceLocator) {
        this.setDefaultValues();
        this.setResourceLocator(resourceLocator);
    }

    public Object clone() throws CloneNotSupportedException {
        ImageView clone;
        try {
            clone = (ImageView)super.clone();
        }
        catch (Exception ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
        if (this.getResourceLocator() instanceof BaseResourceLocator) {
            clone.resourceLocator = (ResourceLocatorInterface)((BaseResourceLocator)this.getResourceLocator()).clone();
            if (clone.resourceLocator != null && clone.resourceLocator instanceof BaseResourceLocator) {
                ((BaseResourceLocator)clone.resourceLocator).addPropertyChangeListener((PropertyChangeListener)clone);
            }
            clone.loadImage();
        }
        return clone;
    }

    private Image getImage(Object src) {
        String imageSourceString;
        this.fileNotFound = false;
        URL imageSourceURL = null;
        if (src instanceof URL) {
            imageSourceURL = (URL)src;
            imageSourceString = imageSourceURL.toExternalForm();
        } else {
            imageSourceString = (String)src;
        }
        if (src != null && imageSourceString.length() != 0) {
            try {
                if (imageSourceURL != null) {
                    return SecuritySupport.securitySupport.getImage(imageSourceURL);
                }
                return SecuritySupport.securitySupport.getImage(imageSourceString);
            }
            catch (IOException e) {
                System.out.println(e);
                this.fileNotFound = true;
            }
            catch (ImageException e) {
                System.out.println(e);
                this.fileNotFound = true;
            }
        } else if (this.getResourceLocator() != null && this.getSource() != null) {
            System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "invalidImage.txt.ex"), (Object)this.getSource()));
            this.fileNotFound = true;
        }
        return null;
    }

    private Image getBrokenImage() {
        return this.getBrokenImage(this.getResourceForResourceLocator((ResourceLocatorInterface)this.missingFileLocator));
    }

    private Image getBrokenImage(URL src) {
        try {
            return SecuritySupport.securitySupport.getImage(src);
        }
        catch (IOException iOException) {
        }
        catch (ImageException imageException) {
            // empty catch block
        }
        return null;
    }

    public static final boolean imageExists(ResourceLocatorInterface rli) {
        try {
            String imageSourceString = null;
            URL imageSourceURL = rli.getResource();
            if (imageSourceURL != null) {
                imageSourceString = imageSourceURL.toExternalForm();
            }
            if (imageSourceString != null && imageSourceString.length() != 0 && SecuritySupport.securitySupport.getImage(imageSourceURL) != null) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public Image getMissingFileImage() {
        if (this.missingImage == null) {
            this.missingImage = this.getBrokenImage();
        }
        return this.missingImage;
    }

    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public Image createFilteredImage(Image img, ImageFilter imgFilter) {
        if (img != null) {
            Image icImage = this.createImage(new FilteredImageSource(img.getSource(), this.consumerListFilter));
            FilteredImageSource filteredSource = new FilteredImageSource(icImage.getSource(), imgFilter);
            return this.createImage(filteredSource);
        }
        return null;
    }

    protected Image createTiledImage(Image img, int width, int height) {
        return this.createFilteredImage(this.dispImage, new TileImageFilter(width, height));
    }

    protected Image createDisabledImage(Image img) {
        return this.createFilteredImage(this.dispImage, new GrayFilter(true, 50));
    }

    protected synchronized void createDisplayImage(int width, int height) {
        MediaTracker tracker = this.getMediaTracker();
        if (this.dispImage != null) {
            tracker.removeImage(this.dispImage);
            this.consumerListFilter.removeConsumers(this.dispImage.getSource());
        }
        if (this.disabledImage != null) {
            tracker.removeImage(this.disabledImage);
            this.consumerListFilter.removeConsumers(this.disabledImage.getSource());
        }
        this.disabledImage = null;
        if (!this.fileNotFound) {
            if (this.getImageFilter() != null) {
                this.dispImage = this.filteredImage;
            } else if (this.image != null) {
                this.dispImage = this.createImage(new FilteredImageSource(this.image.getSource(), this.consumerListFilter));
            }
            if (this.displayMode == 4 && this.image != null && width != 0 && height != 0) {
                this.dispImage = this.createTiledImage(this.dispImage, width, height);
            }
        } else {
            if (this.missingImage == null) {
                this.missingImage = this.getBrokenImage();
            }
            this.dispImage = this.createImage(new FilteredImageSource(this.missingImage.getSource(), this.consumerListFilter));
        }
        if (this.dispImage != null) {
            tracker.addImage(this.dispImage, 0);
        }
    }

    protected void loadDisplayImage() {
        if (this.image != null || this.fileNotFound) {
            if (this.imageWait) {
                try {
                    MediaTracker tracker = this.getMediaTracker();
                    tracker.waitForAll();
                    this.imageDone = !tracker.isErrorAny();
                }
                catch (InterruptedException e) {
                    this.imageDone = false;
                }
            } else {
                if (this.disabledImage != null) {
                    this.prepareImage(this.disabledImage, this);
                }
                this.imageDone = this.prepareImage(this.dispImage, this);
            }
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public Image getImage() {
        return this.image;
    }

    public ImageFilter getImageFilter() {
        return this.imageFilter;
    }

    public boolean isImageLoadWait() {
        return this.imageWait;
    }

    public MediaTracker getMediaTracker() {
        if (this.imageTracker == null) {
            this.imageTracker = new MediaTracker(this);
        }
        return this.imageTracker;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension min = new Dimension();
        Insets insets = this.getInsets();
        min.width = insets.left + insets.right;
        min.height = insets.top + insets.bottom;
        if (this.image != null) {
            if (this.getImageFilter() != null) {
                min.width += this.filteredImage.getWidth(this);
                min.height += this.filteredImage.getHeight(this);
            } else {
                min.width += this.image.getWidth(this);
                min.height += this.image.getHeight(this);
            }
        } else if (this.fileNotFound) {
            if (this.missingImage == null) {
                this.missingImage = this.getBrokenImage();
            }
            min.width += this.missingImage.getWidth(this);
            min.height += this.missingImage.getHeight(this);
        }
        return min;
    }

    public Dimension computePreferredSize() {
        return this.getMinimumSize();
    }

    public String getSource() {
        return this.resourceLocator.getResourceName();
    }

    @Override
    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if ((this.image != null || this.fileNotFound) && this.imageDone) {
            Insets insets = this.getInsets();
            Dimension userSize = this.getSize();
            userSize.width = userSize.width - insets.left - insets.right;
            userSize.height = userSize.height - insets.top - insets.bottom;
            this.paintComponent(this, g, insets.left, insets.top, userSize.width, userSize.height);
        } else if (!this.imageDone) {
            this.loadDisplayImage();
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if ((this.image != null || this.fileNotFound) && this.imageDone) {
            this.paintComponent(c, g, x, y, this.getIconWidth(), this.getIconHeight());
        } else if (!this.imageDone) {
            this.loadDisplayImage();
        }
    }

    @Override
    public int getIconWidth() {
        if ((this.image != null || this.fileNotFound) && this.imageDone) {
            if (this.fileNotFound) {
                if (this.missingImage == null) {
                    this.missingImage = this.getBrokenImage();
                }
                return this.missingImage.getWidth(this);
            }
            return this.image.getWidth(this);
        }
        if (!this.imageDone) {
            this.loadDisplayImage();
        }
        return this.oldWidth;
    }

    @Override
    public int getIconHeight() {
        if ((this.image != null || this.fileNotFound) && this.imageDone) {
            if (this.fileNotFound) {
                if (this.missingImage == null) {
                    this.missingImage = this.getBrokenImage();
                }
                return this.missingImage.getHeight(this);
            }
            return this.image.getHeight(this);
        }
        if (!this.imageDone) {
            this.loadDisplayImage();
        }
        return this.oldHeight;
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        this.paintComponent(comp, g, x, y, width, height);
    }

    public void paintComponent(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.image == null && !this.fileNotFound) {
            return;
        }
        if (this.fileNotFound && this.dispImage == null) {
            if (this.missingImage == null) {
                this.missingImage = this.getBrokenImage();
            }
            this.dispImage = this.createImage(new FilteredImageSource(this.missingImage.getSource(), this.consumerListFilter));
        }
        if (width != this.oldWidth && !this.fileNotFound || height != this.oldHeight && !this.fileNotFound) {
            int imageWidth = 0;
            int imageHeight = 0;
            if (this.dispImage != null) {
                imageWidth = this.dispImage.getWidth(comp);
                imageHeight = this.dispImage.getHeight(comp);
            }
            if (this.displayMode == 4 && (width > imageWidth || height > imageHeight)) {
                this.createDisplayImage(width, height);
                this.loadDisplayImage();
            }
            this.oldWidth = width;
            this.oldHeight = height;
        }
        if (this.dispImage == null) {
            return;
        }
        Image displayImage = this.dispImage;
        if (!comp.isEnabled() && !this.fileNotFound) {
            if (this.disabledImage == null) {
                this.disabledImage = this.createDisabledImage(this.dispImage);
                MediaTracker tracker = this.getMediaTracker();
                tracker.addImage(this.disabledImage, 0);
                this.loadDisplayImage();
            }
            displayImage = this.disabledImage;
        }
        Shape clip = g.getClip();
        g.clipRect(x, y, width, height);
        if (this.isOpaque()) {
            Insets insets = this.getInsets();
            g.setClip(insets.left, insets.top, width, height);
            g.setColor(this.getBackground());
            g.fillRect(insets.left, insets.top, width, height);
        }
        float imgWidth = this.dispImage.getWidth(comp);
        float imgHeight = this.dispImage.getHeight(comp);
        if (this.displayMode == 1 && !this.fileNotFound) {
            g.drawImage(displayImage, x, y, width, height, comp);
        } else if (this.displayMode == 2 && !this.fileNotFound) {
            g.drawImage(displayImage, x, y, (int)((float)height / imgHeight * imgWidth), height, comp);
        } else if (this.displayMode == 3 && !this.fileNotFound) {
            g.drawImage(displayImage, x, y, width, (int)((float)width / imgWidth * imgHeight), comp);
        } else if (this.displayMode == 5 && !this.fileNotFound) {
            float aspectRatio = imgWidth / imgHeight;
            float sizeRatio = (float)width / (float)height;
            if (aspectRatio > sizeRatio) {
                g.drawImage(displayImage, x, y, width, (int)((float)width / imgWidth * imgHeight), comp);
            } else {
                g.drawImage(displayImage, x, y, (int)((float)height / imgHeight * imgWidth), height, comp);
            }
        } else if (this.displayMode == 4 && !this.fileNotFound) {
            g.drawImage(displayImage, x, y, comp);
        } else {
            int imgWid = displayImage.getWidth(comp);
            int imgHt = displayImage.getHeight(comp);
            if (width > imgWid) {
                x += (width - imgWid) / 2;
            }
            if (height > imgHt) {
                y += (height - imgHt) / 2;
            }
            g.drawImage(displayImage, x, y, comp);
        }
        g.setClip(clip);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.resourceLocator) {
            this.loadImage();
        }
    }

    public void refresh() {
    }

    public void resizeToFit() {
        if (this.isResizeToFit() && this.imageDone && this.isDisplayable() && !this.fileNotFound) {
            this.setSize(this.getPreferredSize());
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                parent.validate();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computePreferredSize();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (border instanceof BaseBorder) {
            ((BaseBorder)border).setComponent(this);
        }
    }

    @Override
    public synchronized void setBounds(int x, int y, int width, int height) {
        if (!this.isResizeToFit()) {
            super.setBounds(x, y, width, height);
        } else {
            Dimension pSize = this.getPreferredSize();
            super.setBounds(x, y, pSize.width, pSize.height);
        }
    }

    public void setDefaultValues() {
        this.setDoubleBuffered(true);
        this.imageDone = false;
        this.resizeToFit = false;
        this.source = null;
        this.absoluteSource = null;
        this.sourceURL = null;
        this.relativeSourceClass = null;
        this.relativeSourceClassName = null;
        this.relativeSource = null;
        this.oldWidth = -1;
        this.oldHeight = -1;
        this.displayMode = 0;
        this.prevResizeToFit = this.resizeToFit;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.setImageLoadWait(true);
        this.defaultImageLoaded = false;
        this.consumerListFilter = new ImageConsumerList();
        this.setResourceLocator((ResourceLocatorInterface)new AppletResourceLocator());
        this.missingFileLocator = new ClassResourceLocator();
        this.missingFileLocator.setRelativeClass(AutoSizingGridLayout.class);
        this.missingFileLocator.setResourceName("res/FileMissing.gif");
        this.fileNotFound = false;
    }

    public synchronized void setDisplayMode(int mode) {
        if (!this.validateDisplayMode(mode)) {
            throw new IllegalArgumentException();
        }
        if (mode != this.displayMode) {
            int oldMode = this.displayMode;
            this.displayMode = mode;
            if (this.displayMode == 0) {
                this.resizeToFit = this.prevResizeToFit;
                this.firePropertyChange("resizeToFit", new Boolean(this.prevResizeToFit), new Boolean(this.resizeToFit));
            } else if (this.resizeToFit) {
                this.prevResizeToFit = this.resizeToFit;
                this.resizeToFit = false;
                this.firePropertyChange("resizeToFit", new Boolean(this.prevResizeToFit), new Boolean(this.resizeToFit));
            }
            if (this.displayMode == 4) {
                this.oldWidth = -1;
                this.oldHeight = -1;
            }
            Dimension size = this.getSize();
            this.createDisplayImage(size.width, size.height);
            this.loadDisplayImage();
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("displayMode", new Integer(oldMode), new Integer(this.displayMode));
        }
    }

    protected boolean validateDisplayMode(int mode) {
        return mode >= 0 && mode <= 5;
    }

    @Override
    public synchronized void setResizeToFit(boolean resizeToFit) {
        if (this.resizeToFit != resizeToFit) {
            boolean oldValue = this.resizeToFit;
            this.resizeToFit = resizeToFit;
            this.prevResizeToFit = resizeToFit;
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("resizeToFit", new Boolean(oldValue), new Boolean(resizeToFit));
        }
    }

    public void setImage(Image img) {
        if (!Util.equal((Object)img, (Object)this.image) || this.fileNotFound) {
            this.defaultImageLoaded = false;
            Image oldImage = this.image;
            this.image = img;
            Image oldFilteredImage = this.filteredImage;
            ImageFilter filter = this.getImageFilter();
            if (filter != null && this.image != null) {
                this.filteredImage = this.createImage(new FilteredImageSource(img.getSource(), filter));
            }
            MediaTracker tracker = this.getMediaTracker();
            if (oldFilteredImage != null) {
                tracker.removeImage(oldFilteredImage);
            }
            if (oldImage != null) {
                tracker.removeImage(oldImage);
            }
            if (this.image != null) {
                tracker.addImage(this.image, 0);
            }
            Dimension size = this.getSize();
            this.createDisplayImage(size.width, size.height);
            this.loadDisplayImage();
            this.resizeToFit();
            this.repaint();
            this.firePropertyChange("image", oldImage, this.image);
        }
    }

    public synchronized void setImageFilter(ImageFilter imgFilter) {
        ImageFilter oldFilter = this.imageFilter;
        this.imageFilter = imgFilter;
        Image oldFilteredImage = this.filteredImage;
        this.filteredImage = this.imageFilter != null && this.image != null ? this.createImage(new FilteredImageSource(this.image.getSource(), this.imageFilter)) : null;
        MediaTracker tracker = this.getMediaTracker();
        if (oldFilteredImage != null) {
            tracker.removeImage(oldFilteredImage);
        }
        if (this.filteredImage != null) {
            tracker.addImage(this.filteredImage, 0);
        }
        Dimension size = this.getSize();
        this.createDisplayImage(size.width, size.height);
        this.loadDisplayImage();
        this.resizeToFit();
        this.repaint();
        this.firePropertyChange("imageFilter", oldFilter, this.imageFilter);
    }

    public void setImageLoadWait(boolean loadWait) {
        if (loadWait != this.imageWait) {
            this.imageWait = loadWait;
            this.firePropertyChange("imageLoadWait", new Boolean(!this.imageWait), new Boolean(this.imageWait));
        }
    }

    @Override
    public synchronized void setResourceLocator(ResourceLocatorInterface newValue) {
        if (!Util.equal((Object)this.resourceLocator, (Object)newValue)) {
            ResourceLocatorInterface oldValue = this.resourceLocator;
            if (oldValue != null && oldValue instanceof BaseResourceLocator) {
                ((BaseResourceLocator)oldValue).removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.resourceLocator = newValue;
            if (this.resourceLocator != null && this.resourceLocator instanceof BaseResourceLocator) {
                ((BaseResourceLocator)this.resourceLocator).addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.loadImage();
            this.firePropertyChange("resourceLocator", oldValue, newValue);
        }
    }

    @Override
    public ResourceLocatorInterface getResourceLocator() {
        return this.resourceLocator;
    }

    public synchronized void setSource(String newValue) {
        String oldValue;
        if (newValue != null && ((newValue = newValue.trim()).length() == 0 || newValue.equals("null"))) {
            newValue = null;
        }
        if (!Util.equal((Object)(oldValue = this.resourceLocator.getResourceName()), (Object)newValue)) {
            URL url = null;
            ClassResourceLocator rl = null;
            if (this.relativeSourceClass != null) {
                rl = new ClassResourceLocator(newValue);
                rl.setRelativeClass(this.relativeSourceClass);
                url = this.getResourceForResourceLocator((ResourceLocatorInterface)rl);
            }
            if (url == null && (url = this.getResourceForResourceLocator((ResourceLocatorInterface)(rl = new BaseResourceLocator(newValue)))) == null && (url = this.getResourceForResourceLocator((ResourceLocatorInterface)(rl = new AppletResourceLocator(newValue)))) == null) {
                rl = new ClassResourceLocator(newValue);
                rl.setRelativeClass(this.relativeSourceClass);
                url = this.getResourceForResourceLocator((ResourceLocatorInterface)rl);
                if (url == null) {
                    rl = new FileResourceLocator(newValue);
                    url = this.getResourceForResourceLocator((ResourceLocatorInterface)rl);
                }
            }
            if (url != null) {
                this.setResourceLocator((ResourceLocatorInterface)rl);
            } else {
                this.resourceLocator.setResourceName(newValue);
                this.loadImage();
            }
            this.firePropertyChange("source", oldValue, newValue);
        }
    }

    public String getSourceAbsolute() {
        if (this.resourceLocator instanceof AppletResourceLocator) {
            return ((AppletResourceLocator)this.resourceLocator).getAbsolutePath();
        }
        return this.resourceLocator.getResourceName();
    }

    public synchronized void setSourceAbsolute(String newValue) {
        String oldValue = this.resourceLocator.getResourceName();
        if (!Util.equal((Object)oldValue, (Object)newValue) || !(this.resourceLocator instanceof FileResourceLocator)) {
            if (!(this.resourceLocator instanceof FileResourceLocator)) {
                this.setResourceLocator((ResourceLocatorInterface)new FileResourceLocator(newValue));
            } else {
                this.resourceLocator.setResourceName(newValue);
                this.loadImage();
            }
            this.firePropertyChange("absoluteSource", oldValue, newValue);
        }
    }

    public URL getSourceURL() {
        try {
            return this.resourceLocator.getResource();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public synchronized void setSourceURL(URL newValue) {
        URL oldValue = null;
        try {
            oldValue = this.resourceLocator.getResource();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!Util.equal((Object)oldValue, (Object)newValue) || !(this.resourceLocator instanceof BaseResourceLocator)) {
            if (this.resourceLocator instanceof AppletResourceLocator || this.resourceLocator instanceof FileResourceLocator || this.resourceLocator instanceof ClassResourceLocator || this.resourceLocator instanceof ContextResourceLocator) {
                this.setResourceLocator((ResourceLocatorInterface)new BaseResourceLocator(newValue.toString()));
            } else {
                this.resourceLocator.setResourceName(newValue.toString());
                this.loadImage();
            }
            this.firePropertyChange("sourceURL", oldValue, newValue);
        }
    }

    public boolean isSourceAppletRelative() {
        return this.resourceLocator instanceof AppletResourceLocator;
    }

    public void setSourceAppletRelative(boolean newValue) {
        String resourceName = this.resourceLocator.getResourceName();
        if (newValue && !(this.resourceLocator instanceof AppletResourceLocator) || !newValue && this.resourceLocator instanceof AppletResourceLocator) {
            if (!(this.resourceLocator instanceof AppletResourceLocator)) {
                this.setResourceLocator((ResourceLocatorInterface)new AppletResourceLocator(resourceName));
            } else {
                resourceName = ((AppletResourceLocator)this.resourceLocator).getAbsolutePath();
                this.setResourceLocator((ResourceLocatorInterface)new FileResourceLocator(resourceName));
            }
            this.firePropertyChange("sourceAppletRelative", !newValue, newValue);
        }
    }

    public String getSourceRelative() {
        return this.resourceLocator.getResourceName();
    }

    public synchronized void setSourceRelative(String newValue) {
        String oldValue = this.resourceLocator.getResourceName();
        if (!Util.equal((Object)oldValue, (Object)newValue) || !(this.resourceLocator instanceof ClassResourceLocator) && !(this.resourceLocator instanceof AppletResourceLocator)) {
            if (!(this.resourceLocator instanceof ClassResourceLocator) && !(this.resourceLocator instanceof AppletResourceLocator)) {
                ClassResourceLocator crl = new ClassResourceLocator(newValue);
                crl.setRelativeClass(this.relativeSourceClass);
                this.setResourceLocator((ResourceLocatorInterface)crl);
            } else {
                this.resourceLocator.setResourceName(newValue);
                this.loadImage();
            }
            this.firePropertyChange("sourceRelative", oldValue, newValue);
        }
    }

    public Class getRelativeSourceClass() {
        if (this.resourceLocator instanceof ClassResourceLocator) {
            return ((ClassResourceLocator)this.resourceLocator).getRelativeClass();
        }
        if (this.resourceLocator instanceof AppletResourceLocator && ((AppletResourceLocator)this.resourceLocator).getApplet() != null) {
            return ((AppletResourceLocator)this.resourceLocator).getApplet().getClass();
        }
        return null;
    }

    public synchronized void setRelativeSourceClass(Class newValue) {
        String resourceName = this.resourceLocator.getResourceName();
        if (newValue != null || newValue == null && this.resourceLocator instanceof ClassResourceLocator) {
            Class oldValue = null;
            if (!(this.resourceLocator instanceof ClassResourceLocator)) {
                ClassResourceLocator crl = new ClassResourceLocator(resourceName);
                crl.setRelativeClass(newValue);
                this.setResourceLocator((ResourceLocatorInterface)crl);
            } else {
                oldValue = ((ClassResourceLocator)this.resourceLocator).getRelativeClass();
                ((ClassResourceLocator)this.resourceLocator).setRelativeClass(newValue);
                this.loadImage();
            }
            this.relativeSourceClass = newValue;
            this.firePropertyChange("relativeSourceclass", oldValue, newValue);
        }
    }

    private URL getResourceForResourceLocator(ResourceLocatorInterface rli) {
        URL url = null;
        try {
            url = rli.getResource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private void loadImage() {
        Image img = this.getImage(this.getResourceForResourceLocator(this.resourceLocator));
        this.setImage(img);
    }
}

