/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.swing.visuals.FullWidthColumnHeader;
import com.sas.swing.visuals.itemlistmanager.ItemListManagerTableView;
import javax.swing.table.JTableHeader;

@SASScope
public class FullWidthTable
extends ItemListManagerTableView {
    public FullWidthTable() {
        this.setPopupMenuEnabled(false);
        this.setColumnHeaderVisible(true);
        this.setRowHeaderVisible(false);
    }

    @Override
    public boolean isFocusable() {
        if (this.getRowCount() <= 0) {
            return false;
        }
        return super.isFocusable();
    }

    @Override
    public boolean isRowSelected(int row) {
        if (row == 0 && ValueProviderModelAdapter.NO_RESULTS_FOUND.equals(this.getValueAt(0, 0))) {
            return false;
        }
        return super.isRowSelected(row);
    }

    @Override
    public int getVisibleColumnCount() {
        int cc = this.getColumnCount();
        if (cc > 0) {
            return cc;
        }
        return super.getVisibleColumnCount();
    }

    @Override
    public void doLayout() {
        int colCount = this.getColumnCount();
        int[] colSizes = new int[colCount];
        int totalWidth = 0;
        for (int i = 0; i < colCount; ++i) {
            colSizes[i] = this.getColumnModel().getColumn(i).getPreferredWidth();
            totalWidth += colSizes[i];
        }
        int rm = this.getAutoResizeMode();
        this.autoResizeMode = totalWidth < this.getWidth() ? 4 : 0;
        super.doLayout();
        this.autoResizeMode = rm;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new FullWidthColumnHeader(this.getColumnModel());
    }

    protected boolean isInitialized() {
        return this.tableInitialized;
    }
}

