/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.text.DefaultFormatterFactory;

@SASScope
public class FormattedComboBoxEditor
implements ComboBoxEditor,
SupportsGenericErrorHandlerInterface {
    public static boolean doNotFireActionEventOnCommitEdit_S0802438 = false;
    private JFormattedTextField editor = new JFormattedTextField(){

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            LookAndFeel lf = UIManager.getLookAndFeel();
            if (lf instanceof MetalLookAndFeel) {
                pref.height += 4;
            }
            return pref;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            LookAndFeel lf = UIManager.getLookAndFeel();
            if (lf instanceof MetalLookAndFeel) {
                min.height += 4;
            }
            return min;
        }

        @Override
        protected void invalidEdit() {
        }

        @Override
        public void commitEdit() throws ParseException {
            try {
                FormattedComboBoxEditor.this.edited = false;
                super.commitEdit();
                if (!doNotFireActionEventOnCommitEdit_S0802438) {
                    this.fireActionPerformed();
                }
            }
            catch (ParseException ex) {
                Object v = this.getValue();
                if (FormattedComboBoxEditor.this.getGenericErrorHandler() != null) {
                    String msg = ex.getMessage();
                    FormattedComboBoxEditor.this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)msg)), null);
                }
                this.setValue(v);
                FormattedComboBoxEditor.this.edited = false;
                throw ex;
            }
        }
    };
    private GenericErrorHandlerInterface errorHandler;
    private boolean edited;
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

    public FormattedComboBoxEditor() {
        this.editor.setFocusLostBehavior(1);
        this.editor.setBorder(null);
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (lf instanceof MetalLookAndFeel) {
            this.editor.setBorder(new EditorBorder());
        }
        this.edited = false;
        KeyStroke down = KeyStroke.getKeyStroke(40, 0);
        InputMap im = this.editor.getInputMap();
        im.put(down, new Object());
        KeyStroke up = KeyStroke.getKeyStroke(38, 0);
        im.put(up, new Object());
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FormattedComboBoxEditor.this.edited = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FormattedComboBoxEditor.this.edited = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FormattedComboBoxEditor.this.edited = true;
            }
        });
    }

    public FormattedComboBoxEditor(Object value) {
        this();
        this.editor.setValue(value);
    }

    public FormattedComboBoxEditor(JFormattedTextField.AbstractFormatter formatter) {
        this(new DefaultFormatterFactory(formatter));
    }

    public FormattedComboBoxEditor(JFormattedTextField.AbstractFormatterFactory factory) {
        this();
        this.editor.setFormatterFactory(factory);
    }

    public FormattedComboBoxEditor(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        this(currentValue);
        this.editor.setFormatterFactory(factory);
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    @Override
    public Component getEditorComponent() {
        return this.editor;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.editor.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.editor.removeActionListener(l);
    }

    @Override
    public void setItem(Object anObject) {
        this.editor.setValue(anObject);
        this.edited = false;
    }

    @Override
    public Object getItem() {
        if (this.edited) {
            try {
                this.editor.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.edited = false;
        }
        Object newValue = this.editor.getValue();
        return newValue;
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    @SASScope
    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w, h - 1);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(1, 1, w - 2, h - 3);
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(1, 1, 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(1, h - 2, 1, h - 2);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }
}

