/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.RangeEditor;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

@SASScope
public class DateRangeEditor
extends RangeEditor
implements ActionListener {
    private static final long serialVersionUID = -3947376424760158748L;
    public static final String RB_KEY = "DateRangeEditor.";
    public static final String N_AGO = "N_AGO";
    public static final String N_FROM_NOW = "N_FROM_NOW";
    public static final String RELATIVE_TYPE = "RELATIVE_TYPE";
    public static final String PERIOD_TYPE = "PERIOD_TYPE";
    public static final int YEAR_TO_DATE = 1;
    public static final int MONTH_TO_DATE = 2;
    public static final int PREVIOUS_N_DAYS = 3;
    public static final int NEXT_N_DAYS = 4;
    public static final int PREVIOUS_N_QUARTERS = 101;
    public static final int NEXT_N_QUARTERS = 102;
    public static final int PREVIOUS_N_MONTHS = 201;
    public static final int NEXT_N_MONTHS = 202;
    public static final int PREVIOUS_N_WEEKS = 301;
    public static final int NEXT_N_WEEKS = 302;
    public static final int PREVIOUS_N_YEARS = 401;
    public static final int NEXT_N_YEARS = 402;
    public static final int PREVIOUS_N_HOURS = 501;
    public static final int NEXT_N_HOURS = 502;
    public static final int PREVIOUS_N_MINUTES = 503;
    public static final int NEXT_N_MINUTES = 504;
    private JLabel rangeTypeLabel;
    private ComboBox rangeTypeCombo;
    private DefaultComboBoxModel comboModel;
    private Object customObject;
    private FocusAdapter focusListener;
    private boolean showRelativeDates;
    private DateTypes type;
    private TimeZone timezone;

    public DateRangeEditor(DateTypes dateType, Locale locale) {
        this(dateType, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, TimeZone timeZone, Locale locale) {
        this(dateType, false, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean horizontalLayout, Locale locale) {
        this(dateType, horizontalLayout, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean horizontalLayout, TimeZone timeZone, Locale locale) {
        this(dateType, true, horizontalLayout, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, boolean horizontalLayout, Locale locale) {
        this(dateType, allowRelativeDates, horizontalLayout, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, boolean horizontalLayout, TimeZone timeZone, Locale locale) {
        this(dateType, allowRelativeDates, RB.getStringResource("RangeEditor.", "minLabel.txt", locale), RB.getStringResource("RangeEditor.", "maxLabel.txt", locale), horizontalLayout, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, String minLabel, String maxLabel, Locale locale) {
        this(dateType, minLabel, maxLabel, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, String minLabel, String maxLabel, TimeZone timeZone, Locale locale) {
        this(dateType, true, minLabel, maxLabel, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, String minLabel, String maxLabel, boolean horizontalLayout, Locale locale) {
        this(dateType, minLabel, maxLabel, horizontalLayout, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, String minLabel, String maxLabel, boolean horizontalLayout, TimeZone timeZone, Locale locale) {
        this(dateType, true, minLabel, maxLabel, horizontalLayout, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, String minLabel, String maxLabel, Locale locale) {
        this(dateType, allowRelativeDates, minLabel, maxLabel, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, String minLabel, String maxLabel, TimeZone timeZone, Locale locale) {
        this(dateType, allowRelativeDates, minLabel, maxLabel, false, timeZone, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, String minLabel, String maxLabel, boolean horizontalLayout, Locale locale) {
        this(dateType, allowRelativeDates, minLabel, maxLabel, horizontalLayout, null, locale);
    }

    public DateRangeEditor(DateTypes dateType, boolean allowRelativeDates, String minLabel, String maxLabel, boolean horizontalLayout, TimeZone timeZone, Locale locale) {
        super(new DatePicker(dateType, allowRelativeDates, timeZone, locale), new DatePicker(dateType, allowRelativeDates, timeZone, locale), minLabel, maxLabel, horizontalLayout, locale);
        this.type = dateType;
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.timezone = timeZone;
        this.showRelativeDates = allowRelativeDates;
        if (dateType == DateTypes.TIME) {
            DatePicker min = (DatePicker)this.getMinEditor();
            ArrayList<Object> relativeOptions = new ArrayList<Object>();
            relativeOptions.add(DatePicker.getRelativeValue(501, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(705, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(707, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(708, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(706, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(709, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(710, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(507, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(508, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(509, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(510, this.timezone, locale));
            min.setRelativeOptions(relativeOptions);
            DatePicker max = (DatePicker)this.getMaxEditor();
            relativeOptions = new ArrayList();
            relativeOptions.add(DatePicker.getRelativeValue(501, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(805, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(807, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(808, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(806, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(809, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(810, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(507, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(508, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(509, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(510, this.timezone, locale));
            max.setRelativeOptions(relativeOptions);
        } else if (dateType == DateTypes.TIMESTAMP) {
            DatePicker min = (DatePicker)this.getMinEditor();
            ArrayList<Object> relativeOptions = new ArrayList<Object>();
            relativeOptions.add(DatePicker.getRelativeValue(401, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(402, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(403, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(715, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(717, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(718, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(716, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(719, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(720, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(410, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(411, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(412, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(413, this.timezone, locale));
            min.setRelativeOptions(relativeOptions);
            DatePicker max = (DatePicker)this.getMaxEditor();
            relativeOptions = new ArrayList();
            relativeOptions.add(DatePicker.getRelativeValue(401, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(402, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(403, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(815, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(817, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(818, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(816, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(819, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(820, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(410, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(411, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(412, this.timezone, locale));
            relativeOptions.add(DatePicker.getRelativeValue(413, this.timezone, locale));
            max.setRelativeOptions(relativeOptions);
        }
        this.myinit();
    }

    @Override
    protected void init() {
    }

    private void myinit() {
        super.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.rangeTypeLabel != null) {
            this.rangeTypeLabel.setEnabled(enabled);
        }
        if (this.rangeTypeCombo != null) {
            this.rangeTypeCombo.setEnabled(enabled);
        }
    }

    public static ValueItem createRelativeItem(Object value, Object label, String relativeType, DateTypes type) {
        ValueItem valueItem = new ValueItem(label, value);
        if (relativeType != null) {
            valueItem.setAttribute(RELATIVE_TYPE, (Object)relativeType);
        }
        if (type != null) {
            valueItem.setAttribute(PERIOD_TYPE, (Object)type);
        }
        return valueItem;
    }

    @Override
    public Object getValue() {
        Date o1 = (Date)this.getMinEditor().getValue();
        Date o2 = (Date)this.getMaxEditor().getValue();
        if (o1 != null || o2 != null) {
            return new Date[]{o1, o2};
        }
        return null;
    }

    public static Object getRelativeValue(int key) {
        return DateRangeEditor.getRelativeValue(key, TimeZone.getDefault(), Locale.getDefault());
    }

    public static Object getRelativeValue(int key, TimeZone timezone, Locale locale) {
        switch (key) {
            case 1: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(701, timezone, locale), DatePicker.getRelativeValue(1, timezone, locale)}, RB.getStringResource(RB_KEY, "yearToDate.txt", locale), null, null);
            }
            case 2: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(703, timezone, locale), DatePicker.getRelativeValue(1, timezone, locale)}, RB.getStringResource(RB_KEY, "monthToDate.txt", locale), null, null);
            }
            case 3: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(9, timezone, locale), DatePicker.getRelativeValue(1, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNDays.txt", locale), N_AGO, DateTypes.DATE);
            }
            case 4: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(1, timezone, locale), DatePicker.getRelativeValue(10, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNDays.txt", locale), N_FROM_NOW, DateTypes.DATE);
            }
            case 101: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(306, timezone, locale), DatePicker.getRelativeValue(301, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNQuarters.txt", locale), N_AGO, DateTypes.QUARTER);
            }
            case 102: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(301, timezone, locale), DatePicker.getRelativeValue(307, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNQuarters.txt", locale), N_FROM_NOW, DateTypes.QUARTER);
            }
            case 201: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(206, timezone, locale), DatePicker.getRelativeValue(201, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNMonths.txt", locale), N_AGO, DateTypes.MONTH);
            }
            case 202: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(201, timezone, locale), DatePicker.getRelativeValue(207, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNMonths.txt", locale), N_FROM_NOW, DateTypes.MONTH);
            }
            case 301: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(106, timezone, locale), DatePicker.getRelativeValue(101, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNWeeks.txt", locale), N_AGO, DateTypes.WEEK);
            }
            case 302: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(101, timezone, locale), DatePicker.getRelativeValue(107, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNWeeks.txt", locale), N_FROM_NOW, DateTypes.WEEK);
            }
            case 401: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(604, timezone, locale), DatePicker.getRelativeValue(601, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNYears.txt", locale), N_AGO, DateTypes.YEAR);
            }
            case 402: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(601, timezone, locale), DatePicker.getRelativeValue(605, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNYears.txt", locale), N_FROM_NOW, DateTypes.YEAR);
            }
            case 501: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(507, timezone, locale), DatePicker.getRelativeValue(501, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNHours.txt", locale), N_AGO, DateTypes.HOUR);
            }
            case 502: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(501, timezone, locale), DatePicker.getRelativeValue(508, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNHours.txt", locale), N_FROM_NOW, DateTypes.HOUR);
            }
            case 503: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(509, timezone, locale), DatePicker.getRelativeValue(501, timezone, locale)}, RB.getStringResource(RB_KEY, "previousNMinutes.txt", locale), N_AGO, DateTypes.MINUTE);
            }
            case 504: {
                return DateRangeEditor.createRelativeItem(new Object[]{DatePicker.getRelativeValue(501, timezone, locale), DatePicker.getRelativeValue(510, timezone, locale)}, RB.getStringResource(RB_KEY, "nextNMinutes.txt", locale), N_FROM_NOW, DateTypes.MINUTE);
            }
        }
        return null;
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (event.isTemporary()) {
                    return;
                }
                if (!DateRangeEditor.this.isEditing() && !SwingUtilities.isDescendingFrom(event.getOppositeComponent(), DateRangeEditor.this)) {
                    DateRangeEditor.this.fireEditingStopped();
                }
            }

            @Override
            public void focusGained(FocusEvent event) {
                if (!DateRangeEditor.this.editingStarted) {
                    DateRangeEditor.this.editingStarted = true;
                    DateRangeEditor.this.fireEditingStarted();
                }
            }
        };
        this.ignoreEvents = false;
        this.rangeTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "rangeTypeLabel.txt"));
        this.rangeTypeCombo = new ComboBox();
        this.comboModel = new DefaultComboBoxModel();
        if (this.type == DateTypes.DATE) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(1, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(2, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(3, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(4, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, DateTypes.DATE);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.QUARTER) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(101, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(102, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, DateTypes.QUARTER);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.MONTH) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(201, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(202, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, DateTypes.MONTH);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.WEEK) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(301, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(302, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, DateTypes.WEEK);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.YEAR) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(401, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(402, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, DateTypes.YEAR);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.TIME) {
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(501, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(502, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(503, this.timezone, this.getLocale()));
            this.comboModel.addElement(DateRangeEditor.getRelativeValue(504, this.timezone, this.getLocale()));
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, null);
            this.comboModel.addElement(this.customObject);
        } else if (this.type == DateTypes.TIMESTAMP || this.type == DateTypes.WEEKDAY) {
            // empty if block
        }
        if (this.comboModel.getSize() == 0) {
            this.rangeTypeLabel.setVisible(false);
            this.rangeTypeCombo.setVisible(false);
        }
        if (!this.showRelativeDates) {
            this.rangeTypeLabel.setVisible(false);
            this.rangeTypeCombo.setVisible(false);
        }
        this.rangeTypeCombo.setModel(this.comboModel);
        this.rangeTypeCombo.setSelectedIndex(-1);
    }

    public void setRangeTypeOptions(List options) {
        Object oldValue = this.getValue();
        this.comboModel.removeAllElements();
        if (options != null && !options.isEmpty()) {
            for (Object element : options) {
                this.comboModel.addElement(element);
            }
            this.customObject = DateRangeEditor.createRelativeItem(null, RB.getStringResource(RB_KEY, "custom.txt", this.getLocale()), null, this.type);
            this.comboModel.addElement(this.customObject);
            this.rangeTypeCombo.setSelectedIndex(-1);
            if (this.isShowRelativeDates()) {
                this.rangeTypeLabel.setVisible(true);
                this.rangeTypeCombo.setVisible(true);
            }
        } else {
            this.rangeTypeLabel.setVisible(false);
            this.rangeTypeCombo.setVisible(false);
        }
        this.setValue(oldValue);
    }

    public List getRangeTypeOptions() {
        if (this.showRelativeDates && this.comboModel != null) {
            int size = this.comboModel.getSize();
            ArrayList values = new ArrayList();
            for (int i = 0; i < size; ++i) {
                values.add(this.comboModel.getElementAt(i));
            }
            return values;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void layoutComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(-1, 1, 5, 5, true, true, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        JPanel rangePanel = new JPanel();
        rangePanel.setOpaque(false);
        AutoSizingGridLayout rangeLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, true, true);
        rangeLayout.setIgnoreSizeOfNonVisibleComponents(true);
        rangePanel.setLayout(rangeLayout);
        if (this.isHorizontalLayout()) {
            rangeLayout.setColumnSpacePartitioner(new ProportionalSpacePartitioner(new double[]{0.5, 0.5}, null, null, true));
            rangePanel.add(this.getMinLabel());
            rangePanel.add(this.getMaxLabel());
            rangePanel.add(this.getMinEditor().getEditorComponent());
            rangePanel.add(this.getMaxEditor().getEditorComponent());
        } else {
            rangeLayout.setColumns(1);
            rangeLayout.setRows(4);
            rangePanel.add(this.getMinLabel());
            rangePanel.add(this.getMinEditor().getEditorComponent());
            rangePanel.add(this.getMaxLabel());
            rangePanel.add(this.getMaxEditor().getEditorComponent());
        }
        this.add(this.rangeTypeLabel);
        this.add(this.rangeTypeCombo);
        this.add(rangePanel);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.rangeTypeCombo.addActionListener(this);
        this.rangeTypeCombo.addFocusListener(this.focusListener);
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        this.rangeTypeCombo.removeActionListener(this);
        this.rangeTypeCombo.removeFocusListener(this.focusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ValueItem selectedItem;
        if (this.ignoreEvents || e.getSource() != this.rangeTypeCombo || (selectedItem = (ValueItem)this.rangeTypeCombo.getSelectedItem()) == null) return;
        Object relativeType = selectedItem.getAttribute(RELATIVE_TYPE);
        if (relativeType == N_AGO || relativeType == N_FROM_NOW) {
            try {
                this.ignoreEvents = true;
                Object value = selectedItem.getValue();
                if (!(value instanceof Object[])) return;
                this.getMinEditor().setValue(((Object[])value)[0]);
                this.getMaxEditor().setValue(((Object[])value)[1]);
                return;
            }
            finally {
                this.ignoreEvents = false;
            }
        }
        boolean change = false;
        try {
            this.ignoreEvents = true;
            Object value = selectedItem.getValue();
            if (value instanceof Object[]) {
                this.getMinEditor().setValue(((Object[])value)[0]);
                this.getMaxEditor().setValue(((Object[])value)[1]);
                change = true;
            }
        }
        finally {
            this.ignoreEvents = false;
        }
        if (!change) return;
        this.fireValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ChangeEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        try {
            this.ignoreEvents = true;
            boolean setToCustom = true;
            ValueItem selectedItem = (ValueItem)this.rangeTypeCombo.getSelectedItem();
            if (selectedItem != null && selectedItem != this.customObject) {
                DatePeriod dp;
                int nValue;
                Object item;
                Object relativeType = selectedItem.getAttribute(RELATIVE_TYPE);
                DateTypes type = (DateTypes)selectedItem.getAttribute(PERIOD_TYPE);
                if (relativeType == N_AGO) {
                    DatePeriod dp2;
                    int nValue2;
                    Object item2;
                    if (e.getSource() == this.getMinEditor() && (item2 = this.getMinEditor().getValue()) != null && item2 instanceof DatePeriod && (nValue2 = DatePicker.getNValue(dp2 = (DatePeriod)item2, type)) < 0) {
                        setToCustom = false;
                        ((ValueItem)((Object[])selectedItem.getValue())[0]).setValue((Object)dp2);
                    }
                } else if (relativeType == N_FROM_NOW && e.getSource() == this.getMaxEditor() && (item = this.getMaxEditor().getValue()) != null && item instanceof DatePeriod && (nValue = DatePicker.getNValue(dp = (DatePeriod)item, type)) > 0) {
                    setToCustom = false;
                    ((ValueItem)((Object[])selectedItem.getValue())[1]).setValue((Object)dp);
                }
            }
            if (setToCustom) {
                this.rangeTypeCombo.setSelectedItem(this.customObject);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
        super.valueChanged(e);
    }

    private boolean areValuesEqual(Object value1, Object value2) {
        if (Util.equal((Object)value1, (Object)value2)) {
            return true;
        }
        if (value1 instanceof ValueItem && Util.equal((Object)((ValueItem)value1).getValue(), (Object)value2)) {
            return true;
        }
        if (value2 instanceof ValueItem && Util.equal((Object)value1, (Object)((ValueItem)value2).getValue())) {
            return true;
        }
        return value2 instanceof ValueItem && value1 instanceof ValueItem && Util.equal((Object)((ValueItem)value1).getValue(), (Object)((ValueItem)value2).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object anObject) {
        try {
            this.ignoreEvents = true;
            boolean found = false;
            if (anObject instanceof Object[] && ((Object[])anObject).length == 2) {
                Object minValue = ((Object[])anObject)[0];
                Object maxValue = ((Object[])anObject)[1];
                if (minValue instanceof DatePeriod && ((DatePeriod)minValue).isRelativeDate() && maxValue instanceof DatePeriod && ((DatePeriod)maxValue).isRelativeDate()) {
                    ComboBoxModel model = this.rangeTypeCombo.getModel();
                    int size = model.getSize();
                    for (int i = 0; i < size; ++i) {
                        Object value;
                        Object item = model.getElementAt(i);
                        if (!(item instanceof ValueItem) || !((value = ((ValueItem)item).getValue()) instanceof Object[]) || ((Object[])value).length != 2) continue;
                        Object v1 = ((Object[])value)[0];
                        Object v2 = ((Object[])value)[1];
                        if (!this.areValuesEqual(v1, minValue) || !this.areValuesEqual(v2, maxValue)) continue;
                        this.rangeTypeCombo.setSelectedItem(item);
                        found = true;
                        break;
                    }
                    if (!found) {
                        found = this.findInRangeCombo((DatePeriod)minValue, (DatePeriod)maxValue);
                    }
                    if (found) {
                        this.getMinEditor().setValue(minValue);
                        this.getMaxEditor().setValue(maxValue);
                    }
                }
                if (!found) {
                    this.rangeTypeCombo.setSelectedItem(this.customObject);
                    this.getMinEditor().setValue(minValue);
                    this.getMaxEditor().setValue(maxValue);
                }
            } else {
                this.rangeTypeCombo.setSelectedIndex(-1);
                this.getMinEditor().setValue(null);
                this.getMaxEditor().setValue(null);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private boolean findInRangeCombo(DatePeriod minD, DatePeriod maxD) {
        ComboBoxModel model = this.rangeTypeCombo.getModel();
        int size = model.getSize();
        boolean found = false;
        int nMinFields = 0;
        nMinFields += minD.getNYears() != 0 ? 1 : 0;
        nMinFields += minD.getNQuarters() != 0 ? 1 : 0;
        nMinFields += minD.getNMonths() != 0 ? 1 : 0;
        nMinFields += minD.getNWeeks() != 0 ? 1 : 0;
        nMinFields += minD.getNDays() != 0 ? 1 : 0;
        nMinFields += minD.getNHours() != 0 ? 1 : 0;
        nMinFields += minD.getNMinutes() != 0 ? 1 : 0;
        int nMaxFields = 0;
        nMaxFields += maxD.getNYears() != 0 ? 1 : 0;
        nMaxFields += maxD.getNQuarters() != 0 ? 1 : 0;
        nMaxFields += maxD.getNMonths() != 0 ? 1 : 0;
        nMaxFields += maxD.getNWeeks() != 0 ? 1 : 0;
        nMaxFields += maxD.getNDays() != 0 ? 1 : 0;
        nMaxFields += maxD.getNHours() != 0 ? 1 : 0;
        if (!(nMinFields != 1 && (nMaxFields += maxD.getNMinutes() != 0 ? 1 : 0) != 1 || nMaxFields == 1 && nMinFields == 1)) {
            DatePeriod dp = minD;
            if (nMaxFields == 1) {
                dp = maxD;
            }
            for (int i = 0; i < size; ++i) {
                int value;
                DateTypes periodType;
                Object item = model.getElementAt(i);
                if (!(item instanceof ValueItem)) continue;
                Object relativeType = ((ValueItem)item).getAttribute(RELATIVE_TYPE);
                if (relativeType == N_AGO) {
                    periodType = (DateTypes)((ValueItem)item).getAttribute(PERIOD_TYPE);
                    if (periodType == null || (value = this.getNValue(dp, periodType)) >= 0) continue;
                    found = true;
                    if (this.rangeTypeCombo.getSelectedItem() == item) break;
                    this.rangeTypeCombo.setSelectedItem(item);
                    break;
                }
                if (relativeType != N_FROM_NOW || (periodType = (DateTypes)((ValueItem)item).getAttribute(PERIOD_TYPE)) == null || (value = this.getNValue(dp, periodType)) <= 0) continue;
                found = true;
                if (this.rangeTypeCombo.getSelectedItem() == item) break;
                this.rangeTypeCombo.setSelectedItem(item);
                break;
            }
        }
        return found;
    }

    private int getNValue(DatePeriod dp, DateTypes periodType) {
        if (periodType == DateTypes.YEAR) {
            return dp.getNYears();
        }
        if (periodType == DateTypes.QUARTER) {
            return dp.getNQuarters();
        }
        if (periodType == DateTypes.MONTH) {
            return dp.getNMonths();
        }
        if (periodType == DateTypes.WEEK) {
            return dp.getNWeeks();
        }
        if (periodType == DateTypes.DATE) {
            return dp.getNDays();
        }
        if (periodType == DateTypes.HOUR) {
            return dp.getNHours();
        }
        if (periodType == DateTypes.MINUTE) {
            return dp.getNMinutes();
        }
        return 0;
    }

    @Override
    public boolean isEditing() {
        return this.rangeTypeCombo.hasFocus() || super.isEditing();
    }

    public boolean isShowRelativeDates() {
        return this.showRelativeDates;
    }

    public void setShowRelativeDates(boolean showRelativeDates) {
        if (this.showRelativeDates != showRelativeDates) {
            boolean oldValue = this.showRelativeDates;
            this.showRelativeDates = showRelativeDates;
            this.removeListeners();
            Object value = this.getValue();
            this.removeAll();
            if (this.getMinEditor() instanceof DatePicker) {
                ((DatePicker)this.getMinEditor()).setShowRelativeDates(showRelativeDates);
            }
            if (this.getMaxEditor() instanceof DatePicker) {
                ((DatePicker)this.getMaxEditor()).setShowRelativeDates(showRelativeDates);
            }
            this.createComponents();
            this.layoutComponents();
            boolean setValue = true;
            if (!showRelativeDates && value != null) {
                if (value instanceof Object[] && ((Object[])value).length == 2 && ((Object[])value)[0] instanceof DatePeriod && ((DatePeriod)((Object[])value)[0]).isRelativeDate()) {
                    setValue = false;
                } else if (value instanceof Object[] && ((Object[])value).length == 2 && ((Object[])value)[1] instanceof DatePeriod && ((DatePeriod)((Object[])value)[1]).isRelativeDate()) {
                    setValue = false;
                }
            }
            if (setValue) {
                this.setValue(value);
            } else {
                this.setValue(null);
            }
            this.addListeners();
            this.firePropertyChange("showRelativeDates", oldValue, this.showRelativeDates);
        }
    }
}

