/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

@SASScope
public class ColorIcon
implements Icon {
    private Color color;
    private int w;
    private int h;

    public ColorIcon() {
        this(Color.gray, 12, 12);
    }

    public ColorIcon(Color color, int w, int h) {
        this.color = color;
        this.w = w;
        this.h = h;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Dimension size = c.getSize();
        g.setColor(Color.black);
        g.drawRect(x + 1, y, Math.max(size.width - 7, this.w - 1), Math.max(size.height - 5, this.h - 1));
        g.setColor(this.color);
        g.fillRect(x + 2, y + 1, Math.max(size.width - 8, this.w - 2), Math.max(size.height - 7, this.h - 2));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }
}

