/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.RB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class BevelArrowIcon
implements Icon,
SwingConstants {
    public static final String RB_KEY = "BevelArrowIcon.";
    private static final int DEFAULT_SIZE = 8;
    private Color edge1;
    private Color edge2;
    private int size;
    private int orginalSize;
    private int direction;
    private boolean isRaised;
    private Color fillColor;

    public BevelArrowIcon() {
        this(null);
    }

    public BevelArrowIcon(Color fillColor) {
        this(5, fillColor);
    }

    public BevelArrowIcon(int direction) {
        this(direction, 8);
    }

    public BevelArrowIcon(int direction, Color fillColor) {
        this(direction, 8, fillColor);
    }

    public BevelArrowIcon(int direction, boolean isRaised) {
        this(direction, 8, isRaised);
    }

    public BevelArrowIcon(int direction, boolean isRaised, Color fillColor) {
        this(direction, 8, isRaised, fillColor);
    }

    public BevelArrowIcon(int direction, int size) {
        this(direction, size, false);
    }

    public BevelArrowIcon(int direction, int size, Color fillColor) {
        this(direction, size, false, fillColor);
    }

    public BevelArrowIcon(int direction, int size, boolean isRaised) {
        this(direction, size, isRaised, null);
    }

    public BevelArrowIcon(int direction, int size, boolean isRaised, Color fillColor) {
        if (direction != 1 && direction != 5) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalDirection.ex.txt"));
        }
        this.direction = direction;
        this.size = size;
        this.orginalSize = size;
        this.isRaised = isRaised;
        this.fillColor = fillColor;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != 5) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalDirection.ex.txt"));
        }
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setRaised(boolean raised) {
        this.isRaised = raised;
    }

    public boolean isRaised() {
        return this.isRaised;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getOriginalSize() {
        return this.orginalSize;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isPressed = false;
        if (c instanceof AbstractButton) {
            isPressed = ((AbstractButton)c).getModel().isPressed();
        }
        if (this.isRaised) {
            if (isPressed) {
                this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"));
            } else {
                this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"));
            }
        } else if (isPressed) {
            this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlLtHighlight"));
        } else {
            this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlLtHighlight"));
        }
        switch (this.direction) {
            case 1: {
                this.drawUpArrow(g, x, y);
                break;
            }
            case 5: {
                this.drawDownArrow(g, x, y);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    private void init(Color edge1, Color edge2) {
        this.edge1 = edge1;
        this.edge2 = edge2;
    }

    private void drawDownArrow(Graphics g, int xo, int yo) {
        g.setColor(this.edge1);
        g.drawLine(xo, yo, xo + this.size - 1, yo);
        g.drawLine(xo, yo + 1, xo, yo + 1);
        g.setColor(this.edge2);
        g.drawLine(xo + this.size - 1, yo + 1, xo + this.size - 1, yo + 1);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.drawLine(xo + 1, yo + 1, xo + this.size - 2, yo + 1);
        }
        int x = xo + 1;
        int y = yo + 2;
        int dx = this.size - 6;
        while (y + 1 < yo + this.size) {
            g.setColor(this.edge1);
            g.drawLine(x, y - 1, x, y - 1);
            g.drawLine(x, y, x, y);
            g.drawLine(x, y + 1, x, y + 1);
            if (this.fillColor != null && dx > -2) {
                g.setColor(this.fillColor);
                g.drawLine(x + 1, y - 1, x + dx + 2, y - 1);
                g.drawLine(x + 1, y, x + dx + 2, y);
            }
            g.setColor(this.edge2);
            g.drawLine(x + dx + 3, y - 1, x + dx + 3, y - 1);
            g.drawLine(x + dx + 3, y, x + dx + 3, y);
            g.drawLine(x + dx + 3, y + 1, x + dx + 3, y + 1);
            ++x;
            y += 2;
            dx -= 2;
        }
        if (this.size % 2 == 1) {
            g.setColor(this.edge1);
            g.drawLine(xo + this.size / 2, yo + this.size - 2, xo + this.size / 2, yo + this.size - 1);
        }
    }

    private void drawUpArrow(Graphics g, int xo, int yo) {
        g.setColor(this.edge2);
        g.drawLine(xo + this.size - 1, yo + this.size - 2, xo + this.size - 1, yo + this.size - 2);
        g.drawLine(xo, yo + this.size - 1, xo + this.size - 1, yo + this.size - 1);
        g.setColor(this.edge1);
        g.drawLine(xo, yo + this.size - 2, xo, yo + this.size - 2);
        g.drawLine(xo, yo + this.size - 1, xo, yo + this.size - 1);
        int x = xo + 1;
        int y = yo + this.size - 3;
        int dx = this.size - 6;
        while (y >= yo) {
            g.setColor(this.edge2);
            if (y - 1 >= yo) {
                g.drawLine(x + dx + 3, y - 1, x + dx + 3, y - 1);
            }
            g.drawLine(x + dx + 3, y, x + dx + 3, y);
            g.drawLine(x + dx + 3, y + 1, x + dx + 3, y + 1);
            g.setColor(this.edge1);
            if (y - 1 >= yo) {
                g.drawLine(x, y - 1, x, y - 1);
            }
            g.drawLine(x, y, x, y);
            g.drawLine(x, y + 1, x, y + 1);
            if (this.fillColor != null && dx > -2) {
                g.setColor(this.fillColor);
                g.drawLine(x + 1, y, x + dx + 2, y);
                g.drawLine(x + 1, y + 1, x + dx + 2, y + 1);
            }
            ++x;
            y -= 2;
            dx -= 2;
        }
    }
}

