/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicLabelViewUI
extends BasicLabelUI {
    protected static BasicLabelViewUI labelViewUI = new BasicLabelViewUI();
    protected Rectangle iconR = new Rectangle();
    protected Rectangle textR = new Rectangle();
    protected Rectangle viewR = new Rectangle();
    protected static Insets viewInsets;
    protected static Rectangle paintIconR;
    protected static Rectangle paintTextR;
    protected static Rectangle paintViewR;
    protected static Insets paintViewInsets;
    protected static Rectangle oPaintIconR;
    protected static Rectangle oPaintTextR;

    public BasicLabelViewUI() {
        viewInsets = new Insets(0, 0, 0, 0);
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
        oPaintIconR = new Rectangle();
        oPaintTextR = new Rectangle();
    }

    public static ComponentUI createUI(JComponent c) {
        return labelViewUI;
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clippedMode, int tabSize, int leadingContentOffset, int topContentOffset) {
        return Util.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), orientation, lineWrap, wrapStyleWord, gapBetweenLines, clippedMode, tabSize, leadingContentOffset, topContentOffset);
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clippedMode, int tabSize, int leadingContentOffset, int topContentOffset, boolean replaceTab) {
        return Util.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), orientation, lineWrap, wrapStyleWord, gapBetweenLines, clippedMode, tabSize, leadingContentOffset, topContentOffset, replaceTab);
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, int orientation, boolean lineWrap, boolean wrapStyleWord, int gapBetweenLines, boolean clippedMode, int tabSize, int leadingContentOffset, int topContentOffset, boolean replaceTab, boolean replaceNewline) {
        return Util.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), orientation, lineWrap, wrapStyleWord, gapBetweenLines, clippedMode, tabSize, leadingContentOffset, topContentOffset, replaceTab, replaceNewline);
    }

    protected boolean paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY, int accChar) {
        g.setColor(l.getForeground());
        return Util.drawString(g, s, accChar, textX, textY);
    }

    protected boolean paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY, int accChar) {
        Color background = l.getBackground();
        g.setColor(background.brighter());
        Util.drawString(g, s, accChar, textX, textY);
        g.setColor(background.darker());
        return Util.drawString(g, s, accChar, textX + 1, textY + 1);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c instanceof LabelView) {
            Dimension rv;
            LabelView label = (LabelView)c;
            String text = label.getText();
            Icon icon = label.getIcon();
            viewInsets = label.getInsets();
            Font font = label.getFont();
            int spanW = label.getPreferredSpanSize().width;
            int spanH = label.getPreferredSpanSize().height;
            int dx = BasicLabelViewUI.viewInsets.left + BasicLabelViewUI.viewInsets.right;
            int dy = BasicLabelViewUI.viewInsets.top + BasicLabelViewUI.viewInsets.bottom;
            if (icon == null && (text == null || text != null && font == null)) {
                rv = new Dimension(0, 0);
            } else if (text == null || icon != null && font == null) {
                rv = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            } else {
                FontMetrics fm = label.getFontMetrics(font);
                boolean clippedMode = label.isClipped();
                boolean vertical = false;
                if (label.getOrientation() == 1) {
                    vertical = true;
                }
                if (spanW == -101) {
                    Dimension d;
                    int actualWidth = -101;
                    if (label.getLinkedComponent() != null) {
                        d = label.getLinkedComponent().getSize();
                        if (d.width <= 0) {
                            d = label.getLinkedComponent().getPreferredSize();
                        } else {
                            actualWidth = d.width;
                        }
                        if (d.width > 0) {
                            spanW = d.width;
                        }
                    } else {
                        d = label.getSize();
                        if (d.width > 0) {
                            spanW = d.width;
                            actualWidth = d.width;
                        }
                    }
                    if (spanW > 0 && label.getMinimumWrapWidth() > 0) {
                        spanW = Math.max(spanW, actualWidth > 0 ? actualWidth : label.getMinimumWrapWidth());
                    }
                }
                if (spanH == -101) {
                    if (label.getLinkedComponent() != null) {
                        Dimension d = label.getLinkedComponent().getSize();
                        if (d.height <= 0) {
                            d = label.getLinkedComponent().getPreferredSize();
                        }
                        if (d.height > 0) {
                            spanH = d.height;
                        }
                    } else {
                        Dimension d = label.getSize();
                        if (d.height > 0) {
                            spanH = d.height;
                        }
                    }
                }
                this.iconR.height = 0;
                this.iconR.width = 0;
                this.iconR.y = 0;
                this.iconR.x = 0;
                this.textR.height = 0;
                this.textR.width = 0;
                this.textR.y = 0;
                this.textR.x = 0;
                this.viewR.x = dx;
                this.viewR.y = dy;
                this.viewR.height = Short.MAX_VALUE;
                this.viewR.width = Short.MAX_VALUE;
                if (spanW != -1 && spanW != -101) {
                    this.viewR.width = spanW;
                }
                if (spanH != -1 && spanH != -101) {
                    this.viewR.height = spanH;
                }
                if (vertical) {
                    clippedMode = false;
                }
                this.layoutCL(label, fm, text, icon, this.viewR, this.iconR, this.textR, label.getOrientation(), label.getLineWrap(), label.getWrapStyleWord(), label.getGapBetweenLines(), clippedMode, label.getTabSize(), label.getLeadingContentOffset(), label.getTopContentOffset(), label.getReplaceTab(), label.getReplaceNewline());
                int x1 = Math.min(this.iconR.x, this.textR.x);
                int x2 = Math.max(this.iconR.x + this.iconR.width, this.textR.x + this.textR.width);
                int y1 = Math.min(this.iconR.y, this.textR.y);
                int y2 = Math.max(this.iconR.y + this.iconR.height, this.textR.y + this.textR.height);
                rv = new Dimension(x2 - x1, y2 - y1);
            }
            if (spanW != -1 && spanW != -101) {
                rv.width = Math.min(rv.width, spanW);
            }
            if (spanH != -1 && spanH != -101) {
                rv.height = Math.min(rv.height, spanH);
            }
            rv.width += dx;
            rv.height += dy;
            return rv;
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        block25: {
            Icon icon;
            if (!(c instanceof LabelView)) break block25;
            LabelView label = (LabelView)c;
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int fontAscent = fm.getAscent();
            int numLines = 1;
            boolean maxline = false;
            int gapBetweenLines = label.getGapBetweenLines();
            String[] lines = null;
            paintViewInsets = c.getInsets();
            BasicLabelViewUI.paintViewR.x = BasicLabelViewUI.paintViewInsets.left;
            BasicLabelViewUI.paintViewR.y = BasicLabelViewUI.paintViewInsets.top;
            BasicLabelViewUI.paintViewR.width = c.getWidth() - (BasicLabelViewUI.paintViewInsets.left + BasicLabelViewUI.paintViewInsets.right);
            BasicLabelViewUI.paintViewR.height = c.getHeight() - (BasicLabelViewUI.paintViewInsets.top + BasicLabelViewUI.paintViewInsets.bottom);
            BasicLabelViewUI.paintIconR.height = 0;
            BasicLabelViewUI.paintIconR.width = 0;
            BasicLabelViewUI.paintIconR.y = 0;
            BasicLabelViewUI.paintIconR.x = 0;
            BasicLabelViewUI.paintTextR.height = 0;
            BasicLabelViewUI.paintTextR.width = 0;
            BasicLabelViewUI.paintTextR.y = 0;
            BasicLabelViewUI.paintTextR.x = 0;
            boolean clippedMode = label.isClipped();
            boolean vertical = false;
            if (label.getOrientation() == 1) {
                vertical = true;
            }
            boolean individualAlign = false;
            if (label.getAlignmentMode() == 1) {
                individualAlign = true;
            }
            if (vertical) {
                clippedMode = false;
            }
            text = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR, label.getOrientation(), label.getLineWrap(), label.getWrapStyleWord(), label.getGapBetweenLines(), clippedMode, label.getTabSize(), label.getLeadingContentOffset(), label.getTopContentOffset(), label.getReplaceTab(), label.getReplaceNewline());
            if (icon != null) {
                icon.paintIcon(c, g, BasicLabelViewUI.paintIconR.x, BasicLabelViewUI.paintIconR.y);
            }
            if (text != null) {
                lines = Util.breakupLines(text, label.getReplaceTab(), label.getReplaceNewline());
                numLines = lines.length;
                int accChar = label.getDisplayedMnemonic();
                int textX = BasicLabelViewUI.paintTextR.x;
                int textY = BasicLabelViewUI.paintTextR.y + fontAscent;
                int textWidth = BasicLabelViewUI.paintTextR.width;
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, paintTextR);
                } else if (vertical) {
                    int pixelWidth = fm.stringWidth("W");
                    int pixelColumnWidth = gapBetweenLines + pixelWidth;
                    char[] oneChar = new char[1];
                    int i = 0;
                    while (i < numLines) {
                        String line = lines[i];
                        int strlen = line.length();
                        if (individualAlign) {
                            BasicLabelViewUI.oPaintIconR.height = 0;
                            BasicLabelViewUI.oPaintIconR.width = 0;
                            BasicLabelViewUI.oPaintIconR.y = 0;
                            BasicLabelViewUI.oPaintIconR.x = 0;
                            BasicLabelViewUI.oPaintTextR.height = 0;
                            BasicLabelViewUI.oPaintTextR.width = 0;
                            BasicLabelViewUI.oPaintTextR.y = 0;
                            BasicLabelViewUI.oPaintTextR.x = 0;
                            line = this.layoutCL(label, fm, line, icon, paintViewR, oPaintIconR, oPaintTextR, 1, label.getLineWrap(), label.getWrapStyleWord(), gapBetweenLines, clippedMode, label.getTabSize(), label.getLeadingContentOffset(), label.getTopContentOffset(), label.getReplaceTab(), label.getReplaceNewline());
                            textY = BasicLabelViewUI.oPaintTextR.y + fontAscent;
                        }
                        int j = 0;
                        int k = textY;
                        while (j < strlen) {
                            oneChar[0] = lines[i].charAt(j);
                            String oneCharStr = new String(oneChar);
                            int offset = (pixelWidth - fm.stringWidth(oneCharStr)) / 2;
                            if (label.isEnabled()) {
                                if (this.paintEnabledText(label, g, oneCharStr, textX + offset, k, accChar)) {
                                    accChar = 0;
                                }
                            } else if (this.paintDisabledText(label, g, oneCharStr, textX + offset, k, accChar)) {
                                accChar = 0;
                            }
                            ++j;
                            k += fontHeight;
                        }
                        ++i;
                        textX += pixelColumnWidth;
                    }
                } else {
                    int i = 0;
                    while (i < numLines) {
                        int w;
                        String clipped = lines[i];
                        if (individualAlign) {
                            BasicLabelViewUI.oPaintIconR.height = 0;
                            BasicLabelViewUI.oPaintIconR.width = 0;
                            BasicLabelViewUI.oPaintIconR.y = 0;
                            BasicLabelViewUI.oPaintIconR.x = 0;
                            BasicLabelViewUI.oPaintTextR.height = 0;
                            BasicLabelViewUI.oPaintTextR.width = 0;
                            BasicLabelViewUI.oPaintTextR.y = 0;
                            BasicLabelViewUI.oPaintTextR.x = 0;
                            clipped = this.layoutCL(label, fm, clipped, icon, paintViewR, oPaintIconR, oPaintTextR, 0, label.getLineWrap(), label.getWrapStyleWord(), label.getGapBetweenLines(), clippedMode, label.getTabSize(), label.getLeadingContentOffset(), label.getTopContentOffset(), label.getReplaceTab(), label.getReplaceNewline());
                            textX = BasicLabelViewUI.oPaintTextR.x;
                        } else if (clippedMode && (w = SwingUtilities.computeStringWidth(fm, clipped)) > textWidth) {
                            clipped = Util.getClippedText(clipped, fm, textWidth);
                        }
                        if (label.isEnabled()) {
                            if (this.paintEnabledText(label, g, clipped, textX, textY, accChar)) {
                                accChar = 0;
                            }
                        } else if (this.paintDisabledText(label, g, clipped, textX, textY, accChar)) {
                            accChar = 0;
                        }
                        ++i;
                        textY += fontHeight + gapBetweenLines;
                    }
                }
            }
        }
    }
}

