/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.TableModelInsertRowSupport;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.table.AccurateRowCountInterface;
import com.sas.table.DeleteRowInterface;
import com.sas.table.InsertRowInterface;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.table.UpdateRowInterface;
import com.sas.util.GenericComparator;
import com.sas.util.SortDirectionInterface;
import com.sas.util.UncheckedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class SortableTableModelAdapter
extends AbstractTableModel
implements SortableInterface,
ViewDefaultModel,
TrueRowCountCalculatedInterface,
TableModelListener,
DeleteRowInterface,
InsertRowInterface,
UpdateRowInterface,
SortDirectionInterface,
StaticRowLabelInterface {
    protected boolean defaultModelAttached;
    protected int[] indexes = new int[0];
    protected String[] sortingColumns = new String[0];
    protected String[] sortedColumns;
    protected int[] sortingDirections;
    protected int[] sortedDirections;
    protected TableModel model;
    protected Comparator defaultComparator = GenericComparator.defaultInstance;
    protected Map columnComparators = new HashMap();
    protected SwingPropertyChangeSupport propertyChangeSupport;
    private TableModelInsertRowSupport helper = new TableModelInsertRowSupport();
    protected boolean sortAllowed = true;
    protected boolean staticRowLabelOrder = false;
    protected boolean autoResort = false;
    protected boolean caseSensitive = false;
    private boolean committingRow = false;
    private boolean freshSort;

    public SortableTableModelAdapter() {
        this(null);
    }

    public SortableTableModelAdapter(TableModel model) {
        this(model, false);
    }

    @SASScope
    public SortableTableModelAdapter(TableModel model, boolean freshSort) {
        this.setModel(model);
        this.freshSort = freshSort;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel newModel) {
        boolean defaultModelUsed = false;
        if (newModel == null) {
            defaultModelUsed = true;
            newModel = this.newDefaultModel();
        }
        if (this.model != newModel) {
            TableModel oldModel = this.model;
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            this.model = newModel;
            this.model.addTableModelListener(this);
            this.columnComparators.clear();
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
            this.fireTableStructureChanged();
            this.reallocateIndexes();
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    protected TableModel newDefaultModel() {
        this.setDefaultModelAttached(true);
        return new DefaultTableModel();
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
            this.firePropertyChange("defaultModelAttached", this.defaultModelAttached ? Boolean.FALSE : Boolean.TRUE, this.defaultModelAttached ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        if (this.helper.isUncommittedRowPresent()) {
            if (aRow == this.helper.getUncommittedRowNumber()) {
                return this.helper.getValueAt(aColumn);
            }
            aRow = this.helper.getAdjustedRowNumber(aRow);
        }
        if (aRow > this.indexes.length) {
            Object value = this.model.getValueAt(aRow, aColumn);
            this.resort();
            return this.model.getValueAt(this.indexes[aRow], aColumn);
        }
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        if (this.helper.isUncommittedRowPresent()) {
            if (aRow == this.helper.getUncommittedRowNumber()) {
                this.helper.setValueAt(aValue, aColumn);
                return;
            }
            aRow = this.helper.getAdjustedRowNumber(aRow);
        }
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public int convertRowIndexToModel(int viewIndex) {
        if (viewIndex >= 0 && viewIndex < this.indexes.length) {
            return this.indexes[viewIndex];
        }
        return -1;
    }

    public int convertRowIndexToView(int modelIndex) {
        if (modelIndex >= 0) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] != modelIndex) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        int rowCount = this.model.getRowCount();
        if (this.helper.isUncommittedRowPresent()) {
            ++rowCount;
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.helper.isUncommittedRowPresent()) {
            if (row == this.helper.getUncommittedRowNumber()) {
                return true;
            }
            row = this.helper.getAdjustedRowNumber(row);
        }
        return this.model.isCellEditable(this.convertRowIndexToModel(row), column);
    }

    public void setDefaultComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = GenericComparator.defaultInstance;
        }
        if (this.defaultComparator != comparator) {
            Comparator old = this.defaultComparator;
            this.defaultComparator = comparator;
            this.firePropertyChange("defaultComparator", old, this.defaultComparator);
        }
    }

    public Comparator getDefaultComparator() {
        return this.defaultComparator;
    }

    public Comparator getColumnComparator(String column) {
        return (Comparator)this.columnComparators.get(column);
    }

    public void setColumnComparator(String column, Comparator comparator) {
        Comparator oldComparator = this.getColumnComparator(column);
        if (oldComparator != comparator) {
            if (comparator != null) {
                this.columnComparators.put(column, comparator);
            } else {
                this.columnComparators.remove(column);
            }
        }
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
        this.sortedColumns = new String[0];
        this.sortedDirections = new int[0];
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.autoResort) {
            if (e == null || e.getFirstRow() == -1) {
                this.reallocateIndexes();
                this.fireTableChanged(e);
                return;
            }
            if (e.getType() == 1) {
                int i;
                int start = e.getFirstRow();
                int end = e.getLastRow();
                if (start < 0) {
                    start = 0;
                }
                int addedCount = end - start + 1;
                int[] clone = new int[this.indexes.length + addedCount];
                int count = 0;
                for (i = 0; i < this.indexes.length; ++i) {
                    if (i < start) {
                        if (this.indexes[i] < start) {
                            clone[count++] = this.indexes[i];
                            continue;
                        }
                        clone[count++] = this.indexes[i] + addedCount;
                        continue;
                    }
                    clone[addedCount + count++] = this.indexes[i] < start ? this.indexes[i] : this.indexes[i] + addedCount;
                }
                for (i = start; i <= end; ++i) {
                    clone[i] = i;
                }
                this.indexes = clone;
                if (!this.committingRow) {
                    this.fireTableChanged(e);
                }
                return;
            }
            if (e.getType() == -1) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                if (start < 0) {
                    start = 0;
                }
                int deletedCount = end - start + 1;
                int[] clone = new int[this.indexes.length - deletedCount];
                int count = 0;
                for (int i = 0; i < this.indexes.length; ++i) {
                    if (this.indexes[i] < start) {
                        clone[count++] = this.indexes[i];
                        continue;
                    }
                    if (this.indexes[i] <= end) continue;
                    clone[count++] = this.indexes[i] - deletedCount;
                }
                this.indexes = clone;
                this.fireTableChanged(e);
                return;
            }
            if (this.getRowCount() != this.indexes.length) {
                this.reallocateIndexes();
                this.fireTableChanged(e);
            }
            this.fireTableChanged(e);
        } else {
            int rowCount = this.model.getRowCount();
            this.indexes = new int[rowCount];
            for (int row = 0; row < rowCount; ++row) {
                this.indexes[row] = row;
            }
            this.resort();
            this.fireTableChanged(e);
        }
    }

    private void sort() {
        int rowCount = this.model.getRowCount();
        if (this.sortingColumns.length != 0) {
            Comparator comparator = null;
            Object[] values = new Object[rowCount];
            int sameColumns = this.countSameColumns();
            int[] columns = this.createSortingColumnIndexArray(sameColumns);
            Object[][] orig = this.createModelDataArray(rowCount, columns);
            for (int i = columns.length - 1; i >= 0; --i) {
                comparator = this.getColumnComparator(this.sortingColumns[i]);
                if (comparator == null) {
                    comparator = this.defaultComparator;
                }
                for (int j = 0; j < values.length; ++j) {
                    values[j] = orig[i][this.indexes[j]];
                }
                this.shuttlesort((int[])this.indexes.clone(), this.indexes, (Object[])values.clone(), values, comparator, 0, rowCount, this.sortingDirections[i]);
            }
            this.sortedColumns = (String[])this.sortingColumns.clone();
            this.sortedDirections = (int[])this.sortingDirections.clone();
            if (columns.length > 0) {
                this.fireTableRowsUpdated(0, rowCount - 1);
            }
        } else {
            this.reallocateIndexes();
            this.sortedColumns = new String[0];
            this.sortedDirections = new int[0];
            this.fireTableRowsUpdated(0, rowCount - 1);
        }
    }

    private int countSameColumns() {
        if (this.freshSort) {
            return 0;
        }
        int sameColumns = 0;
        if (this.sortingColumns != null && this.sortedColumns != null && this.sortedDirections != null && this.sortingDirections != null) {
            for (int i = 0; i < Math.min(this.sortedColumns.length, this.sortingColumns.length) && this.sortedColumns[this.sortedColumns.length - i - 1] == this.sortingColumns[this.sortingColumns.length - i - 1] && this.sortedDirections[this.sortedDirections.length - i - 1] == this.sortingDirections[this.sortingDirections.length - i - 1]; ++i) {
                ++sameColumns;
            }
        }
        return sameColumns;
    }

    private int[] createSortingColumnIndexArray(int sameColumns) {
        int[] columns = new int[this.sortingColumns.length - sameColumns];
        for (int i = columns.length - 1; i >= 0; --i) {
            columns[i] = this.findColumn(this.sortingColumns[i]);
        }
        return columns;
    }

    private Object[][] createModelDataArray(int rowCount, int[] columns) {
        Object[][] orig = new Object[columns.length][rowCount];
        for (int j = 0; j < rowCount; ++j) {
            for (int i = columns.length - 1; i >= 0; --i) {
                orig[i][j] = this.model.getValueAt(j, columns[i]);
            }
        }
        return orig;
    }

    private int compare(Comparator comp, Object value1, Object value2, int direction) {
        int result = 0;
        result = !this.isCaseSensitive() && value1 instanceof String && value2 instanceof String ? comp.compare(((String)value1).toLowerCase(), ((String)value2).toLowerCase()) : comp.compare(value1, value2);
        if (result != 0) {
            return direction == 0 ? result : -result;
        }
        return result;
    }

    private void shuttlesort(int[] from, int[] to, Object[] origValues, Object[] values, Comparator comp, int low, int high, int direction) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, values, origValues, comp, low, middle, direction);
        this.shuttlesort(to, from, values, origValues, comp, middle, high, direction);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(comp, origValues[middle - 1], origValues[middle], direction) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
                values[i] = origValues[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            if (q >= high || p < middle && this.compare(comp, origValues[p], origValues[q], direction) <= 0) {
                values[i] = origValues[p];
                to[i] = from[p++];
                continue;
            }
            values[i] = origValues[q];
            to[i] = from[q++];
        }
    }

    private void quickSort(int[] list, Object[] values, Comparator comp, int first, int last, int direction) {
        if (first >= last) {
            return;
        }
        int lo = first;
        int hi = last;
        Object mid = values[(first + last) / 2];
        while (true) {
            if (comp.compare(values[lo], mid) < 0) {
                ++lo;
                continue;
            }
            while (comp.compare(values[hi], mid) > 0) {
                --hi;
            }
            if (lo <= hi) {
                int temp2 = list[lo];
                list[lo] = list[hi];
                list[hi] = temp2;
                Object temp = values[lo];
                values[lo++] = values[hi];
                values[hi--] = temp;
            }
            if (lo > hi) break;
        }
        this.quickSort(list, values, comp, first, hi, direction);
        this.quickSort(list, values, comp, lo, last, direction);
    }

    public void sortColumn(String column) {
        this.sortColumn(column, 0);
    }

    public void sortColumn(String column, int direction) {
        this.sortColumns(new String[]{column}, new int[]{direction});
    }

    public void sortColumns(String[] columns, int[] directions) {
        this.sortingDirections = directions;
        this.sortingColumns = columns;
        this.sort();
    }

    public void sort(String[] columnNames, int[] direction) throws SortException {
        this.sortColumns(columnNames, direction);
    }

    public String[] getSortedColumns() {
        if (this.sortedColumns != null) {
            return this.sortedColumns;
        }
        return new String[0];
    }

    public int[] getSortedDirections() {
        if (this.sortedDirections != null) {
            return this.sortedDirections;
        }
        return new int[0];
    }

    public boolean isColumnSortable(String columnName) {
        return this.sortAllowed;
    }

    public boolean isSortAllowed() {
        return this.sortAllowed;
    }

    public void setSortAllowed(boolean allowSorting) {
        if (allowSorting != this.sortAllowed) {
            this.sortAllowed = allowSorting;
            this.firePropertyChange("sortAllowed", this.sortAllowed ? Boolean.FALSE : Boolean.TRUE, this.sortAllowed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive != caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.firePropertyChange("caseSensitive", caseSensitive ? Boolean.FALSE : Boolean.TRUE, caseSensitive ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void insertUncommittedRow(int rowIndex) throws UncheckedException {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InsertRowInterface) {
            ((InsertRowInterface)tableModel).insertUncommittedRow(rowIndex);
        } else if (tableModel instanceof DefaultTableModel) {
            this.helper.insertUncommittedRow((TableModel)this, rowIndex);
            rowIndex = this.getUncommittedRowNumber();
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitUncommittedRow() throws UncheckedException {
        try {
            this.committingRow = true;
            TableModel tableModel = this.getModel();
            if (tableModel instanceof InsertRowInterface) {
                ((InsertRowInterface)tableModel).commitUncommittedRow();
            } else if (tableModel instanceof DefaultTableModel) {
                int rowIndex = this.getUncommittedRowNumber();
                Object[] temp = this.helper.commitUncommittedRow((TableModel)this);
                if (temp == null) {
                    return;
                }
                if (rowIndex != -1) {
                    ((DefaultTableModel)tableModel).insertRow(rowIndex, temp);
                } else {
                    ((DefaultTableModel)tableModel).addRow(temp);
                }
            }
        }
        finally {
            this.committingRow = false;
        }
    }

    public void cancelUncommittedRow() throws UncheckedException {
        TableModel tableModel = this.getModel();
        int row = this.getUncommittedRowNumber();
        if (tableModel instanceof InsertRowInterface) {
            ((InsertRowInterface)tableModel).cancelUncommittedRow();
        } else if (this.helper.isUncommittedRowPresent()) {
            this.helper.cancelUncommittedRow((TableModel)this);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public boolean isUncommittedRowPresent() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InsertRowInterface) {
            return ((InsertRowInterface)tableModel).isUncommittedRowPresent();
        }
        return this.helper.isUncommittedRowPresent();
    }

    public int getUncommittedRowNumber() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InsertRowInterface) {
            return ((InsertRowInterface)tableModel).getUncommittedRowNumber();
        }
        return this.helper.getUncommittedRowNumber();
    }

    public boolean isRowInsertionAllowed() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InsertRowInterface) {
            return ((InsertRowInterface)tableModel).isRowInsertionAllowed();
        }
        return tableModel instanceof DefaultTableModel;
    }

    public boolean isTableExtendOnly() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InsertRowInterface) {
            return ((InsertRowInterface)tableModel).isTableExtendOnly();
        }
        if (tableModel instanceof DefaultTableModel) {
            return false;
        }
        return false;
    }

    public boolean isRowUpdateAllowed() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof UpdateRowInterface) {
            return ((UpdateRowInterface)tableModel).isRowUpdateAllowed();
        }
        return tableModel instanceof DefaultTableModel;
    }

    public void deleteRow(int rowIndex) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof DeleteRowInterface) {
            ((DeleteRowInterface)tableModel).deleteRow(this.indexes[rowIndex]);
        } else if (tableModel instanceof DefaultTableModel) {
            ((DefaultTableModel)tableModel).removeRow(this.indexes[rowIndex]);
        }
    }

    public boolean isRowDeletionAllowed() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof DeleteRowInterface) {
            return ((DeleteRowInterface)tableModel).isRowDeletionAllowed();
        }
        return tableModel instanceof DefaultTableModel;
    }

    public boolean isAccurateRowCountAvailable() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof AccurateRowCountInterface) {
            return ((AccurateRowCountInterface)tableModel).isAccurateRowCountAvailable();
        }
        return true;
    }

    public boolean isTrueRowCountCalculated() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TrueRowCountCalculatedInterface) {
            return ((TrueRowCountCalculatedInterface)tableModel).isTrueRowCountCalculated();
        }
        return true;
    }

    public void setTrueRowCountCalculated(boolean trueRowCountCalculated) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TrueRowCountCalculatedInterface) {
            ((TrueRowCountCalculatedInterface)tableModel).setTrueRowCountCalculated(trueRowCountCalculated);
        }
    }

    public void setStaticRowLabelOrder(boolean useStaticRowLabelOrder) {
        if (this.staticRowLabelOrder != useStaticRowLabelOrder) {
            this.staticRowLabelOrder = useStaticRowLabelOrder;
            this.firePropertyChange("staticRowLabelOrder", this.staticRowLabelOrder ? Boolean.FALSE : Boolean.TRUE, this.staticRowLabelOrder ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isStaticRowLabelOrder() {
        return this.staticRowLabelOrder;
    }

    public void setAutoResortEnabled(boolean useAutoResort) {
        if (this.autoResort != useAutoResort) {
            this.autoResort = useAutoResort;
            this.firePropertyChange("autoResortEnabled", this.autoResort ? Boolean.FALSE : Boolean.TRUE, this.autoResort ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isAutoResortEnabled() {
        return this.autoResort;
    }

    public void resort() {
        int[] resortingDirections = this.getSortedDirections();
        String[] resortingColumns = this.getSortedColumns();
        this.sortedColumns = new String[0];
        this.sortedDirections = new int[0];
        this.sortColumns(resortingColumns, resortingDirections);
    }

    public Object getRowLabel(int row) {
        if (this.staticRowLabelOrder) {
            return new Integer(row + 1);
        }
        if (this.helper.isUncommittedRowPresent()) {
            if (row == this.helper.getUncommittedRowNumber()) {
                return null;
            }
            row = this.helper.getAdjustedRowNumber(row);
        }
        return new Integer(this.indexes[row] + 1);
    }

    public Object[] getRowLabels(int startIndex, int count) {
        Object[] labels = new Object[count];
        if (this.staticRowLabelOrder) {
            for (int i = 0; i < count; ++i) {
                labels[i] = new Integer(i + startIndex + 1);
            }
        } else if (this.helper.isUncommittedRowPresent()) {
            for (int i = 0; i < count; ++i) {
                labels[i] = i == this.helper.getUncommittedRowNumber() ? null : new Integer(this.indexes[this.helper.getAdjustedRowNumber(i) + startIndex] + 1);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                labels[i] = new Integer(this.indexes[i + startIndex] + 1);
            }
        }
        return labels;
    }

    public boolean isRowLabelsSupported() {
        return true;
    }

    public boolean isRowsLabelSupported() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        }
        this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
    }
}

