/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.models.OLAPMemberTreeNode;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
@SubjectToChange
public class OLAPMemberDeferredRetrievalTreeNode
extends OLAPMemberTreeNode {
    private boolean initialized = false;
    private ValueGetter getter;

    public OLAPMemberDeferredRetrievalTreeNode() {
        this.initialized = true;
    }

    private boolean getInitialized() {
        return this.initialized;
    }

    private void setValueGetter(ValueGetter getter) {
        this.getter = getter;
        this.initialized = false;
    }

    public OLAPMemberDeferredRetrievalTreeNode(OLAPDataSetInterface model, int[] axesShown, boolean axesVisible) throws OLAPException {
        super(model);
        this.getter = new OLAPDataSetInterfaceValueGetter(model, axesShown, axesVisible);
    }

    public OLAPMemberDeferredRetrievalTreeNode(TupleElementInterface element) throws OLAPException {
        super(element);
        this.getter = new TupleElementValueGetter(element);
    }

    public OLAPMemberDeferredRetrievalTreeNode(AxisInterface axis) throws OLAPException {
        super(axis);
        this.getter = new AxisValueGetter(axis);
    }

    private synchronized boolean doInit() {
        if (!this.initialized && this.getter != null) {
            try {
                this.initialized = true;
                this.getter.getValues(this);
            }
            catch (Exception e) {
                this.initialized = false;
            }
        }
        return this.initialized;
    }

    public Enumeration children() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.children();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        if (!this.initialized && this.getter != null) {
            return this.getter.getChildCount();
        }
        return super.getChildCount();
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getIndex(node);
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public boolean isLeaf() {
        if (this.getter != null) {
            return this.getter.getChildCount() == 0;
        }
        return super.isLeaf();
    }

    @Override
    public void insert(MutableTreeNode node, int index) {
        super.insert(node, index);
    }

    @Override
    public void remove(int index) {
        if (!this.initialized) {
            this.doInit();
        }
        super.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (!this.initialized) {
            this.doInit();
        }
        super.remove(node);
    }

    @Override
    public void removeFromParent() {
        if (!this.initialized) {
            this.doInit();
        }
        super.removeFromParent();
    }

    @Override
    public void setParent(MutableTreeNode node) {
        super.setParent(node);
    }

    public Enumeration breadthFirstEnumeration() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.breadthFirstEnumeration();
    }

    public Enumeration depthFirstEnumeration() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.depthFirstEnumeration();
    }

    @Override
    public TreeNode getChildAfter(TreeNode aChild) {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getChildAfter(aChild);
    }

    @Override
    public TreeNode getChildBefore(TreeNode aChild) {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getChildBefore(aChild);
    }

    @Override
    public TreeNode getFirstChild() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getFirstChild();
    }

    @Override
    public DefaultMutableTreeNode getFirstLeaf() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getFirstLeaf();
    }

    @Override
    public TreeNode getLastChild() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getLastChild();
    }

    @Override
    public DefaultMutableTreeNode getLastLeaf() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getLastLeaf();
    }

    @Override
    public int getLeafCount() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getLeafCount();
    }

    @Override
    public DefaultMutableTreeNode getNextLeaf() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getNextLeaf();
    }

    @Override
    public DefaultMutableTreeNode getNextNode() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getNextNode();
    }

    @Override
    public DefaultMutableTreeNode getPreviousLeaf() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getPreviousLeaf();
    }

    @Override
    public DefaultMutableTreeNode getPreviousNode() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.getPreviousNode();
    }

    @Override
    public boolean isNodeChild(TreeNode aNode) {
        if (!this.initialized) {
            this.doInit();
        }
        return super.isNodeChild(aNode);
    }

    public Enumeration postorderEnumeration() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.postorderEnumeration();
    }

    public Enumeration preorderEnumeration() {
        if (!this.initialized) {
            this.doInit();
        }
        return super.preorderEnumeration();
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.initialized = false;
    }

    @SASScope
    private class OLAPDataSetInterfaceValueGetter
    extends ValueGetter {
        private OLAPDataSetInterface model;
        private int[] axesShown;
        private boolean axesVisible;
        private int childCount;

        public OLAPDataSetInterfaceValueGetter(OLAPDataSetInterface odsi, int[] axesShown, boolean axesVisible) {
            this.model = odsi;
            this.axesShown = axesShown;
            this.axesVisible = axesVisible;
            this.childCount = -1;
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
            int count = 0;
            if (this.axesVisible) {
                for (int i = 0; i < this.axesShown.length; ++i) {
                    for (int j = 0; j < axes.length; ++j) {
                        if (this.axesShown[i] != axes[j].getAxisNumber()) continue;
                        root.insert(new OLAPMemberDeferredRetrievalTreeNode(axes[j]), count++);
                    }
                }
            } else {
                for (int i = 0; i < this.axesShown.length; ++i) {
                    for (int j = 0; j < axes.length; ++j) {
                        if (this.axesShown[i] != axes[j].getAxisNumber() || axes[j].getTupleCount() <= 0) continue;
                        TupleInterface[] tuples = axes[j].getTuples(0, -1);
                        TupleElementInterface[] elements = OLAPMemberTreeNode.getTupleElementsForLevel(0, tuples, false, -1);
                        for (int k = 0; k < elements.length; ++k) {
                            if (OLAPMemberTreeNode.getChildCount(elements[k]) > 0) {
                                root.insert(new OLAPMemberDeferredRetrievalTreeNode(elements[k]), count++);
                                continue;
                            }
                            root.insert(new OLAPMemberTreeNode(elements[k]), count++);
                        }
                    }
                }
            }
        }

        @Override
        public int getChildCount() {
            if (this.childCount == -1) {
                this.childCount = 0;
                try {
                    AxisInterface[] axes = this.model.getResultSetMetadata().getAxes(0, -1);
                    if (this.axesVisible) {
                        for (int i = 0; i < axes.length; ++i) {
                            if (!this.usingAxis(axes[i].getAxisNumber())) continue;
                            ++this.childCount;
                        }
                    } else {
                        int count = 0;
                        for (int i = 0; i < axes.length; ++i) {
                            if (!this.usingAxis(axes[i].getAxisNumber()) || axes[i].getTupleCount() <= 0) continue;
                            TupleInterface[] tuples = axes[i].getTuples(0, -1);
                            TupleElementInterface[] elements = OLAPMemberTreeNode.getTupleElementsForLevel(0, tuples, false, -1);
                            count += elements.length;
                        }
                        this.childCount = count;
                    }
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
            return this.childCount;
        }

        private boolean usingAxis(int axis) {
            if (this.axesShown != null) {
                for (int i = 0; i < this.axesShown.length; ++i) {
                    if (this.axesShown[i] != axis) continue;
                    return true;
                }
            }
            return false;
        }
    }

    @SASScope
    private class AxisValueGetter
    extends ValueGetter {
        private AxisInterface axis;
        private int childCount;

        public AxisValueGetter(AxisInterface axis) {
            this.axis = axis;
            this.childCount = -1;
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            if (this.axis.getTupleCount() > 0) {
                TupleInterface[] tuples = this.axis.getTuples(0, -1);
                TupleElementInterface[] elements = OLAPMemberTreeNode.getTupleElementsForLevel(0, tuples, false, -1);
                for (int i = 0; i < elements.length; ++i) {
                    if (OLAPMemberTreeNode.getChildCount(elements[i]) > 0) {
                        root.insert(new OLAPMemberDeferredRetrievalTreeNode(elements[i]), i);
                        continue;
                    }
                    root.insert(new OLAPMemberTreeNode(elements[i]), i);
                }
            }
        }

        @Override
        public int getChildCount() {
            if (this.childCount == -1) {
                try {
                    if (this.axis.getTupleCount() > 0) {
                        TupleInterface[] tuples = this.axis.getTuples(0, -1);
                        TupleElementInterface[] elements = OLAPMemberTreeNode.getTupleElementsForLevel(0, tuples, false, -1);
                        this.childCount = elements.length;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.childCount;
        }
    }

    @SASScope
    private class TupleElementValueGetter
    extends ValueGetter {
        private TupleElementInterface element;
        private int childCount;

        public TupleElementValueGetter(TupleElementInterface element) {
            this.element = element;
            this.childCount = -1;
        }

        @Override
        public void getValues(MutableTreeNode root) throws Exception {
            int i;
            int min = this.element.getMinimumCoordinate();
            int max = this.element.getMaximumCoordinate();
            TupleInterface[] tuples = this.element.getTuple().getAxis().getTuples(min, max - min + 1);
            TupleElementInterface[] elements = this.element.getTuple().getElements(0, this.element.getTupleElementIndex() + 1);
            int level = 0;
            for (i = 0; i < elements.length; ++i) {
                level += elements[i].getSpan();
            }
            elements = OLAPMemberTreeNode.getTupleElementsForLevel(level, tuples, false, -1);
            for (i = 0; i < elements.length; ++i) {
                if (OLAPMemberTreeNode.getChildCount(elements[i]) > 0) {
                    root.insert(new OLAPMemberDeferredRetrievalTreeNode(elements[i]), i);
                    continue;
                }
                root.insert(new OLAPMemberTreeNode(elements[i]), i);
            }
        }

        @Override
        public int getChildCount() {
            if (this.childCount == -1) {
                this.childCount = OLAPMemberTreeNode.getChildCount(this.element);
            }
            return this.childCount;
        }
    }

    @SASScope
    private abstract class ValueGetter
    implements Serializable {
        private ValueGetter() {
        }

        public abstract void getValues(MutableTreeNode var1) throws Exception;

        public abstract int getChildCount();
    }
}

