/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.swing.adapters.JTableClipboardAdapter;
import com.sas.swing.adapters.RB;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.TableDataValidationInterface;
import com.sas.text.Message;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class TableViewClipboardAdapter
extends JTableClipboardAdapter {
    public static final String RB_KEY = "TableViewClipboardAdapter.";
    protected TableView table;

    public TableViewClipboardAdapter(TableView table) {
        super(table);
        this.table = table;
    }

    public static boolean canCopy(TableView table) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        int numCols = table.getSelectedColumnCount();
        int numRows = table.getSelectedRowCount();
        int numCells = table.getSelectedCellCount();
        int[][] cellsSelected = table.getSelectedCells();
        int[] rowsSelected = table.getSelectedRows();
        int[] colsSelected = table.getSelectedColumns();
        boolean ret = false;
        if (!(!table.getCellSelectionEnabled() || numCells <= 0 || numCols != 0 && numCols != colCount || numRows != 0 && numRows != rowCount)) {
            int x1 = cellsSelected[0][0];
            int y1 = cellsSelected[0][1];
            int x2 = cellsSelected[cellsSelected.length - 1][0];
            int y2 = cellsSelected[cellsSelected.length - 1][1];
            ListSelectionModel lsm = table.getSelectionModel();
            int min = lsm.getMinSelectionIndex();
            int max = lsm.getMaxSelectionIndex();
            if ((Math.abs(x2 - x1) + 1) * (Math.abs(y2 - y1) + 1) == numCells && lsm.isSelectedIndex(min) && lsm.isSelectedIndex(max)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (!(!table.getColumnSelectionAllowed() || numCols <= 0 || numCells != 0 && numCells != colCount * rowCount || numRows != 0 && numRows != rowCount)) {
            ret = true;
        }
        if (!(!table.getRowSelectionAllowed() || numRows <= 0 || numCells != 0 && numCells != colCount * rowCount || numCols != 0 && numCols != colCount)) {
            ret = true;
        }
        return ret;
    }

    public static boolean canCut(TableView table) {
        boolean ret = TableViewClipboardAdapter.canCopy(table);
        if (ret) {
            int[][] cells = table.getSelectedCells();
            for (int i = 0; i < cells.length; ++i) {
                if (table.isCellEditable(cells[i][0], cells[i][1])) continue;
                return false;
            }
            int[] rows = table.getSelectedRows();
            int colCount = table.getColumnCount();
            for (int i = 0; i < rows.length; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    if (table.isCellEditable(rows[i], j)) continue;
                    return false;
                }
            }
            int[] cols = table.getSelectedColumns();
            int rowCount = table.getRowCount();
            for (int i = 0; i < cols.length; ++i) {
                for (int j = 0; j < rowCount; ++j) {
                    if (table.isCellEditable(j, cols[i])) continue;
                    return false;
                }
            }
        }
        return ret;
    }

    public static boolean canPaste(TableView table) {
        boolean ret = false;
        if (TableViewClipboardAdapter.canCopy(table)) {
            try {
                Transferable transfer = TableViewClipboardAdapter.getClipboard().getContents(null);
                if (transfer != null && transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                    List clipboardGrid = TableViewClipboardAdapter.parseContents(data);
                    if (clipboardGrid.isEmpty()) {
                        return false;
                    }
                    int clipRowCount = clipboardGrid.size();
                    int clipColCount = 1;
                    for (int i = 0; i < clipRowCount; ++i) {
                        if (((List)clipboardGrid.get(i)).size() <= clipColCount) continue;
                        clipColCount = ((List)clipboardGrid.get(i)).size();
                    }
                    int startRow = 0;
                    int startCol = 0;
                    int numCells = table.getSelectedCellCount();
                    int numSelectedCols = table.getSelectedColumnCount();
                    int numSelectedRows = table.getSelectedRowCount();
                    int[][] cellsSelected = table.getSelectedCells();
                    if (numSelectedRows > 0) {
                        startRow = table.getSelectedRows()[0];
                    }
                    if (numSelectedCols > 0) {
                        startCol = table.getSelectedColumns()[0];
                    }
                    if (table.getCellSelectionEnabled() && numSelectedCols == 0 && numSelectedRows == 0) {
                        if (numCells > 0) {
                            startRow = cellsSelected[0][0];
                            startCol = cellsSelected[0][1];
                        }
                    } else if (table.getColumnSelectionAllowed() && numCells == 0 && numSelectedRows == 0) {
                        startRow = Math.max(0, table.getCurrentRow());
                    } else if (table.getRowSelectionAllowed() && numCells == 0 && numSelectedCols == 0) {
                        startCol = Math.max(0, table.getCurrentColumn());
                    }
                    int rowMax = Math.min(startRow + clipRowCount, table.getRowCount());
                    int colMax = Math.min(startCol + clipColCount, table.getColumnCount());
                    for (int i = startRow; i < rowMax; ++i) {
                        for (int j = startCol; j < colMax; ++j) {
                            if (table.isCellEditable(i, j)) continue;
                            return false;
                        }
                    }
                    ret = true;
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    protected void copyCellsToClipboard(boolean replace, String replaceString) {
        boolean cont = false;
        cont = replace ? TableViewClipboardAdapter.canCut(this.table) : TableViewClipboardAdapter.canCopy(this.table);
        if (cont) {
            StringBuffer sbf = new StringBuffer();
            int rowCount = this.table.getRowCount();
            int colCount = this.table.getColumnCount();
            int numCols = this.table.getSelectedColumnCount();
            int numRows = this.table.getSelectedRowCount();
            int numCells = this.table.getSelectedCellCount();
            int[][] cellsSelected = this.table.getSelectedCells();
            int[] rowsSelected = this.table.getSelectedRows();
            int[] colsSelected = this.table.getSelectedColumns();
            Class[] colClasses = new Class[colCount];
            for (int i = 0; i < colCount; ++i) {
                colClasses[i] = this.table.getModel().getColumnClass(i);
            }
            TableModel model = this.table.getModel();
            boolean isValid = true;
            if (replace && model instanceof TableDataValidationInterface) {
                isValid = this.validateOrCopyCellsToClipboard(replace, replaceString, sbf, rowCount, colCount, numCols, numRows, numCells, cellsSelected, rowsSelected, colsSelected, 0);
            }
            if (isValid) {
                this.validateOrCopyCellsToClipboard(replace, replaceString, sbf, rowCount, colCount, numCols, numRows, numCells, cellsSelected, rowsSelected, colsSelected, 1);
                this.stringSelection = new StringSelection(sbf.toString());
                TableViewClipboardAdapter.getClipboard().setContents(this.stringSelection, this.stringSelection);
            }
        }
    }

    private boolean validateOrCopyCellsToClipboard(boolean replace, String replaceString, StringBuffer sbf, int rowCount, int colCount, int numCols, int numRows, int numCells, int[][] cellsSelected, int[] rowsSelected, int[] colsSelected, int validateUpdateMode) {
        boolean appendFlag;
        boolean flag = true;
        boolean bl = appendFlag = validateUpdateMode == 1;
        if (this.table.getCellSelectionEnabled() && numCells > 0) {
            int x1 = cellsSelected[0][0];
            int y1 = cellsSelected[0][1];
            int x2 = cellsSelected[cellsSelected.length - 1][0];
            int y2 = cellsSelected[cellsSelected.length - 1][1];
            ListSelectionModel lsm = this.table.getSelectionModel();
            int min = lsm.getMinSelectionIndex();
            int max = lsm.getMaxSelectionIndex();
            if ((Math.abs(x2 - x1) + 1) * (Math.abs(y2 - y1) + 1) == numCells && lsm.isSelectedIndex(min) && lsm.isSelectedIndex(max)) {
                for (int i = 0; i < numCells; ++i) {
                    int x = cellsSelected[i][0];
                    int y = cellsSelected[i][1];
                    if (x >= rowCount || y >= colCount) continue;
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(x, y)));
                    this.append(sbf, value, appendFlag);
                    if (replace && !(flag = this.setOrValidateValue(replaceString, x, y, validateUpdateMode))) {
                        this.displayCutError(replaceString, x, y);
                        return flag;
                    }
                    if (i >= numCells - 1) continue;
                    if (x == cellsSelected[i + 1][0]) {
                        this.append(sbf, "\t", appendFlag);
                        continue;
                    }
                    this.append(sbf, "\n", appendFlag);
                }
            }
        } else if (this.table.getColumnSelectionAllowed() && numCols > 0) {
            numRows = rowCount;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    if (colsSelected[j] >= colCount) continue;
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(i, colsSelected[j])));
                    this.append(sbf, value, appendFlag);
                    if (replace && !(flag = this.setOrValidateValue(replaceString, i, colsSelected[j], validateUpdateMode))) {
                        this.displayCutError(replaceString, i, colsSelected[j]);
                        return flag;
                    }
                    if (j >= numCols - 1) continue;
                    this.append(sbf, "\t", appendFlag);
                }
                this.append(sbf, "\n", appendFlag);
            }
        } else if (this.table.getRowSelectionAllowed() && numRows > 0) {
            numCols = colCount;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    if (rowsSelected[i] >= rowCount) continue;
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(rowsSelected[i], j)));
                    this.append(sbf, value, appendFlag);
                    if (replace && !(flag = this.setOrValidateValue(replaceString, rowsSelected[i], j, validateUpdateMode))) {
                        this.displayCutError(replaceString, rowsSelected[i], j);
                        return flag;
                    }
                    if (j >= numCols - 1) continue;
                    this.append(sbf, "\t", appendFlag);
                }
                this.append(sbf, "\n", appendFlag);
            }
        } else {
            return false;
        }
        return flag;
    }

    @Override
    public void pasteSelectedCells() {
        if (TableViewClipboardAdapter.canPaste(this.table)) {
            int startRow = 0;
            int startCol = 0;
            int rowCount = this.table.getRowCount();
            int columnCount = this.table.getColumnCount();
            int numRows = rowCount;
            int numCols = columnCount;
            int numCells = this.table.getSelectedCellCount();
            int numSelectedCols = this.table.getSelectedColumnCount();
            int numSelectedRows = this.table.getSelectedRowCount();
            int[][] cellsSelected = this.table.getSelectedCells();
            int[] rowsSelected = this.table.getSelectedRows();
            int[] colsSelected = this.table.getSelectedColumns();
            if (this.table.getSelectedRowCount() > 0) {
                startRow = this.table.getSelectedRows()[0];
            }
            if (this.table.getSelectedColumnCount() > 0) {
                startCol = this.table.getSelectedColumns()[0];
            }
            if (this.table.getCellSelectionEnabled() && numSelectedCols == 0 && numSelectedRows == 0) {
                if (numCells > 0) {
                    int x1 = cellsSelected[0][0];
                    int y1 = cellsSelected[0][1];
                    if (numCells > 1) {
                        int x2 = cellsSelected[cellsSelected.length - 1][0];
                        int y2 = cellsSelected[cellsSelected.length - 1][1];
                        ListSelectionModel lsm = this.table.getSelectionModel();
                        int min = lsm.getMinSelectionIndex();
                        int max = lsm.getMaxSelectionIndex();
                        if ((Math.abs(x2 - x1) + 1) * (Math.abs(y2 - y1) + 1) == numCells && lsm.isSelectedIndex(min) && lsm.isSelectedIndex(max)) {
                            int nr = cellsSelected[cellsSelected.length - 1][0] - cellsSelected[0][0] + 1;
                            int nc = cellsSelected[cellsSelected.length - 1][1] - cellsSelected[0][1] + 1;
                            if (nr > 1) {
                                numRows = nr;
                            }
                            if (nc > 1) {
                                numCols = nc;
                            }
                        } else {
                            return;
                        }
                    }
                    startRow = x1;
                    startCol = y1;
                }
            } else if (this.table.getColumnSelectionAllowed() && numCells == 0 && numSelectedRows == 0) {
                if (numSelectedCols > 1) {
                    numCols = Math.min(numSelectedCols, columnCount);
                }
                startRow = Math.max(0, this.table.getCurrentRow());
            } else if (this.table.getRowSelectionAllowed() && numCells == 0 && numSelectedCols == 0) {
                if (numSelectedRows > 1) {
                    numRows = Math.min(numSelectedRows, rowCount);
                }
                startCol = Math.max(0, this.table.getCurrentColumn());
            }
            try {
                Transferable transfer = TableViewClipboardAdapter.getClipboard().getContents(this);
                if (transfer != null && transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                    List clipboardGrid = TableViewClipboardAdapter.parseContents(data);
                    if (clipboardGrid.isEmpty()) {
                        return;
                    }
                    int clipRowCount = clipboardGrid.size();
                    int colCount = 1;
                    for (int i = 0; i < clipRowCount; ++i) {
                        if (((List)clipboardGrid.get(i)).size() <= colCount) continue;
                        colCount = ((List)clipboardGrid.get(i)).size();
                    }
                    Class[] colClasses = new Class[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        colClasses[i] = this.table.getModel().getColumnClass(i);
                    }
                    TableModel model = this.table.getModel();
                    boolean validateResult = true;
                    if (model instanceof TableDataValidationInterface) {
                        validateResult = this.updateOrValidateCellValues(clipboardGrid, colCount, startRow, startCol, colClasses, 0);
                        if (validateResult) {
                            this.updateOrValidateCellValues(clipboardGrid, colCount, startRow, startCol, colClasses, 1);
                        }
                    } else {
                        this.updateOrValidateCellValues(clipboardGrid, colCount, startRow, startCol, colClasses, 1);
                    }
                    this.table.repaint();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean updateOrValidateCellValues(List clipboardGrid, int colCount, int startRow, int startCol, Class[] colClasses, int validateUpdateMode) throws TransformException {
        int clipRowCount = clipboardGrid.size();
        int rowCount = this.table.getRowCount();
        int columnCount = this.table.getColumnCount();
        int numRows = rowCount;
        int numCols = columnCount;
        int numSelectedCols = this.table.getSelectedColumnCount();
        int numSelectedRows = this.table.getSelectedRowCount();
        int numCells = this.table.getSelectedCellCount();
        int[] rowsSelected = this.table.getSelectedRows();
        int[] colsSelected = this.table.getSelectedColumns();
        int iTemp = 0;
        int jTemp = 0;
        boolean validateResult = true;
        for (int rIdx = 0; rIdx < clipRowCount && rIdx < numRows; ++rIdx) {
            List colList = (List)clipboardGrid.get(rIdx);
            for (int cIdx = 0; cIdx < colCount && cIdx < numCols; ++cIdx) {
                Object value = null;
                value = cIdx < colList.size() ? colList.get(cIdx) : "";
                if (!this.table.getCellSelectionEnabled() || numSelectedCols != 0 || numSelectedRows != 0) {
                    if (this.table.getRowSelectionAllowed() && numCells == 0 && numSelectedRows == 0) {
                        if (rIdx < rowsSelected.length) {
                            iTemp = rowsSelected[rIdx] - rIdx - startRow;
                        }
                    } else if (this.table.getColumnSelectionAllowed() && numSelectedCols == 0 && numCells == 0 && cIdx < colsSelected.length) {
                        jTemp = colsSelected[cIdx] - cIdx - startCol;
                    }
                }
                if (startRow + rIdx + iTemp >= rowCount || startCol + cIdx + jTemp >= columnCount || !this.table.isCellEditable(startRow + rIdx + iTemp, startCol + cIdx + jTemp)) continue;
                int setRow = startRow + rIdx + iTemp;
                int setCol = startCol + cIdx + jTemp;
                if (this.getTransform() instanceof ObjectToStringTransform && value != null && value.equals(((ObjectToStringTransform)this.getTransform()).getDotString())) {
                    value = "";
                }
                if (BaseTransforms.defaultInstance.isTransformable(String.class, colClasses[setCol])) {
                    try {
                        value = BaseTransforms.defaultInstance.transform(value, colClasses[setCol]);
                    }
                    catch (Exception ex) {
                        validateResult = false;
                        this.displayPasteError(value, setRow, setCol);
                        return validateResult;
                    }
                }
                if (colClasses[setCol] == Date.class) {
                    try {
                        value = df.parse((String)value);
                    }
                    catch (ParseException ex) {
                        validateResult = false;
                        ex.printStackTrace();
                        this.displayPasteError(value, setRow, setCol);
                        return validateResult;
                    }
                }
                validateResult = this.setOrValidateValue(value, setRow, setCol, validateUpdateMode);
                if (validateResult) continue;
                this.displayPasteError(value, setRow, setCol);
                return validateResult;
            }
        }
        return validateResult;
    }

    @Override
    protected void displayCutError(Object value, int row, int col) {
        if (this.table.getGenericErrorHandler() != null) {
            this.setErrorTitle("errorCuttingCell.txt");
            this.table.getGenericErrorHandler().handleError(this.table, new Message(RB.getStringResource(RB_KEY, "errorCuttingValue.txt"), value, (Object)String.valueOf(row), (Object)String.valueOf(col)), null);
        }
    }

    @Override
    protected void displayPasteError(Object value, int row, int col) {
        if (this.table.getGenericErrorHandler() != null) {
            this.setErrorTitle("errorPastingCell.txt");
            this.table.getGenericErrorHandler().handleError(this.table, new Message(RB.getStringResource(RB_KEY, "errorPastingValue.txt"), value, (Object)String.valueOf(row), (Object)String.valueOf(col)), null);
        }
    }

    private void setErrorTitle(String rbKey) {
        String title = RB.getStringResource(RB_KEY, rbKey);
        if (this.table.getGenericErrorHandler() instanceof Frame) {
            ((Frame)((Object)this.table.getGenericErrorHandler())).setTitle(title);
        } else if (this.table.getGenericErrorHandler() instanceof JOptionPaneErrorHandler) {
            ((JOptionPaneErrorHandler)this.table.getGenericErrorHandler()).setTitle(title);
        }
    }
}

