/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.itemlistmanager;

import com.sas.models.itemlistmanager.DeleteRowsInterface;
import com.sas.models.itemlistmanager.GroupRowInterface;
import com.sas.models.itemlistmanager.ILMTableModel;
import com.sas.models.itemlistmanager.MoveRowInterface;
import com.sas.models.itemlistmanager.RB;
import com.sas.models.itemlistmanager.tree.ILMModelEvent;
import com.sas.models.itemlistmanager.tree.ILMModelListener;
import com.sas.models.itemlistmanager.tree.ILMTree;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import com.sas.models.itemlistmanager.tree.ILMTreeNodeContext;
import com.sas.models.itemlistmanager.tree.TreeUtil;
import com.sas.swing.visuals.itemlistmanager.TreeItemListManagerPanel;
import java.util.List;

public class ILMTreeToTableModelAdapter
extends ILMTableModel {
    public static final String RB_KEY = "ILMTreeToTableModelAdapter.";
    protected ILMTreeInterface treeModel;
    public static final Object PREDEFINED_COLUMN_CONDITION = new Object();
    public static final Object PREDEFINED_COLUMN_LEFT_GROUP = new Object();
    public static final Object PREDEFINED_COLUMN_RIGHT_GROUP = new Object();
    protected String LEFT_GROUP_SYMBOL = RB.getStringResource("ILMTreeToTableModelAdapter.", "leftGroupSymbol.txt");
    protected String RIGHT_GROUP_SYMBOL = RB.getStringResource("ILMTreeToTableModelAdapter.", "rightGroupSymbol.txt");

    public ILMTreeToTableModelAdapter() {
    }

    public ILMTreeToTableModelAdapter(ILMTreeInterface tree) {
        this.setModel(tree);
    }

    public void setModel(ILMTreeInterface model) {
        this.treeModel = model;
        this.convertTreeToTable();
        this.treeModel.addILMModelListener(new ILMModelListener(){

            @Override
            public void itemInserted(ILMModelEvent event) {
                Object[] targets = event.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    ILMTreeNode node = (ILMTreeNode)targets[i];
                    int index = TreeUtil.getIndexOfLeaf(ILMTreeToTableModelAdapter.this.treeModel.getRootNode(), node);
                    if (index == -1) continue;
                    ILMTreeToTableModelAdapter.this.addTreeNodeToTable(node, index);
                }
            }

            @Override
            public void itemChanged(ILMModelEvent event) {
                Object[] targets = event.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    ILMTreeNode node = (ILMTreeNode)targets[i];
                    if (!node.isLeaf()) continue;
                    ILMTreeToTableModelAdapter.this.convertTreeNodeToTableRow(node, ILMTreeToTableModelAdapter.this.getRowIndexFromTreeNode(node));
                }
            }

            @Override
            public void itemMoved(ILMModelEvent event) {
                Object[] targets = event.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    ILMTreeNode node = (ILMTreeNode)targets[i];
                    int oldIndex = ILMTreeToTableModelAdapter.this.getRowIndexFromTreeNode(node);
                    int newIndex = TreeUtil.getIndexOfLeaf(ILMTreeToTableModelAdapter.this.treeModel.getRootNode(), node);
                    ILMTreeToTableModelAdapter.this.moveTableRow(oldIndex, newIndex);
                }
            }

            @Override
            public void itemRemoved(ILMModelEvent event) {
                Object[] targets = event.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    ILMTreeNode node = (ILMTreeNode)targets[i];
                    ILMTreeToTableModelAdapter.this.deleteTableRow(ILMTreeToTableModelAdapter.this.getRowIndexFromTreeNode(node));
                }
            }
        });
    }

    public void refresh() {
        this.rebuildRowsFromTree();
    }

    public boolean canGroupRow(int startRowIndex, int endRowIndex) {
        return ((GroupRowInterface)((Object)this.treeModel)).canGroupRow(startRowIndex, endRowIndex);
    }

    public boolean groupRow(int startRowIndex, int endRowIndex) {
        return ((GroupRowInterface)((Object)this.treeModel)).groupRow(startRowIndex, endRowIndex);
    }

    public boolean canUngroupRow(int rowIndex) {
        return ((GroupRowInterface)((Object)this.treeModel)).canSplitRow(rowIndex);
    }

    public boolean ungroupRow(int rowIndex) {
        return ((GroupRowInterface)((Object)this.treeModel)).splitRow(rowIndex);
    }

    public boolean ungroupAll() {
        return this.treeModel.splitAll();
    }

    public boolean isGrouped() {
        if (this.treeModel != null) {
            int count = ((ILMTree)this.treeModel).getRowCount();
            for (int r = 0; r < count; ++r) {
                if (!((GroupRowInterface)((Object)this.treeModel)).isGrouped(r)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean setLogicalCondition(int row, Object condition) {
        ILMTreeNode treeNode = this.getTreeNodeFromRowIndex(row);
        if (treeNode == null) {
            return false;
        }
        return this.treeModel.setLogicalCondition(treeNode, condition);
    }

    protected boolean setGroupValue(Object group, int row, String text, ILMTreeNode treeLeafNode) {
        Object value = this.getValueAt(row, this.getPredefinedColumnIndex(group));
        ILMTreeNodeContext treeNodeContext = value instanceof ILMTreeNodeContext ? (ILMTreeNodeContext)value : new ILMTreeNodeContext(this.treeModel, treeLeafNode);
        treeNodeContext.setText(text);
        super.setValueAt(treeNodeContext, row, this.getPredefinedColumnIndex(group));
        return true;
    }

    protected void convertTreeToTable() {
        this.setColumnCount(0);
        if (this.treeModel == null) {
            return;
        }
        this.addColumn(new Column(RB.getStringResource(RB_KEY, "condition.txt"), PREDEFINED_COLUMN_CONDITION));
        this.addColumn(new Column(RB.getStringResource(RB_KEY, "leftGroupSymbol.txt"), PREDEFINED_COLUMN_LEFT_GROUP));
        int treeColumnCount = this.treeModel.getColumnCount();
        for (int i = 0; i < treeColumnCount; ++i) {
            this.addColumn(new Column(this.treeModel.getColumnName(i), new Integer(i)));
        }
        this.addColumn(new Column(RB.getStringResource(RB_KEY, "rightGroupSymbol.txt"), PREDEFINED_COLUMN_RIGHT_GROUP));
        this.rebuildRowsFromTree();
    }

    protected void rebuildRowsFromTree() {
        this.setRowCount(0);
        int columnCount = this.getColumnCount();
        List leafNodes = TreeUtil.getAllLeafNodes(this.treeModel.getRootNode());
        for (ILMTreeNode treeNode : leafNodes) {
            Object[] cells = new Object[columnCount];
            this.addRow(cells);
            this.convertTreeNodeToTableRow(treeNode, this.getRowCount() - 1);
        }
    }

    protected void convertTreeNodeToTableRow(ILMTreeNode treeLeafNode, int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        super.setValueAt(this.treeModel.getLogicalCondition(treeLeafNode), rowIndex, this.getPredefinedColumnIndex(PREDEFINED_COLUMN_CONDITION));
        this.setGroupValue(PREDEFINED_COLUMN_LEFT_GROUP, rowIndex, TreeItemListManagerPanel.getLeftGroupText(this.treeModel, treeLeafNode, this.LEFT_GROUP_SYMBOL, null), treeLeafNode);
        this.setGroupValue(PREDEFINED_COLUMN_RIGHT_GROUP, rowIndex, TreeItemListManagerPanel.getRightGroupText(this.treeModel, treeLeafNode, this.RIGHT_GROUP_SYMBOL), treeLeafNode);
        int treeColumnCount = this.treeModel.getColumnCount();
        for (int col = 0; col < treeColumnCount; ++col) {
            super.setValueAt(this.treeModel.getValueAt(treeLeafNode, col), rowIndex, this.getTableColumnIndexFromTreeColumnIndex(col));
        }
    }

    protected void addTreeNodeToTable(ILMTreeNode treeNode, int position) {
        Object[] cells = new Object[this.getColumnCount()];
        if (position == -1) {
            super.addRow(cells);
            position = this.getRowCount() - 1;
        } else {
            super.insertRow(position, cells);
        }
        this.convertTreeNodeToTableRow(treeNode, position);
    }

    protected void moveTableRow(int fromIndex, int toIndex) {
        if (fromIndex != -1 && toIndex != -1) {
            super.moveRowRange(fromIndex, fromIndex, toIndex);
        }
    }

    protected void deleteTableRow(int index) {
        if (index != -1) {
            super.deleteRow(index);
        }
    }

    @Override
    public void setValueAt(Object newValue, int row, int column) {
        if (column == this.getPredefinedColumnIndex(PREDEFINED_COLUMN_CONDITION)) {
            this.setLogicalCondition(row, newValue);
            return;
        }
        if (column == this.getPredefinedColumnIndex(PREDEFINED_COLUMN_RIGHT_GROUP)) {
            this.setGroupValue(PREDEFINED_COLUMN_RIGHT_GROUP, row, newValue.toString(), this.getTreeNodeFromRowIndex(row));
            return;
        }
        super.setValueAt(newValue, row, column);
        int treeModelColumn = this.getTreeColumnIndexFromTableColumnIndex(column);
        if (treeModelColumn >= 0 && treeModelColumn < this.treeModel.getColumnCount()) {
            this.treeModel.setValueAt(this.getTreeNodeFromRowIndex(row), treeModelColumn, newValue);
        }
    }

    @Override
    public int insertRow(int row) {
        this.treeModel.addItem();
        return row;
    }

    @Override
    public int insertRow(Object[] values, int row) {
        ILMTreeNode node = this.getTreeNodeFromRowIndex(row);
        ILMTreeNode actual = this.treeModel.insertNode(node, values);
        return this.getRowIndexFromTreeNode(actual);
    }

    @Override
    public boolean canInsertRow(int row) {
        return true;
    }

    @Override
    public boolean canDeleteRow(int index) {
        return true;
    }

    @Override
    public void deleteRow(int index) {
        ILMTreeNode node = this.getTreeNodeFromRowIndex(index);
        super.deleteRow(index);
        this.treeModel.delete(node);
    }

    @Override
    public List deleteRows(int[] rowIndices) {
        List retval = null;
        retval = this.treeModel instanceof DeleteRowsInterface ? ((DeleteRowsInterface)((Object)this.treeModel)).deleteRows(rowIndices) : super.deleteRows(rowIndices);
        return retval;
    }

    @Override
    public boolean canMoveRow(int start, int end, int to) {
        ILMTreeNode startNode = this.getTreeNodeFromRowIndex(start);
        ILMTreeNode endNode = this.getTreeNodeFromRowIndex(end);
        ILMTreeNode toNode = this.getTreeNodeFromRowIndex(to);
        if (startNode == null || endNode == null || toNode == null) {
            return false;
        }
        boolean rv = super.canMoveRow(start, end, to);
        if (rv) {
            rv = this.treeModel.canMoveNodes(startNode, endNode, toNode);
        }
        return rv;
    }

    @Override
    public int moveRowRange(int start, int end, int to) {
        return ((MoveRowInterface)((Object)this.treeModel)).moveRowRange(start, end, to);
    }

    @Override
    public String getClassification(int row, int column) {
        if (column == this.getPredefinedColumnIndex(PREDEFINED_COLUMN_CONDITION)) {
            String classification = this.treeModel.getClassification(this.getTreeNodeFromRowIndex(row), -1);
            if (classification != null) {
                return classification;
            }
            return row == 0 ? "FirstCondition" : "Condition";
        }
        if (column == this.getPredefinedColumnIndex(PREDEFINED_COLUMN_LEFT_GROUP)) {
            return "LeftGroup";
        }
        if (column == this.getPredefinedColumnIndex(PREDEFINED_COLUMN_RIGHT_GROUP)) {
            return "RightGroup";
        }
        return this.treeModel.getClassification(this.getTreeNodeFromRowIndex(row), this.getTreeColumnIndexFromTableColumnIndex(column));
    }

    protected int getTreeColumnIndexFromTableColumnIndex(int tableColumn) {
        Object c = this.columnIdentifiers.get(tableColumn);
        if (c instanceof Column) {
            Column column = (Column)c;
            if (column.object instanceof Integer) {
                return (Integer)column.object;
            }
        }
        return -1;
    }

    protected int getTableColumnIndexFromTreeColumnIndex(int treeColumn) {
        int columnCount = this.columnIdentifiers.size();
        for (int i = 0; i < columnCount; ++i) {
            Object c = this.columnIdentifiers.get(i);
            if (!(c instanceof Column)) continue;
            Column column = (Column)c;
            if (!(column.object instanceof Integer) || (Integer)column.object != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public int getPredefinedColumnIndex(Object column) {
        int columnCount = this.columnIdentifiers.size();
        for (int i = 0; i < columnCount; ++i) {
            Object c = this.columnIdentifiers.get(i);
            if (!(c instanceof Column) || ((Column)c).object != column) continue;
            return i;
        }
        return -1;
    }

    public int getRowIndexFromTreeNode(ILMTreeNode treeNode) {
        int rowCount = this.getRowCount();
        if (treeNode == null) {
            return rowCount - 1;
        }
        for (int i = 0; i < rowCount; ++i) {
            ILMTreeNodeContext treeNodeContext = (ILMTreeNodeContext)this.getValueAt(i, this.getPredefinedColumnIndex(PREDEFINED_COLUMN_RIGHT_GROUP));
            if (treeNodeContext.getTreeNode() != treeNode) continue;
            return i;
        }
        return -1;
    }

    public ILMTreeNode getTreeNodeFromRowIndex(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        ILMTreeNodeContext treeNodeContext = (ILMTreeNodeContext)this.getValueAt(rowIndex, this.getPredefinedColumnIndex(PREDEFINED_COLUMN_RIGHT_GROUP));
        if (treeNodeContext != null) {
            return treeNodeContext.getTreeNode();
        }
        return null;
    }

    protected class Column {
        public String columnName;
        public Object object;

        public Column(String columnName, Object object) {
            this.object = object;
            this.columnName = columnName;
        }

        public String toString() {
            return this.columnName;
        }
    }
}

