/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.formats;

import com.sas.codepolicy.SASScope;
import com.sas.models.formats.FormatDescription;
import com.sas.models.formats.RB;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASNumericFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class SASFormatModel
implements FormatAdapterInterface {
    private static final String NUMERIC = "NUMERIC";
    private static final String CHARACTER = "CHARACTER";
    private static final String DATETIME = "DATETIME";
    private Map formatMap;

    @Override
    public Map getFormatTypes(int dataType, Locale locale) {
        boolean numeric = false;
        boolean dateTime = false;
        boolean currency = false;
        boolean character = false;
        if (dataType == 8 || dataType == 2 || dataType == -5 || dataType == 3 || dataType == 6 || dataType == 4 || dataType == -6 || dataType == 5 || dataType == 91 || dataType == 92 || dataType == 93 || dataType == 1111) {
            numeric = true;
            dateTime = true;
            currency = true;
        }
        if (dataType == 1 || dataType == 1111 || dataType == 12) {
            character = true;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (numeric || dateTime || currency || character) {
            this.loadFormats();
            try {
                Object[] formats = null;
                if (numeric && (formats = (Object[])this.formatMap.get(NUMERIC)).length > 0) {
                    map.put(NUMERIC, RB.getStringResource("SASFormatModel.numeric.txt", locale));
                }
                if (dateTime && (formats = (Object[])this.formatMap.get(DATETIME)).length > 0) {
                    map.put(DATETIME, RB.getStringResource("SASFormatModel.dateTime.txt", locale));
                }
                if (character && (formats = (Object[])this.formatMap.get(CHARACTER)).length > 0) {
                    map.put(CHARACTER, RB.getStringResource("SASFormatModel.character.txt", locale));
                }
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
                ise.initCause(e);
                throw ise;
            }
        }
        return map;
    }

    @Override
    public List getFormatByType(Object formatCategory, Locale locale) {
        this.loadFormats();
        ArrayList<FormatDescription> list = new ArrayList<FormatDescription>();
        try {
            Object[] formats = null;
            if (formatCategory != null) {
                formats = (Object[])this.formatMap.get(formatCategory);
            } else {
                Collection allFormats = this.formatMap.values();
                ArrayList<Object> listOfFormats = new ArrayList<Object>();
                for (Object[] element : allFormats) {
                    listOfFormats.addAll(Arrays.asList(element));
                }
                formats = listOfFormats.toArray();
            }
            if (formats != null) {
                for (int i = 0; i < formats.length; ++i) {
                    FormatDescription fd = new FormatDescription();
                    com.sas.text.FormatDescription sfd = (com.sas.text.FormatDescription)formats[i];
                    fd.setBaseFormatName(sfd.getBaseFormatName());
                    fd.setDescription(sfd.getDescription(locale));
                    fd.setMinWidth(sfd.getMinWidth());
                    fd.setMaxWidth(sfd.getMaxWidth());
                    fd.setDefaultWidth(sfd.getDefaultWidth());
                    fd.setMinDecimalWidth(sfd.getMinDValue());
                    fd.setMaxDecimalWidth(sfd.getMaxDValue());
                    fd.setDecimalWidthSupported(sfd.isDecimalWidthSupported());
                    list.add(fd);
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getLocalizedMessage());
            ise.initCause(e);
            throw ise;
        }
        return list;
    }

    private void loadFormats() {
        if (this.formatMap == null) {
            this.formatMap = new HashMap();
            this.formatMap.put(NUMERIC, SASNumericFormat.getDescriptions());
            this.formatMap.put(CHARACTER, SASCharacterFormat.getDescriptions());
            this.formatMap.put(DATETIME, SASDateTimeFormat.getDescriptions());
        }
    }
}

