/*
 * Decompiled with CFR 0.152.
 */
package com.sas.geometry;

import com.sas.PublicClonable;
import com.sas.util.Countable;
import com.sas.util.PredicateInterface;
import java.awt.Rectangle;

public class Rectangles
implements Countable,
PublicClonable {
    private Rectangle[] rects;
    private int rectCount;

    public void add(Rectangle rect) {
        for (int i = 0; i < this.rectCount; ++i) {
            if (this.rects[i].x == rect.x && Rectangles.getRight(this.rects[i]) == Rectangles.getRight(rect) && (Rectangles.getBottom(rect) >= this.rects[i].y - 1 && Rectangles.getBottom(rect) < Rectangles.getBottom(this.rects[i]) || rect.y <= Rectangles.getBottom(this.rects[i]) + 1 && rect.y > this.rects[i].y)) {
                if (rect.y < this.rects[i].y) {
                    this.rects[i].y = rect.y;
                }
                if (Rectangles.getBottom(rect) > Rectangles.getBottom(this.rects[i])) {
                    this.rects[i].height += Rectangles.getBottom(rect) - Rectangles.getBottom(this.rects[i]);
                }
                return;
            }
            if (this.rects[i].y == rect.y && Rectangles.getBottom(this.rects[i]) == Rectangles.getBottom(rect) && (Rectangles.getRight(rect) >= this.rects[i].x - 1 && Rectangles.getRight(rect) < Rectangles.getRight(this.rects[i]) || rect.x <= Rectangles.getRight(this.rects[i]) + 1 && rect.x > this.rects[i].x)) {
                if (rect.x < this.rects[i].x) {
                    this.rects[i].x = rect.x;
                }
                if (Rectangles.getRight(rect) > Rectangles.getRight(this.rects[i])) {
                    this.rects[i].width += Rectangles.getRight(rect) - Rectangles.getRight(this.rects[i]);
                }
                return;
            }
            if (this.rects[i].x <= rect.x && this.rects[i].y <= rect.y && Rectangles.getRight(this.rects[i]) >= Rectangles.getRight(rect) && Rectangles.getBottom(this.rects[i]) >= Rectangles.getBottom(rect)) {
                return;
            }
            if (rect.x > this.rects[i].x || rect.y > this.rects[i].y || Rectangles.getRight(rect) < Rectangles.getRight(this.rects[i]) || Rectangles.getBottom(rect) < Rectangles.getBottom(this.rects[i])) continue;
            this.rects[i].setBounds(rect.x, rect.y, rect.width, rect.height);
            for (int j = i + 1; j < this.rectCount; ++j) {
                if (rect.x > this.rects[j].x || rect.y > this.rects[j].y || Rectangles.getRight(rect) < Rectangles.getRight(this.rects[j]) || Rectangles.getBottom(rect) < Rectangles.getBottom(this.rects[j])) continue;
                --this.rectCount;
                for (int index = j; index < this.rectCount; ++index) {
                    this.rects[index].setBounds(this.rects[index + 1].x, this.rects[index + 1].y, this.rects[index + 1].width, this.rects[index + 1].height);
                }
                --j;
            }
            return;
        }
        this.stupidAdd(rect);
    }

    public static boolean intersect(Rectangle r1, Rectangle r2, Rectangle rout, Rectangle[] r1Left, int[] nr1Left, Rectangle[] r2Left, int[] nr2Left) {
        if (!r1.intersects(r2)) {
            if (r1Left != null) {
                r1Left[0] = new Rectangle();
                nr1Left[0] = 1;
            }
            if (r2Left != null) {
                r2Left[0] = new Rectangle();
                nr2Left[0] = 1;
            }
            if (rout != null) {
                rout.setSize(0, 0);
            }
            return false;
        }
        if (rout == null) {
            rout = new Rectangle();
        }
        Rectangles.intersectRects(r1, r2, rout);
        if (r1Left == null) {
            r1Left = new Rectangle[4];
        }
        if (r2Left == null) {
            r2Left = new Rectangle[4];
        }
        int left1 = Rectangles.boxsplit(r1, rout, r1Left);
        int left2 = Rectangles.boxsplit(r2, rout, r2Left);
        if (nr1Left != null) {
            nr1Left[0] = left1;
        }
        if (nr2Left != null) {
            nr2Left[0] = left2;
        }
        return left2 == 0 && left1 > 0;
    }

    public void intersect(Rectangle r1, Rectangles list) {
        Rectangles temp;
        if (list == this) {
            temp = new Rectangles();
        } else {
            temp = this;
            this.removeAll();
        }
        int count = list.count();
        for (int i = 0; i < count; ++i) {
            Rectangle r = list.get(i);
            if (!r1.intersects(r)) continue;
            temp.stupidAdd(r1.intersection(r));
        }
        if (list == this) {
            this.assign(temp);
        }
    }

    private void intersect(Rectangles list1, Rectangles list2) {
        Rectangles temp;
        if (list1 == list2) {
            this.assign(list1);
            return;
        }
        if (list1 == this) {
            list1 = list2;
            list2 = this;
        }
        if (list2 == this) {
            temp = new Rectangles();
        } else {
            temp = this;
            this.removeAll();
        }
        int count1 = list1.count();
        int count2 = list2.count();
        for (int i = 0; i < count1; ++i) {
            Rectangle r1 = list1.get(i);
            for (int j = 0; j < count2; ++j) {
                Rectangle r2 = list2.get(j);
                if (!r1.intersects(r2)) continue;
                temp.stupidAdd(r1.intersection(r2));
            }
        }
        if (list2 == this) {
            this.assign(temp);
        }
    }

    public void negate(Rectangle universe) {
        this.negate(universe, this);
    }

    private void negate(Rectangle universe, Rectangles list) {
        Rectangles temp;
        Rectangles tbx;
        int count = list.count();
        if (count == 0) {
            this.removeAll();
            this.stupidAdd(universe);
            return;
        }
        int[] nnegs = new int[]{0};
        Rectangle[] negs = new Rectangle[4];
        Rectangles rectangles = tbx = count > 1 ? new Rectangles() : null;
        if (list == this) {
            temp = new Rectangles();
        } else {
            temp = this;
            this.removeAll();
        }
        int i = 0;
        do {
            int j;
            Rectangles.intersect(universe, list.get(i), null, negs, nnegs, null, null);
            if (i == 0) {
                for (j = 0; j < nnegs[0]; ++j) {
                    temp.stupidAdd(negs[j]);
                }
            } else {
                for (j = 0; j < nnegs[0]; ++j) {
                    tbx.stupidAdd(negs[j]);
                }
                temp.intersect(temp, tbx);
                tbx.removeAll();
            }
        } while (++i < count);
        if (list == this) {
            this.assign(temp);
        }
    }

    public void unite(Rectangles list) {
        if (this == list) {
            return;
        }
        for (int i = 0; i < list.count(); ++i) {
            this.add(list.get(i));
        }
    }

    public void dump() {
        for (int i = 0; i < this.rectCount; ++i) {
            System.out.println(this.rects[i]);
        }
    }

    private static int boxsplit(Rectangle rect, Rectangle chunk, Rectangle[] rectRemain) {
        int nremain = 0;
        if (rectRemain.length != 4) {
            return nremain;
        }
        if (rect.y < chunk.y) {
            if (rectRemain[0] == null) {
                rectRemain[0] = new Rectangle();
            }
            rectRemain[0].setBounds(rect.x, rect.y, rect.width, chunk.y - rect.y);
            ++nremain;
        }
        if (rect.x < chunk.x) {
            if (rectRemain[nremain] == null) {
                rectRemain[nremain] = new Rectangle();
            }
            rectRemain[nremain].setBounds(rect.x, chunk.y, chunk.x - rect.x, chunk.height);
            ++nremain;
        }
        if (Rectangles.getBottom(rect) > Rectangles.getBottom(chunk)) {
            if (rectRemain[nremain] == null) {
                rectRemain[nremain] = new Rectangle();
            }
            rectRemain[nremain].setBounds(rect.x, Rectangles.getBottom(chunk) + 1, rect.width, Rectangles.getBottom(rect) - Rectangles.getBottom(chunk));
            ++nremain;
        }
        if (Rectangles.getRight(rect) > Rectangles.getRight(chunk)) {
            if (rectRemain[nremain] == null) {
                rectRemain[nremain] = new Rectangle();
            }
            rectRemain[nremain].setBounds(Rectangles.getRight(chunk) + 1, chunk.y, Rectangles.getRight(rect) - Rectangles.getRight(chunk), chunk.height);
            ++nremain;
        }
        return nremain;
    }

    public static int getBottom(Rectangle rect) {
        return rect.y + rect.height - 1;
    }

    public static int getRight(Rectangle rect) {
        return rect.x + rect.width - 1;
    }

    public static void setBottom(Rectangle rect, int bottom) {
        rect.height = bottom - rect.y + 1;
    }

    public static void setRight(Rectangle rect, int right) {
        rect.width = right - rect.x + 1;
    }

    public static boolean intersectRects(Rectangle r1, Rectangle r2, Rectangle rx) {
        if (r1.intersects(r2)) {
            int x1 = Math.max(r1.x, r2.x);
            int x2 = Math.min(r1.x + r1.width, r2.x + r2.width);
            int y1 = Math.max(r1.y, r2.y);
            int y2 = Math.min(r1.y + r1.height, r2.y + r2.height);
            rx.setBounds(x1, y1, x2 - x1, y2 - y1);
            return true;
        }
        rx.width = 0;
        rx.height = 0;
        return false;
    }

    public static void setRectBounds(Rectangle rect, int x1, int y1, int x2, int y2) {
        int height;
        int y;
        int width;
        int x;
        if (x1 < x2) {
            x = x1;
            width = x2 - x1;
        } else {
            x = x2;
            width = x1 - x2;
        }
        if (width != Integer.MAX_VALUE) {
            ++width;
        }
        if (y1 < y2) {
            y = y1;
            height = y2 - y1;
        } else {
            y = y2;
            height = y1 - y2;
        }
        if (height != Integer.MAX_VALUE) {
            ++height;
        }
        rect.setBounds(x, y, width, height);
    }

    public Rectangle get(int index) {
        if (index < 0 || index >= this.rectCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.rects[index];
    }

    public void removeAll() {
        this.rectCount = 0;
    }

    private void stupidAdd(Rectangle rect) {
        if (this.rects == null || this.rectCount == this.rects.length) {
            Rectangle[] tempArray = new Rectangle[this.rectCount + 4];
            if (this.rectCount > 0) {
                System.arraycopy(this.rects, 0, tempArray, 0, this.rects.length);
            }
            this.rects = tempArray;
            for (int i = this.rectCount; i < this.rects.length; ++i) {
                this.rects[i] = new Rectangle();
            }
        }
        this.rects[this.rectCount].setBounds(rect.x, rect.y, rect.width, rect.height);
        ++this.rectCount;
    }

    private void assign(Rectangles list) {
        this.rects = list.rects;
        this.rectCount = list.rectCount;
    }

    public int count() {
        return this.rectCount;
    }

    public int count(PredicateInterface pi) {
        int count = 0;
        for (int i = 0; i < this.rectCount; ++i) {
            if (!pi.predicate((Object)this.rects[i])) continue;
            ++count;
        }
        return count;
    }

    public Object clone() {
        try {
            Rectangles retRect = (Rectangles)super.clone();
            retRect.rectCount = this.rectCount;
            retRect.rects = new Rectangle[this.rectCount];
            for (int i = 0; i < this.rectCount; ++i) {
                retRect.rects[i] = new Rectangle();
                retRect.rects[i].setBounds(this.rects[i].x, this.rects[i].y, this.rects[i].width, this.rects[i].height);
            }
            return retRect;
        }
        catch (CloneNotSupportedException cnse) {
            System.out.println(cnse.getMessage());
            return null;
        }
    }
}

