/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTree;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTreeAdapter;
import java.util.List;

@SASScope
public class SelectionTreeDelegate {
    SimpleFilterLogicTreeAdapter tree;
    int cursor;
    FilterLogicTestNodeInterface tempSelection;
    Object initialFilter;

    public SelectionTreeDelegate() {
        this(new SimpleFilterLogicTree());
    }

    public SelectionTreeDelegate(SimpleFilterLogicTree tree) {
        if (tree == null) {
            tree = new SimpleFilterLogicTree();
        }
        this.setSelectionTree(new SimpleFilterLogicTreeAdapter(tree));
    }

    public SimpleFilterLogicTreeAdapter getSelectionTree() {
        return this.tree;
    }

    public void setSelectionTree(SimpleFilterLogicTreeAdapter tree) {
        if (this.tree != tree) {
            this.tree = tree;
            this.tempSelection = null;
            this.cursor = -1;
        }
    }

    public void setSelectionCursor(int index) {
        if (this.cursor != index) {
            if (index == -1) {
                this.tempSelection = null;
            }
            this.cursor = index;
        }
    }

    public int getSelectionCursor() {
        return this.cursor;
    }

    public boolean addSelection(FilterLogicTestNodeInterface value) {
        if (value != null) {
            this.tree.addLeafAt(-1, value);
            this.tempSelection = null;
            return true;
        }
        return false;
    }

    public void removeSelection() {
        this.tree.removeLeafAt(this.cursor);
    }

    public int getSelectionCount() {
        return this.tree.getUnderstoodTestNodeList().size();
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean commit) {
        this.tree.clear();
        if (commit) {
            this.tree.commitTree();
        }
    }

    public void cancel() {
        this.tree.cancel(this.initialFilter);
    }

    public FilterLogicTestNodeInterface getSelection() {
        List nodes;
        FilterLogicTestNodeInterface node = null;
        if (this.cursor >= 0 && this.cursor < (nodes = this.tree.getUnderstoodTestNodeList()).size()) {
            node = (FilterLogicTestNodeInterface)nodes.get(this.cursor);
        }
        if (node == null) {
            if (this.tempSelection == null) {
                this.tempSelection = new DefaultFilterLogicTestNode();
            }
            node = this.tempSelection;
        }
        return node;
    }

    public void setSelection(FilterLogicTestNodeInterface value) {
        this.tree.setLeafAt(this.cursor, value);
        this.tempSelection = null;
    }

    public boolean commitChanges() {
        return this.tree.commitTree();
    }

    public Object getRootFilterObject() {
        return this.tree.getRootFilterItem();
    }

    public Object getInitialFilter() {
        return this.initialFilter;
    }

    public void setInitialFilter(Object initialFilter) {
        this.initialFilter = initialFilter;
    }

    public void setQueryStandardization(boolean value) {
        this.tree.logicTree.setQueryStandardization(value);
    }
}

