/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.RB;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.dataselectors.filters.tree.FilterReferenceNode;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import com.sas.dataselectors.filters.tree.NotNodeInterface;
import com.sas.util.Strings;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.TreeNode;

@SASScope
public class LogicTreeToTextTransform
implements TransformInterface {
    public static final String RB_KEY = "Util.";
    Locale locale;
    protected String groupStart;
    protected String groupEnd;
    protected String lineSeparator;
    protected String indentationText;
    protected String spaceText;

    public LogicTreeToTextTransform() {
        this(null);
    }

    public LogicTreeToTextTransform(Locale locale) {
        this.locale = locale;
        this.spaceText = " ";
        this.groupStart = "( ";
        this.groupEnd = " )";
        this.lineSeparator = " ";
        this.indentationText = "";
    }

    public static LogicTreeToTextTransform getFormattedTextTransform(Locale locale) {
        LogicTreeToTextTransform transform = new LogicTreeToTextTransform(locale);
        transform.setLineSeparatorText(System.getProperty("line.separator"));
        transform.setIndentationText("  ");
        return transform;
    }

    public static LogicTreeToTextTransform getHTMLTextTransform(Locale locale) {
        LogicTreeToHTMLTransform transform = new LogicTreeToHTMLTransform(locale);
        return transform;
    }

    public static LogicTreeToTextTransform getHTMLFormattedTextTransform(Locale locale) {
        LogicTreeToHTMLTransform transform = new LogicTreeToHTMLTransform(locale);
        transform.setLineSeparatorText("<BR>");
        return transform;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getSpaceText() {
        return this.spaceText;
    }

    public void setSpaceText(String value) {
        this.spaceText = value;
    }

    public synchronized String getLineSeparatorText() {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.getProperty("line.separator");
        }
        return this.lineSeparator;
    }

    public void setLineSeparatorText(String value) {
        this.lineSeparator = value;
    }

    public String getGroupStartText() {
        return this.groupStart;
    }

    public void setGroupStartText(String value) {
        this.groupStart = value;
    }

    public String getGroupEndText() {
        return this.groupEnd;
    }

    public void setGroupEndText(String value) {
        this.groupEnd = value;
    }

    public String getIndentationText() {
        return this.indentationText;
    }

    public void setIndentationText(String value) {
        this.indentationText = value;
    }

    protected String getIndentationText(int level) {
        StringBuffer buf = new StringBuffer(Math.min(level, 0));
        for (int i = 0; i < level; ++i) {
            buf.append(this.getIndentationText());
        }
        return buf.toString();
    }

    public Object transform(Object source) throws TransformException {
        Object result = null;
        if (source != null) {
            FilterLogicBaseNodeInterface root;
            if (source instanceof FilterLogicTreeInterface) {
                FilterLogicTreeInterface tree = (FilterLogicTreeInterface)source;
                root = (FilterLogicBaseNodeInterface)tree.getRoot();
            } else if (source instanceof FilterLogicBaseNodeInterface) {
                root = (FilterLogicBaseNodeInterface)source;
            } else {
                throw new IllegalArgumentException("Invalid class type! You must specify a FilterLogicTreeInterface.");
            }
            if (result == null) {
                result = this.processNode(root);
            }
        }
        return result;
    }

    protected Object processNode(FilterLogicBaseNodeInterface root) throws TransformException {
        return this.processNode(root, 0);
    }

    protected Object processNode(FilterLogicBaseNodeInterface root, int indentation) throws TransformException {
        Object result = null;
        if (root instanceof FilterReferenceNode) {
            throw new UnsupportedOperationException();
        }
        if (root instanceof FilterLogicTestNodeInterface) {
            result = this.processTestNode((FilterLogicTestNodeInterface)root, indentation);
        } else if (root instanceof LogicalConditionNodeInterface) {
            result = this.processLogicalConditionNode((LogicalConditionNodeInterface)root, indentation);
        } else if (root instanceof NotNodeInterface) {
            result = this.processNotNode((NotNodeInterface)root, indentation);
        } else if (root != null) {
            throw new TransformException("Illegal FilterLogicTreeInterface tree structure!");
        }
        return result;
    }

    protected boolean shouldApplyParentheses(LogicalConditionNodeInterface groupNode) {
        FilterLogicBaseNodeInterface parent = groupNode.getParentLogicNode();
        return parent instanceof LogicalConditionNodeInterface ? ((LogicalConditionNodeInterface)parent).getLogicalCondition() != groupNode.getLogicalCondition() : groupNode.isExplicitlyCreated() && parent != null;
    }

    protected boolean shouldIndent(LogicalConditionNodeInterface groupNode) {
        FilterLogicBaseNodeInterface parent = groupNode.getParentLogicNode();
        return parent != null && this.shouldApplyParentheses(groupNode);
    }

    protected Object processNotNode(NotNodeInterface root) throws TransformException {
        return this.processNotNode(root, 0);
    }

    protected Object processNotNode(NotNodeInterface root, int indentation) throws TransformException {
        String not_text = RB.getStringResource(RB_KEY, "Negate.Condition.aka.NOT.Label.txt", this.locale);
        StringBuffer buf = new StringBuffer(this.getIndentationText(indentation));
        FilterLogicBaseNodeInterface childNode = root.getChildLogicNodeAt(0);
        boolean needParens = !(childNode instanceof LogicalConditionNodeInterface) || !this.shouldApplyParentheses((LogicalConditionNodeInterface)childNode);
        int childIndentation = indentation + (needParens ? 1 : 0);
        Object child = this.processNode(childNode, childIndentation);
        buf.append(not_text);
        buf.append(this.getSpaceText());
        if (needParens) {
            buf.append(this.getGroupStartText());
        }
        buf.append(child);
        if (needParens) {
            buf.append(this.getGroupEndText());
        }
        return buf.toString();
    }

    protected String getTextForConditionalRelationType(ConditionalRelationType relationship) {
        return relationship.getLabel(this.locale);
    }

    protected Object processTestNode(FilterLogicTestNodeInterface testNode) {
        return this.processTestNode(testNode, 0);
    }

    protected Object processTestNode(FilterLogicTestNodeInterface testNode, int indentation) {
        String result = this.getIndentationText(indentation);
        if (testNode != null) {
            result = testNode.toString();
        }
        return result;
    }

    protected Object processLogicalConditionNode(LogicalConditionNodeInterface root) throws TransformException {
        return this.processLogicalConditionNode(root, 0);
    }

    protected Object processLogicalConditionNode(LogicalConditionNodeInterface root, int indentation) throws TransformException {
        int count;
        StringBuffer buf = new StringBuffer();
        boolean needsParens = this.shouldApplyParentheses(root);
        boolean shouldIndent = this.shouldIndent(root);
        int childIndentation = indentation;
        if (needsParens) {
            buf.append(this.getGroupStartText());
            if (shouldIndent) {
                ++childIndentation;
            }
        }
        if ((count = root.getChildCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                FilterLogicBaseNodeInterface childNode = root.getChildLogicNodeAt(i);
                Object child = this.processNode(childNode, childIndentation);
                if (i > 0) {
                    buf.append(this.getLineSeparatorText());
                    buf.append(this.getIndentationText(childIndentation));
                    buf.append(this.getTextForConditionalRelationType(root.getLogicalCondition()));
                    buf.append(this.getLineSeparatorText());
                    buf.append(this.getIndentationText(childIndentation));
                }
                buf.append(child);
            }
        }
        if (needsParens) {
            buf.append(this.getGroupEndText());
        }
        return buf.toString();
    }

    public String transform(SimpleFilterLogicTreeInterface tree, int startSelection, int endSelection) throws TransformException {
        List testNodes;
        String result = null;
        if (tree != null && (testNodes = tree.getUnderstoodTestNodeList()) != null && !testNodes.isEmpty()) {
            TreeNode[] cNodes;
            int end;
            int start;
            int last = testNodes.size() - 1;
            if (startSelection < 0) {
                startSelection = 0;
            }
            if (endSelection < 0) {
                endSelection = last;
            }
            if (startSelection > endSelection) {
                start = Math.max(0, endSelection);
                end = startSelection < 0 ? last : Math.min(last, startSelection);
            } else {
                start = Math.max(0, startSelection);
                end = endSelection < 0 ? last : Math.min(last, endSelection);
            }
            TreeNode startNode = null;
            TreeNode endNode = null;
            if (start <= last) {
                startNode = (TreeNode)testNodes.get(start);
            }
            if (end <= last) {
                endNode = (TreeNode)testNodes.get(end);
            }
            if (startNode != null && endNode != null && (cNodes = this.getCommonParentPlus(startNode, endNode)) != null) {
                result = (String)this.transform(cNodes[0]);
            }
        }
        return result;
    }

    private TreeNode[] getCommonParentPlus(TreeNode first, TreeNode last) {
        TreeNode[] nodes = null;
        if (null != first && null != last) {
            TreeNode parent;
            TreeNode walk;
            ArrayList<TreeNode> parents = new ArrayList<TreeNode>();
            for (walk = first; walk != null; walk = walk.getParent()) {
                parents.add(walk);
            }
            walk = last;
            while (last != null) {
                int index = Util.indexOfInstance(parents, last);
                if (index >= 0) {
                    nodes = new TreeNode[]{last, index > 0 ? (TreeNode)parents.get(index - 1) : first, walk};
                    break;
                }
                walk = last;
                last = last.getParent();
            }
            if ((parent = nodes[0].getParent()) instanceof NotNodeInterface) {
                if (nodes[1] == nodes[2]) {
                    nodes[0] = parent;
                } else if (nodes[0].getIndex(nodes[1]) == 0 && nodes[0].getIndex(nodes[2]) == nodes[0].getChildCount() - 1) {
                    nodes[0] = parent;
                }
            }
        }
        return nodes;
    }

    @SASScope
    public static class LogicTreeToHTMLTransform
    extends LogicTreeToTextTransform {
        public LogicTreeToHTMLTransform() {
            this(null);
        }

        public LogicTreeToHTMLTransform(Locale locale) {
            super(locale);
            this.lineSeparator = " ";
            this.spaceText = "&nbsp;";
            this.indentationText = "&nbsp;&nbsp;&nbsp;";
        }

        @Override
        protected Object processTestNode(FilterLogicTestNodeInterface testNode, int indentation) {
            String result = this.getIndentationText(indentation);
            if (testNode != null) {
                result = Strings.quoteForXML((String)testNode.toString());
            }
            return result;
        }
    }
}

