/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.RB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
public class DefaultFilterValueList
implements FilterValuesInterface {
    public static String RB_KEY = "DefaultFilterValueList.";
    protected transient String _label;
    protected Collection _itemValues = null;
    protected Iterator _itemValuesIterator = null;

    public DefaultFilterValueList(Collection itemValues) {
        this._itemValues = itemValues;
        this._itemValuesIterator = this._itemValues.iterator();
        this._label = RB.getStringResource(RB_KEY, "ListLabel.txt");
    }

    public DefaultFilterValueList(Object[] itemValues) {
        this(Arrays.asList(itemValues));
    }

    @Override
    public boolean hasMoreValues() {
        return this._itemValuesIterator.hasNext();
    }

    @Override
    public List getFirstValues(long lThreshold) throws DataRetrievalError {
        this._itemValuesIterator = this._itemValues.iterator();
        return this.getNextValues(lThreshold);
    }

    @Override
    public List getNextValues(long lThreshold) throws DataRetrievalError {
        ArrayList temp = new ArrayList();
        int i = 0;
        while (this._itemValuesIterator.hasNext()) {
            temp.add(this._itemValuesIterator.next());
            if (lThreshold <= 0L || (long)(++i) < lThreshold) continue;
            break;
        }
        return temp;
    }

    public void setListLabel(String value) {
        this._label = value;
    }

    @Override
    public String getListLabel() {
        return this._label;
    }

    public String toString() {
        return this._label;
    }
}

